/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.sp.licensing.Feature;
import com.sun.netstorage.array.mgmt.sp.licensing.FeatureFactory;
import com.sun.netstorage.array.mgmt.sp.licensing.Key;
import com.sun.netstorage.array.mgmt.sp.licensing.KeyGenerator;
import com.sun.netstorage.array.mgmt.sp.licensing.KeyStore;
import com.sun.netstorage.array.mgmt.util.StorEdge_InstanceProvider;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;

public class SunStorEdge_6x20Licensing
extends StorEdge_InstanceProvider {
    private static final String CLASSNAME = "ClassName";
    private static final String LICENSEKEY = "LicenseKey";
    private static final String EXPIRATION = "Expiration";
    private static final String SYSTEMID = "SystemId";
    private static final String LICENSEID = "LicenseId";
    private static final String AMOUNT = "Amount";
    private static final String AMOUNTLICENSED = "AmountLicensed";
    private static final String FEATURENAME = "FeatureName";
    private static final String SUNSTOREDGE_FEATURE2CLASS = "SunStorEdge_6x20Feature2Class";
    private static final String SUNSTOREDGE_LICENSEKEY = "SunStorEdge_6x20LicenseKey";
    private static final String SUNSTOREDGE_LICENSESERVICE = "SunStorEdge_6x20LicenseService";
    private static final String SUNSTOREDGE_LICENSING = "SunStorEdge_6x20Licensing";
    private static final String SUNSTOREDGE_LICENSED_SOFTWARE_FEATURE = "SunStorEdge_LicensedSoftwareFeature";
    private static final String NAME_SPACE_ROOT_SE6X20 = "/root/se6x20";
    public static final String ADD_INVOKE_METHOD = "Add";
    public static final String REMOVE_INVOKE_METHOD = "Remove";
    public static final String UPDATE_INVOKE_METHOD = "UpdateAmountsLicensed";
    private static boolean updatedFirstTime = false;

    public boolean isMultiClassProvider() {
        return true;
    }

    public String getClassName() {
        return SUNSTOREDGE_LICENSING;
    }

    public Vector getClassNames() {
        Vector<String> v = new Vector<String>();
        v.add(SUNSTOREDGE_LICENSESERVICE);
        v.add(SUNSTOREDGE_LICENSEKEY);
        return v;
    }

    private CIMInstance newInstance(CIMObjectPath op) throws CIMException {
        return this.getCimomHandle().getClass(op, false, true, true, null).newInstance();
    }

    private void updateAmountsLicensed() throws CIMException {
        String METHOD = "updateAmountsLicensed";
        Enumeration amtInUseEnum = this.getCimomHandle().enumerateInstances(new CIMObjectPath(SUNSTOREDGE_LICENSED_SOFTWARE_FEATURE, NAME_SPACE_ROOT_SE6X20), false, false, true, false, null);
        Trace.verbose((Object)((Object)this), (String)"updateAmountsLicensed", (String)("Enumerating licenses; hasMore is " + amtInUseEnum.hasMoreElements()));
        while (amtInUseEnum.hasMoreElements()) {
            CIMInstance ci = (CIMInstance)amtInUseEnum.nextElement();
            Enumeration f2cEnum = this.getCimomHandle().enumerateInstances(new CIMObjectPath(SUNSTOREDGE_FEATURE2CLASS, NAME_SPACE_ROOT_SE6X20), false, false, true, false, null);
            boolean match = false;
            String featureName = null;
            while (f2cEnum.hasMoreElements()) {
                match = false;
                CIMInstance f2cInst = (CIMInstance)f2cEnum.nextElement();
                CIMProperty f2cProp = f2cInst.getProperty(CLASSNAME);
                String f2cClassName = null;
                if (null != f2cProp) {
                    CIMValue cv = f2cProp.getValue();
                    if (null != f2cProp) {
                        f2cClassName = (String)cv.getValue();
                        Trace.verbose((Object)((Object)this), (String)"updateAmountsLicensed", (String)(" License got this  " + f2cClassName));
                        if (f2cClassName.equals(ci.getClassName())) {
                            featureName = (String)f2cInst.getProperty(FEATURENAME).getValue().getValue();
                            Trace.verbose((Object)((Object)this), (String)"updateAmountsLicensed", (String)("      got FeatureName  " + featureName));
                            match = true;
                        }
                    }
                }
                Trace.verbose((Object)((Object)this), (String)"updateAmountsLicensed", (String)("     About to add for   " + featureName + " add flag = " + match));
                if (!match) continue;
                Long amountLic = new Long(KeyStore.getAmountLicensed(featureName));
                Trace.verbose((Object)((Object)this), (String)"updateAmountsLicensed", (String)("         amountLic " + amountLic));
                ci.setProperty(AMOUNTLICENSED, new CIMValue((Object)new UnsignedInt64(amountLic.toString())));
                CIMObjectPath cp = ci.getObjectPath();
                cp.setNameSpace(NAME_SPACE_ROOT_SE6X20);
                this.getCimomHandle().setInstance(cp, ci);
            }
        }
    }

    protected Vector enumerate(CIMObjectPath op) throws CIMException {
        CIMInstance ci;
        int i;
        String METHOD = "enumerate";
        if (!updatedFirstTime) {
            this.updateAmountsLicensed();
            updatedFirstTime = true;
        }
        Vector<CIMInstance> instances = new Vector<CIMInstance>();
        if (op.getObjectName().equalsIgnoreCase(SUNSTOREDGE_LICENSESERVICE)) {
            CIMInstance ci2 = this.newInstance(op);
            instances.add(ci2);
        }
        if (op.getObjectName().equalsIgnoreCase(SUNSTOREDGE_LICENSEKEY)) {
            Key[] keys = KeyStore.getKeys();
            Trace.verbose((Object)((Object)this), (String)"enumerate", (String)("License enumerate key, keys.length is " + keys.length));
            for (i = 0; i < keys.length; ++i) {
                ci = this.newInstance(op);
                this.loadLicenseKey(ci, keys[i]);
                instances.add(ci);
            }
        }
        if (op.getObjectName().equalsIgnoreCase(SUNSTOREDGE_FEATURE2CLASS)) {
            Feature[] features = FeatureFactory.getFeatures();
            for (i = 0; i < features.length; ++i) {
                ci = this.newInstance(op);
                ci.setProperty(FEATURENAME, new CIMValue((Object)features[i].getName()));
                ci.setProperty(CLASSNAME, new CIMValue((Object)features[i].getClassName()));
                instances.add(ci);
            }
        }
        return instances;
    }

    private void set(CIMInstance ci, String pname, Object pval) throws CIMException {
        ci.setProperty(pname, new CIMValue(pval));
    }

    private void loadLicenseKey(CIMInstance ci, Key key) throws CIMException {
        this.set(ci, FEATURENAME, key.getFeatureName());
        this.set(ci, AMOUNT, new UnsignedInt64(new Long(key.getAmount()).toString()));
        this.set(ci, LICENSEID, new UnsignedInt64(new Long(key.getLicenseId()).toString()));
        this.set(ci, SYSTEMID, key.getSystemId());
        if (key.getExpiration() != null) {
            this.set(ci, EXPIRATION, new CIMDateTime(key.getExpiration()));
        }
        this.set(ci, LICENSEKEY, key.getLicenseKey());
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        CIMInstance ci = cc.newInstance();
        if (op.getObjectName().equalsIgnoreCase(SUNSTOREDGE_LICENSESERVICE)) {
            ci.setProperty("fortesting", new CIMValue((Object)"need-an-instance"));
            Trace.verbose((Object)((Object)this), (String)"getInstance", (String)"License getInstance service");
        }
        if (op.getObjectName().equalsIgnoreCase(SUNSTOREDGE_LICENSEKEY)) {
            Key[] keys = KeyStore.getKeys();
            String key = op.getKey(LICENSEKEY).getValue().getValue().toString();
            Trace.verbose((Object)((Object)this), (String)"getInstance", (String)("License getInstance " + key));
            for (int i = 0; i < keys.length; ++i) {
                if (!key.equals(keys[i].toString())) continue;
                this.loadLicenseKey(ci, keys[i]);
                Trace.verbose((Object)((Object)this), (String)"getInstance", (String)("License getInstance key equals" + key + keys.length));
                break;
            }
        }
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
    }

    public CIMValue invokeMethod(CIMObjectPath op, String method, CIMArgument[] inArg, CIMArgument[] outArg) throws CIMException {
        String METHOD = "invokeMethod";
        if (op.getObjectName().equals(SUNSTOREDGE_LICENSESERVICE)) {
            this.checkAuth("sunw.nws.provider." + this.getClassName() + ".invokeMethod");
            if (ADD_INVOKE_METHOD.equals(method)) {
                Enumeration f2cEnum = this.getCimomHandle().enumerateInstances(new CIMObjectPath(SUNSTOREDGE_FEATURE2CLASS, NAME_SPACE_ROOT_SE6X20), false, false, true, false, null);
                Key key = KeyGenerator.makeKeyFromLicense((String)inArg[0].getValue().getValue());
                if (key == null) {
                    return CIMValue.FALSE;
                }
                boolean match = false;
                String featureName = null;
                while (f2cEnum.hasMoreElements()) {
                    CIMInstance f2cInst = (CIMInstance)f2cEnum.nextElement();
                    CIMProperty f2cProp = f2cInst.getProperty(CLASSNAME);
                    if (null == f2cProp) continue;
                    CIMValue cv = f2cProp.getValue();
                    if (null == f2cProp || !(featureName = (String)f2cInst.getProperty(FEATURENAME).getValue().getValue()).equals(key.getFeatureName())) continue;
                    match = true;
                    Trace.verbose((Object)((Object)this), (String)"invokeMethod", (String)("      found feature " + featureName + " when adding"));
                }
                if (!match) {
                    return CIMValue.FALSE;
                }
                if (KeyStore.add((String)inArg[0].getValue().getValue())) {
                    this.updateAmountsLicensed();
                    Trace.verbose((Object)((Object)this), (String)"invokeMethod", (String)("License add OK - " + (String)inArg[0].getValue().getValue()));
                    return CIMValue.TRUE;
                }
                Trace.verbose((Object)((Object)this), (String)"invokeMethod", (String)("License add failed - " + (String)inArg[0].getValue().getValue()));
                return CIMValue.FALSE;
            }
            if (REMOVE_INVOKE_METHOD.equals(method)) {
                if (KeyStore.remove((String)inArg[0].getValue().getValue())) {
                    this.updateAmountsLicensed();
                    return CIMValue.TRUE;
                }
                return CIMValue.FALSE;
            }
            if (UPDATE_INVOKE_METHOD.equals(method)) {
                this.updateAmountsLicensed();
                return CIMValue.TRUE;
            }
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

