/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp;

import com.sun.netstorage.array.mgmt.sp.FirewallFilterDetails;
import com.sun.netstorage.array.mgmt.sp.FirewallManager;
import com.sun.netstorage.array.mgmt.sp.SunStorEdge_6x20FilterList;
import com.sun.netstorage.array.mgmt.sp.SunStorEdge_6x20IPHeadersFilter;
import com.sun.netstorage.array.mgmt.util.StorEdge_AssociationProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.CIMInstanceProvider;

public class SunStorEdge_6x20EntriesInFilterList
extends StorEdge_AssociationProvider
implements CIMInstanceProvider {
    private static final String PROP_GROUP_COMPONENT = "GroupComponent";
    private static final String PROP_PART_COMPONENT = "PartComponent";
    private static final String CLASSNAME = "SunStorEdge_6x20EntriesInFilterList";

    public String getClassName() {
        return CLASSNAME;
    }

    public void initialize(CIMOMHandle cimom) throws CIMException {
        super.initialize(cimom);
        FirewallManager fm = FirewallManager.getInstance();
    }

    public CIMInstance[] references(CIMObjectPath assocName, CIMObjectPath objectName, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        block18: {
            String METHOD = "references";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "references" + " entered"));
            this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "references");
            try {
                Vector keys = objectName.getKeys();
                if (assocName != null && !assocName.getObjectName().equalsIgnoreCase(this.getClassName())) break block18;
                CIMInstance[] ret = new CIMInstance[]{};
                if (objectName.getObjectName().equalsIgnoreCase(new SunStorEdge_6x20FilterList().getClassName())) {
                    String portDirection = null;
                    for (int i = 0; i < keys.size(); ++i) {
                        CIMProperty prop = (CIMProperty)keys.elementAt(i);
                        if (!prop.getName().equalsIgnoreCase("Name")) continue;
                        portDirection = (String)prop.getValue().getValue();
                        break;
                    }
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Direction is " + portDirection));
                    List portsConnected = null;
                    try {
                        portsConnected = FirewallManager.getInstance().findEnabledFilters();
                    }
                    catch (Exception e) {
                        WBEMDebug.trace1((String)(this.getClassName() + "." + "references" + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                    ArrayList<CIMInstance> instancesForReturn = new ArrayList<CIMInstance>();
                    FirewallManager mgr = FirewallManager.getInstance();
                    for (int i = 0; i < portsConnected.size(); ++i) {
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Building FilterList -> IPHeadersFilter "));
                        String connectedPort = (String)portsConnected.get(i);
                        FirewallFilterDetails filter = mgr.getFilter(connectedPort);
                        if (filter == null || !filter.getDirection().equals(portDirection)) continue;
                        CIMInstance ipHeadersFilter = SunStorEdge_6x20IPHeadersFilter.getIPHeadersFilterInstance(filter, (CIMOMHandle)this.getCimomHandle(), objectName.getNameSpace());
                        if (ipHeadersFilter == null) {
                            throw new CIMException("CIM_ERR_FAILED");
                        }
                        CIMInstance instance = this.buildComponent(objectName, ipHeadersFilter.getObjectPath(), assocName.getNameSpace());
                        instance.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                        WBEMDebug.trace3((String)(this.getClassName() + "." + "references" + " Identity created."));
                        instancesForReturn.add(instance);
                    }
                    ret = instancesForReturn.toArray(new CIMInstance[0]);
                } else if (objectName.getObjectName().equalsIgnoreCase(new SunStorEdge_6x20IPHeadersFilter().getClassName())) {
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Building IPHeadersFilter -> " + " FilterList Identity"));
                    String portDescription = null;
                    for (int i = 0; i < keys.size(); ++i) {
                        CIMProperty prop = (CIMProperty)keys.elementAt(i);
                        if (!prop.getName().equalsIgnoreCase("Name")) continue;
                        portDescription = (String)prop.getValue().getValue();
                        break;
                    }
                    FirewallFilterDetails filter = FirewallManager.getInstance().getFilter(portDescription);
                    List portsConnected = null;
                    try {
                        if (filter != null) {
                            portsConnected = FirewallManager.getInstance().findEnabledFilters();
                        }
                    }
                    catch (Exception e) {
                        WBEMDebug.trace1((String)(this.getClassName() + "." + "references" + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                    if (portsConnected != null && filter != null && portsConnected.contains(filter.getName())) {
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "references" + " Building IPHeadersFilter->FilterList for: " + filter.getName()));
                        ret = new CIMInstance[1];
                        CIMInstance filterList = SunStorEdge_6x20FilterList.getFilterListInstance(filter.getDirection(), (CIMOMHandle)this.getCimomHandle(), objectName.getNameSpace());
                        if (filterList == null) {
                            throw new CIMException("CIM_ERR_FAILED");
                        }
                        ret[0] = this.buildComponent(filterList.getObjectPath(), objectName, assocName.getNameSpace());
                        WBEMDebug.trace3((String)(this.getClassName() + "." + "references" + " Identity created."));
                        ret[0].filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                    }
                } else {
                    CIMException ex = new CIMException("CIM_ERR_NOT_SUPPORTED");
                    throw ex;
                }
                return ret;
            }
            catch (CIMException ex) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "references" + " unknown failure."), (Throwable)ex);
                throw ex;
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "references" + " Exception " + e.getMessage()), (Throwable)e);
                throw new CIMException("CIM_ERR_FAILED");
            }
        }
        return null;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        String METHOD = "enumerateInstanceNames";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerateInstanceNames" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "enumerateInstanceNames");
        CIMInstance[] insts = this.enumerateInstances(op, false, true, true, null, cc);
        int len = insts.length;
        CIMObjectPath[] paths = new CIMObjectPath[len];
        for (int i = 0; i < len; ++i) {
            paths[i] = insts[i].getObjectPath();
        }
        return paths;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "enumerateInstances";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerateInstances" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "enumerateInstances");
        ArrayList<CIMInstance> newInstances = new ArrayList<CIMInstance>();
        FirewallManager mgr = FirewallManager.getInstance();
        HashMap filters = mgr.getFilters();
        try {
            List enabledFilters = mgr.findEnabledFilters();
            int eSize = enabledFilters.size();
            for (int i = 0; i < eSize; ++i) {
                String filterName = (String)enabledFilters.get(i);
                FirewallFilterDetails det = (FirewallFilterDetails)filters.get(filterName);
                if (det == null) continue;
                CIMInstance ipHeadersFilter = SunStorEdge_6x20IPHeadersFilter.getIPHeadersFilterInstance(det, (CIMOMHandle)this.getCimomHandle(), op.getNameSpace());
                CIMInstance filterList = SunStorEdge_6x20FilterList.getFilterListInstance(det.getDirection(), (CIMOMHandle)this.getCimomHandle(), op.getNameSpace());
                CIMInstance instance = this.buildComponent(filterList.getObjectPath(), ipHeadersFilter.getObjectPath(), op.getNameSpace());
                instance.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                newInstances.add(instance);
            }
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "enumerateInstances" + " unable to load filters data"), (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED");
        }
        return newInstances.toArray(new CIMInstance[0]);
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "getInstance");
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        CIMObjectPath cop;
        block11: {
            String METHOD = "createInstance";
            this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "createInstance");
            WBEMDebug.trace3((String)(this.getClassName() + "." + "createInstance" + " entered"));
            cop = null;
            try {
                CIMObjectPath partPath = (CIMObjectPath)ci.getProperty(PROP_PART_COMPONENT).getValue().getValue();
                CIMObjectPath groupPath = (CIMObjectPath)ci.getProperty(PROP_GROUP_COMPONENT).getValue().getValue();
                WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " Part path is " + partPath));
                WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " Group path is" + groupPath));
                String ipHeadersFilterDesc = null;
                Vector partKeys = partPath.getKeys();
                Enumeration en = partKeys.elements();
                while (en.hasMoreElements()) {
                    CIMProperty prop = (CIMProperty)en.nextElement();
                    if (!prop.getName().equalsIgnoreCase("Name")) continue;
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " Part Name is " + prop.getName() + "=" + prop.getValue().getValue()));
                    ipHeadersFilterDesc = (String)prop.getValue().getValue();
                }
                String filterListDirection = null;
                Vector groupKeys = groupPath.getKeys();
                Enumeration en2 = groupKeys.elements();
                while (en2.hasMoreElements()) {
                    CIMProperty prop = (CIMProperty)en2.nextElement();
                    if (!prop.getName().equalsIgnoreCase("Name")) continue;
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " Group Name is " + prop.getName() + "=" + prop.getValue().getValue()));
                    filterListDirection = (String)prop.getValue().getValue();
                }
                if (filterListDirection != null && ipHeadersFilterDesc != null && this.isAssociationPossible(ipHeadersFilterDesc, filterListDirection)) {
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " trying to connect " + filterListDirection + " and " + ipHeadersFilterDesc));
                    try {
                        List enabledFilters = FirewallManager.getInstance().findEnabledFilters();
                        if (enabledFilters != null && enabledFilters.contains(ipHeadersFilterDesc)) {
                            WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " port " + ipHeadersFilterDesc + " is already enabled"));
                        } else {
                            WBEMDebug.trace2((String)(this.getClassName() + "." + "createInstance" + " toggling " + ipHeadersFilterDesc));
                            FirewallManager.getInstance().toggleFilterState(ipHeadersFilterDesc);
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " " + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                }
                WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " One of the props is not set or " + " association is not possible " + " for filter: " + ipHeadersFilterDesc + " in direction: " + filterListDirection));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (CIMException cim) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " " + cim.getMessage()), (Throwable)cim);
                throw cim;
            }
            catch (ClassCastException cce) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " " + cce.getMessage()), (Throwable)cce);
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (Exception ex) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " " + ex.getMessage()), (Throwable)ex);
                throw new CIMException("CIM_ERR_FAILED");
            }
        }
        return cop;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        String METHOD = "setInstance";
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "setInstance");
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setInstance" + " entered"));
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        block14: {
            String METHOD = "deleteInstance";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "deleteInstance" + " entered"));
            this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "deleteInstance");
            try {
                Vector keys = op.getKeys();
                CIMObjectPath partPath = null;
                CIMObjectPath groupPath = null;
                Enumeration en = keys.elements();
                while (en.hasMoreElements()) {
                    CIMProperty prop = (CIMProperty)en.nextElement();
                    if (prop.getName().equalsIgnoreCase(PROP_PART_COMPONENT)) {
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " Part component is  " + prop.getName() + "=" + prop.getValue().getValue()));
                        partPath = (CIMObjectPath)prop.getValue().getValue();
                        continue;
                    }
                    if (!prop.getName().equalsIgnoreCase(PROP_GROUP_COMPONENT)) continue;
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " Group component is " + prop.getName() + "=" + prop.getValue().getValue()));
                    groupPath = (CIMObjectPath)prop.getValue().getValue();
                }
                if (partPath != null && groupPath != null) {
                    Vector partKeys = partPath.getKeys();
                    String partKey = null;
                    String groupKey = null;
                    for (int i = 0; i < partKeys.size(); ++i) {
                        CIMProperty prop = (CIMProperty)partKeys.get(i);
                        if (!prop.getName().equals("Name")) continue;
                        partKey = (String)prop.getValue().getValue();
                        break;
                    }
                    Vector groupKeys = groupPath.getKeys();
                    for (int i = 0; i < groupKeys.size(); ++i) {
                        CIMProperty prop = (CIMProperty)groupKeys.get(i);
                        if (!prop.getName().equals("Name")) continue;
                        groupKey = (String)prop.getValue().getValue();
                        break;
                    }
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " trying to disconnect " + partKey + " and " + groupKey));
                    if (this.isAssociationPossible(partKey, groupKey)) {
                        try {
                            List enabledFilters = FirewallManager.getInstance().findEnabledFilters();
                            if (enabledFilters != null && !enabledFilters.contains(partKey)) {
                                WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " already disabled"));
                            } else {
                                FirewallManager.getInstance().toggleFilterState(partKey);
                                WBEMDebug.trace2((String)(this.getClassName() + "." + "deleteInstance" + " disabling " + partKey));
                            }
                            break block14;
                        }
                        catch (Exception e) {
                            WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " " + e.getMessage()), (Throwable)e);
                            throw e;
                        }
                    }
                    WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + "  " + "the connection was not possible between " + partKey + " and " + groupKey));
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " Keys are not set properly :" + " partPath =" + partPath + " groupPath = " + groupPath));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (CIMException cim) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " " + cim.getMessage()), (Throwable)cim);
                throw cim;
            }
            catch (ClassCastException cce) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " " + cce.getMessage()), (Throwable)cce);
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (Exception ex) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " " + ex.getMessage()), (Throwable)ex);
                throw new CIMException("CIM_ERR_FAILED");
            }
        }
    }

    private boolean isAssociationPossible(String port, String direction) throws CIMException {
        String METHOD = "isAssociationPossible";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "isAssociationPossible" + " entered"));
        boolean result = false;
        FirewallFilterDetails filter = FirewallManager.getInstance().getFilter(port);
        if (filter == null) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "isAssociationPossible" + " Direction " + direction + " does not exist."));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        result = filter.getDirection().equals(direction);
        return result;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        String METHOD = "execQuery";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "execQuery" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "execQuery");
        CIMInstance[] possibles = this.enumerateInstances(op, false, true, true, null, cc);
        CIMInstance[] forReturn = null;
        if (possibles != null && possibles.length > 0) {
            int len = possibles.length;
            forReturn = new CIMInstance[len + 1];
            System.arraycopy(possibles, 0, forReturn, 1, len);
            forReturn[0] = null;
        }
        return forReturn;
    }
}

