/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp;

import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.sp.FirewallFilterDetails;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.wbem.cim.CIMException;

public class FirewallManager {
    private static boolean failedToLoad = true;
    private HashMap filters;
    private static FirewallManager instance = null;
    private static final String CLASSNAME = "FirewallManager";
    public static String DEFAULT_FW_CONFIG_FILE;
    public static final String FIREWALL_CONFIG_SCRIPT = "/usr/local/bin/FW_config";
    private static final String DELIMITER = ":";
    private static final String DISABLED = "disabled";
    private static final String ENABLED = "enabled";
    private static final String[] SERVICES_TO_HIDE;
    private static List lastResults;
    private static long lastReadTime;
    private static final long REFRESH_TIME = 5000L;

    private FirewallManager() {
        WBEMDebug.trace3((String)"FirewallManager constructing instance.");
        this.filters = new HashMap();
        DEFAULT_FW_CONFIG_FILE = "/opt/SUNWsespfw/repository";
    }

    public static synchronized FirewallManager getInstance() {
        WBEMDebug.trace3((String)"FirewallManager.getInstance() entered");
        if (instance == null || failedToLoad) {
            instance = new FirewallManager();
            try {
                instance.loadAvailableFilters();
                failedToLoad = false;
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)"FirewallManager.getInstance() failed to load: ", (Throwable)e);
            }
        }
        return instance;
    }

    public HashMap getFilters() {
        return this.filters;
    }

    public FirewallFilterDetails getFilter(String name) {
        return (FirewallFilterDetails)this.filters.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAvailableFilters() throws Exception {
        String METHOD = "FirewallManager.loadAvailableFilters()";
        String delimiter = ",";
        String cmd = "/usr/local/bin/FW_config --services";
        BufferedReader reader = null;
        Properties servicesToDirection = new Properties();
        servicesToDirection.put("in", "Input");
        servicesToDirection.put("out", "Output");
        servicesToDirection.put("both", "Both");
        List<String> servicesToHide = Arrays.asList(SERVICES_TO_HIDE);
        try {
            reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(cmd).getInputStream()));
            WBEMDebug.trace3((String)"FirewallManager.loadAvailableFilters() have reader");
            String curline = null;
            while ((curline = reader.readLine()) != null) {
                WBEMDebug.trace3((String)("FirewallManager.loadAvailableFilters() reading line: " + curline));
                if (curline.startsWith("#")) continue;
                String[] chunks = curline.split(delimiter);
                WBEMDebug.trace3((String)("FirewallManager.loadAvailableFilters() have num chunks: " + chunks.length));
                if (chunks.length == 5) {
                    try {
                        String[] ports = chunks[1].split("/");
                        int curPort = Integer.parseInt(chunks[1].trim());
                        if (null != servicesToDirection.get(chunks[2].trim())) {
                            if (!servicesToHide.contains(chunks[0].trim())) {
                                FirewallFilterDetails filter = new FirewallFilterDetails(chunks[0].trim(), curPort, (String)servicesToDirection.get(chunks[2].trim()), "yes".equalsIgnoreCase(chunks[3].trim()));
                                this.filters.put(filter.getName(), filter);
                                continue;
                            }
                            WBEMDebug.trace3((String)("FirewallManager Hiding filter: " + chunks[0].trim() + " per request."));
                            continue;
                        }
                        WBEMDebug.trace1((String)("FirewallManager found non-parseable line: <" + curline + "> from cmd: " + cmd));
                    }
                    catch (NumberFormatException nfe) {
                        WBEMDebug.trace1((String)("FirewallManager found unexpected value: <" + chunks[1].trim() + "> from where ports should be in cmd: " + cmd));
                    }
                    continue;
                }
                WBEMDebug.trace1((String)("FirewallManager found unexpected line: <" + curline + "> from cmd: " + cmd));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public synchronized List findEnabledFilters() throws FileNotFoundException, IOException {
        String METHOD = "readConfigFile()";
        WBEMDebug.trace3((String)"FirewallManager.readConfigFile() entered");
        long now = System.currentTimeMillis();
        if (lastResults != null && Math.abs(now - lastReadTime) < 5000L) {
            return lastResults;
        }
        lastResults = new ArrayList();
        BufferedReader reader = null;
        lastReadTime = now;
        try {
            reader = new BufferedReader(new FileReader(DEFAULT_FW_CONFIG_FILE));
            String currLine = null;
            while ((currLine = reader.readLine()) != null) {
                String[] chunks = currLine.split(DELIMITER);
                if (chunks == null || chunks.length != 2) continue;
                String portDesc = chunks[0];
                String state = chunks[1];
                WBEMDebug.trace3((String)("FirewallManager.readConfigFile() state for " + portDesc + " is " + state));
                if (portDesc == null || !ENABLED.equalsIgnoreCase(state)) continue;
                lastResults.add(portDesc);
            }
        }
        catch (FileNotFoundException ex) {
            String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
            LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
            WBEMDebug.trace1((String)("FirewallManager.readConfigFile() " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (IOException ioe) {
            String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
            LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
            WBEMDebug.trace1((String)("FirewallManager.readConfigFile() " + ioe.getMessage()), (Throwable)ioe);
            throw ioe;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return lastResults;
    }

    public synchronized void toggleFilterState(String portName) throws CIMException, InterruptedException, IOException, Exception {
        String METHOD = "toggleFilterState";
        WBEMDebug.trace3((String)"FirewallManager.toggleFilterState entered");
        StringBuffer cmd = new StringBuffer("/usr/local/bin/FW_config --toggle_port_state ");
        if (null == this.filters.get(portName)) {
            WBEMDebug.trace1((String)("FirewallManager.toggleFilterState: requested for unknown port: " + portName));
            throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY");
        }
        lastReadTime = 0L;
        cmd.append(portName);
        try {
            int returnCode = this.runScript(cmd.toString());
            if (returnCode != 0) {
                WBEMDebug.trace1((String)("FirewallManager.toggleFilterState Error running FW command: " + cmd));
                throw new Exception("Error running FW command");
            }
        }
        catch (InterruptedException ie) {
            WBEMDebug.trace1((String)("FirewallManager.toggleFilterState " + ie.getMessage()), (Throwable)ie);
            throw ie;
        }
        catch (IOException ioe) {
            WBEMDebug.trace1((String)("FirewallManager.toggleFilterState " + ioe.getMessage()), (Throwable)ioe);
            throw ioe;
        }
    }

    private void updateConfigValue(String configFileName, String portName) throws FileNotFoundException, IOException {
        String METHOD = "updateConfigValue";
        WBEMDebug.trace3((String)"FirewallManager.updateConfigValue entered");
        ArrayList allPorts = new ArrayList(this.filters.keySet());
        List portsConnected = this.findEnabledFilters();
        if (portsConnected.contains(portName)) {
            portsConnected.remove(portName);
        } else {
            portsConnected.add(portName);
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(configFileName));
            int filterSize = allPorts.size();
            for (int j = 0; j < filterSize; ++j) {
                String nextPort = (String)allPorts.get(j);
                StringBuffer line = new StringBuffer(nextPort + DELIMITER);
                if (portsConnected.contains(nextPort)) {
                    line.append(ENABLED);
                } else {
                    line.append(DISABLED);
                }
                WBEMDebug.trace3((String)("FirewallManager.updateConfigValue wrote line " + line));
                out.println(line);
            }
        }
        catch (FileNotFoundException ex) {
            String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
            LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
            WBEMDebug.trace1((String)("FirewallManager.updateConfigValue " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (IOException ioe) {
            String[] arg = new String[]{DEFAULT_FW_CONFIG_FILE};
            LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
            WBEMDebug.trace1((String)("FirewallManager.updateConfigValue " + ioe.getMessage()), (Throwable)ioe);
            throw ioe;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private int runScript(String cmdStr) throws InterruptedException, IOException {
        String METHOD = "runScript";
        WBEMDebug.trace3((String)"FirewallManager.runScript entered");
        WBEMDebug.trace2((String)("FirewallManager.runScript Calling FW config script: " + cmdStr));
        int returnCode = 0;
        try {
            Process p = Runtime.getRuntime().exec(cmdStr);
            p.waitFor();
            returnCode = p.exitValue();
        }
        catch (InterruptedException ex) {
            WBEMDebug.trace1((String)"FirewallManager.runScript exception", (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            WBEMDebug.trace1((String)"FirewallManager.runScript exception", (Throwable)ex);
            throw ex;
        }
        return returnCode;
    }

    static {
        SERVICES_TO_HIDE = new String[]{"ssh"};
        lastReadTime = 0L;
    }
}

