/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class ClassXml2InstXml {
    public static final String OUTPUT_FILE_EXTENSION = ".xml";
    private static boolean rmdesc = false;
    private static boolean rmqual = false;
    private static boolean pretty = false;
    private static boolean process = true;
    private String destdir = null;
    private String startLoop = null;
    private String endLoop = null;
    private Element classParentElement = null;

    public static void usage() {
        ClassXml2InstXml.trace("\nUsage: java ClassXml2InstXml [--pretty] [ -d dest_dir ] file...");
        ClassXml2InstXml.trace("\n\t--pretty  This flag pretty prints output. \n\t\t  NOTE: Do not use for deployable (6120/T4) files \n\t\t  because newlines will break xml parser.");
        ClassXml2InstXml.trace("\n\t-d dest_dir  Directory to store the results in");
    }

    public static void main(String[] args) {
        ClassXml2InstXml tmp;
        Stack<String> firstPass = new Stack<String>();
        Stack<String> secondPass = new Stack<String>();
        String destination = null;
        process = true;
        for (int i = 0; i < args.length; ++i) {
            if ("--pretty".equals(args[i])) {
                pretty = true;
                continue;
            }
            if ("-d".equals(args[i])) {
                destination = args[++i];
                continue;
            }
            firstPass.push(args[i]);
        }
        if (firstPass.empty() || destination == null) {
            ClassXml2InstXml.usage();
            System.exit(1);
        }
        System.out.println("First pass...");
        while (!firstPass.empty()) {
            tmp = new ClassXml2InstXml();
            String current = (String)firstPass.pop();
            if (tmp.process(current, destination)) continue;
            System.err.println(" Skipping " + current + " for a second pass");
            secondPass.push(current);
        }
        if (secondPass.empty()) {
            return;
        }
        System.out.println("Second pass...");
        while (!secondPass.empty()) {
            tmp = new ClassXml2InstXml();
            String current = (String)secondPass.pop();
            if (tmp.process(current, destination)) continue;
            System.err.println("Failure in second pass on " + current + " .  Terminating.");
            System.exit(1);
        }
    }

    public boolean process(String file, String destination) {
        this.destdir = destination;
        SAXBuilder builder = new SAXBuilder();
        int lastslash = file.lastIndexOf(File.separator);
        String shortName = lastslash >= 0 ? file.substring(lastslash + 1) : file;
        System.out.println("Processing " + shortName);
        try {
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            this.iterateChildren(root);
            Comment start = null;
            Comment end = null;
            if (null != this.startLoop && null != this.endLoop && null != this.classParentElement) {
                start = new Comment("\n" + this.startLoop + "\n");
                end = new Comment("\n" + this.endLoop + "\n");
            }
            this.printElement(shortName, root, start, end);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void iterateChildren(Element current) throws Exception {
        Element child;
        List children = current.getChildren();
        ArrayList<Element> childrenToRemove = new ArrayList<Element>();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            child = (Element)iterator.next();
            if (process) {
                if ("CLASS".equals(child.getName())) {
                    child.setAttribute("CLASSNAME", child.getAttributeValue("NAME"));
                    child.removeAttribute("NAME");
                    child.removeAttribute("SUPERCLASS");
                    child.setName("INSTANCE");
                    this.classParentElement = child.getParent();
                }
                if ("StartTag".equals(child.getAttributeValue("NAME"))) {
                    this.startLoop = child.getChild("VALUE").getText();
                    childrenToRemove.add(child.getChild("VALUE"));
                }
                if ("EndTag".equals(child.getAttributeValue("NAME"))) {
                    this.endLoop = child.getChild("VALUE").getText();
                    childrenToRemove.add(child.getChild("VALUE"));
                }
                if ("Token".equals(child.getAttributeValue("NAME")) && this.handleToken(child) || "UseKeysFrom".equals(child.getAttributeValue("NAME")) && this.handleUseKeys(child)) break;
            }
            if (rmqual && "QUALIFIER".equals(child.getName())) {
                childrenToRemove.add(child);
            } else if (rmdesc && "Description".equals(child.getAttributeValue("NAME"))) {
                childrenToRemove.add(child);
            }
            this.iterateChildren(child);
        }
        iterator = childrenToRemove.iterator();
        while (iterator.hasNext()) {
            child = (Element)iterator.next();
            child.getParent().removeContent(child);
        }
    }

    private boolean handleToken(Element e) {
        Element p = e.getParent();
        if ("PROPERTY.ARRAY".equals(p.getName())) {
            Element valArr = new Element("VALUE.ARRAY");
            String[] chunks = new String(e.getChild("VALUE").getText()).split(",");
            for (int i = 0; i < chunks.length; ++i) {
                Element val = new Element("VALUE");
                val.setText(chunks[i]);
                valArr.addContent(val);
            }
            p.addContent(valArr);
            return true;
        }
        Element val = p.getChild("VALUE");
        if (null == val) {
            val = new Element("VALUE");
            val.setText(e.getChild("VALUE").getText());
            p.addContent(val);
            return true;
        }
        val.setText(e.getChild("VALUE").getText());
        return false;
    }

    private boolean handleUseKeys(Element e) throws Exception {
        String refClassName = null;
        if (this.destdir.length() == 0) {
            return false;
        }
        Element val = e.getChild("VALUE");
        if (null == val) {
            ClassXml2InstXml.trace("Not able to find value for UseKeysFrom Qualifier");
            return false;
        }
        refClassName = val.getText();
        Element p = e.getParent();
        List children = p.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            if (!"VALUE.REFERENCE".equals(child.getName())) continue;
            Element ref = child.getChild("CLASSNAME");
            ref.setName("INSTANCENAME");
            ref.setAttribute("CLASSNAME", ref.getAttributeValue("NAME"));
            ref.removeAttribute("NAME");
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(this.destdir + "/" + refClassName + OUTPUT_FILE_EXTENSION);
            Element root = doc.getRootElement();
            Element elem = ClassXml2InstXml.findInstanceParent(root);
            Iterator keys = ClassXml2InstXml.retrieveKeys(elem, refClassName);
            while (keys.hasNext()) {
                ClassKeyNameValue key = (ClassKeyNameValue)keys.next();
                Element keyBinding = new Element("KEYBINDING");
                keyBinding.setAttribute("NAME", key.getKeyName());
                Element keyValue = new Element("KEYVALUE");
                keyValue.setText(key.getKeyValue());
                keyBinding.addContent(keyValue);
                ref.addContent(keyBinding);
            }
            break block0;
        }
        return true;
    }

    private static Element findInstanceParent(Element current) {
        Element child = current.getChild("DECLARATION");
        child = child.getChild("DECLGROUP");
        if ((child = child.getChild("VALUE.OBJECT")).getChild("INSTANCE") == null) {
            return null;
        }
        return child;
    }

    private static Iterator retrieveKeys(Element current, String refClassName) {
        ArrayList<ClassKeyNameValue> keyList = new ArrayList<ClassKeyNameValue>();
        List children = current.getChildren();
        Iterator iterator = children.iterator();
        Element child = null;
        boolean refClassNameFound = false;
        while (iterator.hasNext()) {
            child = (Element)iterator.next();
            if (!"INSTANCE".equals(child.getName()) || !refClassName.equals(child.getAttributeValue("CLASSNAME"))) continue;
            refClassNameFound = true;
            break;
        }
        if (!refClassNameFound) {
            ClassXml2InstXml.trace("Not able to find INSTANCE");
            return null;
        }
        List properties = child.getChildren("PROPERTY");
        Iterator propIterator = properties.iterator();
        block1: while (propIterator.hasNext()) {
            Element property = (Element)propIterator.next();
            List propChildren = property.getChildren("QUALIFIER");
            Iterator propChildrenIterator = propChildren.iterator();
            while (propChildrenIterator.hasNext()) {
                Element propChild = (Element)propChildrenIterator.next();
                if (!"Key".equals(propChild.getAttributeValue("NAME"))) continue;
                Element val = property.getChild("VALUE");
                if (val == null) continue block1;
                ClassKeyNameValue entry = new ClassKeyNameValue(property.getAttributeValue("NAME"), val.getText());
                keyList.add(entry);
                continue block1;
            }
        }
        return keyList.iterator();
    }

    public void printElement(String file, Element element, Comment start, Comment end) throws IOException {
        File outfile = new File(this.destdir + File.separator + file);
        if (!outfile.createNewFile()) {
            throw new IOException(outfile + " already exists.");
        }
        FileOutputStream out = new FileOutputStream(outfile);
        XMLOutputter outputter = new XMLOutputter();
        try {
            if (pretty) {
                outputter.setNewlines(true);
                outputter.setLineSeparator("\n");
                outputter.setIndent(true);
            }
            if (start != null) {
                outputter.output(start, (OutputStream)out);
                outputter.output(new Text("\n"), (OutputStream)out);
            }
            outputter.output(element, (OutputStream)out);
            outputter.output(new Text("\n"), (OutputStream)out);
            if (end != null) {
                outputter.output(end, (OutputStream)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void trace(String msg) {
        System.out.println(msg);
    }

    private static class ClassKeyNameValue {
        private String keyName;
        private String keyValue;

        public ClassKeyNameValue(String keyName, String keyValue) {
            this.keyName = keyName;
            this.keyValue = keyValue;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public String getKeyValue() {
            return this.keyValue;
        }
    }
}

