/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Vector;
import rl.clbroker.CommLayer;
import rl.clbroker.MultiBroker;
import rl.clbroker.OCP;
import rl.clbroker.PacketComponents;
import rl.clbroker.RlError;
import rl.clbroker.WaitDialog;

public class UDPComm
extends CommLayer
implements Runnable {
    protected DatagramSocket sockSend;
    protected DatagramSocket sockRecv;
    protected DatagramPacket outPacket;
    protected DatagramPacket inPacket;
    protected byte[] inBuffer = new byte[kMaxPacketLen];
    protected MultiBroker broker;
    protected String kDevice;

    public UDPComm(MultiBroker broker, String kDevice, int portID, InetAddress deviceAddress) throws SocketException {
        this.broker = broker;
        this.kDevice = kDevice;
        UDPComm.portID = portID;
        this.deviceAddress = deviceAddress;
    }

    protected void openConnection() throws SocketException {
        try {
            this.sockRecv = new DatagramSocket(portID);
            this.sockSend = new DatagramSocket();
            System.out.println("sockSend Port = " + this.sockSend.getLocalPort());
            System.out.println("sockRecv Port = " + this.sockRecv.getLocalPort());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.inPacket = new DatagramPacket(this.inBuffer, this.inBuffer.length);
        this.outPacket = new DatagramPacket(new byte[0], 0, this.deviceAddress, portID);
        this.sockRecv.setSoTimeout(32000);
        this.connect();
    }

    protected synchronized void logout(byte[] packet) throws SecurityException, IOException {
        this.outPacket.setData(packet);
        this.outPacket.setLength(packet.length);
        this.sockSend.send(this.outPacket);
    }

    protected synchronized void login(byte[] packet) throws SecurityException, IOException, NullPointerException, RlError {
        this.outPacket.setData(packet);
        this.outPacket.setLength(packet.length);
        WaitDialog dialog = null;
        Frame frame = this.getBaseFrame();
        if (frame != null) {
            dialog = new WaitDialog(frame, "Login Dialog", "Logging in ", this.kDevice, null);
        }
        for (int retries = 0; retries < 3; ++retries) {
            this.sockSend.send(this.outPacket);
            try {
                for (int i = 0; i < this.inBuffer.length; ++i) {
                    this.inBuffer[i] = 0;
                }
                this.inPacket.setLength(this.inBuffer.length);
                this.sockRecv.receive(this.inPacket);
                break;
            }
            catch (InterruptedIOException e) {
                MultiBroker.exHandler.receiveLoginExceptions(2, e);
                if (retries != 2) continue;
                if (dialog != null) {
                    dialog.exitDialog();
                }
                throw new RlError("Login not responding");
            }
        }
        if (dialog != null) {
            dialog.exitDialog();
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.inPacket.getData());
        DataInputStream din = new DataInputStream(bin);
        OCP.Header header = new OCP.Header(din);
        OCP.Chunk chunk = new OCP.Chunk(din);
        OCP.Chunk nullChunk = new OCP.Chunk(din);
        int crc = din.readInt();
        Vector<OCP.Chunk> llChunks = new Vector<OCP.Chunk>(4);
        llChunks.addElement(chunk);
        llChunks.addElement(nullChunk);
        OCP.checkCRC(header, llChunks, crc);
        this.processLoginResponse(header, chunk, nullChunk, crc);
    }

    protected synchronized void send(OCP.Header header, PacketComponents components, byte[] packet) throws SecurityException, IOException, RlError {
        if (!this.isEnabled) {
            throw new RlError("Communications is disabled");
        }
        if (!this.isConnected) {
            throw new RlError("Communications is not connected");
        }
        if (this.requestsMade.size() > 256) {
            this.shrinkQueue(this.sessionID);
        }
        this.requestsMade.put(new Integer(header.sessionID), components);
        header.setMesgLen(packet.length);
        byte[] wholePacket = new byte[32 + packet.length];
        System.arraycopy(header.toBytes(), 0, wholePacket, 0, 32);
        System.arraycopy(packet, 0, wholePacket, 32, packet.length);
        packet = OCP.appendCRC(wholePacket);
        this.outPacket.setData(packet);
        this.outPacket.setLength(packet.length);
        this.sockSend.send(this.outPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.canRun) {
            block16: {
                try {
                    if (this.isEnabled) break block16;
                    UDPComm uDPComm = this;
                    synchronized (uDPComm) {
                        while (!this.isEnabled) {
                            this.wait();
                        }
                    }
                }
                catch (SecurityException e) {
                    MultiBroker.exHandler.receiveBrowserExceptions(3, e);
                }
                catch (InterruptedException e) {
                    MultiBroker.exHandler.receiveThreadExceptions(0, e);
                    break;
                }
            }
            Vector<OCP.Chunk> llChunks = new Vector<OCP.Chunk>(8, 8);
            try {
                OCP.Chunk chunk;
                this.inPacket.setLength(this.inBuffer.length);
                this.sockRecv.receive(this.inPacket);
                ByteArrayInputStream bin = new ByteArrayInputStream(this.inPacket.getData());
                DataInputStream din = new DataInputStream(bin);
                OCP.Header header = new OCP.Header(din);
                if (header.headerFlag != 1751280227) {
                    throw new RlError("Bad Header");
                }
                do {
                    chunk = new OCP.Chunk(din);
                    llChunks.addElement(chunk);
                } while (!chunk.equals(OCP.Chunk.kNull));
                int crc = din.readInt();
                OCP.checkCRC(header, llChunks, crc);
                llChunks.removeElementAt(llChunks.size() - 1);
                this.broker.packetParser.parse(header, (Vector)llChunks.clone());
            }
            catch (InterruptedIOException e) {
            }
            catch (SocketException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
                break;
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
            }
            catch (RlError e) {
                MultiBroker.exHandler.receiveBrokerExceptions(2, e);
            }
            for (int i = 0; i < this.inBuffer.length; ++i) {
                this.inBuffer[i] = 0;
            }
        }
    }

    protected void finalize() {
        if (this.sockSend != null) {
            this.sockSend.close();
        }
        if (this.sockRecv != null) {
            this.sockRecv.close();
        }
        this.inPacket = null;
        this.outPacket = null;
        this.sockSend = null;
        this.sockRecv = null;
    }
}

