/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import rl.clbroker.TagContext;

public class TagID {
    protected String id;
    protected TagContext tagContext;
    protected Long pollInterval;
    protected transient long pollState;

    public TagID(String tagName, TagContext context) {
        this(tagName, context, null);
    }

    public TagID(String tagName, TagContext context, Long interval) {
        this.id = tagName;
        this.pollInterval = interval;
        this.tagContext = context == null ? new TagContext(null, null) : context;
        if (interval != null) {
            this.pollState = interval;
        }
    }

    protected boolean matches(String id, String argument) {
        if (!this.id.equals(id)) {
            return false;
        }
        return !(this.tagContext.arguments == null ? argument != null : !this.tagContext.arguments.equals(argument));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TagID)) {
            return false;
        }
        TagID tagID = (TagID)obj;
        if (this.id == null ? tagID.id != null : !this.id.equals(tagID.id)) {
            return false;
        }
        if (this.tagContext == null ? tagID.tagContext != null : !this.tagContext.equals(tagID.tagContext)) {
            return false;
        }
        return !(this.pollInterval == null ? tagID.pollInterval != null : !this.pollInterval.equals(tagID.pollInterval));
    }

    public int hashCode() {
        int count = 0;
        int code = this.id.hashCode();
        ++count;
        if (this.tagContext.arguments != null) {
            code += this.tagContext.arguments.hashCode();
            ++count;
        }
        if (this.tagContext.range != null) {
            code += this.tagContext.range.hashCode();
            ++count;
        }
        if (this.pollInterval != null) {
            code += this.pollInterval.hashCode();
            ++count;
        }
        return code / count;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        buffer.append(this.id);
        buffer.append('(');
        buffer.append(this.tagContext.arguments);
        buffer.append(')');
        buffer.append("[");
        buffer.append(this.tagContext.range);
        buffer.append(']');
        if (this.pollInterval != null) {
            buffer.append('[');
            buffer.append(this.pollInterval);
            buffer.append(']');
        }
        buffer.append('}');
        return buffer.toString();
    }
}

