/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import rl.clbroker.CommLayer;
import rl.clbroker.MultiBroker;
import rl.clbroker.OCP;
import rl.clbroker.PacketComponents;
import rl.clbroker.RetryDialog;
import rl.clbroker.RlError;
import rl.clbroker.WaitDialog;

public class TCPComm
extends CommLayer
implements Runnable {
    protected Socket socket;
    protected DataInputStream din;
    protected DataOutputStream dout;
    protected MultiBroker broker;
    protected String kDevice;

    public TCPComm(MultiBroker broker, String kDevice, int portID, int maxPacketSize, InetAddress deviceAddress) throws IOException {
        this.broker = broker;
        this.kDevice = kDevice;
        TCPComm.portID = portID;
        this.deviceAddress = deviceAddress;
        this.maxPacketSize = maxPacketSize;
    }

    protected void openConnection() throws IOException {
        try {
            this.socket = new Socket(this.deviceAddress, portID);
            this.din = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.dout = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.socket.setSoTimeout(32000);
            this.connect();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    protected synchronized void logout(byte[] packet) throws IOException {
        this.dout.write(packet);
        this.dout.flush();
    }

    protected void login(byte[] packet) throws SecurityException, IOException, NullPointerException, RlError {
        OCP.Header header = null;
        OCP.Chunk chunk = null;
        OCP.Chunk nullChunk = null;
        int crc = 0;
        WaitDialog dialog = null;
        Frame frame = this.getBaseFrame();
        if (frame != null) {
            dialog = new WaitDialog(frame, "Login Dialog", "Logging in ", this.kDevice, this.din);
        }
        for (int retries = 0; retries < 3; ++retries) {
            this.dout.write(packet);
            this.dout.flush();
            try {
                header = new OCP.Header(this.din);
                chunk = new OCP.Chunk(this.din);
                nullChunk = new OCP.Chunk(this.din);
                crc = this.din.readInt();
                break;
            }
            catch (InterruptedIOException e) {
                MultiBroker.exHandler.receiveLoginExceptions(2, e);
                if (retries != 2) continue;
                if (dialog != null) {
                    dialog.exitDialog();
                }
                throw new RlError("Login not responding");
            }
        }
        if (dialog != null) {
            dialog.exitDialog();
        }
        this.processLoginResponse(header, chunk, nullChunk, crc);
    }

    protected synchronized void send(OCP.Header header, PacketComponents components, byte[] packet) throws RlError {
        if (!this.isEnabled) {
            throw new RlError("Communications is disabled");
        }
        if (!this.isConnected) {
            throw new RlError("Communications is not connected");
        }
        if (this.requestsMade.size() > 256) {
            this.shrinkQueue(this.sessionID);
        }
        this.requestsMade.put(new Integer(header.sessionID), components);
        header.setMesgLen(packet.length);
        byte[] wholePacket = new byte[32 + packet.length];
        System.arraycopy(header.toBytes(), 0, wholePacket, 0, 32);
        System.arraycopy(packet, 0, wholePacket, 32, packet.length);
        packet = OCP.appendCRC(wholePacket);
        try {
            this.dout.write(packet);
            this.dout.flush();
        }
        catch (IOException e) {
            MultiBroker.exHandler.receiveIOExceptions(3, e);
            this.isConnected = false;
            this.retryConnection();
        }
    }

    protected synchronized void retryConnection() {
        if (this.isConnected || !this.doRetry) {
            return;
        }
        this.broker.pausePolling();
        if (this.getBaseFrame() != null) {
            RetryDialog retryDialog = new RetryDialog(this);
        } else {
            while (!this.isConnected) {
                try {
                    this.openConnection();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.isConnected) {
            this.broker.unpausePolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.canRun) {
            block17: {
                try {
                    if (this.isEnabled) break block17;
                    TCPComm tCPComm = this;
                    synchronized (tCPComm) {
                        while (!this.isEnabled) {
                            this.wait();
                        }
                    }
                }
                catch (SecurityException e) {
                    MultiBroker.exHandler.receiveBrowserExceptions(3, e);
                }
                catch (InterruptedException e) {
                    MultiBroker.exHandler.receiveThreadExceptions(0, e);
                    break;
                }
            }
            Vector<OCP.Chunk> llChunks = new Vector<OCP.Chunk>(8, 8);
            try {
                OCP.Chunk chunk;
                this.din.mark(256);
                OCP.Header header = new OCP.Header(this.din);
                if (header.headerFlag != 1751280227) {
                    throw new RlError("Bad Header");
                }
                do {
                    chunk = new OCP.Chunk(this.din);
                    llChunks.addElement(chunk);
                } while (!chunk.equals(OCP.Chunk.kNull));
                int crc = this.din.readInt();
                OCP.checkCRC(header, llChunks, crc);
                llChunks.removeElementAt(llChunks.size() - 1);
                this.broker.packetParser.parse(header, (Vector)llChunks.clone());
            }
            catch (InterruptedIOException e) {
                try {
                    this.din.reset();
                }
                catch (Exception er) {
                    MultiBroker.exHandler.receiveIOExceptions(3, e);
                }
            }
            catch (SocketException e) {
                MultiBroker.exHandler.receiveIOExceptions(3, e);
                this.isConnected = false;
                this.retryConnection();
                if (this.isConnected) continue;
                this.canRun = false;
                this.broker.nInstantiated = 0;
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
                this.scanForHeader(this.din);
            }
            catch (RlError e) {
                MultiBroker.exHandler.receiveBrokerExceptions(2, e);
                this.scanForHeader(this.din);
            }
        }
    }

    protected void finalize() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.din = null;
        this.dout = null;
    }
}

