/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Vector;
import rl.clbroker.Broker;
import rl.clbroker.OCP;
import rl.clbroker.PacketComponents;
import rl.clbroker.RlError;
import rl.clbroker.SCommLayer;
import rl.clbroker.SWaitDialog;

public class SUDPComm
extends SCommLayer
implements Runnable {
    protected DatagramSocket sockSend;
    protected DatagramSocket sockRecv;
    protected DatagramPacket outPacket;
    protected DatagramPacket inPacket;
    protected byte[] inBuffer = new byte[kMaxPacketLen];

    public SUDPComm() throws IOException {
        this.openConnection();
    }

    protected void openConnection() throws IOException {
        try {
            this.sockSend = new DatagramSocket();
            this.sockRecv = new DatagramSocket(portID);
            this.inPacket = new DatagramPacket(this.inBuffer, this.inBuffer.length);
            this.outPacket = new DatagramPacket(new byte[0], 0, deviceAddress, portID);
            this.sockRecv.setSoTimeout(32000);
            this.connect();
        }
        catch (Exception e) {
            this.isConnected = false;
        }
    }

    protected synchronized void logout(byte[] packet) throws SecurityException, IOException {
        this.outPacket.setData(packet);
        this.outPacket.setLength(packet.length);
        this.sockSend.send(this.outPacket);
    }

    protected synchronized void login(byte[] packet) throws SecurityException, IOException, NullPointerException, RlError {
        this.outPacket.setData(packet);
        this.outPacket.setLength(packet.length);
        SWaitDialog dialog = null;
        Frame frame = this.getBaseFrame();
        if (frame != null) {
            dialog = new SWaitDialog(frame, "Login Dialog", "Logging in", null);
        }
        for (int retries = 0; retries < 3; ++retries) {
            this.sockSend.send(this.outPacket);
            try {
                for (int i = 0; i < this.inBuffer.length; ++i) {
                    this.inBuffer[i] = 0;
                }
                this.inPacket.setLength(this.inBuffer.length);
                this.sockRecv.receive(this.inPacket);
                break;
            }
            catch (InterruptedIOException e) {
                Broker.exHandler.receiveLoginExceptions(2, e);
                if (retries != 2) continue;
                if (dialog != null) {
                    dialog.exitDialog();
                }
                throw new RlError("Login not responding");
            }
        }
        if (dialog != null) {
            dialog.exitDialog();
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.inPacket.getData());
        DataInputStream din = new DataInputStream(bin);
        OCP.Header header = new OCP.Header(din);
        OCP.Chunk chunk = new OCP.Chunk(din);
        OCP.Chunk nullChunk = new OCP.Chunk(din);
        int crc = din.readInt();
        Vector<OCP.Chunk> llChunks = new Vector<OCP.Chunk>(4);
        llChunks.addElement(chunk);
        llChunks.addElement(nullChunk);
        OCP.checkCRC(header, llChunks, crc);
        this.processLoginResponse(header, chunk, nullChunk, crc);
    }

    protected synchronized void send(OCP.Header header, PacketComponents components, byte[] packet) throws SecurityException, IOException, RlError {
        if (!isEnabled) {
            throw new RlError("Communications is disabled");
        }
        if (!this.isConnected) {
            throw new RlError("Communications is not connected");
        }
        if (requestsMade.size() > 256) {
            this.shrinkQueue(sessionID);
        }
        requestsMade.put(new Integer(header.sessionID), components);
        header.setMesgLen(packet.length);
        byte[] wholePacket = new byte[32 + packet.length];
        System.arraycopy(header.toBytes(), 0, wholePacket, 0, 32);
        System.arraycopy(packet, 0, wholePacket, 32, packet.length);
        packet = OCP.appendCRC(wholePacket);
        this.outPacket.setData(packet);
        this.outPacket.setLength(packet.length);
        this.sockSend.send(this.outPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.canRun) {
            block16: {
                try {
                    if (isEnabled) break block16;
                    SUDPComm sUDPComm = this;
                    synchronized (sUDPComm) {
                        while (!isEnabled) {
                            this.wait();
                        }
                    }
                }
                catch (SecurityException e) {
                    Broker.exHandler.receiveBrowserExceptions(3, e);
                }
                catch (InterruptedException e) {
                    Broker.exHandler.receiveThreadExceptions(0, e);
                    break;
                }
            }
            Vector<OCP.Chunk> llChunks = new Vector<OCP.Chunk>(8, 8);
            try {
                OCP.Chunk chunk;
                this.inPacket.setLength(this.inBuffer.length);
                this.sockRecv.receive(this.inPacket);
                ByteArrayInputStream bin = new ByteArrayInputStream(this.inPacket.getData());
                DataInputStream din = new DataInputStream(bin);
                OCP.Header header = new OCP.Header(din);
                if (header.headerFlag != 1751280227) {
                    throw new RlError("Bad Header");
                }
                do {
                    chunk = new OCP.Chunk(din);
                    llChunks.addElement(chunk);
                } while (!chunk.equals(OCP.Chunk.kNull));
                int crc = din.readInt();
                OCP.checkCRC(header, llChunks, crc);
                llChunks.removeElementAt(llChunks.size() - 1);
                Broker.packetParser.parse(header, (Vector)llChunks.clone());
            }
            catch (InterruptedIOException e) {
            }
            catch (SocketException e) {
                Broker.exHandler.receiveIOExceptions(2, e);
                break;
            }
            catch (IOException e) {
                Broker.exHandler.receiveIOExceptions(2, e);
            }
            catch (RlError e) {
                Broker.exHandler.receiveBrokerExceptions(2, e);
            }
            for (int i = 0; i < this.inBuffer.length; ++i) {
                this.inBuffer[i] = 0;
            }
        }
    }

    protected void close() {
        if (this.sockSend != null) {
            this.sockSend.close();
        }
        if (this.sockRecv != null) {
            this.sockRecv.close();
        }
        this.inPacket = null;
        this.outPacket = null;
        this.sockSend = null;
        this.sockRecv = null;
    }

    protected void finalize() {
        if (this.sockSend != null) {
            this.sockSend.close();
        }
        if (this.sockRecv != null) {
            this.sockRecv.close();
        }
        this.inPacket = null;
        this.outPacket = null;
        this.sockSend = null;
        this.sockRecv = null;
    }
}

