/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import rl.clbroker.Broker;
import rl.clbroker.OCP;
import rl.clbroker.PacketComponents;
import rl.clbroker.RlError;
import rl.clbroker.RlUtil;
import rl.clbroker.SCommLayer;
import rl.clbroker.SRetryDialog;
import rl.clbroker.SWaitDialog;

public class STCPComm
extends SCommLayer
implements Runnable {
    protected Socket socket;
    protected DataInputStream din;
    protected DataOutputStream dout;

    public STCPComm() throws IOException {
        this.openConnection();
    }

    protected void openConnection() throws IOException {
        RlUtil.trace(4, "    STCPComm.openConnection");
        this.socket = new Socket(deviceAddress, portID);
        this.din = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.dout = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        RlUtil.trace(4, "    STCPComm.openConnection - created socket");
        this.socket.setSoTimeout(32000);
        this.connect();
        RlUtil.trace(4, "    STCPComm.openConnection - connected");
    }

    protected synchronized void logout(byte[] packet) throws IOException {
        RlUtil.trace(4, "    STCPComm.logout");
        this.dout.write(packet);
        this.dout.flush();
        RlUtil.trace(4, "    STCPComm.logout - sent logout packet");
    }

    protected void login(byte[] packet) throws SecurityException, IOException, NullPointerException, RlError {
        OCP.Header header = null;
        OCP.Chunk chunk = null;
        OCP.Chunk nullChunk = null;
        int crc = 0;
        SWaitDialog dialog = null;
        RlUtil.trace(4, "    STCPComm.login");
        Frame frame = this.getBaseFrame();
        if (frame != null) {
            dialog = new SWaitDialog(frame, "Login Dialog", "Logging in", this.din);
        }
        for (int retries = 0; retries < 3; ++retries) {
            this.dout.write(packet);
            this.dout.flush();
            RlUtil.trace(4, "    STCPComm.login - sent login packet");
            try {
                header = new OCP.Header(this.din);
                chunk = new OCP.Chunk(this.din);
                nullChunk = new OCP.Chunk(this.din);
                crc = this.din.readInt();
                break;
            }
            catch (InterruptedIOException e) {
                Broker.exHandler.receiveLoginExceptions(2, e);
                RlUtil.trace(4, "    STCPComm.login - exception reading input");
                if (retries != 2) continue;
                if (dialog != null) {
                    dialog.exitDialog();
                }
                RlUtil.trace(4, "    STCPComm.login - login not responding");
                throw new RlError("Login not responding");
            }
        }
        if (dialog != null) {
            dialog.exitDialog();
        }
        this.processLoginResponse(header, chunk, nullChunk, crc);
        RlUtil.trace(4, "    STCPComm.login - complete");
    }

    protected synchronized void send(OCP.Header header, PacketComponents components, byte[] packet) throws RlError {
        RlUtil.trace(4, "    STCPComm.send");
        if (!isEnabled) {
            throw new RlError("Communications is disabled");
        }
        if (!this.isConnected) {
            throw new RlError("Communications is not connected");
        }
        if (requestsMade.size() > 256) {
            this.shrinkQueue(sessionID);
        }
        requestsMade.put(new Integer(header.sessionID), components);
        header.setMesgLen(packet.length);
        byte[] wholePacket = new byte[32 + packet.length];
        System.arraycopy(header.toBytes(), 0, wholePacket, 0, 32);
        System.arraycopy(packet, 0, wholePacket, 32, packet.length);
        packet = OCP.appendCRC(wholePacket);
        try {
            this.dout.write(packet);
            this.dout.flush();
            RlUtil.trace(4, "    STCPComm.send - sent packet");
        }
        catch (IOException e) {
            RlUtil.trace(4, "    STCPComm.send - IOException on send");
            Broker.exHandler.receiveIOExceptions(3, e);
            this.isConnected = false;
            this.retryConnection();
        }
        RlUtil.trace(4, "    STCPComm.send - complete");
    }

    protected synchronized void retryConnection() {
        RlUtil.trace(4, "    STCPComm.retryConnection");
        if (this.isConnected || !this.doRetry) {
            return;
        }
        Broker.pausePolling();
        if (this.getBaseFrame() != null) {
            SRetryDialog retryDialog = new SRetryDialog(this);
        } else {
            while (!this.isConnected) {
                try {
                    RlUtil.trace(4, "    STCPComm.retryConnection - trying to reopen");
                    this.openConnection();
                }
                catch (IOException e) {
                    RlUtil.trace(4, "    STCPComm.retryConnection - IOException trying to reopen");
                }
            }
            RlUtil.trace(4, "    STCPComm.retryConnection - reconnected");
        }
        if (this.isConnected) {
            Broker.unpausePolling();
        }
        RlUtil.trace(4, "    STCPComm.retryConnection - complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RlUtil.trace(4, "    STCPComm.run");
        while (this.canRun) {
            block20: {
                if (!RlUtil.getIgnoreKeepAliveMsgs()) {
                    RlUtil.trace(4, "    STCPComm.run - can run");
                }
                try {
                    if (isEnabled) break block20;
                    STCPComm sTCPComm = this;
                    synchronized (sTCPComm) {
                        while (!isEnabled) {
                            this.wait();
                        }
                    }
                }
                catch (SecurityException e) {
                    Broker.exHandler.receiveBrowserExceptions(3, e);
                }
                catch (InterruptedException e) {
                    Broker.exHandler.receiveThreadExceptions(0, e);
                    break;
                }
            }
            if (!RlUtil.getIgnoreKeepAliveMsgs()) {
                RlUtil.trace(4, "    STCPComm.run - reading chunks");
            }
            Vector<OCP.Chunk> llChunks = new Vector<OCP.Chunk>(8, 8);
            try {
                OCP.Chunk chunk;
                this.din.mark(256);
                OCP.Header header = new OCP.Header(this.din);
                if (header.headerFlag != 1751280227) {
                    throw new RlError("Bad Header");
                }
                do {
                    chunk = new OCP.Chunk(this.din);
                    llChunks.addElement(chunk);
                } while (!chunk.equals(OCP.Chunk.kNull));
                int crc = this.din.readInt();
                OCP.checkCRC(header, llChunks, crc);
                llChunks.removeElementAt(llChunks.size() - 1);
                Broker.packetParser.parse(header, (Vector)llChunks.clone());
            }
            catch (InterruptedIOException e) {
                if (!RlUtil.getIgnoreKeepAliveMsgs()) {
                    RlUtil.trace(4, "    STCPComm.run - InterruptedIOException reading chunks");
                }
                try {
                    this.din.reset();
                }
                catch (Exception er) {
                    Broker.exHandler.receiveIOExceptions(3, e);
                }
            }
            catch (SocketException e) {
                RlUtil.trace(4, "    STCPComm.run - SocketException reading chunks");
                Broker.exHandler.receiveIOExceptions(3, e);
                this.isConnected = false;
                this.retryConnection();
                if (this.isConnected) continue;
                this.canRun = false;
                Broker.nInstantiated = 0;
            }
            catch (IOException e) {
                RlUtil.trace(4, "    STCPComm.run - IOException reading chunks");
                Broker.exHandler.receiveIOExceptions(2, e);
                this.scanForHeader(this.din);
            }
            catch (RlError e) {
                RlUtil.trace(4, "    STCPComm.run - RlError reading chunks");
                Broker.exHandler.receiveBrokerExceptions(2, e);
                this.scanForHeader(this.din);
            }
        }
        RlUtil.trace(4, "    STCPComm.run - CANNOT run - exiting");
    }

    protected void close() {
        RlUtil.trace(4, "    STCPComm.close");
        try {
            if (this.din != null) {
                RlUtil.trace(4, "    STCPComm.close - closing inStream");
                this.din.close();
            }
        }
        catch (Exception e) {
            RlUtil.trace(4, "    STCPComm.close - Exception closing inStream");
        }
        try {
            if (this.dout != null) {
                RlUtil.trace(4, "    STCPComm.close - closing outStream");
                this.dout.close();
            }
        }
        catch (Exception e) {
            RlUtil.trace(4, "    STCPComm.close - Exception closing outStream");
        }
        try {
            if (this.socket != null) {
                RlUtil.trace(4, "    STCPComm.close - closing socket");
                this.socket.close();
            }
        }
        catch (Exception e) {
            RlUtil.trace(4, "    STCPComm.close - Exception closing socket");
        }
        this.din = null;
        this.dout = null;
        RlUtil.trace(4, "    STCPComm.close - complete");
    }

    protected void finalize() {
        RlUtil.trace(4, "    STCPComm.finalize");
        try {
            if (this.socket != null) {
                RlUtil.trace(4, "    STCPComm.finalize - closing socket");
                this.socket.close();
            } else {
                RlUtil.trace(4, "    STCPComm.finalize - socket already closed");
            }
        }
        catch (Exception e) {
            RlUtil.trace(4, "    STCPComm.finalize - Exception closing socket");
        }
        this.din = null;
        this.dout = null;
        RlUtil.trace(4, "    STCPComm.finalize - complete");
    }
}

