/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import rl.clbroker.Broker;
import rl.clbroker.RlSDatabase;
import rl.clbroker.TagID;

public class SPollingThread
extends Thread {
    private static final int kTick = 100;
    protected Vector polls = new Vector();
    protected Hashtable outgoing = new Hashtable(8);
    protected boolean canRun = true;
    protected boolean isPaused = false;

    public SPollingThread() {
        super("SPollingThread");
    }

    protected synchronized void setPause(boolean isPaused) {
        if (isPaused == this.isPaused) {
            return;
        }
        this.isPaused = isPaused;
        if (!isPaused) {
            this.notify();
        }
    }

    protected synchronized void end() {
        this.canRun = false;
        this.interrupt();
    }

    protected synchronized void addPoll(TagID tagID) {
        if (!this.polls.contains(tagID)) {
            this.polls.addElement(tagID);
        }
        this.notify();
    }

    protected synchronized void addPoll(Vector tagIDs) {
        Object[] array = new TagID[tagIDs.size()];
        tagIDs.copyInto(array);
        this.addPoll((TagID[])array);
    }

    protected synchronized void addPoll(TagID[] tagIDs) {
        for (int i = 0; i < tagIDs.length; ++i) {
            if (this.polls.contains(tagIDs[i])) continue;
            this.polls.addElement(tagIDs[i]);
        }
        this.notify();
    }

    protected synchronized void removePoll(TagID tagID) {
        this.polls.removeElement(tagID);
    }

    protected synchronized void removePolls(TagID[] tagIDs) {
        for (int i = 0; i < tagIDs.length; ++i) {
            this.polls.removeElement(tagIDs[i]);
        }
    }

    protected synchronized void pausePolling() {
        this.isPaused = true;
    }

    protected synchronized void resumePolling() {
        this.isPaused = false;
        this.notify();
    }

    protected synchronized void removeAll() {
        this.polls.removeAllElements();
    }

    protected synchronized void addAll() {
        this.polls = (Vector)RlSDatabase.polls.clone();
        this.polls.trimToSize();
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.canRun) {
            SPollingThread sPollingThread;
            try {
                SPollingThread.sleep(100L);
                sPollingThread = this;
                synchronized (sPollingThread) {
                    if (this.isPaused || this.polls.isEmpty()) {
                        while (this.isPaused || this.polls.isEmpty()) {
                            this.wait();
                        }
                    }
                }
            }
            catch (SecurityException e) {
                Broker.exHandler.receiveBrowserExceptions(3, e);
            }
            catch (InterruptedException e) {
                Broker.exHandler.receiveThreadExceptions(0, e);
            }
            sPollingThread = this;
            synchronized (sPollingThread) {
                for (int i = 0; i < this.polls.size(); ++i) {
                    TagID currentID = (TagID)this.polls.elementAt(i);
                    currentID.pollState -= 100L;
                    if (currentID.pollState > 0L) continue;
                    int increment = (int)Math.max(100L, currentID.pollInterval);
                    currentID.pollState += (long)increment;
                    Hashtable hash = (Hashtable)RlSDatabase.bindMap.get(currentID);
                    Enumeration e = hash.keys();
                    while (e.hasMoreElements()) {
                        Object initiator = e.nextElement();
                        Vector<TagID> v = (Vector<TagID>)this.outgoing.get(initiator);
                        if (v == null) {
                            v = new Vector<TagID>(8);
                        }
                        if (v.contains(currentID)) continue;
                        v.addElement(currentID);
                        this.outgoing.put(initiator, v);
                    }
                }
                Enumeration e = this.outgoing.keys();
                while (e.hasMoreElements()) {
                    Object initiatorKey = e.nextElement();
                    Broker.packetBuilder.build(initiatorKey, (Vector)this.outgoing.get(initiatorKey), 5);
                }
                this.outgoing.clear();
            }
        }
    }
}

