/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import rl.clbroker.Broker;
import rl.clbroker.OCP;
import rl.clbroker.PacketComponents;
import rl.clbroker.RlError;
import rl.clbroker.RlUtil;

public abstract class SCommLayer {
    protected static final int kUndef = -1;
    protected boolean canRun = true;
    protected boolean attemptResynch = true;
    protected static boolean isEnabled = true;
    protected static InetAddress deviceAddress;
    protected static int maxPacketSize;
    protected static int connectionID;
    protected static int sessionID;
    public static int portID;
    protected static String userId;
    protected static String password;
    protected static int kMaxPacketLen;
    protected static final int kSizeOfQueue = 256;
    protected static Hashtable requestsMade;
    public static final int kMSecsBlock = 32000;
    public boolean isConnected = false;
    protected static final int kLoginRetries = 3;
    protected boolean doRetry = true;

    public static InetAddress getDeviceAddress() {
        return deviceAddress;
    }

    public static void setUserId(String newUserId) {
        userId = newUserId;
    }

    public static void setPassword(String newPassword) {
        password = newPassword;
    }

    protected synchronized void enable() {
        isEnabled = true;
        this.notify();
    }

    protected synchronized void disable() {
        isEnabled = false;
    }

    protected byte[] buildLoginPacket() {
        OCP.Header header = new OCP.Header(connectionID, sessionID++, 1, new byte[4]);
        OCP.Login login = new OCP.Login();
        login.getClass();
        OCP.Login.Request login2 = login.new OCP.Login.Request(1, 2, userId, password);
        OCP.Chunk chunk = new OCP.Chunk(login2);
        byte[] bChunk = chunk.toBytes();
        byte[] bNull = OCP.Chunk.kNull.toBytes();
        header.setMesgLen(bChunk.length + bNull.length);
        byte[] bHeader = header.toBytes();
        byte[] packet = new byte[bHeader.length + bChunk.length + bNull.length];
        System.arraycopy(bHeader, 0, packet, 0, bHeader.length);
        System.arraycopy(bChunk, 0, packet, bHeader.length, bChunk.length);
        return OCP.appendCRC(packet);
    }

    protected void processLoginResponse(OCP.Header header, OCP.Chunk chunk, OCP.Chunk nullChunk, int crc) throws IOException, RlError {
        RlUtil.trace(4, "    SCommLayer.processLoginResponse");
        if (header.headerFlag != 1751280227) {
            throw new RlError("Bad Header");
        }
        if (chunk.chunkLen != chunk.endLen) {
            throw new RlError("Bad Chunk");
        }
        if (!nullChunk.equals(OCP.Chunk.kNull)) {
            throw new RlError("Bad Login Response packet");
        }
        byte[] recvHeader = header.toBytes();
        byte[] recvChunk = chunk.toBytes();
        byte[] recvNullChunk = nullChunk.toBytes();
        byte[] recvPacket = new byte[recvHeader.length + recvChunk.length + recvNullChunk.length];
        System.arraycopy(recvHeader, 0, recvPacket, 0, recvHeader.length);
        System.arraycopy(recvChunk, 0, recvPacket, recvHeader.length, recvChunk.length);
        System.arraycopy(recvNullChunk, 0, recvPacket, recvHeader.length + recvChunk.length, recvNullChunk.length);
        OCP.checkCRC(recvPacket, crc);
        OCP.Login login = new OCP.Login();
        login.getClass();
        OCP.Login.Response response = login.new OCP.Login.Response(chunk.getDataStream());
        connectionID = response.getConnectionID();
        RlUtil.trace(4, "    SCommLayer.processLoginResponse - complete");
    }

    protected Frame getBaseFrame() {
        Component c = Broker.currentDisplay;
        if (c == null) {
            return null;
        }
        while (!(c instanceof Frame)) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    protected void connect() {
        byte[] loginPacket = this.buildLoginPacket();
        RlUtil.trace(4, "    SCommLayer.connect");
        try {
            this.isConnected = true;
            this.login(loginPacket);
        }
        catch (Exception e) {
            RlUtil.trace(4, "    SCommLayer.connect - Exception");
            Broker.exHandler.receiveLoginExceptions(4, e);
        }
        RlUtil.trace(4, "    SCommLayer.connect - complete");
    }

    protected byte[] buildLogoutPacket() {
        OCP.Header header = new OCP.Header(connectionID, sessionID++, 3, new byte[4]);
        OCP.Logout.Request logout = new OCP.Logout().new OCP.Logout.Request();
        OCP.Chunk nullChunk = OCP.Chunk.kNull;
        byte[] bLogout = logout.toBytes();
        byte[] bNullChunk = nullChunk.toBytes();
        header.setMesgLen(bNullChunk.length);
        byte[] bHeader = header.toBytes();
        byte[] packet = new byte[bHeader.length + bLogout.length + bNullChunk.length];
        System.arraycopy(bHeader, 0, packet, 0, bHeader.length);
        System.arraycopy(bLogout, 0, packet, bHeader.length, bLogout.length);
        return OCP.appendCRC(packet);
    }

    protected void disconnect() {
        byte[] logoutPacket = this.buildLogoutPacket();
        RlUtil.trace(4, "    SCommLayer.disconnect");
        try {
            this.logout(logoutPacket);
        }
        catch (SecurityException e) {
            RlUtil.trace(4, "    SCommLayer.disconnect - SecurityException");
            RlUtil.trace(4, "                            Eating the exception");
        }
        catch (IOException e) {
            RlUtil.trace(4, "    SCommLayer.disconnect - IOException");
            RlUtil.trace(4, "                            Eating the exception");
        }
        catch (Exception e) {
            RlUtil.trace(4, "    SCommLayer.disconnect - Exception", e);
            RlUtil.trace(4, "                            Eating the exception");
        }
        this.doRetry = false;
        this.isConnected = false;
        RlUtil.trace(4, "    SCommLayer.disconnect - complete");
    }

    protected synchronized void shrinkQueue(int sessionID) {
        Enumeration e = requestsMade.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            if (key >= sessionID - 256 + 1) continue;
            requestsMade.remove(key);
        }
    }

    protected void scanForHeader(InputStream in) {
        PushbackInputStream pbin = new PushbackInputStream(in, 4);
        RlUtil.trace(4, "    SCommLayer.scanForHeader");
        try {
            while (this.attemptResynch) {
                RlUtil.trace(4, "    SCommLayer.scanForHeader - starting resynch loop");
                pbin.mark(256);
                int a = pbin.read();
                if (a == OCP.kHeaderFlag[0]) {
                    pbin.mark(256);
                    int b = pbin.read();
                    if (b == OCP.kHeaderFlag[1]) {
                        pbin.mark(256);
                        int c = pbin.read();
                        if (c == OCP.kHeaderFlag[2]) {
                            pbin.mark(256);
                            int d = pbin.read();
                            if (d == OCP.kHeaderFlag[3]) {
                                pbin.unread(d);
                                pbin.unread(c);
                                pbin.unread(b);
                                pbin.unread(a);
                                RlUtil.trace(4, "    SCommLayer.scanForHeader - found header");
                                break;
                            }
                            RlUtil.trace(4, "    SCommLayer.scanForHeader - invalid byte D");
                            pbin.unread(d);
                        } else {
                            RlUtil.trace(4, "    SCommLayer.scanForHeader - invalid byte C");
                        }
                        pbin.unread(c);
                    } else {
                        RlUtil.trace(4, "    SCommLayer.scanForHeader - invalid byte B");
                    }
                    pbin.unread(b);
                    continue;
                }
                RlUtil.trace(4, "    SCommLayer.scanForHeader - invalid byte A");
            }
            RlUtil.trace(4, "    SCommLayer.scanForHeader - resynch aborted");
        }
        catch (IOException e) {
            RlUtil.trace(4, "    SCommLayer.scanForHeader - IOException");
            Broker.exHandler.receiveIOExceptions(3, e);
        }
        RlUtil.trace(4, "    SCommLayer.scanForHeader - complete");
    }

    protected abstract void openConnection() throws IOException;

    protected abstract void logout(byte[] var1) throws SecurityException, IOException;

    protected abstract void login(byte[] var1) throws Exception;

    protected abstract void close() throws Exception;

    protected abstract void send(OCP.Header var1, PacketComponents var2, byte[] var3) throws SecurityException, IOException, RlError;

    static {
        maxPacketSize = 512;
        sessionID = 0;
        portID = -1;
        userId = new String("anonymous");
        password = new String("");
        kMaxPacketLen = 32768;
        requestsMade = new Hashtable(256);
    }
}

