/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RlUtil {
    public static final int TRACE_NONE = 0;
    public static final int TRACE_ALERT = 1;
    public static final int TRACE_ERROR = 2;
    public static final int TRACE_INFO = 3;
    public static final int TRACE_DEBUG = 4;
    public static final int TRACE_OUT = 0;
    public static final int TRACE_ERR = 1;
    public static final int TRACE_DSP = 2;
    private static final String DATE_FORMAT_PATTERN = "yyyy.MM.dd HH:mm:ss";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static int traceLevel = 0;
    private static int traceStream = 0;
    private static boolean ignoreKeepAliveMsgs = true;
    private static final String sccs_id = " * @(#)RlUtil.java    1.5    04/11/29     SMI";
    static /* synthetic */ Class class$rl$clbroker$RlUtil;

    public static synchronized void setTraceLevel(int level) {
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                traceLevel = level;
                break;
            }
        }
    }

    public static synchronized void setTraceStream(int stream) {
        switch (stream) {
            case 0: 
            case 1: 
            case 2: {
                traceStream = stream;
                break;
            }
        }
    }

    public static void setIgnoreKeepAliveMsgs(boolean flag) {
        ignoreKeepAliveMsgs = flag;
    }

    public static boolean getIgnoreKeepAliveMsgs() {
        return ignoreKeepAliveMsgs;
    }

    public static synchronized void trace(int level, String message) {
        RlUtil.trace(level, message, null);
    }

    public static synchronized void trace(int level, String message, Throwable ex) {
        if (level <= traceLevel) {
            block0 : switch (traceStream) {
                case 0: {
                    RlUtil.systemOut(RlUtil.format(level, message));
                    RlUtil.systemExceptionOut(ex);
                    break;
                }
                case 1: {
                    RlUtil.systemErr(RlUtil.format(level, message));
                    RlUtil.systemExceptionErr(ex);
                    break;
                }
                case 2: {
                    switch (traceLevel) {
                        case 1: {
                            Trace.error((Class)(class$rl$clbroker$RlUtil == null ? (class$rl$clbroker$RlUtil = RlUtil.class$("rl.clbroker.RlUtil")) : class$rl$clbroker$RlUtil), (String)message, (Throwable)ex);
                            break block0;
                        }
                        case 2: {
                            Trace.warn((Class)(class$rl$clbroker$RlUtil == null ? (class$rl$clbroker$RlUtil = RlUtil.class$("rl.clbroker.RlUtil")) : class$rl$clbroker$RlUtil), (String)message, (Throwable)ex);
                            break block0;
                        }
                        case 3: 
                        case 4: {
                            Trace.info((Class)(class$rl$clbroker$RlUtil == null ? (class$rl$clbroker$RlUtil = RlUtil.class$("rl.clbroker.RlUtil")) : class$rl$clbroker$RlUtil), (String)message, (Throwable)ex);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
    }

    private static String format(int level, String message) {
        String traceMsg = "Rl: L" + level + ": ";
        StringBuffer dateBuffer = new StringBuffer();
        dateBuffer = dateFormat.format(new Date(), dateBuffer, new FieldPosition(0));
        traceMsg = traceMsg + dateBuffer.toString() + " | " + message;
        return traceMsg;
    }

    public static synchronized void systemOut(String message) {
        try {
            System.out.println(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void systemExceptionOut(Throwable ex) {
        if (ex == null) {
            return;
        }
        try {
            ex.printStackTrace(System.out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void systemErr(String message) {
        try {
            System.err.println(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void systemExceptionErr(Throwable ex) {
        if (ex == null) {
            return;
        }
        try {
            ex.printStackTrace(System.err);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

