/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import rl.clbroker.Broker;
import rl.clbroker.InitiatorContext;
import rl.clbroker.MagicMarkup;
import rl.clbroker.Range;
import rl.clbroker.RlBeanProperty;
import rl.clbroker.TagID;

public class RlSDatabase {
    private static final int initCapacity = 8;
    private static final int initCapIncr = 8;
    protected static Hashtable nameRefMap = new Hashtable(8);
    protected static Hashtable bindMap = new Hashtable(8);
    protected static Hashtable initiatorMap = new Hashtable(8);
    protected static Vector gets = new Vector(8, 8);
    protected static Vector polls = new Vector(8, 8);
    protected static Vector events = new Vector(8, 8);

    protected static MagicMarkup name(String reference, MagicMarkup markup) {
        return nameRefMap.put(reference, markup);
    }

    protected static Vector name(String reference, Vector markups) {
        return nameRefMap.put(reference, markups);
    }

    protected static boolean checkTag(TagID tag) {
        return bindMap.containsKey(tag);
    }

    protected static synchronized InitiatorContext setInitiatorContext(Object initiator, String table) {
        InitiatorContext initContext = (InitiatorContext)initiatorMap.get(initiator);
        InitiatorContext r = null;
        if (initContext == null) {
            initContext = new InitiatorContext();
        } else {
            r = (InitiatorContext)initContext.clone();
        }
        initContext.setSNMPTable(table);
        initiatorMap.put(initiator, initContext);
        return r;
    }

    protected static synchronized InitiatorContext setInitiatorContext(Object initiator, Range range) {
        InitiatorContext initContext = (InitiatorContext)initiatorMap.get(initiator);
        InitiatorContext r = null;
        if (initContext == null) {
            initContext = new InitiatorContext();
        } else {
            r = (InitiatorContext)initContext.clone();
        }
        initContext.setRange(range);
        initiatorMap.put(initiator, initContext);
        return r;
    }

    protected static synchronized InitiatorContext setInitiatorContext(Object initiator, Vector contextNodes) {
        InitiatorContext initContext = (InitiatorContext)initiatorMap.get(initiator);
        InitiatorContext r = null;
        if (initContext == null) {
            initContext = new InitiatorContext();
        } else {
            r = (InitiatorContext)initContext.clone();
        }
        initContext.setContextNodes(contextNodes);
        initiatorMap.put(initiator, initContext);
        return r;
    }

    protected static synchronized InitiatorContext setInitiatorContext(Object initiator, Range range, Vector contextNodes) {
        InitiatorContext initContext = (InitiatorContext)initiatorMap.get(initiator);
        InitiatorContext r = null;
        if (initContext == null) {
            initContext = new InitiatorContext();
        } else {
            r = (InitiatorContext)initContext.clone();
        }
        initContext.setContextNodes(contextNodes);
        initContext.setRange(range);
        initiatorMap.put(initiator, initContext);
        return r;
    }

    protected static synchronized InitiatorContext removeInitiator(Object initiator) {
        InitiatorContext context = (InitiatorContext)initiatorMap.remove(initiator);
        Enumeration e = bindMap.elements();
        while (e.hasMoreElements()) {
            Hashtable hash = (Hashtable)e.nextElement();
            hash.remove(initiator);
        }
        return context;
    }

    protected static synchronized Vector bind(TagID tagID, Object initiator, RlBeanProperty beanProp) {
        Hashtable hashTable = (Hashtable)bindMap.get(tagID);
        Vector<RlBeanProperty> v = null;
        Vector r = null;
        if (hashTable == null) {
            hashTable = new Hashtable(8);
            v = new Vector<RlBeanProperty>(8, 8);
            v.addElement(beanProp);
        } else {
            v = (Vector<RlBeanProperty>)hashTable.get(initiator);
            if (v == null) {
                v = new Vector(8, 8);
                v.addElement(beanProp);
            } else {
                r = (Vector)v.clone();
                if (!v.contains(beanProp)) {
                    v.addElement(beanProp);
                }
            }
        }
        hashTable.put(initiator, v);
        if (!initiator.equals("null") && tagID.pollInterval == null) {
            hashTable.put("null", v);
        }
        bindMap.put(tagID, hashTable);
        InitiatorContext context = (InitiatorContext)initiatorMap.get(initiator);
        if (context == null) {
            context = new InitiatorContext();
        }
        context.addTag(tagID);
        initiatorMap.put(initiator, context);
        return r;
    }

    protected static synchronized void unbindMarkupFrom(TagID tagID, Object initiator, RlBeanProperty beanProp) {
        Hashtable hash = (Hashtable)bindMap.get(tagID);
        if (hash != null) {
            Vector beanProps = (Vector)hash.get(initiator);
            if (beanProps != null) {
                for (int i = 0; i < beanProps.size(); ++i) {
                    RlBeanProperty bean = (RlBeanProperty)beanProps.elementAt(i);
                    if (!beanProp.equals(bean)) continue;
                    beanProps.removeElementAt(i);
                    break;
                }
                if (beanProps.isEmpty()) {
                    hash.remove(initiator);
                }
            }
            if (hash.isEmpty()) {
                bindMap.remove(tagID);
                RlSDatabase.removePoll(tagID);
                gets.removeElement(tagID);
            }
        }
        boolean remove = true;
        Enumeration enumeration = bindMap.keys();
        while (enumeration.hasMoreElements()) {
            TagID tag = (TagID)enumeration.nextElement();
            if (!tagID.id.equals(tag.id)) continue;
            remove = false;
            break;
        }
        if (remove) {
            nameRefMap.remove(tagID);
        }
    }

    protected static synchronized void deleteMarkup(String name) {
        nameRefMap.remove(name);
        Enumeration ebm = bindMap.keys();
        while (ebm.hasMoreElements()) {
            TagID tagID = (TagID)ebm.nextElement();
            if (!tagID.id.equals(name)) continue;
            RlSDatabase.removeMarkup(tagID);
        }
    }

    protected static synchronized void removeMarkup(TagID tagID) {
        Hashtable hash = (Hashtable)bindMap.remove(tagID);
        RlSDatabase.removePoll(tagID);
        gets.removeElement(tagID);
        if (hash != null) {
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                Object initiator = e.nextElement();
                InitiatorContext context = (InitiatorContext)initiatorMap.get(initiator);
                if (context == null) continue;
                context.removeTag(tagID);
                initiatorMap.put(initiator, context);
            }
        }
    }

    protected static synchronized void addPoll(TagID tagID) {
        if (!polls.contains(tagID)) {
            if (Broker.nInstantiated > 0) {
                Broker.pollingThread.addPoll(tagID);
            }
            polls.addElement(tagID);
        }
    }

    protected static synchronized void removePoll(TagID tagID) {
        polls.removeElement(tagID);
        Broker.pollingThread.removePoll(tagID);
    }

    protected static synchronized void clear() {
        gets.removeAllElements();
        polls.removeAllElements();
        initiatorMap.clear();
        nameRefMap.clear();
        bindMap.clear();
    }
}

