/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import rl.clbroker.InitiatorContext;
import rl.clbroker.MagicMarkup;
import rl.clbroker.MultiBroker;
import rl.clbroker.Range;
import rl.clbroker.RlBeanProperty;
import rl.clbroker.TagID;

public class RlDatabase {
    private static final int initCapacity = 8;
    private static final int initCapIncr = 8;
    protected Hashtable nameRefMap = new Hashtable(8);
    protected Hashtable bindMap = new Hashtable(8);
    protected Hashtable initiatorMap = new Hashtable(8);
    protected Vector gets = new Vector(8, 8);
    protected Vector polls = new Vector(8, 8);
    protected Vector events = new Vector(8, 8);
    protected MultiBroker broker;

    public RlDatabase(MultiBroker broker) {
        this.broker = broker;
    }

    protected MagicMarkup name(String reference, MagicMarkup markup) {
        return this.nameRefMap.put(reference, markup);
    }

    protected Vector name(String reference, Vector markups) {
        return this.nameRefMap.put(reference, markups);
    }

    protected boolean checkTag(TagID tag) {
        return this.bindMap.containsKey(tag);
    }

    protected synchronized InitiatorContext setInitiatorContext(Object initiator, String table) {
        InitiatorContext initContext = (InitiatorContext)this.initiatorMap.get(initiator);
        InitiatorContext r = null;
        if (initContext == null) {
            initContext = new InitiatorContext();
        } else {
            r = (InitiatorContext)initContext.clone();
        }
        initContext.setSNMPTable(table);
        this.initiatorMap.put(initiator, initContext);
        return r;
    }

    protected synchronized InitiatorContext setInitiatorContext(Object initiator, Range range) {
        InitiatorContext initContext = (InitiatorContext)this.initiatorMap.get(initiator);
        InitiatorContext r = null;
        if (initContext == null) {
            initContext = new InitiatorContext();
        } else {
            r = (InitiatorContext)initContext.clone();
        }
        initContext.setRange(range);
        this.initiatorMap.put(initiator, initContext);
        return r;
    }

    protected synchronized InitiatorContext setInitiatorContext(Object initiator, Vector contextNodes) {
        InitiatorContext initContext = (InitiatorContext)this.initiatorMap.get(initiator);
        InitiatorContext r = null;
        if (initContext == null) {
            initContext = new InitiatorContext();
        } else {
            r = (InitiatorContext)initContext.clone();
        }
        initContext.setContextNodes(contextNodes);
        this.initiatorMap.put(initiator, initContext);
        return r;
    }

    protected synchronized InitiatorContext setInitiatorContext(Object initiator, Range range, Vector contextNodes) {
        InitiatorContext initContext = (InitiatorContext)this.initiatorMap.get(initiator);
        InitiatorContext r = null;
        if (initContext == null) {
            initContext = new InitiatorContext();
        } else {
            r = (InitiatorContext)initContext.clone();
        }
        initContext.setContextNodes(contextNodes);
        initContext.setRange(range);
        this.initiatorMap.put(initiator, initContext);
        return r;
    }

    protected synchronized InitiatorContext removeInitiator(Object initiator) {
        InitiatorContext context = (InitiatorContext)this.initiatorMap.remove(initiator);
        Enumeration e = this.bindMap.elements();
        while (e.hasMoreElements()) {
            Hashtable hash = (Hashtable)e.nextElement();
            hash.remove(initiator);
        }
        return context;
    }

    protected synchronized Vector bind(TagID tagID, Object initiator, RlBeanProperty beanProp) {
        Hashtable hashTable = (Hashtable)this.bindMap.get(tagID);
        Vector<RlBeanProperty> v = null;
        Vector r = null;
        if (hashTable == null) {
            hashTable = new Hashtable(8);
            v = new Vector<RlBeanProperty>(8, 8);
            v.addElement(beanProp);
        } else {
            v = (Vector<RlBeanProperty>)hashTable.get(initiator);
            if (v == null) {
                v = new Vector(8, 8);
                v.addElement(beanProp);
            } else {
                r = (Vector)v.clone();
                if (!v.contains(beanProp)) {
                    v.addElement(beanProp);
                }
            }
        }
        hashTable.put(initiator, v);
        if (!initiator.equals("null") && tagID.pollInterval == null) {
            hashTable.put("null", v);
        }
        this.bindMap.put(tagID, hashTable);
        InitiatorContext context = (InitiatorContext)this.initiatorMap.get(initiator);
        if (context == null) {
            context = new InitiatorContext();
        }
        context.addTag(tagID);
        this.initiatorMap.put(initiator, context);
        return r;
    }

    protected synchronized void unbindMarkupFrom(TagID tagID, Object initiator, RlBeanProperty beanProp) {
        Hashtable hash = (Hashtable)this.bindMap.get(tagID);
        if (hash != null) {
            Vector beanProps = (Vector)hash.get(initiator);
            if (beanProps != null) {
                for (int i = 0; i < beanProps.size(); ++i) {
                    RlBeanProperty bean = (RlBeanProperty)beanProps.elementAt(i);
                    if (!beanProp.equals(bean)) continue;
                    beanProps.removeElementAt(i);
                    break;
                }
                if (beanProps.isEmpty()) {
                    hash.remove(initiator);
                }
            }
            if (hash.isEmpty()) {
                this.bindMap.remove(tagID);
                this.removePoll(tagID);
                this.gets.removeElement(tagID);
            }
        }
        boolean remove = true;
        Enumeration enumeration = this.bindMap.keys();
        while (enumeration.hasMoreElements()) {
            TagID tag = (TagID)enumeration.nextElement();
            if (!tagID.id.equals(tag.id)) continue;
            remove = false;
            break;
        }
        if (remove) {
            this.nameRefMap.remove(tagID);
        }
    }

    protected synchronized void deleteMarkup(String name) {
        this.nameRefMap.remove(name);
        Enumeration ebm = this.bindMap.keys();
        while (ebm.hasMoreElements()) {
            TagID tagID = (TagID)ebm.nextElement();
            if (!tagID.id.equals(name)) continue;
            this.removeMarkup(tagID);
        }
    }

    protected synchronized void removeMarkup(TagID tagID) {
        Hashtable hash = (Hashtable)this.bindMap.remove(tagID);
        this.removePoll(tagID);
        this.gets.removeElement(tagID);
        if (hash != null) {
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                Object initiator = e.nextElement();
                InitiatorContext context = (InitiatorContext)this.initiatorMap.get(initiator);
                if (context == null) continue;
                context.removeTag(tagID);
                this.initiatorMap.put(initiator, context);
            }
        }
    }

    protected synchronized void addPoll(TagID tagID) {
        if (!this.polls.contains(tagID)) {
            if (this.broker.nInstantiated > 0) {
                this.broker.pollingThread.addPoll(tagID);
            }
            this.polls.addElement(tagID);
        }
    }

    protected synchronized void removePoll(TagID tagID) {
        this.polls.removeElement(tagID);
        this.broker.pollingThread.removePoll(tagID);
    }

    protected synchronized void clear() {
        this.gets.removeAllElements();
        this.polls.removeAllElements();
        this.initiatorMap.clear();
        this.nameRefMap.clear();
        this.bindMap.clear();
    }
}

