/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import rl.clbroker.RlError;

public class RlBeanProperty {
    protected Object bean;
    protected String property;
    protected Class beanClass;
    protected Method getMethod;
    protected Method setMethod;
    protected Method getIndexMethod;
    protected Method setIndexMethod;
    protected Object getInitiator;
    protected Object setInitiator;

    public RlBeanProperty(Object bean, String property) throws NoSuchFieldException, StringIndexOutOfBoundsException, IntrospectionException, RlError {
        this.bean = bean;
        this.property = property;
        this.beanClass = bean.getClass();
        Class propertyClass = this.getPropertyClass();
        if (!this.checkBeanInfo()) {
            this.checkReflection(propertyClass);
        }
        String getMethod = null;
        String setMethod = null;
        if (this.getMethod != null) {
            getMethod = this.getMethod.getName();
        }
        if (this.setMethod != null) {
            setMethod = this.setMethod.getName();
        }
        this.setReflectionArrayMethods(getMethod, setMethod, propertyClass);
    }

    public RlBeanProperty(Object bean, String property, Class propertyClass) throws NoSuchFieldException, StringIndexOutOfBoundsException, IntrospectionException {
        this.bean = bean;
        this.property = property;
        this.beanClass = bean.getClass();
        if (!this.checkBeanInfo()) {
            this.checkReflection(propertyClass);
        }
        String getMethod = null;
        String setMethod = null;
        if (this.getMethod != null) {
            getMethod = this.getMethod.getName();
        }
        if (this.setMethod != null) {
            setMethod = this.setMethod.getName();
        }
        this.setReflectionArrayMethods(getMethod, setMethod, propertyClass);
    }

    private PropertyDescriptor findPropertyDescriptor(PropertyDescriptor[] properties) {
        PropertyDescriptor theProperty = null;
        for (int i = 0; i < properties.length; ++i) {
            if (!this.property.equals(properties[i].getName())) continue;
            theProperty = properties[i];
            break;
        }
        return theProperty;
    }

    private boolean checkBeanInfo() throws IntrospectionException, IllegalArgumentException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.beanClass);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (beanInfo == null) {
            return false;
        }
        PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
        PropertyDescriptor theProperty = this.findPropertyDescriptor(properties);
        if (theProperty == null) {
            return false;
        }
        this.getMethod = theProperty.getReadMethod();
        this.setMethod = theProperty.getWriteMethod();
        if (this.setMethod == null && this.getMethod == null) {
            throw new IllegalArgumentException("No accessor methods for " + this.property);
        }
        return true;
    }

    private void checkReflection(Class propertyClass) throws NoSuchFieldException, StringIndexOutOfBoundsException, IntrospectionException, IllegalArgumentException {
        this.beanClass = this.bean.getClass();
        StringBuffer buffer = new StringBuffer(this.property);
        char firstLetter = Character.toUpperCase(buffer.charAt(0));
        buffer.setCharAt(0, firstLetter);
        this.property = buffer.toString();
        String getMethod = "get" + this.property;
        String setMethod = "set" + this.property;
        Class[] params = new Class[]{propertyClass};
        try {
            this.getMethod = this.beanClass.getMethod(getMethod, null);
            if (!propertyClass.equals(this.getMethod.getReturnType())) {
                throw new IllegalArgumentException("Return type doesn't match");
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            this.setMethod = this.beanClass.getMethod(setMethod, params);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (this.setMethod == null && this.getMethod == null) {
            throw new IllegalArgumentException("No accessor methods for " + this.property);
        }
    }

    private Class getPropertyClass() throws IntrospectionException, NoSuchFieldException, IllegalArgumentException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.beanClass);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Class<?> propertyClass = null;
        if (beanInfo == null) {
            Field propertyField = this.getPropertyField(this.beanClass, this.property);
            propertyClass = propertyField.getType();
        } else {
            PropertyDescriptor theProperty = this.findPropertyDescriptor(beanInfo.getPropertyDescriptors());
            propertyClass = theProperty.getPropertyType();
            if (propertyClass == null) {
                throw new IllegalArgumentException("this constructor does not support indexed properties");
            }
        }
        return propertyClass;
    }

    private Field getPropertyField(Class beanClass, String property) throws SecurityException, NoSuchFieldException {
        Field propertyField = null;
        Class theClass = beanClass;
        block0: do {
            Field[] propertyFields = theClass.getDeclaredFields();
            for (int i = 0; i < propertyFields.length; ++i) {
                if (!property.equals(propertyFields[i].getName())) continue;
                propertyField = propertyFields[i];
                continue block0;
            }
        } while ((theClass = theClass.getSuperclass()) != null);
        if (propertyField == null) {
            throw new NoSuchFieldException(property + " not a field");
        }
        return propertyField;
    }

    public RlBeanProperty(Object bean, String property, Class propertyClass, String getMethod, String setMethod) throws NoSuchMethodException, NoSuchFieldException, IllegalArgumentException {
        if (getMethod == null && setMethod == null) {
            throw new IllegalArgumentException("RlBean must have accessor methods.");
        }
        this.bean = bean;
        this.property = property;
        this.beanClass = bean.getClass();
        Class[] params = new Class[]{propertyClass};
        if (getMethod != null) {
            this.getMethod = this.beanClass.getMethod(getMethod, null);
            if (!propertyClass.equals(this.getMethod.getReturnType())) {
                throw new IllegalArgumentException("Return type doesn't match");
            }
        }
        if (setMethod != null) {
            this.setMethod = this.beanClass.getMethod(setMethod, params);
        }
    }

    public RlBeanProperty(Object bean, String property, String getMethod, String setMethod) throws NoSuchMethodException, NoSuchFieldException, IntrospectionException, IllegalArgumentException {
        if (getMethod == null && setMethod == null) {
            throw new IllegalArgumentException("RlBean must have accessor methods.");
        }
        this.bean = bean;
        this.property = property;
        this.beanClass = bean.getClass();
        Class propertyClass = this.getPropertyClass();
        Class[] params = new Class[]{propertyClass};
        if (getMethod != null) {
            this.getMethod = this.beanClass.getMethod(getMethod, null);
            if (!propertyClass.equals(this.getMethod.getReturnType())) {
                throw new IllegalArgumentException("Return type doesn't match");
            }
        }
        if (setMethod != null) {
            this.setMethod = this.beanClass.getMethod(setMethod, params);
        }
    }

    public RlBeanProperty(Object bean, String getMethod, Class[] getParams, String setMethod, Class[] setParams) throws NoSuchMethodException, IllegalArgumentException {
        this.bean = bean;
        this.beanClass = bean.getClass();
        if (getMethod == null && setMethod == null) {
            throw new IllegalArgumentException("RlBean must have accessor methods.");
        }
        if (getMethod != null) {
            this.getMethod = this.beanClass.getMethod(getMethod, getParams);
        }
        if (setMethod != null) {
            this.setMethod = this.beanClass.getMethod(setMethod, setParams);
        }
    }

    public RlBeanProperty(Object bean, Method getMethod, Method setMethod) throws NoSuchMethodException {
        this.bean = bean;
        this.beanClass = bean.getClass();
        if (getMethod == null && setMethod == null) {
            throw new IllegalArgumentException("RlBean must have accessor methods.");
        }
        if (getMethod != null) {
            this.getMethod = this.beanClass.getMethod(getMethod.getName(), getMethod.getParameterTypes());
        }
        if (setMethod != null) {
            this.setMethod = this.beanClass.getMethod(setMethod.getName(), setMethod.getParameterTypes());
        }
    }

    private void setReflectionArrayMethods(String getMethod, String setMethod, Class propertyClass) {
        if (propertyClass.isArray()) {
            Class[] getParams = new Class[]{Integer.TYPE};
            Class[] setParams = new Class[]{Integer.TYPE, propertyClass};
            try {
                this.getIndexMethod = this.beanClass.getMethod(getMethod, getParams);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                this.setIndexMethod = this.beanClass.getMethod(setMethod, setParams);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    public void setGetInitiator(Object initiator) {
        this.getInitiator = initiator;
    }

    public void setSetInitiator(Object initiator) {
        this.setInitiator = initiator;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RlBeanProperty)) {
            return false;
        }
        RlBeanProperty beanProp = (RlBeanProperty)obj;
        if (this.bean == null ? beanProp.bean != null : !this.bean.equals(beanProp.bean)) {
            return false;
        }
        if (this.property == null ? beanProp.property != null : !this.property.equals(beanProp.property)) {
            return false;
        }
        if (this.getMethod == null ? beanProp.getMethod != null : !this.getMethod.equals(beanProp.getMethod)) {
            return false;
        }
        if (this.setMethod == null ? beanProp.setMethod != null : !this.setMethod.equals(beanProp.setMethod)) {
            return false;
        }
        if (this.getInitiator == null ? beanProp.getInitiator != null : !this.getInitiator.equals(beanProp.getInitiator)) {
            return false;
        }
        return !(this.setInitiator == null ? beanProp.setInitiator != null : !this.setInitiator.equals(beanProp.setInitiator));
    }
}

