/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import rl.clbroker.CommLayer;

public class RetryDialog
implements ActionListener {
    Frame frame;
    Dialog dialog;
    CommLayer commLayer;
    TextArea textArea;
    Button ok;
    Button cancel;
    private boolean isCancelled = false;

    public RetryDialog(CommLayer commLayer) {
        this.dialog = new Dialog(commLayer.getBaseFrame(), "Retry Dialog", true);
        this.commLayer = commLayer;
        this.frame = commLayer.getBaseFrame();
        this.textArea = new TextArea("  Connection lost\n  Try to reconnect?", 0, 0, 3);
        this.textArea.setEditable(false);
        this.ok = new Button("OK");
        this.cancel = new Button("Cancel");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        Panel panel = new Panel();
        panel.add(this.ok);
        panel.add(this.cancel);
        this.dialog.add((Component)this.textArea, "Center");
        this.dialog.add((Component)panel, "South");
        int x = this.frame.getLocation().x + 50;
        int y = this.frame.getLocation().y + 125;
        this.dialog.setBounds(x, y, 200, 150);
        this.dialog.setVisible(true);
        this.dialog.setResizable(false);
        this.dialog.show();
        this.dialog.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            if (evt.getSource().equals(this.ok)) {
                this.textArea.setText("Trying...");
                this.commLayer.openConnection();
            }
        }
        catch (IOException e) {
            this.textArea.setText(e.toString() + "\n\n  Retry failed.\n  Try to reconnect?");
            this.dialog.pack();
            return;
        }
        if (evt.getSource().equals(this.cancel)) {
            if (this.isCancelled) {
                this.commLayer.isConnected = false;
            }
            if (!this.isCancelled) {
                this.isCancelled = true;
            }
            this.textArea.setText("  Cancelling operation.\n\n  Click Cancel to exit.");
        } else {
            this.textArea.setText("  ReConnected!\n\n  Click Cancel to exit.");
        }
        this.ok.removeActionListener(this);
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }
}

