/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import rl.clbroker.CommLayer;
import rl.clbroker.InitiatorContext;
import rl.clbroker.MultiBroker;
import rl.clbroker.OCP;
import rl.clbroker.PacketComponents;
import rl.clbroker.RlDatabase;
import rl.clbroker.RlError;
import rl.clbroker.TagContext;
import rl.clbroker.TagID;

public class PacketParser
extends Thread {
    protected boolean isPaused = false;
    protected boolean canRun = true;
    protected Vector incomingQueue = new Vector(8);
    protected OCP.ContextOption context;
    protected OCP.PktError packetError;
    protected OCP.IterationOption packetRange;
    protected OCP.SNMPTableOption table;
    protected MultiBroker broker;
    protected RlDatabase rlDatabase;
    protected CommLayer commLayer;

    public PacketParser(MultiBroker broker, RlDatabase rlDatabase, CommLayer commLayer) {
        super("PacketParserThread");
        this.broker = broker;
        this.rlDatabase = rlDatabase;
        this.commLayer = commLayer;
    }

    protected synchronized void setPause(boolean isPaused) {
        if (isPaused == this.isPaused) {
            return;
        }
        this.isPaused = isPaused;
        if (!isPaused) {
            this.notify();
        }
    }

    protected synchronized void end() {
        this.canRun = false;
        this.interrupt();
    }

    protected synchronized void parse(OCP.Header header, Vector chunks) {
        this.incomingQueue.addElement(new WholePacket(header, chunks));
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.canRun) {
            try {
                Vector packets;
                try {
                    PacketParser packetParser = this;
                    synchronized (packetParser) {
                        if (this.isPaused || this.incomingQueue.isEmpty()) {
                            while (this.isPaused || this.incomingQueue.isEmpty()) {
                                this.wait();
                            }
                        }
                    }
                }
                catch (SecurityException e) {
                    MultiBroker.exHandler.receiveBrowserExceptions(3, e);
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    MultiBroker.exHandler.receiveThreadExceptions(0, e);
                    e.printStackTrace();
                }
                Vector vector = this.incomingQueue;
                synchronized (vector) {
                    packets = (Vector)this.incomingQueue.clone();
                    this.incomingQueue.removeAllElements();
                }
                while (!packets.isEmpty()) {
                    WholePacket wholePacket = (WholePacket)packets.firstElement();
                    packets.removeElementAt(0);
                    Integer sessionID = new Integer(wholePacket.header.sessionID);
                    PacketComponents component = (PacketComponents)this.commLayer.requestsMade.remove(sessionID);
                    try {
                        this.parseOptions(wholePacket);
                        switch (wholePacket.header.type) {
                            case 2: {
                                this.parseLoginResponse(wholePacket.dataChunks);
                                break;
                            }
                            case 4: {
                                this.parseLogoutResponse(wholePacket.dataChunks);
                                break;
                            }
                            case 6: {
                                if (component == null) {
                                    throw new RlError("Packet not requested or timed out");
                                }
                                this.parseGetResponse(wholePacket.dataChunks, component);
                                break;
                            }
                            case 8: {
                                if (component == null) {
                                    throw new RlError("Packet not requested or timed out");
                                }
                                this.parseGetGroupResponse(wholePacket.dataChunks, component);
                                break;
                            }
                            case 10: {
                                if (component == null) {
                                    throw new RlError("Packet not requested or timed out");
                                }
                                this.parseSetResponse(wholePacket.dataChunks, component);
                                break;
                            }
                            case 11: {
                                this.parseEventReport(wholePacket.dataChunks);
                                break;
                            }
                            default: {
                                throw new RlError("UNKNOWN_TYPE - " + wholePacket.header.type);
                            }
                        }
                    }
                    catch (IOException e) {
                        MultiBroker.exHandler.receiveIOExceptions(2, e);
                        e.printStackTrace();
                    }
                    catch (RlError e) {
                        MultiBroker.exHandler.receiveBrokerExceptions(1, e);
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private TagID getThisTag(Vector tags, Vector v, String markupName, String argument) throws RlError {
        TagID tag = null;
        for (int j = 0; j < tags.size(); ++j) {
            tag = (TagID)tags.elementAt(j);
            if (!tag.matches(markupName, argument)) continue;
            v.removeElement(tag);
            return tag;
        }
        Vector ev = (Vector)this.rlDatabase.events.clone();
        for (int j = 0; j < ev.size(); ++j) {
            tag = (TagID)ev.elementAt(j);
            if (!tag.matches(markupName, argument)) continue;
            return tag;
        }
        String[] markups = new String[]{markupName};
        RlError error = new RlError("MARKUP_NOT_IN_DATABASE: " + markupName);
        error.setMarkups(markups);
        throw error;
    }

    protected void parseLogoutResponse(OCP.Chunk[] dataChunks) throws IOException, RlError {
        if (dataChunks.length != 1) {
            throw new IllegalArgumentException("Not a Logout Response.");
        }
        OCP.Logout logout = new OCP.Logout();
        logout.getClass();
        OCP.Logout.Response response = logout.new OCP.Logout.Response(dataChunks[0].getDataStream());
        if (response.getResponseCode() != 0) {
            RlError error = new RlError("LOGOUT_ERROR: " + response.getResponseCode());
            error.setErrorCode(response.getResponseCode());
            throw error;
        }
    }

    protected void parseLoginResponse(OCP.Chunk[] dataChunks) throws IOException, RlError {
        if (dataChunks.length != 1) {
            throw new IllegalArgumentException("Not a Login Response.");
        }
        OCP.Login login = new OCP.Login();
        login.getClass();
        OCP.Login.Response response = login.new OCP.Login.Response(dataChunks[0].getDataStream());
        if (1 != response.getMajor()) {
            throw new RlError("PROTOCOL_MISMATCH: " + response.getMajor());
        }
        this.commLayer.connectionID = response.connectionID;
    }

    protected void parseGetResponse(OCP.Chunk[] dataChunks, PacketComponents component) {
        Object initiator = component.initiator;
        InitiatorContext initContext = (InitiatorContext)this.rlDatabase.initiatorMap.get(component.initiator);
        Vector tags = component.tags == null ? initContext.tags : component.tags;
        Hashtable tagPacketMap = this.collectGetResponses(dataChunks, tags);
        if (!tagPacketMap.isEmpty()) {
            this.broker.beanGateway.passGet(tagPacketMap, initiator);
        }
    }

    protected Hashtable collectGetResponses(OCP.Chunk[] dataChunks, Vector tags) {
        Hashtable<TagID, Vector<byte[]>> tagPacketMap = new Hashtable<TagID, Vector<byte[]>>(8);
        Vector leftover = (Vector)tags.clone();
        for (int i = 0; i < dataChunks.length; ++i) {
            try {
                OCP.Get get = new OCP.Get();
                get.getClass();
                OCP.Get.Response getResponse = get.new OCP.Get.Response(dataChunks[i].getDataStream());
                String markupName = getResponse.getMarkupName();
                String argument = getResponse.getArgument();
                if (getResponse.responseCode != 0) {
                    RlError rlerror = new RlError("RESPONSE_ERROR: " + markupName + "(" + argument + ") = " + getResponse.responseCode);
                    rlerror.setErrorCode(getResponse.responseCode);
                    String[] markups = new String[]{markupName + "(" + argument + ")"};
                    rlerror.setMarkups(markups);
                    throw rlerror;
                }
                TagID tag = this.getThisTag(tags, leftover, markupName, argument);
                Vector<byte[]> v = (Vector<byte[]>)tagPacketMap.get(tag);
                if (v == null) {
                    v = new Vector<byte[]>(8, 8);
                }
                v.addElement(getResponse.data);
                tagPacketMap.put(tag, v);
                continue;
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
                continue;
            }
            catch (RlError e) {
                MultiBroker.exHandler.receiveBrokerExceptions(1, e);
            }
        }
        this.reportMissingData(leftover);
        return tagPacketMap;
    }

    private void reportMissingData(Vector missing) {
        try {
            Vector<String> tags = new Vector<String>(8, 8);
            for (int i = 0; i < missing.size(); ++i) {
                TagID tag = (TagID)missing.elementAt(i);
                tags.addElement(tag.id);
            }
            Object[] markups = new String[tags.size()];
            tags.copyInto(markups);
            if (missing.size() > 0) {
                RlError error = new RlError("MARKUPS_NOT_RETURNED");
                error.setMarkups((String[])markups);
                throw error;
            }
        }
        catch (RlError e) {
            MultiBroker.exHandler.receiveBrokerExceptions(1, e);
        }
    }

    protected void parseGetGroupResponse(OCP.Chunk[] dataChunks, PacketComponents component) throws RlError {
        Object initiator = component.initiator;
        InitiatorContext initContext = (InitiatorContext)this.rlDatabase.initiatorMap.get(component.initiator);
        Vector tags = component.tags == null ? initContext.tags : component.tags;
        Hashtable<String, Vector<Hashtable>> groupTagDataMap = new Hashtable<String, Vector<Hashtable>>(8);
        int chunksProcessed = 0;
        String groupName = null;
        TagID groupID = null;
        while (chunksProcessed < dataChunks.length) {
            try {
                OCP.GetGroup getGroup = new OCP.GetGroup();
                getGroup.getClass();
                OCP.GetGroup.GroupResponse getGroupResponse = getGroup.new OCP.GetGroup.GroupResponse(dataChunks[chunksProcessed].getDataStream());
                ++chunksProcessed;
                groupName = getGroupResponse.groupName.toJavaString();
                if (groupName.equals("")) {
                    Hashtable tagPacketMap = this.collectGetResponses(dataChunks, new Vector(1));
                    if (!tagPacketMap.isEmpty()) {
                        this.broker.beanGateway.passGet(tagPacketMap, initiator);
                    }
                    ++chunksProcessed;
                    continue;
                }
                groupID = (TagID)this.rlDatabase.nameRefMap.get(groupName);
                if (groupID == null) {
                    String[] markups = new String[]{};
                    markups[0] = groupName;
                    RlError error = new RlError("NOT_FOUND: " + groupName);
                    error.setMarkups(markups);
                    throw error;
                }
                Vector temp = (Vector)this.rlDatabase.nameRefMap.get(groupID.id);
                Vector groupElements = (Vector)temp.clone();
                int numElements = groupElements.size();
                Vector<TagID> tagElements = new Vector<TagID>(8, 8);
                for (int i = 0; i < numElements; ++i) {
                    String element = (String)groupElements.elementAt(i);
                    tagElements.addElement(new TagID(element, null));
                }
                Hashtable markupMap = null;
                OCP.Chunk[] chunks = new OCP.Chunk[numElements];
                for (int i = 0; i < numElements; ++i) {
                    chunks[i] = dataChunks[i + chunksProcessed];
                }
                markupMap = this.collectGetResponses(chunks, tagElements);
                chunksProcessed += numElements;
                Vector<Hashtable> v = (Vector<Hashtable>)groupTagDataMap.get(groupName);
                if (v == null) {
                    v = new Vector<Hashtable>(8, 8);
                }
                v.addElement(markupMap);
                groupTagDataMap.put(groupName, v);
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
            }
            catch (RlError e) {
                MultiBroker.exHandler.receiveBrokerExceptions(1, e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RlError("UNEXPECTED_END: " + groupID.id);
            }
        }
        if (!groupTagDataMap.isEmpty()) {
            this.broker.beanGateway.passGetGroup(groupTagDataMap, initiator);
        }
    }

    protected void parseSetResponse(OCP.Chunk[] dataChunks, PacketComponents component) {
        Object initiator = component.initiator;
        InitiatorContext initContext = (InitiatorContext)this.rlDatabase.initiatorMap.get(initiator);
        Vector tags = component.tags == null ? initContext.tags : component.tags;
        OCP.Set.Response setResponse = null;
        for (int i = 0; i < dataChunks.length; ++i) {
            try {
                OCP.Set set = new OCP.Set();
                set.getClass();
                setResponse = set.new OCP.Set.Response(dataChunks[i].getDataStream());
                String markup = setResponse.getMarkupName();
                String argument = setResponse.getArgument();
                if (setResponse.responseCode == 0) continue;
                RlError rlerror = new RlError("RESPONSE_ERROR: " + markup + "(" + argument + ") = " + setResponse.responseCode);
                rlerror.setErrorCode(setResponse.responseCode);
                String[] markups = new String[]{markup + "(" + argument + ")"};
                rlerror.setMarkups(markups);
                throw rlerror;
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
                continue;
            }
            catch (RlError e) {
                MultiBroker.exHandler.receiveBrokerExceptions(1, e);
            }
        }
    }

    protected void parseEventReport(OCP.Chunk[] dataChunks) throws RlError {
        this.parseGroupChunks(dataChunks, "null");
    }

    private void buildTagFromString(Vector tagElements, String element) {
        String markup = "";
        String args = "";
        StringTokenizer stok = new StringTokenizer(element, "()");
        markup = stok.nextToken();
        if (stok.hasMoreTokens()) {
            args = stok.nextToken();
        }
        tagElements.addElement(new TagID(markup, new TagContext(args)));
    }

    private void parseGroupChunks(OCP.Chunk[] dataChunks, Object initiator) throws RlError {
        Hashtable<TagID, Vector<Hashtable>> groupTagDataMap = new Hashtable<TagID, Vector<Hashtable>>(8);
        int chunksProcessed = 0;
        TagID groupTag = null;
        while (chunksProcessed < dataChunks.length) {
            try {
                OCP.GetGroup getGroup = new OCP.GetGroup();
                getGroup.getClass();
                OCP.GetGroup.GroupResponse getGroupResponse = getGroup.new OCP.GetGroup.GroupResponse(dataChunks[chunksProcessed].getDataStream());
                ++chunksProcessed;
                String groupName = getGroupResponse.groupName.toJavaString();
                groupTag = new TagID(groupName, null);
                if (groupName.equals("")) {
                    OCP.Chunk[] chunk = new OCP.Chunk[]{dataChunks[chunksProcessed]};
                    Hashtable tagPacketMap = this.collectGetResponses(chunk, new Vector(1));
                    if (!tagPacketMap.isEmpty()) {
                        this.broker.beanGateway.passGet(tagPacketMap, initiator);
                    }
                    ++chunksProcessed;
                    continue;
                }
                Vector temp = (Vector)this.rlDatabase.nameRefMap.get(groupName);
                if (temp == null) {
                    String[] markups = new String[]{groupName};
                    RlError error = new RlError("NOT_FOUND: " + groupName);
                    error.setMarkups(markups);
                    throw error;
                }
                Vector groupElements = (Vector)temp.clone();
                int numElements = groupElements.size();
                Vector tagElements = new Vector(8, 8);
                for (int i = 0; i < numElements; ++i) {
                    String element = (String)groupElements.elementAt(i);
                    this.buildTagFromString(tagElements, element);
                }
                Hashtable markupMap = null;
                OCP.Chunk[] chunks = new OCP.Chunk[numElements];
                for (int i = 0; i < numElements; ++i) {
                    chunks[i] = dataChunks[i + chunksProcessed];
                }
                markupMap = this.collectGetResponses(chunks, tagElements);
                chunksProcessed += numElements;
                Vector<Hashtable> v = (Vector<Hashtable>)groupTagDataMap.get(groupTag);
                if (v == null) {
                    v = new Vector<Hashtable>(8, 8);
                }
                v.addElement(markupMap);
                groupTagDataMap.put(groupTag, v);
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
                break;
            }
            catch (RlError e) {
                MultiBroker.exHandler.receiveBrokerExceptions(1, e);
                break;
            }
            catch (ClassCastException e) {
                MultiBroker.exHandler.receiveRuntimeExceptions(1, e);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                String[] markups = new String[]{};
                markups[0] = groupTag.id;
                RlError error = new RlError("UNEXPECTED_END: " + groupTag);
                error.setMarkups(markups);
                throw error;
            }
        }
        if (!groupTagDataMap.isEmpty()) {
            this.broker.beanGateway.passGetGroup(groupTagDataMap, initiator);
        }
    }

    protected void parseOptions(WholePacket packet) throws RlError, IOException {
        this.context = null;
        this.packetError = null;
        this.packetRange = null;
        this.table = null;
        Vector<OCP.Chunk> v = new Vector<OCP.Chunk>(8);
        for (int i = 0; i < packet.optionChunks.length; ++i) {
            v.addElement(packet.optionChunks[i]);
        }
        if (packet.contextFlag) {
            OCP.Chunk contextChunk = (OCP.Chunk)v.firstElement();
            v.removeElementAt(0);
            this.context = new OCP.ContextOption(contextChunk.getDataStream());
        }
        if (packet.errorFlag) {
            OCP.Chunk errorChunk = (OCP.Chunk)v.firstElement();
            v.removeElementAt(0);
            this.packetError = new OCP.PktError(errorChunk.getDataStream());
            throw new RlError(this.packetError);
        }
        if (packet.rangeFlag) {
            OCP.Chunk rangeChunk = (OCP.Chunk)v.firstElement();
            v.removeElementAt(0);
            this.packetRange = new OCP.IterationOption(rangeChunk.getDataStream());
        }
        if (packet.tableFlag) {
            OCP.Chunk tableChunk = (OCP.Chunk)v.firstElement();
            v.removeElementAt(0);
            this.table = new OCP.SNMPTableOption(tableChunk.getDataStream());
        }
    }

    class WholePacket {
        protected OCP.Header header;
        protected OCP.Chunk[] optionChunks;
        protected OCP.Chunk[] dataChunks;
        protected boolean contextFlag = false;
        protected boolean errorFlag = false;
        protected boolean rangeFlag = false;
        protected boolean tableFlag = false;
        protected int numFlags = 0;

        public WholePacket(OCP.Header header, Vector chunks) {
            int i;
            this.header = header;
            block3: for (i = 0; i < 4; ++i) {
                byte flag = header.options[i];
                switch (i) {
                    case 0: {
                        if ((flag & 0xFFFFFF80) != 0) {
                            this.contextFlag = true;
                            ++this.numFlags;
                        }
                        if ((flag & 0x40) != 0) {
                            this.errorFlag = true;
                            ++this.numFlags;
                        }
                        if ((flag & 0x20) != 0) {
                            this.rangeFlag = true;
                            ++this.numFlags;
                        }
                        if ((flag & 0x10) == 0) continue block3;
                        this.tableFlag = true;
                        ++this.numFlags;
                    }
                }
            }
            if (chunks.size() < this.numFlags) {
                throw new IllegalArgumentException("More flags than Chunks");
            }
            this.optionChunks = new OCP.Chunk[this.numFlags];
            this.dataChunks = new OCP.Chunk[chunks.size() - this.numFlags];
            for (i = 0; i < this.optionChunks.length; ++i) {
                this.optionChunks[i] = (OCP.Chunk)chunks.elementAt(i);
            }
            for (i = 0; i < this.dataChunks.length; ++i) {
                this.dataChunks[i] = (OCP.Chunk)chunks.elementAt(i + this.optionChunks.length);
            }
        }
    }
}

