/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import rl.clbroker.Broker;
import rl.clbroker.CommLayer;
import rl.clbroker.ContextNode;
import rl.clbroker.InitiatorContext;
import rl.clbroker.MagicMarkup;
import rl.clbroker.MultiBroker;
import rl.clbroker.OCP;
import rl.clbroker.PacketComponents;
import rl.clbroker.Range;
import rl.clbroker.RlBeanProperty;
import rl.clbroker.RlDatabase;
import rl.clbroker.RlError;
import rl.clbroker.TagID;

public class PacketBuilder
extends Thread {
    protected boolean isPaused = false;
    protected boolean canRun = true;
    protected Vector outgoingQueue;
    protected EventObject event;
    protected EventObject setevt;
    protected MultiBroker broker;
    protected RlDatabase rlDatabase;
    protected CommLayer commLayer;
    Hashtable dataQueue = new Hashtable(8);
    Vector markups = new Vector(8, 8);

    public PacketBuilder(MultiBroker broker, RlDatabase rlDatabase, CommLayer commLayer) {
        super("PacketBuilderThread");
        this.outgoingQueue = new Vector(8);
        this.broker = broker;
        this.rlDatabase = rlDatabase;
        this.commLayer = commLayer;
    }

    protected synchronized void setPause(boolean isPaused) {
        if (isPaused == this.isPaused) {
            return;
        }
        this.isPaused = isPaused;
        if (!isPaused) {
            this.notify();
        }
    }

    protected synchronized void end() {
        this.canRun = false;
        this.interrupt();
    }

    protected synchronized void buildSet(Object initiator, TagID tag, EventObject evt) throws RlError {
        if (tag != null && !this.rlDatabase.checkTag(tag)) {
            throw new RlError(tag.toString() + " - not in database.");
        }
        Hashtable temp = (Hashtable)this.rlDatabase.bindMap.get(tag);
        Vector beanProps = (Vector)temp.get(initiator);
        try {
            for (int i = 0; i < beanProps.size(); ++i) {
                RlBeanProperty prop = (RlBeanProperty)beanProps.elementAt(i);
                Object data = prop.getMethod.invoke(prop.bean, null);
                this.buildSet(initiator, tag, data, evt);
            }
        }
        catch (Exception e) {
            MultiBroker.exHandler.receiveUserClassesExceptions(1, e);
        }
    }

    protected synchronized void buildSet(Object initiator, EventObject evt) throws RlError {
        InitiatorContext initContext = (InitiatorContext)this.rlDatabase.initiatorMap.get(initiator);
        Vector tags = (Vector)initContext.tags.clone();
        for (int j = 0; j < tags.size(); ++j) {
            TagID tag = (TagID)tags.elementAt(j);
            this.buildSet(initiator, tag, evt);
        }
    }

    protected synchronized void buildSet(Object initiator, TagID tag, Object data, EventObject evt) throws RlError {
        if (tag != null && !this.rlDatabase.checkTag(tag)) {
            throw new RlError(tag.toString() + " - not in database.");
        }
        if (evt == null ? this.setevt != null && !this.dataQueue.isEmpty() : evt != this.setevt && !this.dataQueue.isEmpty()) {
            throw new RlError("Set already in progress");
        }
        if (initiator.equals("null")) {
            this.dataQueue.put(tag, data);
            Vector<TagID> v = new Vector<TagID>(1);
            v.addElement(tag);
            this.buildSet(initiator, v, (Hashtable)this.dataQueue.clone());
            this.dataQueue.clear();
            this.markups.removeAllElements();
        } else {
            InitiatorContext context = (InitiatorContext)this.rlDatabase.initiatorMap.get(initiator);
            if (this.markups.isEmpty()) {
                this.markups = (Vector)context.tags.clone();
            }
            if (!context.tags.contains(tag)) {
                this.dataQueue.clear();
                this.markups.removeAllElements();
                throw new RlError(tag.toString() + " not initiated by given initiator.");
            }
            this.markups.removeElement(tag);
            this.dataQueue.put(tag, data);
            if (this.markups.isEmpty()) {
                this.buildSet(initiator, (Vector)context.tags.clone(), (Hashtable)this.dataQueue.clone());
                this.dataQueue.clear();
            }
        }
        this.setevt = evt;
    }

    protected synchronized void buildGet(Object initiator, EventObject evt) {
        if (evt == null || evt != this.event) {
            this.build(initiator, null, 5);
        }
        this.event = evt;
    }

    protected synchronized void buildGet(Object initiator, TagID tag, EventObject evt) throws RlError {
        if (tag != null && !this.rlDatabase.checkTag(tag)) {
            throw new RlError(tag.toString() + " - not in database.");
        }
        if (initiator.equals("null")) {
            Vector<TagID> v = new Vector<TagID>(2);
            v.addElement(tag);
            this.build(initiator, v, 5);
        } else if (evt == null || evt != this.event) {
            this.build(initiator, null, 5);
        }
        this.event = evt;
    }

    protected synchronized void build(Object initiator, Vector tags, int type) {
        this.outgoingQueue.addElement(new PacketComponents(initiator, tags, type));
        this.notify();
    }

    protected synchronized void buildSet(Object initiator, Vector tags, Hashtable tagData) {
        this.outgoingQueue.addElement(new PacketComponents(initiator, tags, tagData, 9));
        this.notify();
    }

    protected String buildPacketContext(InitiatorContext initContext) {
        StringBuffer packetContext = new StringBuffer();
        Vector v = initContext.contextNodes;
        for (int i = 0; i < v.size(); ++i) {
            String valuePortion;
            String namePortion;
            ContextNode node = (ContextNode)v.elementAt(i);
            try {
                namePortion = (String)node.nameMethod.invoke(node.nameObj, null);
                valuePortion = (String)node.valueMethod.invoke(node.valueObj, null);
            }
            catch (Exception e) {
                MultiBroker.exHandler.receiveUserClassesExceptions(1, e);
                continue;
            }
            packetContext.append(namePortion);
            packetContext.append('=');
            packetContext.append(valuePortion);
            if (i == v.size() - 1) continue;
            packetContext.append('&');
        }
        return packetContext.toString();
    }

    protected String buildSNMPTable(String table, Vector tags) {
        if (table == null || table.equals("") || table.equals(" ")) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(table);
        for (int i = 0; i < tags.size(); ++i) {
            buffer.append(',');
            TagID tag = (TagID)tags.elementAt(i);
            buffer.append(tag.id);
        }
        return buffer.toString();
    }

    protected void buildOptions(PacketComponents component, byte[] options, Vector optionChunks) throws IOException, RlError {
        String table;
        Range range;
        if (component.initiator == null) {
            return;
        }
        InitiatorContext initContext = (InitiatorContext)this.rlDatabase.initiatorMap.get(component.initiator);
        if (initContext == null) {
            return;
        }
        Vector tags = component.tags == null ? initContext.tags : component.tags;
        String packetContext = this.buildPacketContext(initContext);
        if (packetContext != null && !packetContext.equals("")) {
            options[0] = (byte)(options[0] | 0xFFFFFF80);
            optionChunks.addElement(new OCP.Chunk(new OCP.ContextOption(packetContext)));
        }
        if ((range = initContext.range) != null) {
            options[0] = (byte)(options[0] | 0x20);
            optionChunks.addElement(new OCP.Chunk(new OCP.IterationOption(range.begin, range.end)));
        }
        if ((table = this.buildSNMPTable(initContext.SNMPTable, tags)) != null) {
            options[0] = (byte)(options[0] | 0x10);
            optionChunks.addElement(new OCP.Chunk(new OCP.SNMPTableOption(table)));
        }
    }

    protected byte[] assemblePacket(Vector optionChunks, OCP.Chunk[] requestChunks) throws IOException {
        int i;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Object[] chunks = new OCP.Chunk[optionChunks.size()];
        optionChunks.copyInto(chunks);
        for (i = 0; i < optionChunks.size(); ++i) {
            bout.write(((OCP.Chunk)chunks[i]).toBytes());
        }
        for (i = 0; i < requestChunks.length; ++i) {
            bout.write(requestChunks[i].toBytes());
        }
        bout.write(OCP.Chunk.kNull.toBytes());
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void run() {
        while (this.canRun) {
            PacketBuilder packetBuilder;
            try {
                packetBuilder = this;
                synchronized (packetBuilder) {
                    if (this.isPaused || this.outgoingQueue.isEmpty()) {
                        while (this.isPaused || this.outgoingQueue.isEmpty()) {
                            this.wait();
                        }
                    }
                }
            }
            catch (SecurityException e) {
                MultiBroker.exHandler.receiveBrowserExceptions(3, e);
            }
            catch (InterruptedException e) {
                MultiBroker.exHandler.receiveThreadExceptions(0, e);
            }
            Vector vector = this.outgoingQueue;
            synchronized (vector) {
                Vector packetComponents = (Vector)this.outgoingQueue.clone();
                this.outgoingQueue.removeAllElements();
            }
            while (!((Vector)((Object)packetBuilder)).isEmpty()) {
                PacketComponents component = (PacketComponents)((Vector)((Object)packetBuilder)).firstElement();
                ((Vector)((Object)packetBuilder)).removeElementAt(0);
                try {
                    void var6_13;
                    byte[] options = new byte[4];
                    Vector optionChunks = new Vector(8);
                    this.buildOptions(component, options, optionChunks);
                    OCP.Header header = new OCP.Header(this.commLayer.connectionID, this.commLayer.sessionID++, component.type, options);
                    switch (component.type) {
                        case 5: {
                            OCP.Chunk[] requestChunks = this.buildGetRequest(component);
                            break;
                        }
                        case 9: {
                            OCP.Chunk[] requestChunks = this.buildSetRequest(component);
                            break;
                        }
                        default: {
                            throw new RlError("Unknown packet type - " + component.type);
                        }
                    }
                    byte[] packet = this.assemblePacket(optionChunks, (OCP.Chunk[])var6_13);
                    this.broker.commLayer.send(header, component, packet);
                }
                catch (SecurityException e) {
                    MultiBroker.exHandler.receiveBrowserExceptions(2, e);
                }
                catch (IOException e) {
                    MultiBroker.exHandler.receiveIOExceptions(2, e);
                }
                catch (RlError e) {
                    MultiBroker.exHandler.receiveBrokerExceptions(1, e);
                }
            }
        }
    }

    protected OCP.Chunk[] buildGetRequest(PacketComponents component) {
        InitiatorContext initContext = (InitiatorContext)this.rlDatabase.initiatorMap.get(component.initiator);
        Vector tags = component.tags == null ? initContext.tags : component.tags;
        int the_size = tags.size();
        OCP.Chunk[] chunks = new OCP.Chunk[the_size];
        for (int i = 0; i < the_size; ++i) {
            OCP.Get get = new OCP.Get();
            get.getClass();
            OCP.Get.Request request = get.new OCP.Get.Request((TagID)tags.elementAt(i));
            chunks[i] = new OCP.Chunk(request);
        }
        return chunks;
    }

    protected OCP.Chunk[] buildSetRequest(PacketComponents component) {
        InitiatorContext initContext = (InitiatorContext)this.rlDatabase.initiatorMap.get(component.initiator);
        Vector tags = component.tags == null ? initContext.tags : component.tags;
        int the_size = tags.size();
        OCP.Chunk[] chunks = new OCP.Chunk[the_size];
        Object[] dataTable = new Object[tags.size()];
        for (int i = 0; i < the_size; ++i) {
            TagID tag = (TagID)tags.elementAt(i);
            MagicMarkup markup = (MagicMarkup)this.rlDatabase.nameRefMap.get(tag.id);
            if (markup.isArray) {
                dataTable = (Object[])component.tagDataMap.get(tag);
                try {
                    OCP.Set.Request request;
                    byte[] byteData;
                    if (dataTable.length == 1) {
                        byteData = markup.write(dataTable[0]);
                        OCP.Set set = new OCP.Set();
                        set.getClass();
                        request = set.new OCP.Set.Request(tag, byteData);
                        chunks[i] = new OCP.Chunk(request);
                        continue;
                    }
                    byteData = markup.write(dataTable[i]);
                    OCP.Set set = new OCP.Set();
                    set.getClass();
                    request = set.new OCP.Set.Request(tag, byteData);
                    chunks[i] = new OCP.Chunk(request);
                }
                catch (InvocationTargetException e) {
                    Broker.exHandler.receiveUserClassesExceptions(1, e);
                }
                catch (IllegalAccessException e) {
                    Broker.exHandler.receiveBrowserExceptions(2, e);
                }
                continue;
            }
            Object data = component.tagDataMap.get(tag);
            try {
                byte[] byteData = markup.write(data);
                OCP.Set set = new OCP.Set();
                set.getClass();
                OCP.Set.Request request = set.new OCP.Set.Request(tag, byteData);
                chunks[i] = new OCP.Chunk(request);
                continue;
            }
            catch (InvocationTargetException e) {
                MultiBroker.exHandler.receiveUserClassesExceptions(1, e);
                continue;
            }
            catch (IllegalAccessException e) {
                MultiBroker.exHandler.receiveBrowserExceptions(2, e);
            }
        }
        return chunks;
    }
}

