/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import rl.clbroker.CrcCheck;
import rl.clbroker.MultiBroker;
import rl.clbroker.Range;
import rl.clbroker.RlError;
import rl.clbroker.TagID;

public class OCP {
    protected static final int kUnitLen = 4;
    public static final int kHeaderLen = 32;
    public static final short kMajor = 1;
    public static final short kMinor = 2;
    public static final int kLoginRequest = 1;
    public static final int kLoginResponse = 2;
    protected static final int kLogoutRequest = 3;
    protected static final int kLogoutResponse = 4;
    protected static final int kGetRequest = 5;
    protected static final int kGetResponse = 6;
    protected static final int kGetGroupRequest = 7;
    protected static final int kGetGroupResponse = 8;
    protected static final int kSetRequest = 9;
    protected static final int kSetResponse = 10;
    protected static final int kEventReport = 11;
    public static final int kDumpOCBRequest = 12;
    public static final int kDumpOCBResponse = 13;
    protected static final int kDevInfoRequest = 14;
    protected static final int kDevInfoResponse = 15;
    protected static final int kSW_UpgradeRequest = 16;
    protected static final int kSW_UpgradeResponse = 17;
    public static final int kDTmacro = 0;
    public static final int kDTstring = 1;
    public static final int kDTipaddress = 2;
    public static final int kDTinteger = 3;
    public static final int kDTchar = 4;
    public static final int kDTshort = 5;
    public static final int kDTlong = 6;
    public static final int kDTuinteger = 7;
    public static final int kDTuchar = 8;
    public static final int kDTushort = 9;
    public static final int kDTulong = 10;
    public static final int kDTvoid = 11;
    protected static final int OK = 0;
    protected static final byte[] kHeaderFlag = new byte[]{104, 98, 106, 99};
    public static final int kHeaderFlagInt = 1751280227;
    protected static final int kUnknownLen = -1;
    protected static final int kNoIteration = -1;
    public static final int kNumOptionFields = 4;
    protected static final byte contextFlag = -128;
    protected static final byte errorFlag = 64;
    protected static final byte rangeFlag = 32;
    protected static final byte tableFlag = 16;

    public static byte[] appendCRC(byte[] packet) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        int crc = CrcCheck.crc32(0, packet, packet.length);
        try {
            dout.write(packet);
            dout.writeInt(crc);
            dout.flush();
        }
        catch (IOException e) {
            MultiBroker.exHandler.receiveIOExceptions(2, e);
        }
        return bout.toByteArray();
    }

    public static void checkCRC(Header header, Vector llChunks, int crc) throws RlError {
        Object[] chunks = new Chunk[llChunks.size()];
        llChunks.copyInto(chunks);
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.write(header.toBytes());
            for (int i = 0; i < chunks.length; ++i) {
                dout.write(((Chunk)chunks[i]).toBytes());
            }
            dout.flush();
            OCP.checkCRC(bout.toByteArray(), crc);
        }
        catch (IOException e) {
            throw new RlError("CRC check failed");
        }
    }

    public static void checkCRC(byte[] data, int crc) throws RlError {
        int checked = CrcCheck.crc32(0, data, data.length);
        if (checked != crc) {
            throw new RlError("CRC check failed");
        }
    }

    public static void writePktString(String string, DataOutputStream dout) throws IOException {
        PktString pktString = new PktString(string);
        dout.write(pktString.toBytes());
    }

    public static String readPktString(DataInputStream din) throws IOException {
        byte[] array = new byte[din.available()];
        din.read(array);
        return OCP.readPktString(array);
    }

    public static String readPktString(byte[] array) throws IOException {
        PktString pktString = new PktString(array);
        return pktString.toJavaString();
    }

    protected static class PktString
    implements Interface {
        protected int length;
        protected byte[] string;
        protected byte[] nulls;

        public PktString(String str) {
            if (str == null) {
                this.length = 0;
                this.string = new byte[0];
                this.nulls = new byte[4];
                return;
            }
            this.length = str.length();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(this.length);
            BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(bout));
            try {
                bwriter.write(str);
                bwriter.flush();
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
            }
            this.string = bout.toByteArray();
            int remainder = 4 - this.length % 4;
            this.nulls = new byte[remainder];
        }

        public PktString(byte[] array) throws IOException {
            this(new ByteArrayInputStream(array));
        }

        public PktString(InputStream input) throws IOException {
            if (input.available() < 8) {
                throw new IOException("OCP String read error");
            }
            DataInputStream din = new DataInputStream(input);
            this.length = din.readInt();
            if (din.available() < this.length) {
                throw new IOException("OCP String read error");
            }
            if (this.length == 0) {
                this.string = new byte[0];
            } else {
                this.string = new byte[this.length];
                din.readFully(this.string);
            }
            int remainder = 4 - this.length % 4;
            if (din.available() < remainder) {
                throw new IOException("OCP String read error");
            }
            this.nulls = new byte[remainder];
            din.readFully(this.nulls);
            for (int i = 0; i < this.nulls.length; ++i) {
                if (this.nulls[i] == 0) continue;
                throw new IOException("OCP String format error");
            }
        }

        public byte[] toBytes() {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            try {
                dout.writeInt(this.length);
                dout.write(this.string, 0, this.string.length);
                dout.write(this.nulls, 0, this.nulls.length);
                dout.flush();
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
            }
            return bout.toByteArray();
        }

        protected String toJavaString() {
            String theString = new String(this.string);
            return theString;
        }
    }

    public static class Header
    implements Interface {
        protected int headerFlag;
        protected int connectionID;
        protected int sessionID;
        protected int type;
        protected byte[] options = new byte[4];
        protected int mesgLen;
        protected byte[] reserved1 = new byte[4];
        protected byte[] reserved2 = new byte[4];

        public Header(InputStream inputStream) throws IOException {
            DataInputStream din = new DataInputStream(inputStream);
            this.headerFlag = din.readInt();
            this.connectionID = din.readInt();
            this.sessionID = din.readInt();
            this.type = din.readInt();
            for (int i = 0; i < 4; ++i) {
                this.options[i] = din.readByte();
            }
            this.mesgLen = din.readInt();
            din.readFully(this.reserved1);
            din.readFully(this.reserved2);
        }

        public Header(byte[] header) throws IOException {
            this(new ByteArrayInputStream(header));
        }

        public Header(int connectionID, int sessionID, int type, byte[] options) {
            this.headerFlag = 1751280227;
            this.connectionID = connectionID;
            this.sessionID = sessionID;
            this.type = type;
            this.options = options;
        }

        public void setMesgLen(int length) {
            this.mesgLen = length;
        }

        public int getHeaderFlag() {
            return this.headerFlag;
        }

        public byte[] toBytes() {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(32);
            DataOutputStream dout = new DataOutputStream(bout);
            try {
                dout.writeInt(this.headerFlag);
                dout.writeInt(this.connectionID);
                dout.writeInt(this.sessionID);
                dout.writeInt(this.type);
                dout.write(this.options);
                dout.writeInt(this.mesgLen);
                dout.write(this.reserved1);
                dout.write(this.reserved2);
                dout.flush();
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
            }
            return bout.toByteArray();
        }
    }

    public static class Chunk
    implements Interface {
        public static final Chunk kNull = new Chunk(0, new byte[0]);
        protected int chunkLen = 0;
        protected byte[] chunkData;
        protected int endLen = 0;

        public Chunk(InputStream inputStream) throws IOException, RlError {
            DataInputStream din = new DataInputStream(inputStream);
            this.chunkLen = din.readInt();
            this.chunkData = new byte[this.chunkLen];
            din.readFully(this.chunkData);
            this.endLen = din.readInt();
            if (this.chunkLen != this.endLen) {
                throw new RlError("Bad Chunk!");
            }
        }

        public Chunk(Interface data) {
            byte[] array = data.toBytes();
            this.chunkLen = array.length;
            this.chunkData = array;
            this.endLen = array.length;
        }

        public Chunk(int chunkLen, byte[] chunkData) {
            this.chunkLen = chunkLen;
            this.chunkData = chunkData;
            this.endLen = chunkLen;
        }

        public InputStream getDataStream() {
            return new ByteArrayInputStream(this.chunkData);
        }

        public int getChunkLen() {
            return this.chunkLen;
        }

        public int getEndLen() {
            return this.endLen;
        }

        public byte[] getChunkData() {
            return this.chunkData;
        }

        public byte[] toBytes() {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(this.chunkLen + 4);
            DataOutputStream dout = new DataOutputStream(bout);
            try {
                dout.writeInt(this.chunkLen);
                dout.write(this.chunkData);
                dout.writeInt(this.endLen);
                dout.flush();
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
            }
            return bout.toByteArray();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Chunk)) {
                return false;
            }
            Chunk chunk = (Chunk)obj;
            if (this.chunkLen != chunk.chunkLen) {
                return false;
            }
            if (this.chunkData.length != chunk.chunkData.length) {
                return false;
            }
            for (int i = 0; i < this.chunkData.length; ++i) {
                if (this.chunkData[i] == chunk.chunkData[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class PktError
    implements Interface {
        protected int responseCode;
        protected PktString errString;

        public PktError(int responseCode) {
            this(responseCode, null);
        }

        public PktError(int responseCode, String errString) {
            this.responseCode = responseCode;
            this.errString = new PktString(errString);
        }

        public PktError(InputStream inputStream) throws IOException {
            DataInputStream din = new DataInputStream(inputStream);
            this.responseCode = din.readInt();
            this.errString = new PktString(din);
        }

        public byte[] toBytes() {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            try {
                byte[] string = this.errString.toBytes();
                dout.writeInt(this.responseCode);
                dout.write(string, 0, string.length);
                dout.flush();
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
            }
            return bout.toByteArray();
        }
    }

    public static class ContextOption
    implements Interface {
        protected PktString context;

        public ContextOption(InputStream in) throws IOException {
            this.context = new PktString(in);
        }

        public ContextOption(byte[] array) throws IOException {
            this.context = new PktString(array);
        }

        public ContextOption(String string) {
            this.context = new PktString(string);
        }

        public byte[] toBytes() {
            return this.context.toBytes();
        }
    }

    public static class IterationOption
    implements Interface {
        protected PktString begin;
        protected PktString end;

        public IterationOption(InputStream in) throws IOException {
            this.begin = new PktString(in);
            this.end = new PktString(in);
        }

        public IterationOption(byte[] array) throws IOException {
            this(new ByteArrayInputStream(array));
        }

        public IterationOption(String begin, String end) {
            this.begin = new PktString(begin);
            this.end = new PktString(end);
        }

        public byte[] toBytes() {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                bout.write(this.begin.toBytes());
                bout.write(this.end.toBytes());
            }
            catch (IOException e) {
                MultiBroker.exHandler.receiveIOExceptions(2, e);
            }
            return bout.toByteArray();
        }
    }

    public static class SNMPTableOption
    implements Interface {
        protected PktString table;

        public SNMPTableOption(InputStream in) throws IOException {
            this.table = new PktString(in);
        }

        public SNMPTableOption(byte[] array) throws IOException {
            this.table = new PktString(array);
        }

        public SNMPTableOption(String string) {
            this.table = new PktString(string);
        }

        public byte[] toBytes() {
            return this.table.toBytes();
        }
    }

    public static class Get {
        protected PktString markupName;
        protected PktString argument;

        protected class Response {
            protected int dataLen;
            protected byte[] data;
            protected int iteration;
            protected int responseCode;

            public Response(InputStream inputStream) throws IOException {
                DataInputStream din = new DataInputStream(inputStream);
                Get.this.markupName = new PktString(din);
                Get.this.argument = new PktString(din);
                this.dataLen = din.readInt();
                this.data = new byte[this.dataLen];
                din.readFully(this.data);
                this.iteration = din.readInt();
                this.responseCode = din.readInt();
            }

            protected String getMarkupName() {
                return Get.this.markupName.toJavaString();
            }

            protected String getArgument() {
                return Get.this.argument.toJavaString();
            }
        }

        public class Request
        implements Interface {
            protected Range range;

            public Request(TagID id) {
                this(id.id, id.tagContext.arguments, id.tagContext.range);
            }

            public Request(String markupName, String argument, Range range) {
                Get.this.markupName = new PktString(markupName);
                Get.this.argument = new PktString(argument);
                this.range = range == null ? new Range(null, null) : range;
            }

            public Request(InputStream inputStream) throws IOException {
                DataInputStream din = new DataInputStream(inputStream);
                Get.this.markupName = new PktString(din);
                Get.this.argument = new PktString(din);
                PktString begin = new PktString(din);
                PktString end = new PktString(din);
                this.range = new Range(begin.toJavaString(), end.toJavaString());
            }

            public byte[] toBytes() {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    bout.write(Get.this.markupName.toBytes());
                    bout.write(Get.this.argument.toBytes());
                    bout.write(new PktString(this.range.begin).toBytes());
                    bout.write(new PktString(this.range.end).toBytes());
                }
                catch (IOException e) {
                    MultiBroker.exHandler.receiveIOExceptions(2, e);
                }
                return bout.toByteArray();
            }
        }
    }

    protected static class GetGroup
    extends Get {
        protected GetGroup() {
        }

        protected class GroupResponse {
            protected PktString groupName;

            public GroupResponse(InputStream inputStream) throws IOException {
                this.groupName = new PktString(inputStream);
            }
        }

        protected class GroupRequest
        extends Get.Request
        implements Interface {
            public GroupRequest(TagID id) {
                this(id.id, id.tagContext.arguments, id.tagContext.range);
            }

            public GroupRequest(String groupName, String argument, Range range) {
                super(groupName, argument, range);
            }

            public GroupRequest(InputStream inputStream) throws IOException {
                super(inputStream);
            }
        }
    }

    protected static class Set
    extends Get {
        protected Set() {
        }

        protected class Response {
            protected int responseCode;

            public Response(InputStream inputStream) throws IOException {
                DataInputStream din = new DataInputStream(inputStream);
                Set.this.markupName = new PktString(din);
                Set.this.argument = new PktString(din);
                this.responseCode = din.readInt();
            }

            protected String getMarkupName() {
                return Set.this.markupName.toJavaString();
            }

            protected String getArgument() {
                return Set.this.argument.toJavaString();
            }
        }

        protected class Request
        implements Interface {
            protected int dataLen;
            protected byte[] data;

            public Request(TagID id, byte[] data) {
                this(id.id, id.tagContext.arguments, data);
            }

            public Request(String markupName, String argument, byte[] data) {
                Set.this.markupName = new PktString(markupName);
                Set.this.argument = new PktString(argument);
                this.data = data;
                this.dataLen = data.length;
            }

            public byte[] toBytes() {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                try {
                    dout.write(Set.this.markupName.toBytes());
                    dout.write(Set.this.argument.toBytes());
                    dout.writeInt(this.dataLen);
                    dout.write(this.data);
                    dout.flush();
                }
                catch (IOException e) {
                    MultiBroker.exHandler.receiveIOExceptions(2, e);
                }
                return bout.toByteArray();
            }
        }
    }

    public static class Dump {

        public class Response {
            protected PktString name;
            protected int dataType;

            public Response(byte[] array) throws IOException {
                this(new ByteArrayInputStream(array));
            }

            public Response(InputStream inputStream) throws IOException {
                DataInputStream din = new DataInputStream(inputStream);
                this.name = new PktString(din);
                this.dataType = din.readInt();
            }

            public String getName() {
                return this.name.toJavaString();
            }

            public int getDataType() {
                return this.dataType;
            }
        }

        public class Request
        implements Interface {
            public byte[] toBytes() {
                return new byte[0];
            }
        }
    }

    public static class Logout {

        public class Response {
            public int responseCode;

            public Response(InputStream in) throws IOException {
                DataInputStream din = new DataInputStream(in);
                this.responseCode = din.readInt();
            }

            public int getResponseCode() {
                return this.responseCode;
            }
        }

        public class Request
        implements Interface {
            public byte[] toBytes() {
                return new byte[0];
            }
        }
    }

    public static class Login {
        protected short majVersion;
        protected short minVersion;

        public class Response {
            protected int connectionID;

            public Response(byte[] array) throws IOException {
                this(new ByteArrayInputStream(array));
            }

            public Response(InputStream in) throws IOException {
                DataInputStream din = new DataInputStream(in);
                this.connectionID = din.readInt();
                Login.this.majVersion = din.readShort();
                Login.this.minVersion = din.readShort();
            }

            public int getConnectionID() {
                return this.connectionID;
            }

            public int getMajor() {
                return Login.this.majVersion;
            }
        }

        public class Request
        implements Interface {
            PktString username;
            PktString password;

            public Request(short maj, short min, String username, String password) {
                Login.this.majVersion = maj;
                Login.this.minVersion = min;
                this.username = new PktString(username);
                this.password = new PktString(password);
            }

            public byte[] toBytes() {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                try {
                    dout.writeShort(Login.this.majVersion);
                    dout.writeShort(Login.this.minVersion);
                    dout.write(this.username.toBytes());
                    dout.write(this.password.toBytes());
                    dout.flush();
                }
                catch (IOException e) {
                    MultiBroker.exHandler.receiveIOExceptions(2, e);
                }
                return bout.toByteArray();
            }
        }
    }

    protected static interface Interface {
        public byte[] toBytes();
    }
}

