/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.awt.Component;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import rl.clbroker.BeanGateway;
import rl.clbroker.Broker;
import rl.clbroker.CommLayer;
import rl.clbroker.ExceptionObserver;
import rl.clbroker.ExceptionPropogator;
import rl.clbroker.MagicMarkup;
import rl.clbroker.PacketBuilder;
import rl.clbroker.PacketParser;
import rl.clbroker.PollingThread;
import rl.clbroker.Range;
import rl.clbroker.RlBeanProperty;
import rl.clbroker.RlDatabase;
import rl.clbroker.RlError;
import rl.clbroker.TCPComm;
import rl.clbroker.TagContext;
import rl.clbroker.TagID;
import rl.clbroker.UDPComm;

public class MultiBroker
extends Thread {
    protected int nInstantiated = 0;
    protected static final int initCapacity = 8;
    protected static final int initCapIncr = 8;
    protected static int maxPacketSize = 512;
    protected static int portNum = 80;
    protected static Component currentDisplay = null;
    protected PacketBuilder packetBuilder;
    protected PacketParser packetParser;
    protected PollingThread pollingThread;
    protected CommLayer commLayer;
    protected Thread commThread;
    protected BeanGateway beanGateway;
    protected boolean isTCP = false;
    protected static ExceptionPropogator exHandler = new ExceptionPropogator();
    protected InetAddress deviceAddress;
    protected RlDatabase rlDatabase;
    protected String ip;
    protected static Hashtable brokers = new Hashtable(8, 8.0f);
    static /* synthetic */ Class array$Ljava$lang$Object;

    protected MultiBroker() {
    }

    protected MultiBroker(String name, boolean isTCP, int portNum, int maxPacketSize, String ip) throws UnknownHostException {
        this.rlDatabase = new RlDatabase(this);
        this.isTCP = isTCP;
        MultiBroker.portNum = portNum;
        MultiBroker.maxPacketSize = maxPacketSize;
        this.ip = ip;
        try {
            this.commLayer = isTCP ? new TCPComm(this, name, portNum, maxPacketSize, InetAddress.getByName(ip)) : new UDPComm(this, name, portNum, InetAddress.getByName(ip));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.packetBuilder = new PacketBuilder(this, this.rlDatabase, this.commLayer);
        this.packetParser = new PacketParser(this, this.rlDatabase, this.commLayer);
        this.pollingThread = new PollingThread(this, this.rlDatabase);
        this.beanGateway = new BeanGateway(this, this.rlDatabase);
    }

    protected MultiBroker(String name, boolean isTCP, int portNum, int maxPacketSize, InetAddress ip) throws UnknownHostException {
        this.rlDatabase = new RlDatabase(this);
        this.isTCP = isTCP;
        MultiBroker.portNum = portNum;
        MultiBroker.maxPacketSize = maxPacketSize;
        this.deviceAddress = ip;
        try {
            this.commLayer = isTCP ? new TCPComm(this, name, portNum, maxPacketSize, this.deviceAddress) : new UDPComm(this, name, portNum, this.deviceAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.packetBuilder = new PacketBuilder(this, this.rlDatabase, this.commLayer);
        this.packetParser = new PacketParser(this, this.rlDatabase, this.commLayer);
        this.pollingThread = new PollingThread(this, this.rlDatabase);
        this.beanGateway = new BeanGateway(this, this.rlDatabase);
    }

    public static MultiBroker getBrokerInstance(String ip, int port, int maxPacketSize, boolean tcp) throws UnknownHostException {
        return MultiBroker.getBrokerInstance("oneDevice", tcp, port, maxPacketSize, ip);
    }

    public static MultiBroker getBrokerInstance(String device, String ip, int port, int maxPacketSize, boolean tcp) throws UnknownHostException {
        return MultiBroker.getBrokerInstance(device, tcp, port, maxPacketSize, ip);
    }

    public static MultiBroker getBrokerInstance(String name, boolean isTCP, int portNum, int maxPacketSize, String ip) throws UnknownHostException {
        MultiBroker b = (MultiBroker)brokers.get(name);
        if (ip.regionMatches(true, 0, "http://", 0, 7) || ip.regionMatches(true, 0, "file://", 0, 7)) {
            ip = ip.substring(7);
        }
        if (b == null) {
            b = new MultiBroker(name, isTCP, portNum, maxPacketSize, ip);
            brokers.put(name, b);
        }
        return b;
    }

    public static MultiBroker getBrokerInstance(String name, boolean isTCP, int portNum, int maxPacketSize, InetAddress ip) throws UnknownHostException {
        MultiBroker b = (MultiBroker)brokers.get(name);
        if (b == null) {
            b = new MultiBroker(name, isTCP, portNum, maxPacketSize, ip);
            brokers.put(name, b);
        }
        return b;
    }

    public static void test() {
        System.out.println(" MultiBroker is Working=======");
    }

    public void run() {
        try {
            if (this.nInstantiated > 0) {
                ++this.nInstantiated;
            }
            this.startCommunications();
            if (this.commLayer.isConnected) {
                this.startHandlers();
                this.getAllData();
                this.startPolling();
            } else {
                this.breakCommunications();
            }
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(4, e);
        }
    }

    public static void registerExceptionObserver(ExceptionObserver eo) {
        exHandler.addExceptionObserver(eo);
    }

    private void startPolling() {
        this.pollingThread.addPoll(this.rlDatabase.polls);
    }

    public static synchronized void setCurrentDisplay(Component c) {
        currentDisplay = c;
    }

    public synchronized void setOptions(InetAddress ip, int port, int maxPacketSize, boolean tcp) {
        this.setTCP(tcp);
        this.setPort(port);
        this.setMaxPacketSize(maxPacketSize);
        if (ip != null) {
            this.setIp(ip);
        }
    }

    public synchronized void setOptions(String ip, int port, int maxPacketSize, boolean tcp) throws UnknownHostException {
    }

    public synchronized void setOptions(URL url, int port, int maxPacketSize, boolean tcp) throws UnknownHostException {
        this.setTCP(tcp);
        this.setPort(port);
        this.setMaxPacketSize(maxPacketSize);
        this.setIp(url);
    }

    public void setMaxPacketSize(int maxPacketSize) {
    }

    public void setIp(URL url) throws UnknownHostException {
        this.setIp(url.getHost());
    }

    public void setIp(String ip) throws UnknownHostException {
        if (ip.regionMatches(true, 0, "http://", 0, 7) || ip.regionMatches(true, 0, "file://", 0, 7)) {
            ip = ip.substring(7);
        }
        this.setIp(InetAddress.getByName(ip));
    }

    public void setIp(InetAddress ip) {
        this.commLayer.deviceAddress = ip;
    }

    public void setPort(int port) {
        CommLayer.portID = port;
    }

    public void setTCP(boolean tcp) {
        this.isTCP = tcp;
    }

    public void addTrap(String group, Vector markups) {
        this.addGroup(group, markups);
    }

    public void addGroup(String group, Vector markups) {
        if (markups == null) {
            markups = new Vector(8);
        }
        this.rlDatabase.name(group, markups);
    }

    public MagicMarkup addMagicMarkup(String name, String dataType, boolean isArray) {
        MagicMarkup markup = null;
        try {
            markup = new MagicMarkup(name, dataType, isArray);
            this.rlDatabase.name(name, markup);
        }
        catch (Exception e) {
            exHandler.receiveBrokerExceptions(1, e);
        }
        return markup;
    }

    public RlBeanProperty wrapBeanProperty(Object bean, String property, Class propertyClass) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, property, propertyClass);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public RlBeanProperty wrapBeanProperty(Object bean, String property) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, property);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(1, e);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public RlBeanProperty wrapBeanProperty(Object bean, Method getMethod, Method setMethod) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, getMethod, setMethod);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public RlBeanProperty wrapBeanProperty(Object bean, String property, Class propertyClass, String getMethod, String setMethod) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, property, propertyClass, getMethod, setMethod);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public RlBeanProperty wrapBeanProperty(Object bean, String property, String getMethod, String setMethod) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, property, getMethod, setMethod);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public RlBeanProperty wrapBeanProperty(Object bean, String getMethod, Class[] getParams, String setMethod, Class[] setParams) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, getMethod, getParams, setMethod, setParams);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public void bindMarkupToBeanProperty(String markupName, String arguments, Range range, RlBeanProperty beanProp, boolean isGet, boolean isSet, boolean isTrap, Object initiator) {
        if (beanProp == null || markupName == null) {
            throw new IllegalArgumentException("beanProp && markupName != null");
        }
        if (!this.rlDatabase.nameRefMap.containsKey(markupName)) {
            throw new IllegalArgumentException("RapidMark " + markupName + " not found.");
        }
        if (initiator == null) {
            initiator = "null";
        }
        TagContext context = new TagContext(arguments, range);
        try {
            TagID markupID = new TagID(markupName, context);
            this.rlDatabase.bind(markupID, initiator, beanProp);
            if ((isGet || isSet) && !this.rlDatabase.gets.contains(markupID)) {
                this.rlDatabase.gets.addElement(markupID);
                if (this.nInstantiated > 0) {
                    EventObject evt = new EventObject(initiator);
                    this.getData(evt, markupName, arguments, range, null);
                }
            }
            if (isTrap && !this.rlDatabase.events.contains(markupID)) {
                this.rlDatabase.events.addElement(markupID);
            }
        }
        catch (Exception e) {
            exHandler.receiveRuntimeExceptions(1, e);
        }
    }

    public void bindMarkupToBeanProperty(String markupName, String arguments, Range range, RlBeanProperty beanProp, long pollInterval, String pollGroup) {
        if (beanProp == null || markupName == null) {
            throw new IllegalArgumentException("beanProp && markupName != null");
        }
        if (!this.rlDatabase.nameRefMap.containsKey(markupName)) {
            throw new IllegalArgumentException("RapidMark " + markupName + " not found.");
        }
        if (pollGroup == null) {
            pollGroup = "null";
        }
        TagContext context = new TagContext(arguments, range);
        try {
            TagID markupID = new TagID(markupName, context, new Long(pollInterval));
            this.rlDatabase.bind(markupID, pollGroup, beanProp);
            this.rlDatabase.addPoll(markupID);
        }
        catch (Exception e) {
            exHandler.receiveRuntimeExceptions(1, e);
        }
    }

    public void setInitiatorContext(Object initiator, Vector contextNodes) {
        this.rlDatabase.setInitiatorContext(initiator, contextNodes);
    }

    public void setInitiatorRange(Object initiator, Range range) {
        this.rlDatabase.setInitiatorContext(initiator, range);
    }

    public void setInitiatorSNMPTable(Object initiator, String table) {
        this.rlDatabase.setInitiatorContext(initiator, table);
    }

    public void removeInitiator(Object initiator) {
        this.rlDatabase.removeInitiator(initiator);
    }

    public synchronized void startHandlers() throws RlError {
        block5: {
            block4: {
                if (this.commLayer.deviceAddress == null) break block4;
                if (CommLayer.portID != -1) break block5;
            }
            throw new RlError("Handlers must have an deviceID and portID");
        }
        if (this.nInstantiated <= 0) {
            this.nInstantiated = 1;
            this.packetBuilder.start();
            this.packetParser.start();
            this.pollingThread.start();
            this.beanGateway.start();
        }
    }

    public synchronized void startCommunications() throws RlError {
        try {
            this.commLayer.openConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.commThread = new Thread((Runnable)((Object)this.commLayer));
        this.commThread.start();
    }

    public synchronized void clearDatabase() {
        this.rlDatabase.clear();
    }

    public synchronized void pauseHandlers() {
        this.packetBuilder.setPause(true);
        this.packetParser.setPause(true);
        this.beanGateway.setPause(true);
    }

    public synchronized void unpauseHandlers() {
        this.packetBuilder.setPause(false);
        this.packetParser.setPause(false);
        this.pollingThread.setPause(false);
        this.beanGateway.setPause(false);
    }

    public synchronized void stopHandlers() {
        if (this.nInstantiated > 0) {
            this.packetBuilder.end();
            this.packetParser.end();
            this.pollingThread.end();
            this.beanGateway.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void breakCommunications() {
        this.commLayer.disconnect();
        Thread thread = this.commThread;
        synchronized (thread) {
            this.commLayer.canRun = false;
            this.commThread.interrupt();
        }
    }

    public synchronized void disableCommunications() {
        this.commLayer.disable();
    }

    public synchronized void enableCommunications() {
        this.commLayer.enable();
    }

    public void setSNMPTableEnum(String dataType, boolean isArray) {
        this.addMagicMarkup("enum", dataType, isArray);
    }

    public void setSNMPTableMACADDR(String dataType, boolean isArray) {
        this.addMagicMarkup("MACADDR", dataType, isArray);
    }

    public void enumDisplay(String enumSNMPVar, String SNMPVar, RlBeanProperty beanProp, long pollInterval, String pollGroup) {
        String enumVar = "(" + enumSNMPVar + "," + SNMPVar + ")";
        this.bindMarkupToBeanProperty("enum", enumVar, null, beanProp, pollInterval, pollGroup);
    }

    public void enumDisplay(String enumSNMPVar, String SNMPVar, RlBeanProperty beanProp, boolean isGet, boolean isSet, boolean isTrap, Object initiator) {
        String enumVar = "(" + enumSNMPVar + "," + SNMPVar + ")";
        this.bindMarkupToBeanProperty("enum", enumVar, null, beanProp, isGet, isSet, isTrap, initiator);
    }

    public void MACADDRDisplay(String SNMPVar, RlBeanProperty beanProp, long pollInterval, String pollGroup) {
        String MACADDR = ":" + SNMPVar;
        this.bindMarkupToBeanProperty("MACADDR", MACADDR, null, beanProp, pollInterval, pollGroup);
    }

    public void MACADDRDisplay(String SNMPVar, RlBeanProperty beanProp, boolean isGet, boolean isSet, boolean isTrap, Object initiator) {
        String MACADDR = ":" + SNMPVar;
        this.bindMarkupToBeanProperty("MACADDR", MACADDR, null, beanProp, isGet, isSet, isTrap, initiator);
    }

    public synchronized void pausePolling() {
        this.pollingThread.setPause(true);
    }

    public synchronized void unpausePolling() {
        this.pollingThread.setPause(false);
    }

    public void deleteMarkup(String name) {
        this.rlDatabase.deleteMarkup(name);
    }

    public void removeMarkup(String name, String args, Range range, Long pollInterval) {
        TagID tag = new TagID(name, new TagContext(args, range), pollInterval);
        this.removeMarkup(tag);
    }

    public void removeMarkup(TagID markup) {
        this.rlDatabase.removeMarkup(markup);
    }

    public void unbindMarkupFrom(TagID tagID, Object initiator, RlBeanProperty beanProp) {
        this.rlDatabase.unbindMarkupFrom(tagID, initiator, beanProp);
    }

    public void removeGroup(String name, String args, Range range, Long pollInterval) {
        TagID tag = new TagID(name, new TagContext(args, range), pollInterval);
        this.removeGroup(tag);
    }

    public void removeGroup(TagID group) {
        this.removeMarkup(group);
    }

    public synchronized void changePollInterval(String name, String argument, Range range, long oldInterval, long newInterval) throws RlError {
        TagContext context = new TagContext(argument, range);
        TagID tagID = new TagID(name, context, new Long(oldInterval));
        Hashtable hash = (Hashtable)this.rlDatabase.bindMap.remove(tagID);
        if (hash == null) {
            throw new RlError(tagID.toString() + " has not been initiated.");
        }
        this.rlDatabase.removePoll(tagID);
        tagID.pollInterval = new Long(newInterval);
        this.rlDatabase.bindMap.put(tagID, hash);
        this.rlDatabase.addPoll(tagID);
    }

    public void creatSNMPTable(Object initiator, String table, Range range) {
        this.setInitiatorSNMPTable(initiator, table);
        this.setInitiatorRange(initiator, range);
    }

    public void stopPollingFor(String name, String argument, Range range, long pollInterval) {
        TagContext context = new TagContext(argument, range);
        TagID tagID = new TagID(name, context, new Long(pollInterval));
        this.pollingThread.removePoll(tagID);
    }

    public void startPollingFor(String name, String argument, Range range, long pollInterval) {
        TagContext context = new TagContext(argument, range);
        TagID tagID = new TagID(name, context, new Long(pollInterval));
        if (this.rlDatabase.polls.contains(tagID) && !this.pollingThread.polls.contains(tagID)) {
            this.pollingThread.polls.addElement(tagID);
        }
    }

    public synchronized void kill() {
        if (this.nInstantiated > 1) {
            --this.nInstantiated;
            return;
        }
        this.clearAll();
        this.breakCommunications();
        this.nInstantiated = 0;
    }

    public synchronized void clearAll() {
        if (this.nInstantiated > 0) {
            this.stopHandlers();
        }
        this.clearDatabase();
    }

    public void setData(EventObject evt, String markup, String args, Range range) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        TagID tag = null;
        if (markup != null) {
            tag = new TagID(markup, new TagContext(args, range));
        }
        try {
            this.packetBuilder.buildSet(initiator, tag, evt);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
    }

    public void setData(EventObject evt) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        try {
            this.packetBuilder.buildSet(initiator, evt);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
    }

    public void setData(String markup, String args, Object data) {
        this.setData(null, markup, args, null, data);
    }

    public void setData(String markup, String args, Range range, Object data) {
        this.setData(null, markup, args, range, data);
    }

    public void setData(EventObject evt, String markup, String args, Range range, Object data) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        TagID tag = null;
        if (markup != null) {
            tag = new TagID(markup, new TagContext(args, range));
        }
        try {
            this.packetBuilder.buildSet(initiator, tag, data, evt);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
    }

    public void setSNMPTableData(Object[] column, String[] fieldName, Range range, String setMethod, String getMethod, Object initiator, EventObject evt) {
        int rowNum = range.length();
        int begingingRow = range.getFirst();
        int endRow = range.getLast();
        int colNum = column.length;
        Class[] param = new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = MultiBroker.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
        for (int i = 0; i < colNum; ++i) {
            for (int j = begingingRow; j < endRow + 1; ++j) {
                String thRow = new Integer(j + 1).toString();
                String entity = fieldName[i] + "." + thRow;
                this.addMagicMarkup(entity, "java.lang.String", true);
                RlBeanProperty beanProp = Broker.wrapBeanProperty(column[i], setMethod, null, getMethod, param);
                this.bindMarkupToBeanProperty(entity, "", null, beanProp, false, true, false, initiator);
            }
        }
        this.setData(evt);
    }

    public void setSNMPScalarData(Object[] column, String[] fieldName, Range range, String setMethod, String getMethod, Object initiator, EventObject evt) {
        int rowNum = range.length();
        int begingingRow = range.getFirst();
        int endRow = range.getLast();
        int colNum = fieldName.length;
        Class[] param = new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = MultiBroker.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
        for (int i = 0; i < colNum; ++i) {
            this.addMagicMarkup(fieldName[i], "java.lang.String", true);
            RlBeanProperty beanProp = Broker.wrapBeanProperty(column[i], setMethod, null, getMethod, param);
            this.bindMarkupToBeanProperty(fieldName[i], "", null, beanProp, false, true, false, initiator);
        }
        this.setData(evt);
    }

    public void getAllData() {
        int i;
        Vector initiators = new Vector(8, 8);
        Vector v = (Vector)this.rlDatabase.gets.clone();
        for (i = 0; i < v.size(); ++i) {
            TagID tagID = (TagID)v.elementAt(i);
            Hashtable hash = (Hashtable)this.rlDatabase.bindMap.get(tagID);
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                Object initiator = e.nextElement();
                if (initiator == "null" && hash.size() != 1 || initiators.contains(initiator)) continue;
                initiators.addElement(initiator);
            }
        }
        for (i = 0; i < initiators.size(); ++i) {
            this.getData(new EventObject(initiators.elementAt(i)));
        }
    }

    public void getData(EventObject evt) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        this.packetBuilder.buildGet(initiator, evt);
    }

    public void getData(String markup, String args) {
        this.getData(null, markup, args, null, null);
    }

    public void getData(String markup, String args, long pollInterval) {
        this.getData(null, markup, args, null, new Long(pollInterval));
    }

    public void getData(String markup, String args, Range range) {
        this.getData(null, markup, args, range, null);
    }

    public void getData(String markup, String args, Range range, long pollInterval) {
        this.getData(null, markup, args, range, new Long(pollInterval));
    }

    public void getData(EventObject evt, String markup, String args, Range range, Long pollInterval) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        TagID tag = null;
        if (markup != null) {
            tag = new TagID(markup, new TagContext(args, range), pollInterval);
        }
        try {
            this.packetBuilder.buildGet(initiator, tag, evt);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
    }

    protected void finalize() {
        if (this.nInstantiated > 1) {
            this.nInstantiated = 1;
        }
        this.kill();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

