/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.util.Vector;
import rl.clbroker.ContextNode;
import rl.clbroker.Range;
import rl.clbroker.TagID;

public class InitiatorContext
implements Cloneable {
    protected Vector tags;
    protected Vector contextNodes;
    protected Range range;
    protected String SNMPTable;

    public InitiatorContext() {
        this.tags = new Vector(8, 8);
        this.contextNodes = new Vector(8, 8);
    }

    public InitiatorContext(Vector tags, Vector contextNodes, Range range, String table) {
        this.tags = tags == null ? new Vector(8, 8) : tags;
        this.contextNodes = contextNodes == null ? new Vector(8, 8) : contextNodes;
        this.range = range;
        this.SNMPTable = table;
    }

    public void setSNMPTable(String table) {
        this.SNMPTable = table;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setTags(Vector tags) {
        this.tags = tags == null ? new Vector(8, 8) : tags;
    }

    public void setContextNodes(Vector nodes) {
        this.contextNodes = nodes == null ? new Vector(8, 8) : nodes;
    }

    public void addTag(TagID tag) {
        if (!this.tags.contains(tag)) {
            this.tags.addElement(tag);
        }
    }

    public void removeTag(TagID tag) {
        this.tags.removeElement(tag);
    }

    public void addContextNode(ContextNode context) {
        if (!this.contextNodes.contains(context)) {
            this.contextNodes.addElement(context);
        }
    }

    public void removeContextNode(ContextNode context) {
        this.contextNodes.removeElement(context);
    }

    public Object clone() {
        InitiatorContext context = new InitiatorContext((Vector)this.tags.clone(), (Vector)this.contextNodes.clone(), null, null);
        if (this.range != null) {
            context.setRange((Range)this.range.clone());
        }
        if (this.SNMPTable != null) {
            context.setSNMPTable(new String(this.SNMPTable));
        }
        return context;
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null || !(obj instanceof InitiatorContext)) {
            return false;
        }
        InitiatorContext initr = (InitiatorContext)obj;
        if (this.contextNodes.size() != initr.contextNodes.size()) {
            return false;
        }
        if (this.tags.size() != initr.tags.size()) {
            return false;
        }
        for (i = 0; i < this.contextNodes.size(); ++i) {
            if (!(this.contextNodes.elementAt(i) == null ? initr.contextNodes.elementAt(i) != null : !this.contextNodes.elementAt(i).equals(initr.contextNodes.elementAt(i)))) continue;
            return false;
        }
        for (i = 0; i < this.tags.size(); ++i) {
            if (!(this.tags.elementAt(i) == null ? initr.tags.elementAt(i) != null : !this.tags.elementAt(i).equals(initr.tags.elementAt(i)))) continue;
            return false;
        }
        return !(this.range == null ? initr.range != null : !this.range.equals(initr.range));
    }

    public String toString() {
        StringBuffer value = new StringBuffer();
        value.append('{');
        value.append(this.tags);
        value.append('}');
        value.append('{');
        value.append(this.contextNodes);
        value.append('}');
        value.append('{');
        value.append(this.range);
        value.append('}');
        value.append('{');
        value.append(this.SNMPTable);
        value.append('}');
        return value.toString();
    }
}

