/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import rl.clbroker.ExceptionInterface;
import rl.clbroker.ExceptionObserver;
import rl.clbroker.ExceptionOccurence;

public class ExceptionPropogator
implements ExceptionInterface {
    protected Vector observers = new Vector();

    public void addExceptionObserver(ExceptionObserver eo) {
        if (!this.observers.contains(eo)) {
            this.observers.addElement(eo);
        }
    }

    public void removeExceptionObserver(ExceptionObserver eo) {
        this.observers.removeElement(eo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(int errorLevel, Throwable t, int type) {
        Vector obCopy = null;
        Vector vector = this.observers;
        synchronized (vector) {
            obCopy = (Vector)this.observers.clone();
        }
        ExceptionOccurence ec = new ExceptionOccurence(errorLevel, t, type);
        for (int i = 0; i < obCopy.size(); ++i) {
            ((ExceptionObserver)this.observers.elementAt(i)).exceptionOccurred(ec);
        }
    }

    public void receiveIOExceptions(int errorLevel, Throwable t) {
        this.receive(errorLevel, t, 1);
    }

    public void receiveUserClassesExceptions(int errorLevel, Throwable t) {
        if (t instanceof InvocationTargetException) {
            this.receive(errorLevel, ((InvocationTargetException)t).getTargetException(), 2);
        } else {
            this.receive(errorLevel, t, 2);
        }
    }

    public void receiveBrowserExceptions(int errorLevel, Throwable t) {
        this.receive(errorLevel, t, 3);
    }

    public void receiveThreadExceptions(int errorLevel, Throwable t) {
        this.receive(errorLevel, t, 4);
    }

    public void receiveLoginExceptions(int errorLevel, Throwable t) {
        this.receive(errorLevel, t, 5);
    }

    public void receiveBrokerExceptions(int errorLevel, Throwable t) {
        this.receive(errorLevel, t, 6);
    }

    public void receiveRuntimeExceptions(int errorLevel, Throwable t) {
        this.receive(errorLevel, t, 7);
    }
}

