/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import rl.clbroker.MagicMarkup;
import rl.clbroker.RlDatabase;
import rl.clbroker.RlError;
import rl.clbroker.TagContext;
import rl.clbroker.TagID;

public class Converter {
    protected Object initiator;
    protected Hashtable dataMap;
    protected Enumeration groups;
    protected RlDatabase rlDatabase;

    public Converter(Object initiator, Hashtable dataMap, RlDatabase rlDatabase, Enumeration groups) {
        this.initiator = initiator;
        this.dataMap = dataMap;
        this.groups = groups;
        this.rlDatabase = rlDatabase;
    }

    protected Hashtable convertToJava() throws InvocationTargetException, InstantiationException, IllegalAccessException, RlError {
        if (this.groups == null) {
            return this.convertTagsToJava(this.dataMap);
        }
        return this.convertGroupsToJava();
    }

    private TagID buildTagFromString(String element) {
        String markup = "";
        String args = "";
        StringTokenizer stok = new StringTokenizer(element, "()");
        markup = stok.nextToken();
        if (stok.hasMoreTokens()) {
            args = stok.nextToken();
        }
        return new TagID(markup, new TagContext(args));
    }

    private Hashtable convertGroupsToJava() throws InvocationTargetException, InstantiationException, IllegalAccessException, RlError {
        Hashtable<TagID, Object[][]> hash = new Hashtable<TagID, Object[][]>(8);
        while (this.groups.hasMoreElements()) {
            TagID groupID = (TagID)this.groups.nextElement();
            Vector tagMaps = (Vector)this.dataMap.get(groupID);
            Vector v = (Vector)this.rlDatabase.nameRefMap.get(groupID.id);
            Hashtable subHash = this.convertTagsToJava((Hashtable)tagMaps.elementAt(0));
            Object[][] array = new Object[1][v.size()];
            for (int i = 0; i < v.size(); ++i) {
                TagID temp = this.buildTagFromString((String)v.elementAt(i));
                Object[][] subArray = (Object[][])subHash.get(temp);
                array[0][i] = subArray[0][0];
            }
            hash.put(groupID, array);
        }
        return hash;
    }

    private Hashtable convertTagsToJava(Hashtable data) throws InvocationTargetException, InstantiationException, IllegalAccessException, RlError {
        Hashtable<TagID, Object[][]> hash = new Hashtable<TagID, Object[][]>(8);
        Enumeration e = data.keys();
        while (e.hasMoreElements()) {
            TagID tagID = (TagID)e.nextElement();
            Vector v = (Vector)data.get(tagID);
            MagicMarkup markup = (MagicMarkup)this.rlDatabase.nameRefMap.get(tagID.id);
            if (markup == null) {
                throw new RlError(tagID.id + " not a registered RapidMark.");
            }
            Object[] javaData = new Object[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                javaData[i] = markup.read((byte[])v.elementAt(i));
            }
            Object[][] wrap = new Object[javaData.length][1];
            if (markup.isArray) {
                Object[] array = new Object[]{javaData};
                for (int i = 0; i < array.length; ++i) {
                    wrap[i][0] = array[i];
                }
            } else {
                for (int i = 0; i < javaData.length; ++i) {
                    wrap[i][0] = javaData[i];
                }
            }
            hash.put(tagID, wrap);
        }
        return hash;
    }
}

