/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import rl.clbroker.MultiBroker;
import rl.clbroker.OCP;
import rl.clbroker.PacketComponents;
import rl.clbroker.RlError;

public abstract class CommLayer {
    protected static final int kUndef = -1;
    protected boolean canRun = true;
    protected boolean isEnabled = true;
    protected InetAddress deviceAddress;
    protected int maxPacketSize;
    protected int connectionID;
    protected int sessionID = 0;
    public static int portID = -1;
    protected static int kMaxPacketLen = 4096;
    protected static final int kSizeOfQueue = 256;
    protected Hashtable requestsMade = new Hashtable(256);
    public static final int kMSecsBlock = 32000;
    protected boolean isConnected = false;
    protected static final int kLoginRetries = 3;
    protected boolean doRetry = true;

    public InetAddress getDeviceAddress() {
        return this.deviceAddress;
    }

    protected int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    protected synchronized void enable() {
        this.isEnabled = true;
        this.notify();
    }

    protected synchronized void disable() {
        this.isEnabled = false;
    }

    protected byte[] buildLoginPacket() {
        OCP.Header header = new OCP.Header(this.connectionID, this.sessionID++, 1, new byte[4]);
        OCP.Login login = new OCP.Login();
        login.getClass();
        OCP.Login.Request login2 = new OCP.Login.Request(login, 1, 2, "username", "password");
        OCP.Chunk chunk = new OCP.Chunk(login2);
        byte[] bChunk = chunk.toBytes();
        byte[] bNull = OCP.Chunk.kNull.toBytes();
        header.setMesgLen(bChunk.length + bNull.length);
        byte[] bHeader = header.toBytes();
        byte[] packet = new byte[bHeader.length + bChunk.length + bNull.length];
        System.arraycopy(bHeader, 0, packet, 0, bHeader.length);
        System.arraycopy(bChunk, 0, packet, bHeader.length, bChunk.length);
        return OCP.appendCRC(packet);
    }

    protected void processLoginResponse(OCP.Header header, OCP.Chunk chunk, OCP.Chunk nullChunk, int crc) throws IOException, RlError {
        if (header.headerFlag != 1751280227) {
            throw new RlError("Bad Header");
        }
        if (chunk.chunkLen != chunk.endLen) {
            throw new RlError("Bad Chunk");
        }
        if (!nullChunk.equals(OCP.Chunk.kNull)) {
            throw new RlError("Bad Login Response packet");
        }
        byte[] recvHeader = header.toBytes();
        byte[] recvChunk = chunk.toBytes();
        byte[] recvNullChunk = nullChunk.toBytes();
        byte[] recvPacket = new byte[recvHeader.length + recvChunk.length + recvNullChunk.length];
        System.arraycopy(recvHeader, 0, recvPacket, 0, recvHeader.length);
        System.arraycopy(recvChunk, 0, recvPacket, recvHeader.length, recvChunk.length);
        System.arraycopy(recvNullChunk, 0, recvPacket, recvHeader.length + recvChunk.length, recvNullChunk.length);
        OCP.checkCRC(recvPacket, crc);
        OCP.Login login = new OCP.Login();
        login.getClass();
        OCP.Login.Response response = new OCP.Login.Response(login, chunk.getDataStream());
        this.connectionID = response.getConnectionID();
    }

    protected Frame getBaseFrame() {
        Component c = MultiBroker.currentDisplay;
        if (c == null) {
            return null;
        }
        while (!(c instanceof Frame)) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    protected void connect() {
        byte[] loginPacket = this.buildLoginPacket();
        try {
            this.login(loginPacket);
            this.isConnected = true;
        }
        catch (Exception e) {
            MultiBroker.exHandler.receiveLoginExceptions(4, e);
        }
    }

    protected byte[] buildLogoutPacket() {
        OCP.Header header = new OCP.Header(this.connectionID, this.sessionID++, 3, new byte[4]);
        OCP.Logout.Request logout = new OCP.Logout.Request(new OCP.Logout());
        OCP.Chunk nullChunk = OCP.Chunk.kNull;
        byte[] bLogout = logout.toBytes();
        byte[] bNullChunk = nullChunk.toBytes();
        header.setMesgLen(bNullChunk.length);
        byte[] bHeader = header.toBytes();
        byte[] packet = new byte[bHeader.length + bLogout.length + bNullChunk.length];
        System.arraycopy(bHeader, 0, packet, 0, bHeader.length);
        System.arraycopy(bLogout, 0, packet, bHeader.length, bLogout.length);
        return OCP.appendCRC(packet);
    }

    protected void disconnect() {
        byte[] logoutPacket = this.buildLogoutPacket();
        try {
            this.logout(logoutPacket);
            this.doRetry = false;
            this.isConnected = false;
        }
        catch (SecurityException e) {
            MultiBroker.exHandler.receiveBrowserExceptions(1, e);
        }
        catch (IOException e) {
            MultiBroker.exHandler.receiveIOExceptions(1, e);
        }
    }

    protected synchronized void shrinkQueue(int sessionID) {
        Enumeration e = this.requestsMade.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            if (key >= sessionID - 256 + 1) continue;
            this.requestsMade.remove(key);
        }
    }

    protected void scanForHeader(InputStream in) {
        PushbackInputStream pbin = new PushbackInputStream(in, 4);
        try {
            while (true) {
                pbin.mark(256);
                int a = pbin.read();
                if (a != OCP.kHeaderFlag[0]) continue;
                pbin.mark(256);
                int b = pbin.read();
                if (b == OCP.kHeaderFlag[1]) {
                    pbin.mark(256);
                    int c = pbin.read();
                    if (c == OCP.kHeaderFlag[2]) {
                        pbin.mark(256);
                        int d = pbin.read();
                        if (d == OCP.kHeaderFlag[3]) {
                            pbin.unread(d);
                            pbin.unread(c);
                            pbin.unread(b);
                            pbin.unread(a);
                            break;
                        }
                        pbin.unread(d);
                    }
                    pbin.unread(c);
                }
                pbin.unread(b);
            }
        }
        catch (IOException e) {
            MultiBroker.exHandler.receiveIOExceptions(3, e);
        }
    }

    protected abstract void openConnection() throws IOException;

    protected abstract void logout(byte[] var1) throws SecurityException, IOException;

    protected abstract void login(byte[] var1) throws Exception;

    protected abstract void send(OCP.Header var1, PacketComponents var2, byte[] var3) throws SecurityException, IOException, RlError;
}

