/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.awt.Component;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import rl.clbroker.ExceptionObserver;
import rl.clbroker.ExceptionPrinter;
import rl.clbroker.ExceptionPropogator;
import rl.clbroker.MagicMarkup;
import rl.clbroker.Range;
import rl.clbroker.RlBeanProperty;
import rl.clbroker.RlError;
import rl.clbroker.RlSDatabase;
import rl.clbroker.RlUtil;
import rl.clbroker.SBeanGateway;
import rl.clbroker.SCommLayer;
import rl.clbroker.SPacketBuilder;
import rl.clbroker.SPacketParser;
import rl.clbroker.SPollingThread;
import rl.clbroker.TagContext;
import rl.clbroker.TagID;
import rl.clbroker.requestComplete;

public class Broker {
    private static int threadCounter = 0;
    protected static Vector callerList;
    public static boolean isPaused;
    public static int nInstantiated;
    protected static Component currentDisplay;
    protected static SPacketBuilder packetBuilder;
    protected static SPacketParser packetParser;
    protected static SPollingThread pollingThread;
    public static SCommLayer commLayer;
    protected static Thread commThread;
    protected static SBeanGateway beanGateway;
    protected static ExceptionPropogator exHandler;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public static void start() {
        RlUtil.trace(4, "   Broker.start");
        if (nInstantiated > 0) {
            RlUtil.trace(4, "   Broker.start - already instantiated");
            ++nInstantiated;
        } else {
            RlUtil.trace(4, "   Broker.start - first instantiation");
            try {
                exHandler.addExceptionObserver(new ExceptionPrinter());
                Broker.startCommunications();
                RlUtil.trace(4, "   Broker.start - communications started");
                if (Broker.commLayer.isConnected) {
                    RlUtil.trace(4, "   Broker.start - connected");
                    Broker.startHandlers();
                    Broker.getAllData();
                    Broker.startPolling();
                    RlUtil.trace(4, "   Broker.start - polling");
                } else {
                    RlUtil.trace(4, "   Broker.start - not connected");
                    Broker.breakCommunications();
                }
            }
            catch (RlError e) {
                RlUtil.trace(4, "   Broker.start - RlError exception: " + e);
                exHandler.receiveBrokerExceptions(4, e);
            }
        }
        RlUtil.trace(4, "   Broker.start - complete");
    }

    public static void registerExceptionObserver(ExceptionObserver eo) {
        RlUtil.trace(4, "   Broker.registerExceptionObserver");
        exHandler.addExceptionObserver(eo);
        RlUtil.trace(4, "   Broker.registerExceptionObserver - complete");
    }

    private static void startPolling() {
        RlUtil.trace(4, "   Broker.startPolling");
        pollingThread.addPoll(RlSDatabase.polls);
        RlUtil.trace(4, "   Broker.startPolling - complete");
    }

    public static synchronized void setCurrentDisplay(Component c) {
        currentDisplay = c;
    }

    public static synchronized void setOptions(InetAddress ip, int port, int maxPacketSize) {
        Broker.setPort(port);
        Broker.setMaxPacketSize(maxPacketSize);
        if (ip != null) {
            Broker.setIp(ip);
        }
    }

    public static synchronized void setOptions(String ip, int port, int maxPacketSize) throws UnknownHostException {
        Broker.setPort(port);
        Broker.setMaxPacketSize(maxPacketSize);
        Broker.setIp(ip);
    }

    public static synchronized void setOptions(URL url, int port, int maxPacketSize) throws UnknownHostException {
        Broker.setPort(port);
        Broker.setMaxPacketSize(maxPacketSize);
        Broker.setIp(url);
    }

    public static synchronized void setUser(String userId, String password) {
        if (userId != null) {
            SCommLayer.setUserId(userId);
        }
        if (password != null) {
            SCommLayer.setPassword(password);
        }
    }

    public static void setMaxPacketSize(int maxPacketSize) {
        SCommLayer.maxPacketSize = maxPacketSize;
    }

    public static void setIp(URL url) throws UnknownHostException {
        Broker.setIp(url.getHost());
    }

    public static void setIp(String ip) throws UnknownHostException {
        if (ip.regionMatches(true, 0, "http://", 0, 7) || ip.regionMatches(true, 0, "file://", 0, 7)) {
            ip = ip.substring(7);
        }
        Broker.setIp(InetAddress.getByName(ip));
    }

    public static void setIp(InetAddress ip) {
        SCommLayer.deviceAddress = ip;
    }

    public static void setPort(int port) {
        SCommLayer.portID = port;
    }

    public static void addTrap(String group, Vector markups) {
        Broker.addGroup(group, markups);
    }

    public static void addGroup(String group, Vector markups) {
        if (markups == null) {
            markups = new Vector(8);
        }
        RlSDatabase.name(group, markups);
    }

    public static MagicMarkup addMagicMarkup(String name, String dataType, boolean isArray) {
        MagicMarkup markup = null;
        try {
            markup = new MagicMarkup(name, dataType, isArray);
            RlSDatabase.name(name, markup);
        }
        catch (Exception e) {
            exHandler.receiveBrokerExceptions(1, e);
        }
        return markup;
    }

    public static RlBeanProperty wrapBeanProperty(Object bean, String property, Class propertyClass) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, property, propertyClass);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public static RlBeanProperty wrapBeanProperty(Object bean, String property) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, property);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(1, e);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public static RlBeanProperty wrapBeanProperty(Object bean, Method getMethod, Method setMethod) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, getMethod, setMethod);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public static RlBeanProperty wrapBeanProperty(Object bean, String property, Class propertyClass, String getMethod, String setMethod) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, property, propertyClass, getMethod, setMethod);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public static RlBeanProperty wrapBeanProperty(Object bean, String property, String getMethod, String setMethod) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, property, getMethod, setMethod);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public static RlBeanProperty wrapBeanProperty(Object bean, String getMethod, Class[] getParams, String setMethod, Class[] setParams) {
        RlBeanProperty beanProp = null;
        try {
            beanProp = new RlBeanProperty(bean, getMethod, getParams, setMethod, setParams);
        }
        catch (Exception e) {
            exHandler.receiveUserClassesExceptions(1, e);
        }
        return beanProp;
    }

    public static void bindMarkupToBeanProperty(String markupName, String arguments, Range range, RlBeanProperty beanProp, boolean isGet, boolean isSet, boolean isTrap, Object initiator) {
        if (beanProp == null || markupName == null) {
            throw new IllegalArgumentException("beanProp && markupName != null");
        }
        if (!RlSDatabase.nameRefMap.containsKey(markupName)) {
            throw new IllegalArgumentException("RapidMark " + markupName + " not found.");
        }
        if (initiator == null) {
            initiator = "null";
        }
        TagContext context = new TagContext(arguments, range);
        try {
            TagID markupID = new TagID(markupName, context);
            RlSDatabase.bind(markupID, initiator, beanProp);
            if ((isGet || isSet) && !RlSDatabase.gets.contains(markupID)) {
                RlSDatabase.gets.addElement(markupID);
                if (nInstantiated > 0) {
                    EventObject evt = new EventObject(initiator);
                    Broker.getData(evt, markupName, arguments, range, null);
                }
            }
            if (isTrap && !RlSDatabase.events.contains(markupID)) {
                RlSDatabase.events.addElement(markupID);
            }
        }
        catch (Exception e) {
            exHandler.receiveRuntimeExceptions(1, e);
        }
    }

    public static void bindMarkupToBeanPropertyNoGet(String markupName, String arguments, Range range, RlBeanProperty beanProp, boolean isGet, boolean isSet, boolean isTrap, Object initiator) {
        if (beanProp == null || markupName == null) {
            throw new IllegalArgumentException("beanProp && markupName != null");
        }
        if (!RlSDatabase.nameRefMap.containsKey(markupName)) {
            throw new IllegalArgumentException("RapidMark " + markupName + " not found.");
        }
        if (initiator == null) {
            initiator = "null";
        }
        TagContext context = new TagContext(arguments, null);
        try {
            TagID markupID = new TagID(markupName, context);
            RlSDatabase.bind(markupID, initiator, beanProp);
            if ((isGet || isSet) && !RlSDatabase.gets.contains(markupID)) {
                RlSDatabase.gets.addElement(markupID);
                if (nInstantiated > 0) {
                    EventObject evt = new EventObject(initiator);
                }
            }
            if (isTrap && !RlSDatabase.events.contains(markupID)) {
                RlSDatabase.events.addElement(markupID);
            }
        }
        catch (Exception e) {
            exHandler.receiveRuntimeExceptions(1, e);
        }
        Broker.setInitiatorRange(initiator, range);
    }

    public static void bindMarkupToBeanProperty(String markupName, String arguments, Range range, RlBeanProperty beanProp, long pollInterval, String pollGroup) {
        if (beanProp == null || markupName == null) {
            throw new IllegalArgumentException("beanProp && markupName != null");
        }
        if (!RlSDatabase.nameRefMap.containsKey(markupName)) {
            throw new IllegalArgumentException("RapidMark " + markupName + " not found.");
        }
        if (pollGroup == null) {
            pollGroup = "null";
        }
        TagContext context = new TagContext(arguments, range);
        try {
            TagID markupID = new TagID(markupName, context, new Long(pollInterval));
            RlSDatabase.bind(markupID, pollGroup, beanProp);
            RlSDatabase.addPoll(markupID);
        }
        catch (Exception e) {
            exHandler.receiveRuntimeExceptions(1, e);
        }
    }

    public static void setSNMPTableEnum(String dataType, boolean isArray) {
        Broker.addMagicMarkup("enum", dataType, isArray);
    }

    public static void setSNMPTableMACADDR(String dataType, boolean isArray) {
        Broker.addMagicMarkup("MACADDR", dataType, isArray);
    }

    public static void enumDisplay(String enumSNMPVar, String SNMPVar, RlBeanProperty beanProp, long pollInterval, String pollGroup) {
        String enumVar = "(" + enumSNMPVar + "," + SNMPVar + ")";
        Broker.bindMarkupToBeanProperty("enum", enumVar, null, beanProp, pollInterval, pollGroup);
    }

    public static void enumDisplay(String enumSNMPVar, String SNMPVar, RlBeanProperty beanProp, boolean isGet, boolean isSet, boolean isTrap, Object initiator) {
        String enumVar = "(" + enumSNMPVar + "," + SNMPVar + ")";
        Broker.bindMarkupToBeanProperty("enum", enumVar, null, beanProp, isGet, isSet, isTrap, initiator);
    }

    public static void MACADDRDisplay(String SNMPVar, RlBeanProperty beanProp, long pollInterval, String pollGroup) {
        String MACADDR = ":" + SNMPVar;
        Broker.bindMarkupToBeanProperty("MACADDR", MACADDR, null, beanProp, pollInterval, pollGroup);
    }

    public static void MACADDRDisplay(String SNMPVar, RlBeanProperty beanProp, boolean isGet, boolean isSet, boolean isTrap, Object initiator) {
        String MACADDR = ":" + SNMPVar;
        Broker.bindMarkupToBeanProperty("MACADDR", MACADDR, null, beanProp, isGet, isSet, isTrap, initiator);
    }

    public static void setInitiatorContext(Object initiator, Vector contextNodes) {
        RlSDatabase.setInitiatorContext(initiator, contextNodes);
    }

    public static void setInitiatorRange(Object initiator, Range range) {
        RlSDatabase.setInitiatorContext(initiator, range);
    }

    public static void setInitiatorSNMPTable(Object initiator, String table) {
        RlSDatabase.setInitiatorContext(initiator, table);
    }

    public static void removeInitiator(Object initiator) {
        RlSDatabase.removeInitiator(initiator);
    }

    public static synchronized void startHandlers() throws RlError {
        RlUtil.trace(4, "   Broker.startHandlers");
        if (SCommLayer.deviceAddress == null || SCommLayer.portID == -1) {
            throw new RlError("Handlers must have an deviceID and portID");
        }
        if (nInstantiated <= 0) {
            RlUtil.trace(4, "   Broker.startHandlers - starting threads");
            nInstantiated = 1;
            packetBuilder = new SPacketBuilder();
            packetParser = new SPacketParser();
            pollingThread = new SPollingThread();
            beanGateway = new SBeanGateway();
            packetBuilder.start();
            packetParser.start();
            pollingThread.start();
            beanGateway.start();
        }
        RlUtil.trace(4, "   Broker.startHandlers - complete");
    }

    public static synchronized void startCommunications() throws RlError {
        RlUtil.trace(4, "   Broker.startCommunications");
        if (commLayer != null || commThread != null) {
            RlUtil.trace(2, "   Broker.startCommunications - commLayer not null!");
            RlUtil.trace(2, "   Broker.startCommunications - breaking communications first");
            Broker.breakCommunications();
            RlUtil.trace(2, "   Broker.startCommunications -  communications broken");
        }
        Class<?> comm = null;
        try {
            RlUtil.trace(4, "   Broker.startCommunications - instantiating STCPComm class");
            comm = Class.forName("rl.clbroker.STCPComm");
            commLayer = (SCommLayer)comm.newInstance();
        }
        catch (Exception e) {
            RlUtil.trace(4, "   Broker.startCommunications - exception instantiating STCPComm class");
            throw new RlError(e.toString());
        }
        commThread = new Thread((Runnable)((Object)commLayer));
        commThread.setName(" STCPComm thread " + ++threadCounter);
        RlUtil.trace(4, "   Broker.startCommunications - starting thread " + threadCounter);
        commThread.start();
        RlUtil.trace(4, "   Broker.startCommunications - complete");
    }

    public static synchronized void clearDatabase() {
        RlSDatabase.clear();
    }

    public static synchronized void pauseHandlers() {
        RlUtil.trace(4, "   Broker.pauseHandlers");
        packetBuilder.setPause(true);
        packetParser.setPause(true);
        beanGateway.setPause(true);
        RlUtil.trace(4, "   Broker.pauseHandlers - complete");
    }

    public static synchronized void unpauseHandlers() {
        RlUtil.trace(4, "   Broker.unpauseHandlers");
        packetBuilder.setPause(false);
        packetParser.setPause(false);
        pollingThread.setPause(false);
        beanGateway.setPause(false);
        RlUtil.trace(4, "   Broker.unpauseHandlers - complete");
    }

    public static synchronized void stopHandlers() {
        RlUtil.trace(4, "   Broker.stopHandlers");
        if (nInstantiated > 0) {
            packetBuilder.end();
            packetParser.end();
            pollingThread.end();
            beanGateway.end();
            RlUtil.trace(4, "   Broker.stopHandlers - ended threads");
        }
        RlUtil.trace(4, "   Broker.stopHandlers - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void breakCommunications() {
        RlUtil.trace(4, "   Broker.breakCommunications");
        RlUtil.trace(4, "   Broker.breakCommunications - disconnecting commLayer");
        try {
            commLayer.disconnect();
        }
        catch (Exception e) {
            RlUtil.trace(4, "   Broker.breakCommunications - exception" + e);
            e.printStackTrace();
        }
        RlUtil.trace(4, "   Broker.breakCommunications - commLayer disconnected.  Closing commLayer");
        Thread e = commThread;
        synchronized (e) {
            RlUtil.trace(4, "   Broker.breakCommunications - interrupting commThread");
            Broker.commLayer.canRun = false;
            Broker.commLayer.attemptResynch = false;
            commThread.interrupt();
        }
        try {
            commLayer.close();
        }
        catch (Exception e2) {
            RlUtil.trace(4, "   Broker.breakCommunications - exception" + e2);
            e2.printStackTrace();
        }
        RlUtil.trace(4, "   Broker.breakCommunications - commLayer closed");
        commLayer = null;
        commThread = null;
        RlUtil.trace(4, "   Broker.breakCommunications - complete");
    }

    public static synchronized void disableCommunications() {
        RlUtil.trace(4, "   Broker.disableCommunications");
        commLayer.disable();
        RlUtil.trace(4, "   Broker.disableCommunications - complete");
    }

    public static synchronized void enableCommunications() {
        RlUtil.trace(4, "   Broker.enableCommunications");
        commLayer.enable();
        RlUtil.trace(4, "   Broker.enableCommunications - complete");
    }

    public static synchronized void pausePolling() {
        RlUtil.trace(4, "   Broker.pausePolling");
        pollingThread.setPause(true);
        RlUtil.trace(4, "   Broker.pausePolling - complete");
    }

    public static synchronized void unpausePolling() {
        RlUtil.trace(4, "   Broker.unpausePolling");
        pollingThread.setPause(false);
        RlUtil.trace(4, "   Broker.unpausePolling - complete");
    }

    public static void deleteMarkup(String name) {
        RlSDatabase.deleteMarkup(name);
    }

    public static void removeMarkup(String name, String args, Range range, Long pollInterval) {
        TagID tag = new TagID(name, new TagContext(args, range), pollInterval);
        Broker.removeMarkup(tag);
    }

    public static void removeMarkup(TagID markup) {
        RlSDatabase.removeMarkup(markup);
    }

    public static void unbindMarkupFrom(TagID tagID, Object initiator, RlBeanProperty beanProp) {
        RlSDatabase.unbindMarkupFrom(tagID, initiator, beanProp);
    }

    public static void removeGroup(String name, String args, Range range, Long pollInterval) {
        TagID tag = new TagID(name, new TagContext(args, range), pollInterval);
        Broker.removeGroup(tag);
    }

    public static void removeGroup(TagID group) {
        Broker.removeMarkup(group);
    }

    public static synchronized void changePollInterval(String name, String argument, Range range, long oldInterval, long newInterval) throws RlError {
        TagContext context = new TagContext(argument, range);
        TagID tagID = new TagID(name, context, new Long(oldInterval));
        Hashtable hash = (Hashtable)RlSDatabase.bindMap.remove(tagID);
        if (hash == null) {
            throw new RlError(tagID.toString() + " has not been initiated.");
        }
        RlSDatabase.removePoll(tagID);
        tagID.pollInterval = new Long(newInterval);
        RlSDatabase.bindMap.put(tagID, hash);
        RlSDatabase.addPoll(tagID);
    }

    public static void stopPollingFor(String name, String argument, Range range, long pollInterval) {
        TagContext context = new TagContext(argument, range);
        TagID tagID = new TagID(name, context, new Long(pollInterval));
        pollingThread.removePoll(tagID);
    }

    public static void startPollingFor(String name, String argument, Range range, long pollInterval) {
        TagContext context = new TagContext(argument, range);
        TagID tagID = new TagID(name, context, new Long(pollInterval));
        if (RlSDatabase.polls.contains(tagID) && !Broker.pollingThread.polls.contains(tagID)) {
            Broker.pollingThread.polls.addElement(tagID);
        }
    }

    public static synchronized void kill() {
        RlUtil.trace(4, "   Broker.kill");
        if (nInstantiated > 1) {
            --nInstantiated;
            return;
        }
        Broker.clearAll();
        Broker.breakCommunications();
        nInstantiated = 0;
        RlUtil.trace(4, "   Broker.kill - end");
    }

    public static synchronized void clearAll() {
        RlUtil.trace(4, "   Broker.clearAll");
        if (nInstantiated > 0) {
            Broker.stopHandlers();
        }
        Broker.clearDatabase();
        RlUtil.trace(4, "   Broker.clearAll - complete");
    }

    public static void setBlockingData(EventObject evt, requestComplete caller) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        try {
            packetBuilder.buildSet(initiator, evt, caller);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
    }

    public static void setSNMPTableData(Object[] column, String[] fieldName, Range range, String setMethod, String getMethod, Object initiator, EventObject evt) {
        int rowNum = range.length();
        int begingingRow = range.getFirst();
        int endRow = range.getLast();
        int colNum = column.length;
        Class[] param = new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = Broker.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
        for (int i = 0; i < colNum; ++i) {
            for (int j = begingingRow; j < endRow + 1; ++j) {
                String thRow = new Integer(j + 1).toString();
                String entity = fieldName[i] + "." + thRow;
                Broker.addMagicMarkup(entity, "java.lang.String", true);
                RlBeanProperty beanProp = Broker.wrapBeanProperty(column[i], setMethod, null, getMethod, param);
                Broker.bindMarkupToBeanProperty(entity, "", null, beanProp, false, true, false, initiator);
            }
        }
        Broker.setData(evt);
    }

    public static void setSNMPScalarData(Object[] column, String[] fieldName, Range range, String setMethod, String getMethod, Object initiator, EventObject evt) {
        int rowNum = range.length();
        int begingingRow = range.getFirst();
        int endRow = range.getLast();
        int colNum = fieldName.length;
        Class[] param = new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = Broker.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
        for (int i = 0; i < colNum; ++i) {
            Broker.addMagicMarkup(fieldName[i], "java.lang.String", true);
            RlBeanProperty beanProp = Broker.wrapBeanProperty(column[i], setMethod, null, getMethod, param);
            Broker.bindMarkupToBeanProperty(fieldName[i], "", null, beanProp, false, true, false, initiator);
        }
        Broker.setData(evt);
    }

    public static void setData(EventObject evt, String markup, String args, Range range) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        TagID tag = null;
        if (markup != null) {
            tag = new TagID(markup, new TagContext(args, range));
        }
        try {
            packetBuilder.buildSet(initiator, tag, evt);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
    }

    public static void setData(EventObject evt) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        try {
            packetBuilder.buildSet(initiator, evt);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
    }

    public static void setData(String markup, String args, Object data) {
        Broker.setData(null, markup, args, null, data);
    }

    public static void setData(String markup, String args, Range range, Object data) {
        Broker.setData(null, markup, args, range, data);
    }

    public static void setData(EventObject evt, String markup, String args, Range range, Object data) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        TagID tag = null;
        if (markup != null) {
            tag = new TagID(markup, new TagContext(args, range));
        }
        try {
            packetBuilder.buildSet(initiator, tag, data, evt);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
    }

    public static void creatSNMPTable(Object initiator, String table, Range range) {
        Broker.setInitiatorSNMPTable(initiator, table);
        Broker.setInitiatorRange(initiator, range);
    }

    public static void getAllData() {
        int i;
        Vector initiators = new Vector(8, 8);
        Vector v = (Vector)RlSDatabase.gets.clone();
        for (i = 0; i < v.size(); ++i) {
            TagID tagID = (TagID)v.elementAt(i);
            Hashtable hash = (Hashtable)RlSDatabase.bindMap.get(tagID);
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                Object initiator = e.nextElement();
                if (initiator == "null" && hash.size() != 1 || initiators.contains(initiator)) continue;
                initiators.addElement(initiator);
            }
        }
        for (i = 0; i < initiators.size(); ++i) {
            Broker.getData(new EventObject(initiators.elementAt(i)));
        }
    }

    public static void getData(EventObject evt) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        packetBuilder.buildGet(initiator, evt);
    }

    public static void getData(String markup, String args) {
        Broker.getData(null, markup, args, null, null);
    }

    public static void getData(String markup, String args, long pollInterval) {
        Broker.getData(null, markup, args, null, new Long(pollInterval));
    }

    public static void getData(String markup, String args, Range range) {
        Broker.getData(null, markup, args, range, null);
    }

    public static void getData(String markup, String args, Range range, long pollInterval) {
        Broker.getData(null, markup, args, range, new Long(pollInterval));
    }

    public static void getData(EventObject evt, String markup, String args, Range range, Long pollInterval) {
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        TagID tag = null;
        if (markup != null) {
            tag = new TagID(markup, new TagContext(args, range), pollInterval);
        }
        try {
            packetBuilder.buildGet(initiator, tag, evt);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
    }

    public static synchronized void getBlockingData(EventObject evt, requestComplete caller) {
        System.out.println(evt);
        Object initiator = null;
        if (evt == null) {
            initiator = "null";
        } else {
            initiator = evt.getSource();
            System.out.println("Object:");
            System.out.println(initiator);
        }
        packetBuilder.buildGet(initiator, evt, caller);
    }

    public static void getBlockingData(EventObject evt, String markup, String args, Range range, Long pollInterval) {
        try {
            if (Broker.packetBuilder.isPaused) {
                packetBuilder.wait();
            } else {
                packetBuilder.setPause(true);
            }
        }
        catch (InterruptedException e) {
            exHandler.receiveThreadExceptions(0, e);
        }
        Object initiator = null;
        initiator = evt == null ? "null" : evt.getSource();
        TagID tag = null;
        if (markup != null) {
            tag = new TagID(markup, new TagContext(args, range), pollInterval);
        }
        try {
            packetBuilder.buildGet(initiator, tag, evt);
        }
        catch (RlError e) {
            exHandler.receiveBrokerExceptions(2, e);
        }
        packetBuilder.setPause(false);
    }

    protected void finalize() {
        RlUtil.trace(4, "   Broker.finalize");
        if (nInstantiated > 1) {
            nInstantiated = 1;
        }
        Broker.kill();
        RlUtil.trace(4, "   Broker.finalize - complete");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        isPaused = false;
        nInstantiated = 0;
        currentDisplay = null;
        exHandler = new ExceptionPropogator();
    }
}

