/*
 * Decompiled with CFR 0.152.
 */
package rl.clbroker;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import rl.clbroker.Converter;
import rl.clbroker.MultiBroker;
import rl.clbroker.RlBeanProperty;
import rl.clbroker.RlDatabase;
import rl.clbroker.TagID;

public class BeanGateway
extends Thread {
    protected boolean isPaused = false;
    protected boolean canRun = true;
    protected Vector queue = new Vector(8, 8);
    protected MultiBroker broker;
    protected RlDatabase rlDatabase;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public BeanGateway(MultiBroker broker, RlDatabase rlDatabase) {
        super("BeanGatewayThread");
        this.rlDatabase = rlDatabase;
        this.broker = broker;
    }

    protected synchronized void setPause(boolean isPaused) {
        if (isPaused == this.isPaused) {
            return;
        }
        this.isPaused = isPaused;
        if (!isPaused) {
            this.notify();
        }
    }

    protected synchronized void end() {
        this.canRun = false;
        this.interrupt();
    }

    protected synchronized void passGet(Hashtable data, Object initiator) {
        Converter convert = new Converter(initiator, data, this.rlDatabase, null);
        this.queue.addElement(convert);
        this.notify();
    }

    protected synchronized void passGetGroup(Hashtable data, Object initiator) {
        Converter convert = new Converter(initiator, data, this.rlDatabase, data.keys());
        this.queue.addElement(convert);
        this.notify();
    }

    private void convertToString(Object[] params, Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (types[i].equals(class$java$lang$String == null ? BeanGateway.class$("java.lang.String") : class$java$lang$String) && !(params[i] instanceof String)) {
                params[i] = params[i].toString();
            }
            if (!types[i].equals(array$Ljava$lang$String == null ? BeanGateway.class$("[Ljava.lang.String;") : array$Ljava$lang$String) || params[i] instanceof String[]) continue;
            for (int j = 0; j < ((Object[])params[i]).length; ++j) {
                ((Object[])params[i])[j] = ((Object[])params[i])[j].toString();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.canRun) {
            BeanGateway beanGateway;
            try {
                beanGateway = this;
                synchronized (beanGateway) {
                    if (this.isPaused || this.queue.isEmpty()) {
                        while (this.isPaused || this.queue.isEmpty()) {
                            this.wait();
                        }
                    }
                }
            }
            catch (SecurityException e) {
                MultiBroker.exHandler.receiveBrowserExceptions(3, e);
            }
            catch (InterruptedException e) {
                MultiBroker.exHandler.receiveThreadExceptions(0, e);
            }
            Vector vector = this.queue;
            synchronized (vector) {
                Vector tempQueue = (Vector)this.queue.clone();
                this.queue.removeAllElements();
            }
            while (!((Vector)((Object)beanGateway)).isEmpty()) {
                Converter data = (Converter)((Vector)((Object)beanGateway)).firstElement();
                ((Vector)((Object)beanGateway)).removeElementAt(0);
                try {
                    Hashtable hash = data.convertToJava();
                    Enumeration e = hash.keys();
                    while (e.hasMoreElements()) {
                        TagID tagID = (TagID)e.nextElement();
                        Object[][] params = (Object[][])hash.get(tagID);
                        Hashtable initPropMap = (Hashtable)this.rlDatabase.bindMap.get(tagID);
                        if (initPropMap == null) {
                            MultiBroker.exHandler.receiveUserClassesExceptions(1, new IllegalArgumentException(tagID + " not found in database"));
                            continue;
                        }
                        Vector beanProps = (Vector)initPropMap.get(data.initiator);
                        try {
                            for (int i = 0; i < beanProps.size(); ++i) {
                                RlBeanProperty beanProp = (RlBeanProperty)beanProps.elementAt(i);
                                for (int j = 0; j < params.length; ++j) {
                                    if (beanProp.setMethod == null) continue;
                                    this.convertToString(params[j], beanProp.setMethod);
                                    beanProp.setMethod.invoke(beanProp.bean, params[j]);
                                }
                            }
                        }
                        catch (Exception ex) {
                            MultiBroker.exHandler.receiveUserClassesExceptions(1, ex);
                        }
                    }
                }
                catch (Exception exp) {
                    MultiBroker.exHandler.receiveUserClassesExceptions(2, exp);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

