/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920.utils;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;

public class DspUtil {
    public static final String CLASSNAME = "DspUtil";
    public static final int ONE_SECOND = 1000;
    public static final int THIRTY_SECONDS = 30000;
    public static final int ONE_MINUTE = 60000;
    public static final int DSP_RETURNCODE_BASE = 20000;
    public static final int CIM_RETURNCODE_BASE = 32768;
    public static final String ON_STRING = "on";
    public static final String OFF_STRING = "off";
    private static final int BITMAP_CHUNK_SIZE = 65536;
    private static final int BITMAP_BYTES_PER_PAGE = 4096;
    private static final int BITMAP_BLOCKS_PER_STRIPE = 18;
    private static final int BITMAP_HEADER_BLOCKS = 1;
    private static final int BITMAP_BLOCK_SIZE = 512;
    private static final int BITMAP_1M_SIZE = 0x100000;
    private static final int BITMAP_2M_SIZE = 0x200000;
    private static final int BITMAP_8M_SIZE = 0x800000;
    static final BigInteger bitmapChunkSize = new BigInteger("65536");
    static final BigInteger bitmapBytesPerPage = new BigInteger("4096");
    static final BigInteger bitmapBlocksPerStripe = new BigInteger("18");
    static final BigInteger bitmapHeaderBlocks = new BigInteger("1");
    static final BigInteger bitmapBlockSize = new BigInteger("512");
    static final BigInteger minBitmapSize = new BigInteger("2097152");
    private static final int BITMAP_BITS_PER_VOLUME_CHUNK = 17;
    private static final int BITS_PER_BYTE = 8;
    private static final int ONE_DISK_BLOCK_IN_BYTES = 512;
    private static final String sccs_id = "@(#)DspUtil.java   1.18   05/06/08   SMI";
    static /* synthetic */ Class class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil;

    public static String unquote(String input) {
        if (input.startsWith("\"") && input.endsWith("\"")) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    public static String unquoteEscaped(String input) {
        if (input.startsWith("\\\"") && input.endsWith("\\\"")) {
            return input.substring(2, input.length() - 2);
        }
        return input;
    }

    public static String mapBooleanToOnOff(Boolean input) {
        return DspUtil.mapBooleanToOnOff((boolean)input);
    }

    public static String mapBooleanToOnOff(boolean input) {
        if (input) {
            return new String(ON_STRING);
        }
        return new String(OFF_STRING);
    }

    public static CIMObjectPath stringToCOP(CIMOMHandle cHandle, String passedInNamespace, String op) {
        String METHOD = "stringToCOP";
        String namespace = "";
        String classname = "";
        String values = "";
        int cnIndex = -1;
        int nsIndex = -1;
        Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"stringToCOP", (String)("DspUtil.stringToCop  passedInNamespace = <" + passedInNamespace + ">"));
        Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"stringToCOP", (String)("DspUtil.stringToCop  input = <" + op + ">"));
        if (op.startsWith("//")) {
            int start = op.indexOf("/", 2);
            op = op.substring(start);
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"stringToCOP", (String)("Trimming hostname, new string: " + op));
        }
        if ((cnIndex = op.indexOf(46)) != -1 && op.charAt(cnIndex - 1) == '/') {
            cnIndex = op.indexOf(46, cnIndex + 1);
        }
        if ((nsIndex = cnIndex == -1 ? op.lastIndexOf(58, op.length()) : op.lastIndexOf(58, cnIndex)) != -1) {
            namespace = op.substring(0, nsIndex);
            if (namespace.equals(":")) {
                namespace = "";
            }
            if (namespace.startsWith("//")) {
                int idx = namespace.indexOf(47, 2);
                namespace = idx == -1 ? "" : namespace.substring(idx + 1);
            }
            ++nsIndex;
        } else {
            nsIndex = 0;
        }
        if (passedInNamespace != null) {
            namespace = passedInNamespace;
        }
        Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"stringToCOP", (String)("NAMESPACE: " + namespace));
        if (cnIndex != -1) {
            classname = op.substring(nsIndex, cnIndex);
            values = op.substring(cnIndex + 1, op.length());
        } else {
            classname = op.substring(nsIndex, op.length());
        }
        Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"stringToCOP", (String)("CLASSNAME: " + classname));
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        if (values.length() != 0) {
            String[] propertyList = DspUtil.parsePropertyList(values);
            for (int i = 0; i < propertyList.length; ++i) {
                int eqIndex = propertyList[i].indexOf(61);
                if (eqIndex == -1) {
                    throw new IllegalArgumentException("Invalid property initialization " + propertyList[i] + " there is no '='.");
                }
                CIMProperty cp = new CIMProperty();
                cp.setName(propertyList[i].substring(0, eqIndex));
                String value = propertyList[i].substring(eqIndex + 1);
                value = DspUtil.unquote(value);
                cp.setValue(new CIMValue((Object)value));
                keys.addElement(cp);
            }
        }
        CIMObjectPath thePath = new CIMObjectPath(classname);
        if (namespace != null) {
            thePath.setNameSpace(namespace);
        }
        CIMClass theClass = null;
        try {
            theClass = cHandle.getClass(thePath, false, true, true, null);
        }
        catch (CIMException ce) {
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"stringToCOP", (String)"DspUtil.stringToCop  Error retrieving the class");
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"DspUtil.stringToCop stack trace:", (Throwable)ce);
        }
        CIMInstance theInstance = theClass.newInstance();
        for (int j = 0; j < keys.size(); ++j) {
            CIMProperty curKey = (CIMProperty)keys.get(j);
            String val = (String)curKey.getValue().getValue();
            String key = curKey.getName();
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil") : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"stringToCOP", (String)("DspUtil.stringToCop  key = " + key));
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil") : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"stringToCOP", (String)("DspUtil.stringToCop  val = " + val));
            CIMProperty nextProperty = theInstance.getProperty(key);
            try {
                switch (nextProperty.getType().getType()) {
                    case 9: {
                        Object realVal = Boolean.valueOf(val);
                        CIMValue newVal = new CIMValue(realVal, new CIMDataType(9));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 29: {
                        Object realVal = val;
                        CIMValue newVal = new CIMValue(realVal, new CIMDataType(29));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 10: {
                        Object realVal = new Float(val);
                        CIMValue newVal = new CIMValue(realVal, new CIMDataType(10));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 11: {
                        Object realVal = new Double(val);
                        CIMValue newVal = new CIMValue(realVal, new CIMDataType(11));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 28: {
                        Object realVal = DspUtil.stringToCOP(cHandle, namespace, val);
                        CIMValue newVal = new CIMValue(realVal, new CIMDataType(28));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 1: {
                        Object realVal = new Byte(val);
                        CIMValue newVal = new CIMValue(realVal, new CIMDataType(1));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 3: {
                        Object realVal = new Short(val);
                        CIMValue newVal = new CIMValue(realVal, new CIMDataType(3));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 5: {
                        Object realVal = new Integer(val);
                        CIMValue newVal = new CIMValue(realVal, new CIMDataType(5));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 7: {
                        Object realVal = new Long(val);
                        CIMValue newVal = new CIMValue(realVal, new CIMDataType(7));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 8: {
                        CIMValue newVal = new CIMValue((Object)val, new CIMDataType(8));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                    case 30: {
                        CIMValue newVal = new CIMValue(null, new CIMDataType(30));
                        nextProperty.setValue(newVal);
                        theInstance.updatePropertyValue(nextProperty);
                        break;
                    }
                }
                continue;
            }
            catch (CIMException ce) {
                Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil") : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"stringToCOP", (String)"Set property operation failed.");
                Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil") : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"DspUtil.stringToCop stack trace:", (Throwable)ce);
            }
        }
        return theInstance.getObjectPath();
    }

    public static int mapDSPReturnCode(int dspReturnCode) {
        int returnCode = dspReturnCode + 20000;
        returnCode = -returnCode;
        return returnCode += 32768;
    }

    public static String convertDspInternalWwnToStandardWwn(String dspWwn) {
        String METHOD = "convertDspInternalWwnToStandardWwn";
        String partOne = null;
        String partTwo = null;
        String partThree = null;
        String partFour = null;
        String badResultString = new String("N/A");
        String tmpWwn = dspWwn.toUpperCase();
        try {
            StringTokenizer st = new StringTokenizer(tmpWwn, "-");
            if (st.hasMoreTokens()) {
                partOne = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                partTwo = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                partThree = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                partFour = st.nextToken();
            }
        }
        catch (NoSuchElementException nse) {
            Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"convertDspInternalWwnToStandardWwn", (String)(" Improperly formatted internal DSP WWN: " + dspWwn));
            return badResultString;
        }
        if (partOne == null || partTwo == null || partThree == null || partFour == null) {
            return badResultString;
        }
        return DspUtil.addColonsToWWN(partOne + partTwo + partThree + partFour);
    }

    public static String convertStandardWwnToDspInternalWwn(String standardWwn) {
        String METHOD = "convertStandardWwnToDspInternalWwn";
        Trace.methodBegin((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"convertStandardWwnToDspInternalWwn");
        String[] wwnPieces = standardWwn.split(":");
        String partOne = new String();
        String partTwo = new String();
        String partThree = new String();
        String partFour = new String();
        String badResultString = new String("N/A");
        try {
            int i;
            for (i = 0; i < 4; ++i) {
                partOne = partOne + wwnPieces[i];
            }
            for (i = 4; i < 8; ++i) {
                partTwo = partTwo + wwnPieces[i];
            }
            for (i = 8; i < 12; ++i) {
                partThree = partThree + wwnPieces[i];
            }
            for (i = 12; i < 16; ++i) {
                partFour = partFour + wwnPieces[i];
            }
            return partOne + "-" + partTwo + "-" + partThree + "-" + partFour;
        }
        catch (Exception e) {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"convertStandardWwnToDspInternalWwn", (String)"Issues converting standard wwn to DSP-internal wwn.");
            return badResultString;
        }
    }

    public static String addColonsToWWN(String input) {
        int COLON = 58;
        StringBuffer outputBuffer = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            if (i == 0 || i % 2 != 0) {
                outputBuffer.append(input.charAt(i));
                continue;
            }
            outputBuffer.append(':');
            outputBuffer.append(input.charAt(i));
        }
        return outputBuffer.toString();
    }

    public static String timeStamp() {
        GregorianCalendar cal = new GregorianCalendar();
        String ts = String.valueOf(cal.get(1)) + String.valueOf(cal.get(2)) + String.valueOf(cal.get(5)) + "-" + String.valueOf(cal.get(11)) + String.valueOf(cal.get(12)) + String.valueOf(cal.get(13)) + String.valueOf(cal.get(14));
        return ts;
    }

    public static CIMInstance decorateInstance(CIMInstance origInst) {
        CIMInstance newInst = null;
        CIMClass newClass = null;
        try {
            CIMObjectPath tmp = new CIMObjectPath(origInst.getClassName());
            tmp.setNameSpace("\\root\\se6x20\\");
            newClass = SunStorEdge_DSPProvider.getCIMOMHandle().getClass(tmp, false, true, true, null);
        }
        catch (Exception e) {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"DspUtil.decorate instances:  Exception retrieving the class", (Throwable)e);
        }
        if (newClass == null) {
            newInst = origInst;
        } else {
            newInst = newClass.newInstance();
            try {
                newInst.updatePropertyValues(origInst.getProperties());
            }
            catch (Exception e) {
                newInst = origInst;
            }
        }
        return newInst;
    }

    public static BigInteger computeBitmapSize(BigInteger volSize) {
        BigInteger[] numPages;
        String METHOD = "computeBitmapSize";
        Trace.methodBegin((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"computeBitmapSize");
        BigInteger bitmapSize = minBitmapSize;
        BigInteger[] volChunks = volSize.divideAndRemainder(bitmapChunkSize);
        if (1 == volChunks[1].compareTo(BigInteger.ZERO)) {
            volChunks[0] = volChunks[0].add(BigInteger.ONE);
        }
        if (1 == (numPages = volChunks[0].divideAndRemainder(bitmapBytesPerPage))[1].compareTo(BigInteger.ZERO)) {
            numPages[0] = numPages[0].add(BigInteger.ONE);
        }
        bitmapSize = numPages[0].multiply(bitmapBlocksPerStripe);
        bitmapSize = bitmapSize.add(bitmapHeaderBlocks);
        if (-1 == (bitmapSize = bitmapSize.multiply(bitmapBlockSize)).compareTo(minBitmapSize)) {
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"computeBitmapSize", (String)(" Computed bitmap size of " + bitmapSize + " bytes for a volume size of " + volSize + " bytes was rounded up to " + minBitmapSize + " bytes"));
            bitmapSize = minBitmapSize;
        } else {
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil = DspUtil.class$("com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil")) : class$com$sun$netstorage$dsp$mgmt$se6920$utils$DspUtil), (String)"computeBitmapSize", (String)(" Computed bitmap size of " + bitmapSize + " bytes for a volume size of " + volSize + " bytes"));
        }
        return bitmapSize;
    }

    private static String[] parsePropertyList(String properties) {
        ArrayList<String> propertyList = new ArrayList<String>();
        boolean inQuotes = false;
        int lastComma = 0;
        int length = properties.length();
        for (int i = 0; i < length; ++i) {
            char c = properties.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inQuotes || c != ',') continue;
            propertyList.add(properties.substring(lastComma, i));
            lastComma = i + 1;
        }
        if (inQuotes) {
            throw new IllegalArgumentException("String literal is not properly closed by a double quote:" + properties);
        }
        if (lastComma >= length) {
            throw new IllegalArgumentException("Found a comma, but there was now subsequent property and value: " + properties);
        }
        propertyList.add(properties.substring(lastComma));
        return propertyList.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

