/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920.licensing;

import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.RouteAgent;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.LicenseHelper;
import java.math.BigInteger;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;

public class ReplicationAsyncHelper
extends LicenseHelper {
    ReplicationAsyncHelper() {
        super("ReplicationAsync", 5);
    }

    BigInteger getAmountInUse() {
        String METHOD = "getAmountInUse";
        CIMInstance[] ans = null;
        try {
            ans = RouteAgent.getInstance().enumerateInstances(new CIMObjectPath("SunStorEdge_DSPReplicationSet"), false, false, false, ConstantsEnt.StorageVolumeProperties.PROPERTY_NAMES, null);
            if (ans == null) {
                return BigInteger.ZERO;
            }
            BigInteger total = new BigInteger("0");
            for (int i = 0; i < ans.length; ++i) {
                CIMInstance[] bans = null;
                CIMObjectPath assocPath = new CIMObjectPath("SunStorEdge_DSPRemoteStorageSynchronized");
                bans = RouteAgent.getInstance().references(assocPath, ans[i].getObjectPath(), "SyncedElement", false, false, null);
                if (bans == null || bans.length == 0) continue;
                if (bans.length != 1) {
                    throw new RuntimeException("More than one local volume replicated to single remote volume?");
                }
                CIMValue copyType = bans[0].getProperty("CopyType").getValue();
                if (((UnsignedInt16)copyType.getValue()).intValue() != 2) continue;
                CIMObjectPath volPath = (CIMObjectPath)bans[0].getProperty("SystemElement").getValue().getValue();
                CIMInstance vol = RequestBroker.getInstance().getInstance(volPath, false, false, true, null);
                CIMValue consumable = vol.getProperty("ConsumableBlocks").getValue();
                CIMValue blksize = vol.getProperty("BlockSize").getValue();
                UnsignedInt64 u1 = (UnsignedInt64)consumable.getValue();
                UnsignedInt64 u2 = (UnsignedInt64)blksize.getValue();
                BigInteger b1 = u1.bigIntValue();
                BigInteger b2 = u2.bigIntValue();
                total = total.add(b1.multiply(b2));
            }
            return total;
        }
        catch (CIMException e) {
            Trace.error((Object)this, (String)"getAmountInUse", (Throwable)e);
            return BigInteger.ZERO;
        }
    }
}

