/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920.licensing;

import com.sun.netstorage.dsp.mgmt.se6920.licensing.DataPoolManagementHelper;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.HeteroPoolManagementHelper;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.LicenseHelper;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.LocalMirroringHelper;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.ReplicationAsyncHelper;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.ReplicationSyncHelper;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.SnapshotHelper;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.VirtualizedLegacyVolume;
import java.math.BigInteger;
import java.util.HashMap;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;

public class LicenseDispatcher {
    static HashMap helperMap = new HashMap();

    public static boolean isLicenseClass(CIMObjectPath x) {
        if (x == null) {
            return false;
        }
        return helperMap.get(x.getObjectName()) != null;
    }

    public static CIMInstance[] enumerateInstances(CIMObjectPath op, CIMClass cc) throws CIMException {
        CIMInstance[] r = new CIMInstance[]{LicenseDispatcher.create(op, cc)};
        if (r[0] == null) {
            return null;
        }
        return r;
    }

    private static CIMInstance create(CIMObjectPath op, CIMClass cc) throws CIMException {
        CIMInstance ci = cc.newInstance();
        LicenseHelper lh = (LicenseHelper)helperMap.get(op.getObjectName());
        if (lh == null) {
            return null;
        }
        ci.setProperty("IdentifyingNumber", new CIMValue((Object)("" + lh.getId())));
        ci.setProperty("ProductName", new CIMValue((Object)"System1"));
        ci.setProperty("Vendor", new CIMValue((Object)"Sun Microsystems"));
        ci.setProperty("Version", new CIMValue((Object)"A"));
        ci.setProperty("Name", new CIMValue((Object)lh.getShortName()));
        BigInteger aiuComputed = lh.getAmountInUse();
        ci.setProperty("AmountInUse", new CIMValue((Object)new UnsignedInt64(aiuComputed)));
        ci.setProperty("AmountLicensed", new CIMValue((Object)new UnsignedInt64(lh.getAmountLicensed())));
        if (aiuComputed.compareTo(lh.getAmountLicensed()) == 1) {
            ci.setProperty("InCompliance", CIMValue.FALSE);
        } else {
            ci.setProperty("InCompliance", CIMValue.TRUE);
        }
        return ci;
    }

    public static CIMInstance getInstance(CIMObjectPath op, CIMClass cc) throws CIMException {
        return LicenseDispatcher.create(op, cc);
    }

    public static void setInstance(CIMObjectPath op, CIMInstance ci) {
        if (!LicenseDispatcher.isLicenseClass(op)) {
            return;
        }
        LicenseHelper lh = (LicenseHelper)helperMap.get(op.getObjectName());
        lh.amountLicensed = LicenseDispatcher.extractLong(ci, "AmountLicensed");
    }

    private static BigInteger extractLong(CIMInstance ci, String string) {
        UnsignedInt64 u64 = (UnsignedInt64)ci.getProperty(string).getValue().getValue();
        return u64.bigIntValue();
    }

    static {
        LicenseHelper[] aiu = new LicenseHelper[]{new SnapshotHelper(), new DataPoolManagementHelper(), new LocalMirroringHelper(), new ReplicationSyncHelper(), new ReplicationAsyncHelper(), new VirtualizedLegacyVolume(), new HeteroPoolManagementHelper()};
        for (int i = 0; i < aiu.length; ++i) {
            helperMap.put(aiu[i].getCimClassName(), aiu[i]);
        }
    }
}

