/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920.licensing;

import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.RouteAgent;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.LicenseHelper;
import java.math.BigInteger;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;

public class HeteroPoolManagementHelper
extends LicenseHelper {
    HeteroPoolManagementHelper() {
        super("HeterogeneousPoolManagement", 2);
    }

    BigInteger getAmountInUse() {
        String METHOD = "getAmountInUse";
        CIMInstance[] ans = null;
        try {
            ans = RouteAgent.getInstance().enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStorageExtent"), false, false, false, ConstantsEnt.StorageExtentProperties.PROP_LIST, null);
        }
        catch (CIMException e) {
            Trace.error((Object)this, (String)"getAmountInUse", (Throwable)e);
            return BigInteger.ZERO;
        }
        if (ans == null) {
            return BigInteger.ZERO;
        }
        BigInteger total = new BigInteger("0");
        for (int i = 0; i < ans.length; ++i) {
            Trace.verbose((Object)this, (String)"getAmountInUse", (String)("Disk: " + i));
            CIMObjectPath extentPath = ans[i].getObjectPath();
            extentPath.setNameSpace("\\root\\se6x20\\");
            CIMObjectPath externalExtentPath = new CIMObjectPath("SunStorEdge_DSPExternalExtent");
            externalExtentPath.setNameSpace("\\root\\se6x20\\");
            CIMInstance[] collection = null;
            try {
                collection = RequestBroker.getInstance().associators(externalExtentPath, extentPath, "SunStorEdge_DSPExternalCollection", "Member", "Collection", false, false, null);
            }
            catch (CIMException ce) {
                Trace.error((Object)this, (String)"getAmountInUse", (String)"Errors retrieving associated External Collection.");
                return BigInteger.ZERO;
            }
            if (collection == null || collection.length == 0) continue;
            Trace.verbose((Object)this, (String)"getAmountInUse", (String)"Is external disk.");
            CIMObjectPath concCompPath = new CIMObjectPath("SunStorEdge_DSPConcreteComponent");
            concCompPath.setNameSpace("\\root\\se6x20\\");
            CIMInstance[] pools = null;
            try {
                pools = RequestBroker.getInstance().associators(concCompPath, extentPath, "SunStorEdge_DSPStoragePool", "PartComponent", "GroupComponent", false, false, null);
            }
            catch (CIMException ce) {
                Trace.error((Object)this, (String)"getAmountInUse", (String)"Errors retrieving associated StoragePools.");
                return BigInteger.ZERO;
            }
            if (pools == null || pools.length == 0) continue;
            Trace.verbose((Object)this, (String)"getAmountInUse", (String)"Belongs to StoragePool.");
            CIMInstance extent = RequestBroker.getInstance().findInstance(extentPath);
            String mfcName = (String)extent.getProperty("Manufacturer").getValue().getValue();
            Trace.verbose((Object)this, (String)"getAmountInUse", (String)("MFC: " + mfcName));
            if (mfcName.equalsIgnoreCase("SUN")) continue;
            Trace.verbose((Object)this, (String)"getAmountInUse", (String)"Not SUN Storage");
            CIMValue totalBlocks = ans[i].getProperty("NumberOfBlocks").getValue();
            CIMValue blksize = ans[i].getProperty("BlockSize").getValue();
            UnsignedInt64 u1 = (UnsignedInt64)totalBlocks.getValue();
            UnsignedInt64 u2 = (UnsignedInt64)blksize.getValue();
            BigInteger b1 = u1.bigIntValue();
            BigInteger b2 = u2.bigIntValue();
            total = total.add(b1.multiply(b2));
        }
        return total;
    }
}

