/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920.licensing;

import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.RouteAgent;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.LicenseHelper;
import java.math.BigInteger;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;

public class DataPoolManagementHelper
extends LicenseHelper {
    DataPoolManagementHelper() {
        super("DataPoolManagement", 2);
    }

    BigInteger getAmountInUse() {
        String METHOD = "getAmountInUse";
        Trace.methodBegin((Object)this, (String)"getAmountInUse");
        CIMInstance[] ans = null;
        try {
            ans = RouteAgent.getInstance().enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStorageExtent"), false, false, false, ConstantsEnt.StorageExtentProperties.PROP_LIST, null);
        }
        catch (CIMException e) {
            Trace.error((Object)this, (String)"getAmountInUse", (Throwable)e);
            return BigInteger.ZERO;
        }
        if (ans == null) {
            Trace.verbose((Object)this, (String)"getAmountInUse", (String)"No storage extents found.");
            return BigInteger.ZERO;
        }
        BigInteger total = new BigInteger("0");
        for (int i = 0; i < ans.length; ++i) {
            CIMObjectPath concreteCompPath = new CIMObjectPath("SunStorEdge_DSPConcreteComponent");
            concreteCompPath.setNameSpace("\\root\\se6x20\\");
            CIMObjectPath extentPath = ans[i].getObjectPath();
            extentPath.setNameSpace("\\root\\se6x20\\");
            CIMObjectPath[] poolAssocs = null;
            try {
                poolAssocs = RequestBroker.getInstance().referenceNames(concreteCompPath, extentPath, "PartComponent");
            }
            catch (CIMException ce) {
                Trace.error((Object)this, (String)"getAmountInUse", (String)"Errors retrieving associated StoragePools.");
                return BigInteger.ZERO;
            }
            if (poolAssocs == null || poolAssocs.length == 0) continue;
            CIMValue totalBlocks = ans[i].getProperty("NumberOfBlocks").getValue();
            CIMValue blksize = ans[i].getProperty("BlockSize").getValue();
            UnsignedInt64 u1 = (UnsignedInt64)totalBlocks.getValue();
            UnsignedInt64 u2 = (UnsignedInt64)blksize.getValue();
            BigInteger b1 = u1.bigIntValue();
            BigInteger b2 = u2.bigIntValue();
            total = total.add(b1.multiply(b2));
        }
        return total;
    }
}

