/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.se6120.internal.ProviderToBOLConnection;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayInventory;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.InstanceFormer;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyBroker;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageConfigurationService;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageExtent;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageVolume;
import com.sun.netstorage.dsp.mgmt.se6920.ObjectPath;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;

public class SunStorEdge_DSPPersistenceManager {
    private static String CLASSNAME = "SunStorEdge_DSPPersistenceManager";
    private static SunStorEdge_DSPPersistenceManager singleton;
    private static final String DEFAULT_DEBUG_FILE_PATH = "/opt/se6x20/resources/PersistenceDebug.err";
    private static final String DEFAULT_PERSISTENCE_FILE_PATH = "/opt/se6x20/resources/DspPersistence.xml";
    private static final String TEMP_PERSISTENCE_FILE_PATH = "/opt/se6x20/resources/DspPersistenceTemp.xml";
    private static final String DEFAULT_FACTORY_PERSISTENCE_FILE_PATH = "/opt/se6x20/resources/DspFactorySettings.xml";
    private static final String DEFAULT_RELEASE_FILE_PATH = "/etc/release";
    private static final String XML_FILE_NAME = "/opt/se6x20/resources/DspPersistence.xml";
    private static final String XML_TMP_SUFFIX = ".tmp";
    private static final String XML_BAD_SUFFIX = ".err";
    private static final String XML_BACKUP_SUFFIX = ".bkup";
    private static final String RENAME_UNIX_COMMAND = "mv -f ";
    private static final int RENAME_SUCCESS = 0;
    private static final int RENAME_FILE_NOT_FOUND = 1;
    private static final int RENAME_FAILED = 2;
    private static final String PERSISTENCE_FILE_PATH_KEY = "persistence-file-path";
    private static final String BACKUP_SUFFIX = ".bkup";
    private static String persistenceFilePath;
    private static String factoryPersistenceFilePath;
    private static String persistenceFileBackupPath;
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String XML_ROOT_B = "<sscs_dsp_persistence xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
    private static final String XML_ROOT_E = "</sscs_dsp_persistence>";
    private static final String XML_PREV_B = "<PREVIOUS_PERSISTED>";
    private static final String XML_PREV_E = "</PREVIOUS_PERSISTED>";
    private static final String XML_MGMT_PERSIST_INFO_B = "<MANAGEMENT_PERSISTED_INFO>";
    private static final String XML_MGMT_PERSIST_INFO_E = "</MANAGEMENT_PERSISTED_INFO>";
    private static final int CUSTOM_PERSISTENCE_NAME_MAX = 1000;
    private static String POOL_CLASS;
    private static String PROFILE_CLASS;
    private static String ALLOCATED_POOL_CLASS;
    private static String HOSTEDPOOL_CLASS;
    private static String ELEMENT_SETTING_CLASS;
    private static String STORAGE_CAPABILITIES_CLASS;
    private static String ELEMENT_CAPABILITIES_CLASS;
    private static String MGMT_PERSISTENCE_INFO_CLASS;
    private static String STORAGE_EXTENT_CLASS;
    private static String STORAGE_SYSTEM_CLASS;
    private static String STORAGE_POOL_CLASS;
    private static String EXTERNAL_COLLECTION_CLASS;
    private static String EXTERNAL_EXTENT_CLASS;
    private static String SYSTEM_SETTING_6120_CLASS;
    private static String SYNTHSETTING_CLASS;
    private static String SYNTH_ELEMENT_SETTING_CLASS;
    private static String ARRAY_CTL_SET_CLASS;
    private static String EXTENT_ARRAY_SETTING_CLASS;
    private static String STORAGE_DOMAIN_CLASS;
    private static String SOFTWARE_IDENTITY_CLASS;
    private static String INSTALLED_SW_IDENTITY_CLASS;
    private static final String DEVICE_ID = "DeviceID";
    private static final String EXTENT_STATUS = "ExtentStatus";
    private static final String INSTANCE_ID = "InstanceID";
    private static final String DEFAULT_POOL_ID = "DEFAULT";
    private static final String DEFAULT_PROFILE_ID = "FACTORY_DEFAULT";
    private static String ALLOC_POOL_VOLUME;
    private static String ALLOC_POOL_POOL;
    private static String ELEMENT_SETTING_SETTING;
    private static String ELEMENT_ELEMENT;
    private static String ELEMENT_CAPABILITIES_SETTING;
    private static String ELEMENT_CAPABILITIES_ELEMENT;
    private static String EXTERNAL_EXTENT_COLLECTION;
    private static String EXTERNAL_EXTENT_MEMBER;
    private static String NO_SINGLE_POINT_OF_FAILURE;
    private static String DATA_REDUNDANCY;
    private static String DATA_REDUNDANCY_DEFAULT;
    private static String SEGMENT_SIZE;
    private static String HOSTED_POOL_GROUP;
    private static String HOSTED_POOL_PART;
    private static final String SW_ID_SYSTEM = "System";
    private static final String SW_ID_SW = "InstalledSoftware";
    private static final String SW_ID_MAJOR = "MajorVersion";
    private static final String SW_ID_MINOR = "MinorVersion";
    private static final String SW_ID_REV = "RevisionNumber";
    private static final String SW_ID_BLD = "BuildNumber";
    private static final String SW_ID_VERSION = "VersionString";
    private static ConfigContext context;
    List persistedInstances = Collections.synchronizedList(new ArrayList());
    List persistedFactoryInstances = Collections.synchronizedList(new ArrayList());
    private static boolean firstBoot;
    private static int runCount;
    private static Thread processVDiskThread;
    static /* synthetic */ Class class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager;

    public static Thread getProcessVDiskThread() {
        return processVDiskThread;
    }

    public static synchronized SunStorEdge_DSPPersistenceManager getInstance() {
        if (singleton == null) {
            singleton = new SunStorEdge_DSPPersistenceManager();
        }
        return singleton;
    }

    private SunStorEdge_DSPPersistenceManager() {
        if (persistenceFilePath == null) {
            persistenceFilePath = "/opt/se6x20/resources/DspPersistence.xml";
        }
        persistenceFileBackupPath = persistenceFilePath + ".bkup";
    }

    public synchronized void recoverLastPersistenceBackup() {
        String METHOD = "recoverLastPersistenceBackup";
        Trace.methodBegin((Object)this, (String)"recoverLastPersistenceBackup");
        String cmd = null;
        String firstBackupPath = new String(persistenceFileBackupPath + "0");
        File fback = new File(firstBackupPath);
        try {
            if (fback.exists()) {
                Trace.info((Object)this, (String)"recoverLastPersistenceBackup", (String)(": " + firstBackupPath + " exists... "));
                Trace.info((Object)this, (String)"recoverLastPersistenceBackup", (String)(": Recovering " + persistenceFilePath + " from " + firstBackupPath));
                cmd = "cp -f " + firstBackupPath + " " + persistenceFilePath;
                Runtime.getRuntime().exec(cmd);
            } else {
                File fdebug = new File(persistenceFilePath);
                if (fdebug.exists()) {
                    Trace.info((Object)this, (String)"recoverLastPersistenceBackup", (String)(": " + persistenceFilePath + " exists... "));
                    Trace.info((Object)this, (String)"recoverLastPersistenceBackup", (String)(": Creating persistence debug file" + persistenceFilePath + ".debug "));
                    cmd = RENAME_UNIX_COMMAND + persistenceFilePath + " " + persistenceFilePath + ".debug";
                    Runtime.getRuntime().exec(cmd);
                }
                Trace.info((Object)this, (String)"recoverLastPersistenceBackup", (String)(": Removing user persistence file" + persistenceFilePath));
                cmd = "rm -f " + persistenceFilePath;
                Runtime.getRuntime().exec(cmd);
            }
        }
        catch (IOException ioe) {
            Trace.info((Object)this, (String)": Failed to recover last persisted backup... ", (Throwable)ioe);
        }
    }

    public synchronized void storeAllPersistedInstancesToXml() {
        String METHOD = "storeAllPersistedInstancesToXml";
        Trace.methodBegin((Object)this, (String)"storeAllPersistedInstancesToXml");
        String tmpFilename = "/opt/se6x20/resources/DspPersistence.xml.tmp";
        FileOutputStream stream = null;
        Trace.info((Object)this, (String)"storeAllPersistedInstancesToXml", (String)(" Creating temp XML file " + tmpFilename));
        try {
            stream = new FileOutputStream(tmpFilename);
            Trace.info((Object)this, (String)"storeAllPersistedInstancesToXml", (String)(" " + tmpFilename + " opened for writing"));
        }
        catch (Exception openException) {
            Trace.error((Object)this, (String)(" Failed to open " + tmpFilename + " persistence file"), (Throwable)openException);
            this.cleanupFileError(tmpFilename, stream);
            Trace.info((Object)this, (String)"storeAllPersistedInstancesToXml", (String)" Aborting config save");
            return;
        }
        if (!this.writeXmlConfig(stream, null)) {
            Trace.error((Object)this, (String)"storeAllPersistedInstancesToXml", (String)(" Unable to write config to " + tmpFilename));
            this.cleanupFileError(tmpFilename, stream);
            Trace.info((Object)this, (String)"storeAllPersistedInstancesToXml", (String)" Aborting config save");
            return;
        }
        try {
            stream.close();
        }
        catch (IOException ioe) {
            Trace.error((Object)this, (String)"storeAllPersistedInstancesToXml", (String)(" Unable to close " + tmpFilename));
            this.cleanupFileError(tmpFilename, null);
            Trace.info((Object)this, (String)"storeAllPersistedInstancesToXml", (String)" Aborting config save");
            return;
        }
        try {
            int result = 0;
            String baseFilename = new String("/opt/se6x20/resources/DspPersistence.xml.bkup");
            for (int i = 8; i >= 0; --i) {
                String newname;
                String oldname = new String(baseFilename + i);
                result = this.renameFile(oldname, newname = new String(baseFilename + (i + 1)));
                if (result == 0 || result == 1) continue;
                try {
                    String[] logArgs = new String[]{oldname, newname};
                    LogAPI.staticLog((String)"PERSISTENCE_RENAME_ERROR", (String[])logArgs, null);
                    continue;
                }
                catch (Exception logEx) {
                    // empty catch block
                }
            }
            result = this.renameFile("/opt/se6x20/resources/DspPersistence.xml", baseFilename + "0");
            if (result != 0 && result != 1) {
                try {
                    String[] logArgs = new String[]{"/opt/se6x20/resources/DspPersistence.xml", baseFilename + "0"};
                    LogAPI.staticLog((String)"PERSISTENCE_RENAME_ERROR", (String[])logArgs, null);
                }
                catch (Exception logEx) {
                    // empty catch block
                }
            }
            if ((result = this.renameFile("/opt/se6x20/resources/DspPersistence.xml.tmp", "/opt/se6x20/resources/DspPersistence.xml")) != 0 && result != 1) {
                try {
                    String[] logArgs = new String[]{"/opt/se6x20/resources/DspPersistence.xml.tmp", "/opt/se6x20/resources/DspPersistence.xml"};
                    LogAPI.staticLog((String)"PERSISTENCE_RENAME_ERROR", (String[])logArgs, null);
                }
                catch (Exception logEx) {}
            }
        }
        catch (Exception renameException) {
            Trace.error((Object)this, (String)" Unable to rename persistence file(s) ", (Throwable)renameException);
            try {
                String[] logArgs = new String[1];
                LogAPI.staticLog((String)"PERSISTENCE_IO_ERROR", (String[])logArgs, null);
            }
            catch (Exception logEx) {
                // empty catch block
            }
        }
        Trace.methodEnd((Object)this, (String)"storeAllPersistedInstancesToXml");
    }

    private int renameFile(String oldName, String newName) {
        String METHOD = "renameFile";
        Trace.methodBegin((Object)this, (String)"renameFile");
        File theFile = new File(oldName);
        Process proc = null;
        Runtime runtime = Runtime.getRuntime();
        Trace.info((Object)this, (String)"renameFile", (String)(" renaming " + oldName + " to " + newName));
        if (!theFile.exists()) {
            Trace.warn((Object)this, (String)"renameFile", (String)(oldName + " not found"));
            return 1;
        }
        try {
            String cmd = RENAME_UNIX_COMMAND + oldName + " " + newName;
            proc = runtime.exec(cmd);
            proc.waitFor();
            Trace.info((Object)this, (String)"renameFile", (String)(": " + cmd));
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)(" Unable to rename " + oldName + " to " + newName), (Throwable)e);
            if (proc != null) {
                Trace.error((Object)this, (String)"renameFile", (String)" Cleaning up failed shell proc");
                proc.destroy();
            }
            return 2;
        }
        Trace.info((Object)this, (String)"renameFile", (String)"     rename complete ");
        return 0;
    }

    private void cleanupFileError(String filename, FileOutputStream stream) {
        String METHOD = "cleanupFileError";
        Trace.methodBegin((Object)this, (String)"cleanupFileError");
        if (stream != null) {
            Trace.info((Object)this, (String)"cleanupFileError", (String)(" closing " + filename));
            try {
                stream.close();
            }
            catch (IOException closeException) {
                Trace.error((Object)this, (String)"cleanupFileError", (String)(" Failed to close " + filename));
            }
        } else {
            Trace.info((Object)this, (String)"cleanupFileError", (String)(" No FileOutputStream to close for " + filename));
        }
        Trace.info((Object)this, (String)"cleanupFileError", (String)(" Renaming " + filename + " to .err"));
        this.renameFile(filename, filename + XML_BAD_SUFFIX);
    }

    private boolean writeXmlConfig(FileOutputStream stream, List arrayList) {
        String METHOD = "writeXmlConfig";
        Trace.methodBegin((Object)this, (String)"writeXmlConfig");
        List persistenceList = null;
        try {
            if (arrayList == null) {
                Trace.info((Object)this, (String)"writeXmlConfig", (String)" Persisting all arrays");
                persistenceList = ArrayInventory.getInstance().getArrayInventory();
            } else {
                Trace.info((Object)this, (String)"writeXmlConfig", (String)" Persisting specified arrays");
                persistenceList = arrayList;
            }
            Trace.info((Object)this, (String)"writeXmlConfig", (String)" Writing headers...");
            SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, "<sscs_dsp_persistence xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
            Trace.info((Object)this, (String)"writeXmlConfig", (String)" Writing mgmt persisted info...");
            this.saveManagementPersistenceInfo(stream);
            for (int i = 0; i < persistenceList.size(); ++i) {
                ArrayObject thisArrayObject = (ArrayObject)persistenceList.get(i);
                Trace.info((Object)this, (String)"writeXmlConfig", (String)(" Persisting info for DSP " + i + ", " + thisArrayObject));
                ModifyBroker.getInstance().persistModulesToXml(thisArrayObject, stream);
            }
            Trace.info((Object)this, (String)"writeXmlConfig", (String)" Writing previously persisted info...");
            this.savePreviousPersisted(stream);
            Trace.info((Object)this, (String)"writeXmlConfig", (String)" Writing footers");
            SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, XML_ROOT_E);
            Trace.info((Object)this, (String)"writeXmlConfig", (String)" Done writing persistence");
        }
        catch (IOException ioE) {
            Trace.error((Object)this, (String)"writeXmlConfig", (String)" Write failed!!!");
            return false;
        }
        catch (CIMException cimE) {
            Trace.error((Object)this, (String)"writeXmlConfig", (String)" CIM exception - write failed!!!");
            return false;
        }
        return true;
    }

    public static synchronized void instancesToXml(CIMInstance[] input, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied, FileOutputStream stream) {
        String METHOD = "instancesToXml";
        Trace.methodBegin((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager = SunStorEdge_DSPPersistenceManager.class$("com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager")) : class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager), (String)"instancesToXml");
        CIMXml xmlImpl = CIMXmlFactory.getCIMXmlImpl();
        if (input != null) {
            int numInst = input.length;
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager = SunStorEdge_DSPPersistenceManager.class$("com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager")) : class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager), (String)"instancesToXml", (String)(" converting " + numInst + " instances "));
            for (int i = 0; i < numInst; ++i) {
                if (input[i] == null) continue;
                Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager == null ? SunStorEdge_DSPPersistenceManager.class$("com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager") : class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager), (String)"instancesToXml", (String)(" converting CIM instance " + (i + 1) + " of " + numInst + ":  " + input[i].getClassName() + " to XML "));
                try {
                    SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, xmlImpl.CIMInstanceToXml(input[i], includeQualifiers, includeClassOrigin, propertyList, showImplied));
                    continue;
                }
                catch (Exception e) {
                    Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager == null ? SunStorEdge_DSPPersistenceManager.class$("com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager") : class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager), (String)"Exception converting to XML: ", (Throwable)e);
                }
            }
        } else {
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager = SunStorEdge_DSPPersistenceManager.class$("com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager")) : class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager), (String)"instancesToXml", (String)" no instances to convert");
        }
        Trace.methodEnd((Object)(class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager = SunStorEdge_DSPPersistenceManager.class$("com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager")) : class$com$sun$netstorage$dsp$mgmt$se6920$SunStorEdge_DSPPersistenceManager), (String)"instancesToXml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processPersistedData() {
        String METHOD = "processPersistedData";
        Trace.methodBegin((Object)this, (String)"processPersistedData");
        boolean readFactoryInstances = false;
        if (this.loadPersistence() != 0) {
            Trace.error((Object)this, (String)"processPersistedData", (String)"Failed to retrieve persisted instances");
            return;
        }
        List list = this.persistedInstances;
        synchronized (list) {
            this.processPersistedDataImpl(this.persistedInstances);
        }
        try {
            CIMObjectPath mpiPath = new CIMObjectPath(MGMT_PERSISTENCE_INFO_CLASS);
            mpiPath.setNameSpace("\\root\\se6x20\\");
            CIMClass mpiClass = SunStorEdge_DSPProvider.cimom.getClass(mpiPath, false, true, true, null);
            if (mpiClass != null) {
                UnsignedInt32 versionUint32;
                CIMInstance mpiInstance;
                CIMInstance[] mpiInstanceArray = RequestBroker.getInstance().enumerateInstances(mpiPath, false, true, true, null, mpiClass);
                if (mpiInstanceArray != null) {
                    mpiInstance = mpiInstanceArray[0];
                    versionUint32 = (UnsignedInt32)mpiInstance.getProperty("Version").getValue().getValue();
                } else {
                    versionUint32 = new UnsignedInt32("1");
                    CIMValue versionVal = new CIMValue((Object)versionUint32);
                    mpiInstance = mpiClass.newInstance();
                    mpiInstance.setProperty("Version", versionVal);
                    RequestBroker.getInstance().addSyntheticCacheInstance(mpiInstance);
                    readFactoryInstances = true;
                }
                long version = versionUint32.longValue();
                List list2 = this.persistedFactoryInstances;
                synchronized (list2) {
                    Iterator pfIter = this.persistedFactoryInstances.iterator();
                    while (pfIter.hasNext()) {
                        CIMProperty versionProp;
                        UnsignedInt32 pfiVersionVal;
                        long pfiVersion;
                        String instName;
                        CIMInstance thisPfi = (CIMInstance)pfIter.next();
                        if (thisPfi == null || !(instName = thisPfi.getClassName()).equals(MGMT_PERSISTENCE_INFO_CLASS) || (pfiVersion = (pfiVersionVal = (UnsignedInt32)(versionProp = thisPfi.getProperty("Version")).getValue().getValue()).longValue()) <= version) continue;
                        readFactoryInstances = true;
                        break;
                    }
                }
                if (readFactoryInstances) {
                    this.processPersistedDataImpl(this.persistedFactoryInstances);
                    this.persistedInstances.addAll(this.persistedFactoryInstances);
                }
            }
            this.updateProviderVersion();
            this.startProcessVDiskThread();
            ModifyBroker.setPersistenceRequired();
        }
        catch (CIMException ce) {
            String errorString = new String("processPersistedData caught CIMException: ");
            Trace.error((Object)this, (String)errorString, (Throwable)ce);
        }
    }

    public void updateProviderVersion() {
        String build;
        String rev;
        String minor;
        String major;
        block17: {
            String METHOD = "updateProviderVersion";
            Trace.methodBegin((Object)this, (String)"updateProviderVersion");
            major = "3";
            minor = "0";
            rev = "1";
            build = "0";
            boolean verfound = false;
            FileInputStream releaseStream = null;
            try {
                File prFile = !System.getProperty("os.name").equals("SunOS") ? new File("c:\\release") : new File(DEFAULT_RELEASE_FILE_PATH);
                if (!prFile.exists()) break block17;
                try {
                    if (prFile.length() == 0L) break block17;
                    releaseStream = new FileInputStream(prFile);
                    BufferedReader releaseReader = new BufferedReader(new InputStreamReader(releaseStream));
                    while (!verfound) {
                        try {
                            String line = releaseReader.readLine();
                            if (line != null) {
                                if (!(line = line.trim()).endsWith("6920")) continue;
                                while (!verfound && (line = releaseReader.readLine()) != null) {
                                    if (!(line = line.trim()).startsWith("Version")) continue;
                                    String[] spit1 = line.split(":");
                                    String verstr = spit1[1].trim();
                                    String[] split2 = verstr.split("\\.");
                                    major = split2[0];
                                    minor = split2[1];
                                    rev = split2[2];
                                    build = split2[3];
                                    ((InputStream)releaseStream).close();
                                    verfound = true;
                                }
                                continue;
                            }
                            break;
                        }
                        catch (IOException e1) {
                            Trace.info((Object)this, (String)"Exception reading version data : \n", (Throwable)e1);
                            break;
                        }
                    }
                }
                catch (SecurityException se) {
                    Trace.info((Object)this, (String)"Version file access exception: \n", (Throwable)se);
                    return;
                }
            }
            catch (FileNotFoundException e) {
                Trace.error((Object)this, (String)"Can not discover software version :", (Throwable)e);
                return;
            }
        }
        ArrayList<CIMObjectPath> softIdLst = new ArrayList<CIMObjectPath>();
        try {
            CIMObjectPath sysClassPath = new CIMObjectPath("SunStorEdge_DSPStorageSystem");
            sysClassPath.setNameSpace("\\root\\se6x20\\");
            CIMClass sysClass = SunStorEdge_DSPProvider.cimom.getClass(sysClassPath, false, true, true, null);
            CIMInstance[] systems = RequestBroker.getInstance().enumerateInstances(sysClassPath, false, false, true, null, sysClass);
            CIMInstance system = systems[0];
            CIMObjectPath sysPath = system.getObjectPath();
            sysPath.setNameSpace("\\root\\se6x20\\");
            CIMObjectPath instSwIdPath = new CIMObjectPath(INSTALLED_SW_IDENTITY_CLASS);
            instSwIdPath.setNameSpace("\\root\\se6x20\\");
            CIMObjectPath[] swIds = RequestBroker.getInstance().associatorNames(instSwIdPath, sysPath, SOFTWARE_IDENTITY_CLASS, SW_ID_SYSTEM, SW_ID_SW);
            if (swIds != null) {
                softIdLst.add(swIds[0]);
            }
            CIMObjectPath compCsPath = new CIMObjectPath("SunStorEdge_DSPComponentCS");
            instSwIdPath.setNameSpace("\\root\\se6x20\\");
            CIMInstance[] domains = RequestBroker.getInstance().associators(compCsPath, sysPath, "SunStorEdge_DSPStorageDomain", "GroupComponent", "PartComponent", false, false, null);
            if (domains != null) {
                for (int j = 0; j < domains.length; ++j) {
                    CIMObjectPath domPath = domains[j].getObjectPath();
                    domPath.setNameSpace("\\root\\se6x20\\");
                    instSwIdPath.setNameSpace("\\root\\se6x20\\");
                    swIds = RequestBroker.getInstance().associatorNames(instSwIdPath, domPath, SOFTWARE_IDENTITY_CLASS, SW_ID_SYSTEM, SW_ID_SW);
                    if (swIds == null) continue;
                    softIdLst.add(swIds[0]);
                }
            }
            UnsignedInt16 majInt = new UnsignedInt16("3");
            UnsignedInt16 minorInt = new UnsignedInt16("0");
            UnsignedInt16 revInt = new UnsignedInt16("1");
            UnsignedInt16 bldInt = new UnsignedInt16("0");
            String verStr = major + "." + minor + "." + rev + "." + build;
            try {
                majInt = new UnsignedInt16(major);
                minorInt = new UnsignedInt16(minor);
                revInt = new UnsignedInt16(rev);
                bldInt = new UnsignedInt16(build);
            }
            catch (NumberFormatException e2) {
                Trace.error((Object)this, (String)"Bad version values", (Throwable)e2);
                return;
            }
            Iterator swidItr = softIdLst.iterator();
            while (swidItr.hasNext()) {
                CIMObjectPath swidPath = (CIMObjectPath)swidItr.next();
                swidPath.setNameSpace("\\root\\se6x20\\");
                CIMInstance swIdInst = RequestBroker.getInstance().findInstance(swidPath);
                swIdInst.setProperty(SW_ID_MAJOR, new CIMValue((Object)majInt));
                swIdInst.setProperty(SW_ID_MINOR, new CIMValue((Object)minorInt));
                swIdInst.setProperty(SW_ID_REV, new CIMValue((Object)revInt));
                swIdInst.setProperty(SW_ID_BLD, new CIMValue((Object)bldInt));
                swIdInst.setProperty(SW_ID_VERSION, new CIMValue((Object)verStr));
            }
        }
        catch (CIMException e1) {
            Trace.error((Object)this, (String)"Exception while updating SoftwareIdentity instances :", (Throwable)e1);
            return;
        }
    }

    private void startProcessVDiskThread() {
        String METHOD = "startProcessVDiskThread";
        String THREAD_NAME = "ProcessVDiskThread";
        Trace.methodBegin((Object)this, (String)"startProcessVDiskThread");
        processVDiskThread = new Thread("ProcessVDiskThread"){

            public void run() {
                boolean running = true;
                try {
                    try {
                        CIMObjectPath extPath = new CIMObjectPath("SunStorEdge_6120StorageVolume");
                        extPath.setNameSpace("\\root\\se6x20\\");
                        Enumeration enumeration = SunStorEdge_DSPProvider.getCIMOMHandle().enumerateInstances(extPath, true, false, false, false, null);
                    }
                    catch (Exception ex) {
                        Trace.warn((Object)this, (String)"This exception may be ignored; just used to force 6120 provider load", (Throwable)ex);
                    }
                    SunStorEdge_DSPPersistenceManager.this.processAllVDisks();
                    if (!firstBoot) {
                        runCount = 8;
                    }
                    int sleepInMinutes = 1;
                    while (running) {
                        Trace.warn((Object)this, (String)"ProcessVDiskThread:", (String)(" in startProcessVDisk thread runcount " + runCount));
                        if (runCount < 10) {
                            try {
                                SunStorEdge_DSPPersistenceManager.this.process6120VDisks();
                            }
                            catch (Exception e) {
                                Trace.error((Object)this, (String)"ProcessVDiskThread-Exception", (Throwable)e);
                            }
                            sleepInMinutes = 1;
                        } else if (runCount < 13) {
                            try {
                                SunStorEdge_DSPPersistenceManager.this.process6120VDisks();
                            }
                            catch (Exception e) {
                                Trace.error((Object)this, (String)"ProcessVDiskThread-Exception", (Throwable)e);
                            }
                            sleepInMinutes = 5;
                        } else {
                            try {
                                SunStorEdge_DSPPersistenceManager.this.process6120VDisks();
                            }
                            catch (Exception e) {
                                Trace.error((Object)this, (String)"ProcessVDiskThread-Exception", (Throwable)e);
                            }
                            sleepInMinutes = 30;
                        }
                        runCount++;
                        try {
                            Thread.sleep(sleepInMinutes * 60000);
                        }
                        catch (InterruptedException iex) {
                            runCount = 8;
                            Trace.info((Object)this, (String)"ProcessVDiskThread", (String)("ProcessVDiskThread interrupted, setting count back to " + runCount));
                        }
                    }
                }
                catch (Exception e) {
                    String errorString = new String("ProcessVDiskThread.run() caught Exception: ");
                    Trace.error((Object)this, (String)errorString, (Throwable)e);
                    running = false;
                }
            }
        };
        processVDiskThread.start();
    }

    private synchronized void processPersistedDataImpl(List persistInstList) {
        CIMInstance newInst = null;
        CIMClass newClass = null;
        String METHOD = "processPersistedDataImpl";
        Trace.methodBegin((Object)this, (String)"processPersistedDataImpl");
        Iterator instIter = persistInstList.iterator();
        while (instIter.hasNext()) {
            CIMInstance inst = (CIMInstance)instIter.next();
            if (!inst.getClassName().equals(POOL_CLASS) && !inst.getClassName().equals(MGMT_PERSISTENCE_INFO_CLASS) && !inst.getClassName().equals(PROFILE_CLASS) && !inst.getClassName().equals(STORAGE_CAPABILITIES_CLASS) && !inst.getClassName().equals(SYNTHSETTING_CLASS) && !inst.getClassName().equals(ARRAY_CTL_SET_CLASS)) continue;
            CIMObjectPath newClassPath = new CIMObjectPath(inst.getClassName());
            newClassPath.setNameSpace("\\root\\se6x20\\");
            try {
                newClass = SunStorEdge_DSPProvider.cimom.getClass(newClassPath, false, true, true, null);
                if (newClass == null) {
                    Trace.error((Object)this, (String)"processPersistedDataImpl", (String)" Unable to get StorageSetting Class. ");
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                    tmpe.setDescription("Internal error: Failed getClass.");
                    throw tmpe;
                }
                newInst = newClass.newInstance();
                newInst.updatePropertyValues(inst.getProperties());
                RequestBroker.getInstance().addSyntheticCacheInstance(newInst);
            }
            catch (Exception e) {
                Trace.error((Object)this, (String)"processPersistedDataImpl", (String)(" Unable to process persisted instance: " + inst.getName()));
            }
            instIter.remove();
        }
        instIter = persistInstList.iterator();
        while (instIter.hasNext()) {
            CIMProperty prop;
            Iterator itr;
            Vector keys;
            CIMObjectPath ref1 = null;
            CIMObjectPath ref2 = null;
            CIMInstance refInst = null;
            CIMInstance inst = (CIMInstance)instIter.next();
            if (inst.getClassName().equals(ALLOCATED_POOL_CLASS)) {
                ref1 = (CIMObjectPath)inst.getProperty(ALLOC_POOL_VOLUME).getValue().getValue();
                ref2 = (CIMObjectPath)inst.getProperty(ALLOC_POOL_POOL).getValue().getValue();
            } else if (inst.getClassName().equals("SunStorEdge_DSPConcreteComponent")) {
                ref1 = (CIMObjectPath)inst.getProperty("GroupComponent").getValue().getValue();
                ref2 = (CIMObjectPath)inst.getProperty("PartComponent").getValue().getValue();
            } else if (inst.getClassName().equals(HOSTEDPOOL_CLASS)) {
                ref1 = (CIMObjectPath)inst.getProperty("GroupComponent").getValue().getValue();
                ref2 = (CIMObjectPath)inst.getProperty("PartComponent").getValue().getValue();
            } else if (inst.getClassName().equals(ELEMENT_SETTING_CLASS)) {
                ref1 = (CIMObjectPath)inst.getProperty(ELEMENT_SETTING_SETTING).getValue().getValue();
                ref2 = (CIMObjectPath)inst.getProperty(ELEMENT_ELEMENT).getValue().getValue();
            } else if (inst.getClassName().equals(ELEMENT_CAPABILITIES_CLASS)) {
                ref1 = (CIMObjectPath)inst.getProperty(ELEMENT_CAPABILITIES_SETTING).getValue().getValue();
                ref2 = (CIMObjectPath)inst.getProperty(ELEMENT_CAPABILITIES_ELEMENT).getValue().getValue();
            } else if (inst.getClassName().equals(SYNTH_ELEMENT_SETTING_CLASS)) {
                ref1 = (CIMObjectPath)inst.getProperty(ELEMENT_ELEMENT).getValue().getValue();
                ref2 = (CIMObjectPath)inst.getProperty(ELEMENT_SETTING_SETTING).getValue().getValue();
            } else if (inst.getClassName().equals(EXTENT_ARRAY_SETTING_CLASS)) {
                ref1 = (CIMObjectPath)inst.getProperty(ELEMENT_SETTING_SETTING).getValue().getValue();
                ref2 = (CIMObjectPath)inst.getProperty(ELEMENT_ELEMENT).getValue().getValue();
            }
            if (ref1 == null) continue;
            refInst = RequestBroker.getInstance().findInstance(ref1);
            if (refInst != null) {
                refInst = null;
                refInst = RequestBroker.getInstance().findInstance(ref2);
                if (refInst == null) continue;
                RequestBroker.getInstance().addSyntheticCacheInstance(inst);
                instIter.remove();
                continue;
            }
            if (inst.getClassName().equals(ALLOCATED_POOL_CLASS) || inst.getClassName().equals(SYNTH_ELEMENT_SETTING_CLASS)) {
                keys = ref1.getKeys();
                itr = keys.iterator();
                String wwn = null;
                while (itr.hasNext()) {
                    prop = (CIMProperty)itr.next();
                    if (!prop.getName().equalsIgnoreCase(DEVICE_ID)) continue;
                    wwn = prop.getValue().getValue().toString();
                    break;
                }
                if (wwn != null) {
                    String searchWwn = wwn.replaceAll(":", "");
                    try {
                        CIMInstance vol = ModifySunStorEdge_DSPStorageVolume.getStorageVolume(searchWwn);
                        if (vol != null) {
                            if (inst.getClassName().equals(ALLOCATED_POOL_CLASS)) {
                                inst.setProperty(ALLOC_POOL_VOLUME, new CIMValue((Object)vol.getObjectPath()));
                            } else if (inst.getClassName().equals(SYNTH_ELEMENT_SETTING_CLASS)) {
                                inst.setProperty(ELEMENT_ELEMENT, new CIMValue((Object)vol.getObjectPath()));
                            }
                            refInst = null;
                            refInst = RequestBroker.getInstance().findInstance(ref2);
                            if (refInst != null) {
                                RequestBroker.getInstance().addSyntheticCacheInstance(inst);
                                instIter.remove();
                            }
                        }
                    }
                    catch (CIMException e) {
                        Trace.error((Object)this, (String)"Excetption searching for storage volume ", (Throwable)e);
                    }
                }
            }
            if (!inst.getClassName().equals(HOSTEDPOOL_CLASS)) continue;
            keys = ref1.getKeys();
            itr = keys.iterator();
            String domainName = null;
            while (itr.hasNext()) {
                prop = (CIMProperty)itr.next();
                if (!prop.getName().equalsIgnoreCase("Name")) continue;
                domainName = prop.getValue().getValue().toString();
                break;
            }
            if (domainName == null) continue;
            if (domainName.matches("[0-9A-Fa-f]*\\..*")) {
                String[] substr = domainName.split("\\.");
                domainName = substr[1];
            }
            try {
                CIMObjectPath domainClassPath = new CIMObjectPath(STORAGE_DOMAIN_CLASS);
                domainClassPath.setNameSpace("\\root\\se6x20\\");
                CIMClass domainClass = SunStorEdge_DSPProvider.cimom.getClass(domainClassPath, false, true, true, null);
                if (domainClass == null) {
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                    tmpe.setDescription("Internal error: Failed getClass.");
                    throw tmpe;
                }
                CIMInstance[] domains = RequestBroker.getInstance().enumerateInstances(domainClassPath, false, false, true, null, domainClass);
                CIMObjectPath domainPath = null;
                for (int i = 0; i < domains.length; ++i) {
                    String name = (String)domains[i].getProperty("ElementName").getValue().getValue();
                    if (!name.equalsIgnoreCase(domainName)) continue;
                    domainPath = domains[i].getObjectPath();
                    break;
                }
                if (domainPath == null) continue;
                inst.setProperty(HOSTED_POOL_GROUP, new CIMValue(domainPath));
                refInst = null;
                refInst = RequestBroker.getInstance().findInstance(ref2);
                if (refInst == null) continue;
                RequestBroker.getInstance().addSyntheticCacheInstance(inst);
                instIter.remove();
            }
            catch (CIMException e) {
                Trace.error((Object)this, (String)"Excetption searching for storage domain ", (Throwable)e);
            }
        }
    }

    public synchronized int loadPersistence() {
        block11: {
            String METHOD = "loadPersistence";
            Trace.methodBegin((Object)this, (String)"loadPersistence");
            FileInputStream persistUserStream = null;
            FileInputStream persistFactoryStream = null;
            try {
                File pfFile;
                File puFile;
                if (!System.getProperty("os.name").equals("SunOS")) {
                    puFile = new File("c:\\DspPersistence.xml");
                    pfFile = new File("c:\\DspFactorySettings.xml");
                } else {
                    puFile = new File("/opt/se6x20/resources/DspPersistence.xml");
                    pfFile = new File(DEFAULT_FACTORY_PERSISTENCE_FILE_PATH);
                }
                if (puFile.exists()) {
                    try {
                        if (puFile.length() != 0L) {
                            persistUserStream = new FileInputStream(puFile);
                            this.persistedInstances = InstanceFormer.parseXml(persistUserStream);
                            firstBoot = false;
                        }
                    }
                    catch (SecurityException se) {
                        Trace.info((Object)this, (String)": \n", (Throwable)se);
                    }
                }
                if (!pfFile.exists()) break block11;
                try {
                    if (pfFile.length() != 0L) {
                        persistFactoryStream = new FileInputStream(pfFile);
                        this.persistedFactoryInstances = InstanceFormer.parseXml(persistFactoryStream);
                    }
                }
                catch (SecurityException se) {
                    Trace.info((Object)this, (String)": \n", (Throwable)se);
                }
            }
            catch (Exception ex) {
                Trace.error((Object)this, (String)"", (Throwable)ex);
                return -1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void findAndWire(CIMObjectPath path) {
        String METHOD = "findAndWire";
        Trace.methodBegin((Object)this, (String)"findAndWire");
        Iterator instIter = null;
        boolean noAssociations = true;
        path.setNameSpace("\\root\\se6x20\\");
        List list = this.persistedInstances;
        synchronized (list) {
            instIter = this.persistedInstances.iterator();
            while (instIter.hasNext()) {
                CIMObjectPath ref1 = null;
                CIMObjectPath ref2 = null;
                CIMObjectPath match = null;
                CIMInstance refInst = null;
                CIMInstance inst = (CIMInstance)instIter.next();
                if (inst.getClassName().equals(ALLOCATED_POOL_CLASS)) {
                    ref1 = (CIMObjectPath)inst.getProperty(ALLOC_POOL_VOLUME).getValue().getValue();
                    ref2 = (CIMObjectPath)inst.getProperty(ALLOC_POOL_POOL).getValue().getValue();
                } else if (inst.getClassName().equals("SunStorEdge_DSPConcreteComponent")) {
                    ref1 = (CIMObjectPath)inst.getProperty("GroupComponent").getValue().getValue();
                    ref2 = (CIMObjectPath)inst.getProperty("PartComponent").getValue().getValue();
                } else if (inst.getClassName().equals(HOSTEDPOOL_CLASS)) {
                    ref1 = (CIMObjectPath)inst.getProperty("GroupComponent").getValue().getValue();
                    ref2 = (CIMObjectPath)inst.getProperty("PartComponent").getValue().getValue();
                } else if (inst.getClassName().equals(ELEMENT_SETTING_CLASS)) {
                    ref1 = (CIMObjectPath)inst.getProperty(ELEMENT_SETTING_SETTING).getValue().getValue();
                    ref2 = (CIMObjectPath)inst.getProperty(ELEMENT_ELEMENT).getValue().getValue();
                } else if (inst.getClassName().equals(ELEMENT_CAPABILITIES_CLASS)) {
                    ref1 = (CIMObjectPath)inst.getProperty(ELEMENT_CAPABILITIES_SETTING).getValue().getValue();
                    ref2 = (CIMObjectPath)inst.getProperty(ELEMENT_CAPABILITIES_ELEMENT).getValue().getValue();
                } else if (inst.getClassName().equals(EXTERNAL_EXTENT_CLASS)) {
                    ref1 = (CIMObjectPath)inst.getProperty(EXTERNAL_EXTENT_COLLECTION).getValue().getValue();
                    ref2 = (CIMObjectPath)inst.getProperty(EXTERNAL_EXTENT_MEMBER).getValue().getValue();
                }
                if (ref1 == null || ref2 == null) continue;
                if (ObjectPath.objectPathsAreEqual(path, ref1)) {
                    match = ref2;
                } else if (ObjectPath.objectPathsAreEqual(path, ref2)) {
                    match = ref1;
                }
                if (match == null || (refInst = RequestBroker.getInstance().findInstance(match)) == null) continue;
                RequestBroker.getInstance().addSyntheticCacheInstance(inst);
                if (inst.getClassName().equals("SunStorEdge_DSPConcreteComponent")) {
                    try {
                        ModifySunStorEdge_DSPStoragePool.calculatePoolSize(ref1);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                instIter.remove();
                ModifyBroker.setPersistenceRequired();
                noAssociations = false;
            }
        }
        try {
            if (noAssociations) {
                CIMInstance disk = RequestBroker.getInstance().findInstance(path);
                this.processNewVDisk(disk);
            }
        }
        catch (CIMException ce) {
            // empty catch block
        }
    }

    public synchronized void addNewInstance(CIMInstance theInstance) {
        String METHOD = "addNewInstance";
        Trace.methodBegin((Object)this, (String)"addNewInstance");
        this.persistedInstances.add(theInstance);
        ModifyBroker.setPersistenceRequired();
    }

    public synchronized boolean removeObsoleteInstance(CIMInstance theInstance) {
        String METHOD = "removeObsoleteInstance";
        Trace.methodBegin((Object)this, (String)"removeObsoleteInstance");
        boolean removed = this.persistedInstances.remove(theInstance);
        ModifyBroker.setPersistenceRequired();
        return removed;
    }

    public synchronized void savePreviousPersisted(FileOutputStream stream) throws IOException {
        String METHOD = "savePreviousPersisted";
        Trace.methodBegin((Object)this, (String)"savePreviousPersisted");
        CIMInstance[] prevInstances = this.persistedInstances.toArray(new CIMInstance[0]);
        ArrayList<CIMInstance> saveInstances = new ArrayList<CIMInstance>();
        if (prevInstances != null) {
            for (int i = 0; i < prevInstances.length; ++i) {
                if (prevInstances[i].getClassName().equals("SunStorEdge_DSPAllocatedFromStoragePool")) continue;
                saveInstances.add(prevInstances[i]);
            }
        }
        Object profilePath = null;
        SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, "<PREVIOUS_PERSISTED>\n  ");
        SunStorEdge_DSPPersistenceManager.instancesToXml(saveInstances.toArray(new CIMInstance[0]), true, true, null, true, stream);
        SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, "</PREVIOUS_PERSISTED>\n  ");
        Trace.methodEnd((Object)this, (String)"savePreviousPersisted");
    }

    public synchronized void saveManagementPersistenceInfo(FileOutputStream stream) throws IOException {
        String METHOD = "saveManagementPersistenceInfo";
        Trace.methodBegin((Object)this, (String)"saveManagementPersistenceInfo");
        CIMObjectPath mpiPath = new CIMObjectPath(MGMT_PERSISTENCE_INFO_CLASS);
        mpiPath.setNameSpace("\\root\\se6x20\\");
        try {
            CIMClass mpiClass = SunStorEdge_DSPProvider.cimom.getClass(mpiPath, false, true, true, null);
            if (mpiClass != null) {
                CIMInstance[] mpiInstanceArray = RequestBroker.getInstance().enumerateInstances(mpiPath, false, true, true, null, mpiClass);
                SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, "<MANAGEMENT_PERSISTED_INFO>\n  ");
                SunStorEdge_DSPPersistenceManager.instancesToXml(mpiInstanceArray, true, true, null, true, stream);
                SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, "</MANAGEMENT_PERSISTED_INFO>\n  ");
            }
        }
        catch (CIMException ce) {
            String errorString = new String("saveManagementPersistenceInfo caught CIMException: ");
            Trace.error((Object)this, (String)errorString, (Throwable)ce);
        }
    }

    private void processAllVDisks() throws CIMException {
        String METHOD = "processVDisks";
        CIMObjectPath vdiskPath = new CIMObjectPath(STORAGE_EXTENT_CLASS);
        vdiskPath.setNameSpace("\\root\\se6x20\\");
        CIMClass vdiskClass = SunStorEdge_DSPProvider.cimom.getClass(vdiskPath, false, true, true, null);
        CIMInstance[] vdisks = RequestBroker.getInstance().enumerateInstances(vdiskPath, false, false, true, null, vdiskClass);
        if (vdisks != null) {
            for (int i = 0; i < vdisks.length; ++i) {
                this.processNewVDisk(vdisks[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process6120VDisks() throws CIMException {
        String METHOD = "process6120VDisks";
        Trace.methodBegin((Object)this, (String)"process6120VDisks");
        Enumeration enum6120Slices = this.get6120Extents();
        ArrayList list6120 = new ArrayList();
        if (null != enum6120Slices) {
            while (enum6120Slices.hasMoreElements()) {
                CIMInstance sliceInst = (CIMInstance)enum6120Slices.nextElement();
                String sliceWWN = (String)sliceInst.getProperty(DEVICE_ID).getValue().getValue();
                sliceWWN = sliceWWN.substring(8);
                CIMObjectPath externalExtentPath = new CIMObjectPath(EXTERNAL_EXTENT_CLASS);
                externalExtentPath.setNameSpace("\\root\\se6x20\\");
                CIMObjectPath storExtPath = new CIMObjectPath(STORAGE_EXTENT_CLASS);
                storExtPath.setNameSpace("\\root\\se6x20\\");
                Vector<CIMProperty> keys = new Vector<CIMProperty>();
                keys.addElement(new CIMProperty("SystemCreationClassName", new CIMValue((Object)STORAGE_SYSTEM_CLASS)));
                keys.addElement(new CIMProperty("CreationClassName", new CIMValue((Object)STORAGE_EXTENT_CLASS)));
                keys.addElement(new CIMProperty("SystemName", new CIMValue((Object)this.getSystemName())));
                keys.addElement(new CIMProperty(DEVICE_ID, new CIMValue((Object)sliceWWN)));
                storExtPath.setKeys(keys);
                CIMObjectPath[] externalExtentRefNames = RequestBroker.getInstance().referenceNames(externalExtentPath, storExtPath, EXTERNAL_EXTENT_MEMBER);
                Trace.info((Object)this, (String)"process6120VDisks", (String)" getting externalExtentRefNames ");
                if (null == externalExtentRefNames) continue;
                for (int i = 0; i < externalExtentRefNames.length; ++i) {
                    CIMObjectPath member = (CIMObjectPath)externalExtentRefNames[i].getKey("Member").getValue().getValue();
                    member.setNameSpace("\\root\\se6x20\\");
                    Trace.info((Object)this, (String)"process6120VDisks", (String)(" deleting externalExtentRefNames: " + externalExtentRefNames[i]));
                    RequestBroker.getInstance().deleteInstance(externalExtentRefNames[i]);
                    CIMInstance dspStorageCapabilities = this.getDSPDefaultStorageCapabilities();
                    CIMInstance dspStorageSettings = this.getDSPDefaultStorageSetting();
                    CIMInstance systemSettings6120 = this.get6120SystemSettings((String)sliceInst.getProperty("SystemName").getValue().getValue());
                    CIMInstance vdisk = RequestBroker.getInstance().findInstance(storExtPath);
                    if (this.getVDiskStatus(vdisk) != 2 || !this.doesSliceMatchPool(sliceInst, dspStorageCapabilities) || !this.doSettingsMatch(systemSettings6120, dspStorageSettings)) continue;
                    SunStorEdge_DSPPersistenceManager sunStorEdge_DSPPersistenceManager = this;
                    synchronized (sunStorEdge_DSPPersistenceManager) {
                        CIMObjectPath concreteComponentPath = new CIMObjectPath("SunStorEdge_DSPConcreteComponent");
                        concreteComponentPath.setNameSpace("\\root\\se6x20\\");
                        CIMObjectPath[] concreteComponentRefNames = RequestBroker.getInstance().referenceNames(concreteComponentPath, storExtPath, "PartComponent");
                        if (null == concreteComponentRefNames || concreteComponentRefNames.length == 0) {
                            CIMInstance concComp = ModifySunStorEdge_DSPStorageConfigurationService.associateExtentWithPool("\\root\\se6x20\\", this.getDefaultPoolPath(), storExtPath);
                            if (!RequestBroker.getInstance().isSyntheticCacheInstance(concComp.getObjectPath())) {
                                RequestBroker.getInstance().addSyntheticCacheInstance(concComp);
                            }
                        }
                        continue;
                    }
                }
            }
        }
    }

    private void processNewVDisk(CIMInstance vdisk) throws CIMException {
        String METHOD = "processNewVDisk";
        CIMInstance concComp = null;
        CIMInstance extExtent = null;
        CIMObjectPath vdiskPath = new CIMObjectPath(STORAGE_EXTENT_CLASS);
        vdiskPath.setNameSpace("\\root\\se6x20\\");
        CIMObjectPath collectionPath = null;
        CIMObjectPath tmpCollPath = new CIMObjectPath(EXTERNAL_COLLECTION_CLASS);
        tmpCollPath.setNameSpace("\\root\\se6x20\\");
        CIMClass collectionClass = SunStorEdge_DSPProvider.cimom.getClass(tmpCollPath, false, false, true, null);
        CIMInstance[] collections = RequestBroker.getInstance().enumerateInstances(tmpCollPath, false, false, true, null, collectionClass);
        if (collections != null) {
            CIMInstance coll = collections[0];
            collectionPath = coll.getObjectPath();
            collectionPath.setNameSpace("\\root\\se6x20\\");
        }
        ModifySunStorEdge_DSPStorageExtent.configureRepository();
        context = new ConfigContext((CIMOMHandleWrapper)new ProviderToBOLConnection("\\root\\se6x20\\"));
        Vector otherVector = (Vector)vdisk.getProperty("OtherIdentifyingInfo").getValue().getValue();
        String wwn = (String)otherVector.get(0);
        int numLeadingDigits = 8;
        String pattern = "^\\d{" + numLeadingDigits + "}" + wwn + "$";
        SearchFilter sf = new SearchFilter(DEVICE_ID, Pattern.compile(pattern));
        ManageStorageVolumes msv = new ManageStorageVolumes();
        try {
            msv.init(context, sf);
            List volList = msv.getItemList();
            vdiskPath = vdisk.getObjectPath();
            vdiskPath.setNameSpace("\\root\\se6x20\\");
            if (volList.isEmpty()) {
                extExtent = ModifySunStorEdge_DSPStorageConfigurationService.associateExtentWithCollection("\\root\\se6x20\\", collectionPath, vdiskPath);
                RequestBroker.getInstance().addSyntheticCacheInstance(extExtent);
            } else if (firstBoot && this.getVDiskStatus(vdisk) == 2) {
                Trace.info((Object)this, (String)"processNewVDisk", (String)" associate with pool ");
                concComp = ModifySunStorEdge_DSPStorageConfigurationService.associateExtentWithPool("\\root\\se6x20\\", this.getDefaultPoolPath(), vdiskPath);
                if (!RequestBroker.getInstance().isSyntheticCacheInstance(concComp.getObjectPath())) {
                    RequestBroker.getInstance().addSyntheticCacheInstance(concComp);
                }
            }
        }
        catch (Exception ex) {
            Trace.error((Object)this, (String)"processNewVDisk", (String)"Exception retrieving T4 VDisks");
            Trace.error((Object)this, (String)"", (Throwable)ex);
            return;
        }
    }

    private int getVDiskStatus(CIMInstance dspStorageExtent) {
        String METHOD = "getVDiskStatus";
        Vector statusVector = (Vector)dspStorageExtent.getProperty(EXTENT_STATUS).getValue().getValue();
        if (statusVector != null && statusVector.size() != 0) {
            Trace.info((Object)this, (String)METHOD, (String)("Extent status vector: " + statusVector));
            Trace.info((Object)this, (String)METHOD, (String)("Status at index 0: " + statusVector.get(0)));
            UnsignedInt16 status = (UnsignedInt16)statusVector.get(0);
            return status.intValue();
        }
        Trace.error((Object)this, (String)METHOD, (String)"Unable to retrieve VDisk status.");
        Trace.error((Object)this, (String)METHOD, (String)("Extent status vector: " + statusVector));
        return -1;
    }

    private Enumeration get6120Extents() {
        String METHOD = "get6120Extents";
        Enumeration enumeration = null;
        Object extDisks = null;
        Trace.methodBegin((Object)this, (String)METHOD);
        CIMObjectPath extPath = new CIMObjectPath("SunStorEdge_6120StorageVolume");
        extPath.setNameSpace("\\root\\se6x20\\");
        try {
            enumeration = context.getClient().enumerateInstances(extPath, true, false, false);
        }
        catch (Exception ex) {
            Trace.error((Object)this, (String)"", (Throwable)ex);
        }
        return enumeration;
    }

    private String getSystemName() throws CIMException {
        CIMObjectPath sysPath = new CIMObjectPath("SunStorEdge_DSPStorageSystem");
        sysPath.setNameSpace("\\root\\se6x20\\");
        CIMClass sysClass = SunStorEdge_DSPProvider.cimom.getClass(sysPath, false, true, true, null);
        CIMInstance[] systems = RequestBroker.getInstance().enumerateInstances(sysPath, false, false, true, null, sysClass);
        CIMInstance system = systems[0];
        String systemName = (String)system.getProperty("Name").getValue().getValue();
        return systemName;
    }

    private CIMObjectPath getDefaultPoolPath() throws CIMException {
        CIMObjectPath poolPath = null;
        CIMObjectPath tmpPoolPath = new CIMObjectPath(STORAGE_POOL_CLASS);
        tmpPoolPath.setNameSpace("\\root\\se6x20\\");
        CIMClass poolClass = SunStorEdge_DSPProvider.cimom.getClass(tmpPoolPath, false, false, true, null);
        CIMInstance tmpPoolInst = poolClass.newInstance();
        tmpPoolInst.setProperty(INSTANCE_ID, new CIMValue((Object)DEFAULT_POOL_ID));
        poolPath = tmpPoolInst.getObjectPath();
        poolPath.setNameSpace("\\root\\se6x20\\");
        return poolPath;
    }

    private CIMInstance getDSPDefaultStorageCapabilities() {
        CIMInstance inst;
        block3: {
            String METHOD = "getDSPDefaultStorageCapabilities";
            inst = null;
            CIMObjectPath capabilitiesPath = new CIMObjectPath(STORAGE_CAPABILITIES_CLASS);
            capabilitiesPath.setNameSpace("\\root\\se6x20\\");
            try {
                CIMClass capabilitiesClass = SunStorEdge_DSPProvider.cimom.getClass(capabilitiesPath, false, true, true, null);
                CIMInstance[] capabilitiesInsts = RequestBroker.getInstance().enumerateInstances(capabilitiesPath, false, false, true, null, capabilitiesClass);
                if (capabilitiesInsts == null) break block3;
                for (int i = 0; i < capabilitiesInsts.length; ++i) {
                    String instanceID = (String)capabilitiesInsts[i].getProperty(INSTANCE_ID).getValue().getValue();
                    if (!DEFAULT_POOL_ID.equals(instanceID)) continue;
                    inst = capabilitiesInsts[i];
                    break;
                }
            }
            catch (Exception ex) {
                Trace.error((Object)this, (String)"getDSPDefaultStorageCapabilities : Could not get default Capabilities enum.", (Throwable)ex);
            }
        }
        return inst;
    }

    private boolean doesSliceMatchPool(CIMInstance slice6120Inst, CIMInstance poolCapabilitiesInst) {
        String METHOD = "doesSliceMatchPool";
        boolean retVal = false;
        if (null == slice6120Inst || null == poolCapabilitiesInst) {
            return retVal;
        }
        Boolean noSinglePointOfFailure6120 = (Boolean)slice6120Inst.getProperty(NO_SINGLE_POINT_OF_FAILURE).getValue().getValue();
        Boolean noSinglePointOfFailureDSP = (Boolean)poolCapabilitiesInst.getProperty(NO_SINGLE_POINT_OF_FAILURE).getValue().getValue();
        UnsignedInt16 dataRedundancy6120 = (UnsignedInt16)slice6120Inst.getProperty(DATA_REDUNDANCY).getValue().getValue();
        UnsignedInt16 dataRedundancyDSP = (UnsignedInt16)poolCapabilitiesInst.getProperty(DATA_REDUNDANCY_DEFAULT).getValue().getValue();
        if (noSinglePointOfFailure6120.equals(noSinglePointOfFailureDSP) && dataRedundancy6120.equals((Object)dataRedundancyDSP)) {
            retVal = true;
        }
        return retVal;
    }

    private boolean doSettingsMatch(CIMInstance systemSettings6120, CIMInstance dspDefaultStorageSettings) {
        double segDSPinK;
        String METHOD = "doSettingsMatch";
        boolean retVal = false;
        if (null == systemSettings6120 || null == dspDefaultStorageSettings) {
            return retVal;
        }
        UnsignedInt32 segmentSize6120 = (UnsignedInt32)systemSettings6120.getProperty(SEGMENT_SIZE).getValue().getValue();
        UnsignedInt16 segmentSizeDSP = (UnsignedInt16)dspDefaultStorageSettings.getProperty("SegmentSize").getValue().getValue();
        UnsignedInt8 readAhead = (UnsignedInt8)systemSettings6120.getProperty("ReadAheadMode").getValue().getValue();
        UnsignedInt16 accessDirectionHint = (UnsignedInt16)dspDefaultStorageSettings.getProperty("AccessDirectionHint").getValue().getValue();
        int segIntVal6120 = segmentSize6120.intValue();
        int segIntValDSP = segmentSizeDSP.intValue();
        int readAheadIntVal6120 = readAhead.intValue();
        int readAheadIntValDSP = accessDirectionHint.intValue();
        boolean readAheadsMatch = false;
        if (readAheadIntVal6120 == 0 && readAheadIntValDSP <= 5 || readAheadIntVal6120 == 2 && readAheadIntValDSP > 5) {
            readAheadsMatch = true;
        }
        if ((double)segIntVal6120 == (segDSPinK = 4096.0 * Math.pow(2.0, segIntValDSP)) && readAheadsMatch) {
            retVal = true;
        }
        return retVal;
    }

    private CIMInstance get6120SystemSettings(String ip) {
        String METHOD = "get6120SystemSettings";
        CIMInstance inst = null;
        String query = "Select * from " + SYSTEM_SETTING_6120_CLASS + " where " + "SystemName" + " = '" + ip + "'";
        try {
            Enumeration enumeration = CIMObjectWrapper.execQuery((CIMOMHandleWrapper)context.getClient(), (String)query);
            while (enumeration.hasMoreElements()) {
                inst = (CIMInstance)enumeration.nextElement();
            }
        }
        catch (Exception ex) {
            Trace.error((Object)this, (String)(METHOD + " : Could not get SunStorEdge_6120SystemSetting."), (Throwable)ex);
        }
        return inst;
    }

    private CIMInstance getDSPDefaultStorageSetting() throws CIMException {
        String METHOD = "getDSPDefaultStorageSetting";
        CIMObjectPath settingPath = new CIMObjectPath(PROFILE_CLASS);
        settingPath.setNameSpace("\\root\\se6x20\\");
        CIMClass settingClass = SunStorEdge_DSPProvider.cimom.getClass(settingPath, false, true, true, null);
        CIMInstance[] settings = RequestBroker.getInstance().enumerateInstances(settingPath, false, false, true, null, settingClass);
        CIMInstance inst = null;
        if (settings != null) {
            for (int i = 0; i < settings.length; ++i) {
                String pName = (String)settings[i].getProperty(INSTANCE_ID).getValue().getValue();
                if (!pName.equals(DEFAULT_PROFILE_ID)) continue;
                inst = settings[i];
                break;
            }
        }
        return inst;
    }

    public static void writeStringToStream(FileOutputStream stream, String data) throws IOException {
        stream.write(data.getBytes());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        persistenceFilePath = "/opt/se6x20/resources/DspPersistence.xml";
        factoryPersistenceFilePath = DEFAULT_FACTORY_PERSISTENCE_FILE_PATH;
        persistenceFileBackupPath = "/opt/se6x20/resources/DspPersistence.xml.bkup";
        POOL_CLASS = "SunStorEdge_DSPStoragePool";
        PROFILE_CLASS = "SunStorEdge_StorageSettingWithHints";
        ALLOCATED_POOL_CLASS = "SunStorEdge_DSPAllocatedFromStoragePool";
        HOSTEDPOOL_CLASS = "SunStorEdge_DSPHostedStoragePool";
        ELEMENT_SETTING_CLASS = "SunStorEdge_DSPElementSettingData";
        STORAGE_CAPABILITIES_CLASS = "SunStorEdge_DSPStorageCapabilities";
        ELEMENT_CAPABILITIES_CLASS = "SunStorEdge_DSPElementCapabilities";
        MGMT_PERSISTENCE_INFO_CLASS = "SunStorEdge_DSPManagementPersistenceInfo";
        STORAGE_EXTENT_CLASS = "SunStorEdge_DSPStorageExtent";
        STORAGE_SYSTEM_CLASS = "SunStorEdge_DSPStorageSystem";
        STORAGE_POOL_CLASS = "SunStorEdge_DSPStoragePool";
        EXTERNAL_COLLECTION_CLASS = "SunStorEdge_DSPExternalCollection";
        EXTERNAL_EXTENT_CLASS = "SunStorEdge_DSPExternalExtent";
        SYSTEM_SETTING_6120_CLASS = "SunStorEdge_6120SystemSetting";
        SYNTHSETTING_CLASS = "SunStorEdge_DSPSyntheticSettingData";
        SYNTH_ELEMENT_SETTING_CLASS = "SunStorEdge_DSPSyntheticElementSettingData";
        ARRAY_CTL_SET_CLASS = "SunStorEdge_DSPArrayControllerSettingData";
        EXTENT_ARRAY_SETTING_CLASS = "SunStorEdge_DSPExtentArraySettingData";
        STORAGE_DOMAIN_CLASS = "SunStorEdge_DSPStorageDomain";
        SOFTWARE_IDENTITY_CLASS = "SunStorEdge_DSPSoftwareIdentity";
        INSTALLED_SW_IDENTITY_CLASS = "SunStorEdge_DSPInstalledSoftwareIdentity";
        ALLOC_POOL_VOLUME = "Dependent";
        ALLOC_POOL_POOL = "Antecedent";
        ELEMENT_SETTING_SETTING = "SettingData";
        ELEMENT_ELEMENT = "ManagedElement";
        ELEMENT_CAPABILITIES_SETTING = "Capabilities";
        ELEMENT_CAPABILITIES_ELEMENT = "ManagedElement";
        EXTERNAL_EXTENT_COLLECTION = "Collection";
        EXTERNAL_EXTENT_MEMBER = "Member";
        NO_SINGLE_POINT_OF_FAILURE = "NoSinglePointOfFailure";
        DATA_REDUNDANCY = "DataRedundancy";
        DATA_REDUNDANCY_DEFAULT = "DataRedundancyDefault";
        SEGMENT_SIZE = "SegmentSize";
        HOSTED_POOL_GROUP = "GroupComponent";
        HOSTED_POOL_PART = "PartComponent";
        context = null;
        firstBoot = true;
        runCount = 0;
        processVDiskThread = null;
    }
}

