/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayInventory;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyBroker;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import java.util.ArrayList;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMIndicationProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;

public class RouteAgent
implements Authorizable,
CIMAssociatorProvider,
CIMIndicationProvider,
CIMInstanceProvider,
CIMMethodProvider {
    private static RouteAgent instance = new RouteAgent();
    private ArrayList arrayList;
    private CIMOMHandle cimom;
    private long lastEPReload = 0L;
    private long lastFCReload = 0L;

    private RouteAgent() {
    }

    public static RouteAgent getInstance() {
        return instance;
    }

    public void initialize(CIMOMHandle cimom) throws CIMException {
        String METHOD = "initialize";
        Trace.methodBegin((Object)this, (String)METHOD);
        this.cimom = cimom;
        RequestBroker.getInstance().initialize(cimom);
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole) throws CIMException {
        try {
            this.refreshObjects(resultClass, objectName);
            return RequestBroker.getInstance().associatorNames(assocName, objectName, resultClass, role, resultRole);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"RouteAgent.associatorNames exception", (Throwable)e);
            throw new CIMException(e.toString());
        }
    }

    public CIMInstance[] associators(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            this.refreshObjects(resultClass, objectName);
            return RequestBroker.getInstance().associators(assocName, objectName, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"RouteAgent.associators exception", (Throwable)e);
            throw new CIMException(e.toString());
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath assocName, CIMObjectPath objectName, String role) throws CIMException {
        try {
            return RequestBroker.getInstance().referenceNames(assocName, objectName, role);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"RouteAgent.cleanup exception", (Throwable)e);
            throw new CIMException(e.toString());
        }
    }

    public CIMInstance[] references(CIMObjectPath assocName, CIMObjectPath objectName, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            return RequestBroker.getInstance().references(assocName, objectName, role, includeQualifiers, includeClassOrigin, propertyList);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"RouteAgent.references exception", (Throwable)e);
            throw new CIMException(e.toString());
        }
    }

    public void activateFilter(CIMInstance cIMInstance, CIMInstance cIMInstance1, CIMInstance cIMInstance2, String[] str, CIMObjectPath[] op, String[] str5) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void authorizeFilter(CIMInstance cIMInstance, CIMInstance cIMInstance1, CIMInstance cIMInstance2, String[] str, CIMObjectPath[] op, String[] str5) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deActivateFilter(CIMInstance cIMInstance, CIMInstance cIMInstance1, CIMInstance cIMInstance2, String[] str, CIMObjectPath[] op, String[] str5) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public boolean[] mustPoll(CIMInstance cIMInstance, CIMInstance cIMInstance1, CIMInstance cIMInstance2, String[] str, CIMObjectPath[] op, String[] str5) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        return ModifyBroker.getInstance().createInstance(op, ci);
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        ModifyBroker.getInstance().deleteInstance(op);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        try {
            this.refreshObjects(op.getClass().getName(), op);
            return RequestBroker.getInstance().enumerateInstanceNames(op, cc);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"RouteAgent.enumerateInstanceNames exception", (Throwable)e);
            throw new CIMException(e.toString());
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        try {
            this.refreshObjects(op.getClass().getName(), op);
            return RequestBroker.getInstance().enumerateInstances(op, localOnly, includeQualifiers, includeClassOrigin, propertyList, cc);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"RouteAgent.enumerateInstances exception", (Throwable)e);
            throw new CIMException(e.toString());
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String str, String str2, CIMClass cc) throws CIMException {
        this.refreshObjects(op.getClass().getName(), op);
        if (cc.getName().equals("SunStorEdge_DSPStorageVolume") && str != null && str.length() >= 63 && str.substring(43, 62).equals("where ElementName =")) {
            return this.fastVolumeFind(op, str, str2, cc);
        }
        CIMInstance[] possibles = this.enumerateInstances(op, false, true, true, null, cc);
        CIMInstance[] forReturn = null;
        if (possibles != null && possibles.length > 0) {
            int len = possibles.length;
            forReturn = new CIMInstance[len + 1];
            System.arraycopy(possibles, 0, forReturn, 1, len);
            forReturn[0] = null;
        }
        return forReturn;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        try {
            this.refreshObjects(op.getClass().getName(), op);
            return RequestBroker.getInstance().getInstance(op, localOnly, includeQualifiers, includeClassOrigin, propertyList, cc);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"RouteAgent.getInstace exception", (Throwable)e);
            throw new CIMException(e.toString());
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        ModifyBroker.getInstance().setInstance(op, ci, includeQualifiers, propertyList);
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, CIMArgument[] inParams, CIMArgument[] outParams) throws CIMException {
        return ModifyBroker.getInstance().invokeMethod(op, methodName, inParams, outParams);
    }

    public void refreshObjects(String resultClass, CIMObjectPath objPath) {
        String METHOD = "refreshObjects";
        String hostname = RequestBroker.getInstance().getHostName(objPath);
        if (resultClass != null) {
            if (resultClass.equalsIgnoreCase("SunStorEdge_DSPEthernetPortStatistics") || resultClass.equalsIgnoreCase("SunStorEdge_DSPEthernetPort")) {
                long currentTime = System.currentTimeMillis();
                if (this.lastEPReload == 0L || currentTime - this.lastEPReload > 5000L) {
                    Trace.verbose((Object)this, (String)"refreshObjects", (String)"Reloading eports.xml.");
                    RequestBroker.getInstance().reloadCachePage(ArrayInventory.getInstance().getArrayObject(hostname), "eports.xml");
                    this.lastEPReload = currentTime;
                    return;
                }
            } else if (resultClass.equalsIgnoreCase("SunStorEdge_DSPFCPortStatistics") || resultClass.equalsIgnoreCase("SunStorEdge_DSPFCPort")) {
                long currentTime = System.currentTimeMillis();
                if (this.lastFCReload == 0L || currentTime - this.lastFCReload > 5000L) {
                    Trace.verbose((Object)this, (String)"refreshObjects", (String)"Reloading fcports.xml.");
                    RequestBroker.getInstance().reloadCachePage(ArrayInventory.getInstance().getArrayObject(hostname), "fcports.xml");
                    this.lastFCReload = currentTime;
                    return;
                }
            }
        }
    }

    public CIMInstance[] fastVolumeFind(CIMObjectPath op, String str, String str2, CIMClass cc) throws CIMException {
        String METHOD = "fastVolumeFind";
        Trace.methodBegin((Object)this, (String)"fastVolumeFind");
        try {
            return RequestBroker.getInstance().fastVolumeFind(op, str, str2, cc);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"RouteAgent.fastVolumeFind exception", (Throwable)e);
            throw new CIMException(e.toString());
        }
    }
}

