/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayInventory;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMCacheEvent;
import com.sun.netstorage.dsp.mgmt.se6920.CIMInstanceCache;
import com.sun.netstorage.dsp.mgmt.se6920.CIMUtils;
import com.sun.netstorage.dsp.mgmt.se6920.CacheAddr;
import com.sun.netstorage.dsp.mgmt.se6920.Constants;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspPage;
import com.sun.netstorage.dsp.mgmt.se6920.IndicationListener;
import com.sun.netstorage.dsp.mgmt.se6920.InstanceFormer;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyBroker;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool;
import com.sun.netstorage.dsp.mgmt.se6920.ObjectPath;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import com.sun.netstorage.dsp.mgmt.se6920.Uploader;
import com.sun.netstorage.dsp.mgmt.se6920.licensing.LicenseDispatcher;
import com.sun.netstorage.dsp.mgmt.se6920.utils.StorEdge_AssociationProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class RequestBroker
extends StorEdge_AssociationProvider
implements Constants {
    private static final int LOGIN_SLEEP_INTERVAL = 5000;
    private static final int LOGIN_WAIT_INTERVAL = 30000;
    private static final int CACHE_WAIT_INTERVAL = 60000;
    private static final int SLEEP_FIVE_SECONDS = 5000;
    private static int numberOfSleeps = 1;
    private static CIMInstanceCache devCache = new CIMInstanceCache();
    private static IndicationListener cacheListener = null;
    private static Map synCache = Collections.synchronizedMap(new HashMap());
    private static final String PROPS = "__T4_PROPERTIES__";
    private static final String FILENAME = "dataFile";
    private static String fileName = "cim.htm";
    private static final String OS_FILENAME = "osInfoFile";
    private String osFileName = "osinfo.htm";
    private static RequestBroker singleton = new RequestBroker();
    private static boolean initialized = false;
    public static final String T4_DATA_FILE = "__LOCAL_DATA_FILE__";
    private static final String CLASSNAME = "RequestBroker";
    private static final String sccs_id = "@(#)RequestBroker.java    1.41    05/07/20   SMI";
    static /* synthetic */ Class class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker;

    private RequestBroker() {
        cacheListener = new IndicationListener(devCache);
    }

    public String getClassName() {
        return "SunStorEdge_DSPProvider";
    }

    public void invalidateCache(ArrayObject device) {
        this.invalidateCache(device, null);
    }

    public void invalidateCache(ArrayObject device, String[] classes) {
        String METHOD = "invalidateCache";
        Trace.info((Object)this, (String)"invalidateCache", (String)" entered ");
        if (null == device) {
            Trace.info((Object)this, (String)"invalidateCache", (String)"   null device passed in - done ");
            return;
        }
        boolean notDone = true;
        while (notDone) {
            if (ModifyBroker.setCacheUpdateOwner("RequestBroker.invalidateCache")) {
                Trace.info((Object)this, (String)"invalidateCache", (String)("Invalidating cache for: " + device));
                try {
                    device.cacheRefreshed();
                    RequestBroker.getAllDeviceInstances(device);
                    ModifySunStorEdge_DSPStoragePool.updatePoolSizes();
                    notDone = false;
                    SunStorEdge_DSPPersistenceManager persistMgr = SunStorEdge_DSPPersistenceManager.getInstance();
                    persistMgr.updateProviderVersion();
                }
                catch (Exception badThing) {
                    Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)" Refresh after cache invalidation failed!", (Throwable)badThing);
                    Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"invalidateCache", (String)" Retrying cache refresh");
                }
                ModifyBroker.clearCacheUpdateOwner(false, false);
                continue;
            }
            Trace.info((Object)this, (String)"invalidateCache", (String)" Sleeping before retrying lock ");
            try {
                Thread.sleep(5000 * numberOfSleeps);
            }
            catch (InterruptedException iex) {
                Trace.warn((Object)this, (String)"invalidateCache", (String)" Interrupted sleep ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List reloadCachePage(ArrayObject dsp, String url) {
        String METHOD = "reloadCachePage";
        Trace.info((Object)this, (String)"reloadCachePage", (String)" entered ");
        List deviceList = null;
        boolean notDone = true;
        boolean failed = false;
        int MAX_ATTEMPTS = 5;
        int attempts = 1;
        while (notDone) {
            failed = false;
            if (ModifyBroker.setCacheUpdateOwner("RequestBroker.reloadCachePage")) {
                try {
                    Trace.info((Object)this, (String)"reloadCachePage", (String)("Reloading: " + url));
                    deviceList = InstanceFormer.parseXml(DevComm.getInstance().get(dsp, url));
                    if ((url.startsWith("volume") || url.startsWith("lmcreate")) && !RequestBroker.isValidData(deviceList)) {
                        Trace.error((Object)this, (String)"reloadCachePage", (String)"reloadCachePage: Corrupted data returned from DSP. Invalidating cache.");
                        this.invalidateCache(dsp);
                        notDone = false;
                        continue;
                    }
                    CIMInstance[] cims = null;
                    cims = deviceList.toArray(new CIMInstance[0]);
                    RequestBroker.getDevCache().addAll(dsp, cims);
                    Trace.info((Object)this, (String)"reloadCachePage", (String)("reloadCachePage: Added updated device info to cache. " + cims.length + " instances"));
                }
                catch (Exception e) {
                    Trace.error((Object)this, (String)"reloadCachePage", (String)("Error reloading page: " + url + "\n" + e.getMessage()));
                    if (++attempts < 5) {
                        Trace.error((Object)this, (String)"reloadCachePage", (String)("Retrying request: " + url + " attempt #: " + attempts + "\n"));
                        notDone = true;
                        failed = true;
                    } else {
                        Trace.error((Object)this, (String)"reloadCachePage", (String)"Already retried 5 times, giving up!!");
                    }
                }
                finally {
                    ModifyBroker.clearCacheUpdateOwner(false, false);
                    continue;
                }
                if (failed) continue;
                notDone = false;
                continue;
            }
            Trace.info((Object)this, (String)"reloadCachePage", (String)" Sleeping before retrying lock ");
            try {
                Thread.sleep(5000 * numberOfSleeps);
            }
            catch (InterruptedException iex) {
                Trace.warn((Object)this, (String)"reloadCachePage", (String)" Interrupted sleep ");
            }
        }
        return deviceList;
    }

    public static RequestBroker getInstance() {
        return singleton;
    }

    void addArray(ArrayObject ao) {
        CIMInstance cluster = RequestBroker.getClusterInstance(ao);
        String METHOD = "addArray";
        if (null == cluster) {
            cluster = RequestBroker.createCluster(ao, 12, null);
            devCache.addArray(ao, cluster);
            ao.initialLogin();
            String hostname = ao.getHost();
            long startTime = System.currentTimeMillis();
            long currentTime = System.currentTimeMillis();
            while (currentTime - startTime < 30000L && !ao.isLoggedIn()) {
                try {
                    Trace.info((Object)this, (String)"addArray", (String)(" Sleeping while waiting for " + hostname + " login request to complete"));
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Trace.info((Object)this, (String)"addArray", (String)" Received InterruptedException");
                }
                currentTime = System.currentTimeMillis();
            }
            if (ao.isLoggedIn()) {
                Trace.info((Object)this, (String)"addArray", (String)(" Logged in to " + hostname));
            } else {
                Trace.error((Object)this, (String)"addArray", (String)(" Logged in to " + hostname));
            }
            startTime = System.currentTimeMillis();
            currentTime = System.currentTimeMillis();
            while (currentTime - startTime < 60000L && !ao.isCacheInitialized()) {
                try {
                    Trace.info((Object)this, (String)"addArray", (String)(" Sleeping while waiting for " + hostname + " cache initialization to complete"));
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Trace.info((Object)this, (String)"addArray", (String)" Received InterruptedException");
                }
                currentTime = System.currentTimeMillis();
            }
            if (ao.isCacheInitialized()) {
                Trace.info((Object)this, (String)"addArray", (String)(" " + hostname + " cache initialized"));
            } else {
                Trace.error((Object)this, (String)"addArray", (String)(" " + hostname + " cache NOT initialized"));
            }
        }
    }

    void removeArray(ArrayObject ao) {
        devCache.removeArray(ao);
        ao.logout(false);
        ao.endRefreshThread();
    }

    private static List getDeviceInstances(ArrayObject ao, String[] classes) {
        ArrayList<CIMInstance> deviceInstances;
        block25: {
            String METHOD = "getDeviceInstances";
            deviceInstances = new ArrayList<CIMInstance>();
            boolean retry = false;
            try {
                CIMInstance cluster = RequestBroker.getClusterInstance(ao);
                if (null == cluster) {
                    cluster = RequestBroker.createCluster(ao, 12, null);
                    deviceInstances.add(cluster);
                    devCache.addArray(ao, cluster);
                    break block25;
                }
                do {
                    try {
                        Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)("ABOUT TO READ DEV :" + fileName));
                        if (null != classes) {
                            Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)"Getting specific instances :");
                            for (int i = 0; i < classes.length; ++i) {
                                Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)("inst:" + classes[i]));
                            }
                        } else {
                            Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)"Getting all Instances :");
                        }
                        deviceInstances.addAll(InstanceFormer.parseXml(DevComm.getInstance().get(ao, fileName)));
                        Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)("DONE READING DEV inst count: " + deviceInstances.size()));
                        CIMInstance[] cims = null;
                        try {
                            cims = deviceInstances.toArray(new CIMInstance[0]);
                            devCache.addArrayWithInstances(ao, cims);
                        }
                        catch (ClassCastException e) {
                            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"Can not get CIMInstances.", (Throwable)e);
                        }
                        retry = false;
                    }
                    catch (StorEdgeIOException ex) {
                        Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)("IOException communicating to T4: " + ex.getMessage()));
                        int code = ex.getType();
                        if (code == 0) {
                            deviceInstances.clear();
                            Vector v = (Vector)CIMUtils.getPropertyValue(cluster, "OperationalStatus");
                            boolean lostComm = false;
                            boolean modify = true;
                            if (null != v) {
                                UnsignedInt16 status = (UnsignedInt16)v.elementAt(0);
                                if (null != status && (status.intValue() == 2 || status.intValue() == 13)) {
                                    lostComm = true;
                                } else if (null != status && (status.intValue() == 11 || status.intValue() == 15 || status.intValue() == 1)) {
                                    Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)("new status = " + status.intValue()));
                                    modify = false;
                                }
                            }
                            if (!modify) continue;
                            if (lostComm) {
                                deviceInstances.add(RequestBroker.modifyCluster(cluster, 13, null));
                                continue;
                            }
                            deviceInstances.add(RequestBroker.modifyCluster(cluster, 12, null));
                            continue;
                        }
                        if (code == 2) {
                            deviceInstances.add(RequestBroker.modifyCluster(cluster, 11, null));
                            continue;
                        }
                        if (code != 1) continue;
                        if (!ao.permitUpload()) {
                            deviceInstances.add(RequestBroker.modifyCluster(cluster, 16, null));
                            break;
                        }
                        try {
                            FileInputStream file = new FileInputStream(T4_DATA_FILE);
                            if (file != null) {
                                Uploader.upload(ao, file, fileName);
                            } else {
                                Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)"Unable to find local data file while trying to upload.");
                            }
                            if (retry) {
                                deviceInstances.add(RequestBroker.modifyCluster(cluster, 16, null));
                                retry = false;
                                continue;
                            }
                            retry = true;
                        }
                        catch (IOException ioe) {
                            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"Failure uploading latest data file: ", (Throwable)ioe);
                            deviceInstances.add(RequestBroker.modifyCluster(cluster, 16, null));
                        }
                    }
                    catch (Exception e) {
                        UnsignedInt16 status;
                        Vector v = (Vector)CIMUtils.getPropertyValue(cluster, "OperationalStatus");
                        if (null == v || null != (status = (UnsignedInt16)v.elementAt(0)) && (null == status || status.intValue() == 15)) continue;
                        Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"Could not fetching T4 Data", (Throwable)e);
                        deviceInstances.add(RequestBroker.modifyCluster(cluster, 12, null));
                    }
                } while (retry);
            }
            catch (Exception ex) {
                Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker = RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker")) : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"Exception", (Throwable)ex);
            }
        }
        return deviceInstances;
    }

    public static List getAllDeviceInstances(ArrayObject ao) {
        ArrayList<CIMInstance> deviceInstances;
        block27: {
            String METHOD = "getAllDeviceInstances";
            deviceInstances = new ArrayList<CIMInstance>();
            DspPage[] pageArray = DspPage.getDspInitialPages();
            int arraySize = pageArray.length;
            boolean retry = false;
            try {
                CIMInstance cluster = RequestBroker.getClusterInstance(ao);
                if (null == cluster) {
                    cluster = RequestBroker.createCluster(ao, 12, null);
                    deviceInstances.add(cluster);
                    devCache.addArray(ao, cluster);
                    break block27;
                }
                do {
                    try {
                        Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)("ABOUT TO READ DEV :" + fileName));
                        Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)"Getting all Instances :");
                        for (int i = 0; i < arraySize; ++i) {
                            String xmlFile = pageArray[i].toString();
                            if (xmlFile.startsWith("volume") || xmlFile.startsWith("lmcreate")) {
                                List devList = InstanceFormer.parseXml(DevComm.getInstance().get(ao, xmlFile));
                                if (!RequestBroker.isValidData(devList)) {
                                    Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker = RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker")) : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)"Corrupted data returned from DSP. ");
                                    CIMInstance[] cims = new CIMInstance[]{new CIMInstance()};
                                    devCache.addArrayWithInstances(ao, cims);
                                    CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                                    tmpe.setDescription("Internal error: Corrupted DSP cache data");
                                    throw tmpe;
                                }
                                deviceInstances.addAll(devList);
                                continue;
                            }
                            deviceInstances.addAll(InstanceFormer.parseXml(DevComm.getInstance().get(ao, xmlFile)));
                        }
                        Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)("DONE READING DEV inst count: " + deviceInstances.size()));
                        CIMInstance[] cims = null;
                        try {
                            cims = deviceInstances.toArray(new CIMInstance[0]);
                            devCache.addArrayWithInstances(ao, cims);
                        }
                        catch (ClassCastException e) {
                            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"Can not get CIMInstances.", (Throwable)e);
                        }
                        retry = false;
                    }
                    catch (StorEdgeIOException ex) {
                        Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)("IOException communicating to DSP: " + ex.getMessage()));
                        int code = ex.getType();
                        if (code == 0) {
                            deviceInstances.clear();
                            Vector v = (Vector)CIMUtils.getPropertyValue(cluster, "OperationalStatus");
                            boolean lostComm = false;
                            boolean modify = true;
                            if (null != v) {
                                UnsignedInt16 status = (UnsignedInt16)v.elementAt(0);
                                if (null != status && (status.intValue() == 2 || status.intValue() == 13)) {
                                    lostComm = true;
                                } else if (null != status && (status.intValue() == 11 || status.intValue() == 15 || status.intValue() == 1)) {
                                    Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)("new status = " + status.intValue()));
                                    modify = false;
                                }
                            }
                            if (!modify) continue;
                            if (lostComm) {
                                deviceInstances.add(RequestBroker.modifyCluster(cluster, 13, null));
                                continue;
                            }
                            deviceInstances.add(RequestBroker.modifyCluster(cluster, 12, null));
                            continue;
                        }
                        if (code == 2) {
                            deviceInstances.add(RequestBroker.modifyCluster(cluster, 11, null));
                            continue;
                        }
                        if (code != 1) continue;
                        if (!ao.permitUpload()) {
                            deviceInstances.add(RequestBroker.modifyCluster(cluster, 16, null));
                            break;
                        }
                        try {
                            FileInputStream file = new FileInputStream(T4_DATA_FILE);
                            if (file != null) {
                                Uploader.upload(ao, file, fileName);
                            } else {
                                Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)"Unable to find local data file while trying to upload.");
                            }
                            if (retry) {
                                deviceInstances.add(RequestBroker.modifyCluster(cluster, 16, null));
                                retry = false;
                                continue;
                            }
                            retry = true;
                        }
                        catch (IOException ioe) {
                            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"Failure uploading latest data file: ", (Throwable)ioe);
                            deviceInstances.add(RequestBroker.modifyCluster(cluster, 16, null));
                        }
                    }
                    catch (CIMException cime) {
                        throw cime;
                    }
                    catch (Exception e) {
                        UnsignedInt16 status;
                        Vector v = (Vector)CIMUtils.getPropertyValue(cluster, "OperationalStatus");
                        if (null == v || null != (status = (UnsignedInt16)v.elementAt(0)) && (null == status || status.intValue() == 15)) continue;
                        Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"Could not retrieve all DSP XML Files ", (Throwable)e);
                        deviceInstances.add(RequestBroker.modifyCluster(cluster, 12, null));
                    }
                } while (retry);
            }
            catch (CIMException cime) {
                return null;
            }
            catch (Exception ex) {
                Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker = RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker")) : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"", (Throwable)ex);
            }
        }
        return deviceInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List copyUnmodifiedInstances(ArrayObject ao, List newList, String[] skipClasses) {
        List<String> skip = Arrays.asList(skipClasses);
        CIMInstance[] cims = devCache.enumerate(ao);
        if (null != cims) {
            List list = newList;
            synchronized (list) {
                for (int i = 0; i < cims.length; ++i) {
                    if (skip.contains(cims[i].getClassName())) continue;
                    newList.add(cims[i]);
                }
            }
        }
        return newList;
    }

    private static CIMInstance createCluster(ArrayObject ao, int status, String otherStatDesc) {
        CIMObjectPath cop = new CIMObjectPath("SunStorEdge_DSPStorageSystem", "\\root\\se6x20\\");
        CIMInstance cluster = null;
        try {
            CIMClass clusterClass = SunStorEdge_DSPProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
            cluster = clusterClass.newInstance();
            cluster.setProperty("Name", new CIMValue((Object)ao.getHost()));
            cluster = RequestBroker.modifyCluster(cluster, status, otherStatDesc);
        }
        catch (Exception ex) {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker = RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker")) : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"", (Throwable)ex);
        }
        return cluster;
    }

    private static CIMInstance modifyCluster(CIMInstance cluster, int status, String otherStatDesc) {
        String METHOD = "modifyCluster";
        try {
            Vector<Object> data = new Vector<Object>();
            data.add(new UnsignedInt16(status));
            CIMValue val = new CIMValue(data, new CIMDataType(16));
            cluster.setProperty("OperationalStatus", val);
            if (null != otherStatDesc) {
                data = new Vector();
                data.add(otherStatDesc);
                cluster.setProperty("OtherStatusDescriptions", new CIMValue(data, new CIMDataType(22)));
            }
        }
        catch (CIMException ce) {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker = RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker")) : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)METHOD, (String)"Set property operation failed.");
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker = RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker")) : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"RequestBroker.modifyCluster stack trace:", (Throwable)ce);
        }
        return cluster;
    }

    void setClusterOperationalStatus(ArrayObject ao, int status, String otherStatDesc) throws ArrayException {
        if (status != 15 && status != 11 && status != 1) {
            throw new ArrayException("Invalid OperationalStatus");
        }
        CIMInstance cluster = RequestBroker.createCluster(ao, status, otherStatDesc);
        devCache.addArray(ao, cluster);
    }

    private static CIMInstance getClusterInstance(ArrayObject ao) {
        CIMInstance[] tlos = devCache.enumerate(ao, "SunStorEdge_DSPStorageSystem");
        if (tlos == null || tlos.length == 0) {
            return null;
        }
        return tlos[0];
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        return this.enumerateInstanceNames(null, op, cc);
    }

    CIMObjectPath[] enumerateInstanceNames(String device, CIMObjectPath op, CIMClass cc) throws CIMException {
        return this.convertInstToObjectPath(this.enumerateInstances(device, op, false, true, false, null, cc));
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        return this.enumerateInstances((ArrayObject)null, op, localOnly, includeQualifier, includeClassOrigin, propertyList, cc);
    }

    CIMInstance[] enumerateInstances(String device, CIMObjectPath op, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        return this.enumerateInstances(ArrayInventory.getInstance().getArrayObject(device), op, localOnly, includeQualifier, includeClassOrigin, propertyList, cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CIMInstance[] enumerateInstances(ArrayObject device, CIMObjectPath op, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        Object iter;
        String METHOD = "enumerateInstances";
        ArrayList<Object> ret = null;
        if (op != null && "StorEdge_DSPOperatingSystem".equals(op.getObjectName())) {
            ret = new ArrayList();
            if (device == null) {
                ArrayList allArrays = ArrayInventory.getInstance().getArrayInventory();
                iter = allArrays.iterator();
                while (iter.hasNext()) {
                    ArrayObject array = (ArrayObject)iter.next();
                    ret.addAll(this.refreshOperatingSystemInstance(array));
                    Trace.info((Object)this, (String)"enumerateInstances", (String)(": Refreshed OperatingSystem instance for the array: " + array.getHost()));
                }
            } else {
                ret = this.refreshOperatingSystemInstance(device);
                Trace.info((Object)this, (String)"enumerateInstances", (String)(": Refreshed OperatingSystem instance for the array: " + device.getHost()));
            }
        } else {
            CIMInstance[] cims = devCache.enumerate(device, op);
            ret = null != cims ? new ArrayList<CIMInstance>(Arrays.asList(cims)) : new ArrayList();
            if (!op.getObjectName().equals("SunStorEdge_DSPStorageVolume")) {
                iter = synCache;
                synchronized (iter) {
                    Iterator synIT = synCache.values().iterator();
                    while (synIT.hasNext()) {
                        CIMInstance inst = (CIMInstance)synIT.next();
                        if (!inst.getClassName().equals(op.getObjectName())) continue;
                        ret.add(inst);
                    }
                }
            }
        }
        if (LicenseDispatcher.isLicenseClass(op)) {
            return LicenseDispatcher.enumerateInstances(op, cc);
        }
        if (ret.isEmpty()) {
            return null;
        }
        CIMInstance curInst = null;
        ArrayList<CIMInstance> newRet = new ArrayList<CIMInstance>();
        ListIterator retIt = ret.listIterator();
        while (retIt.hasNext()) {
            curInst = (CIMInstance)retIt.next();
            if ((curInst = this.filterProperties(curInst, propertyList, localOnly, includeQualifier, includeClassOrigin)) == null) continue;
            CIMObjectPath curOp = new CIMObjectPath();
            curOp.setObjectName(op.getObjectName());
            curOp.setNameSpace("\\root\\se6x20\\");
            curOp.setHost(op.getHost());
            Vector keyVals = curInst.getKeys();
            for (int i = 0; i < keyVals.size(); ++i) {
                curOp.addKey((CIMProperty)keyVals.get(i));
            }
            curInst.setObjectPath(curOp);
            newRet.add(curInst);
        }
        return newRet.toArray(new CIMInstance[0]);
    }

    public String getHostName(CIMObjectPath op) {
        CacheAddr addr = devCache.getCacheAddr(op);
        if (addr == null || addr.getArray() == null) {
            return null;
        }
        return addr.getArray().getHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSyntheticCacheInstance(CIMInstance inst) {
        CIMObjectPath op = inst.getObjectPath();
        ModifyBroker modifyBroker = ModifyBroker.getInstance();
        synchronized (modifyBroker) {
            synCache.put(new ObjectPath(op), inst);
        }
        ArrayList arrayInv = ArrayInventory.getInstance().getArrayInventory();
        CIMCacheEvent addEvent = new CIMCacheEvent(4, RequestBroker.getDevCache(), (ArrayObject)arrayInv.get(0));
        addEvent.addInstance(inst);
        addEvent.addObjectPath(inst.getObjectPath());
        RequestBroker.getDevCache().postEvent(addEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSyntheticCacheInstance(CIMObjectPath op, CIMInstance inst) {
        ModifyBroker modifyBroker = ModifyBroker.getInstance();
        synchronized (modifyBroker) {
            synCache.put(new ObjectPath(op), inst);
        }
        ArrayList arrayInv = ArrayInventory.getInstance().getArrayInventory();
        CIMCacheEvent addEvent = new CIMCacheEvent(4, RequestBroker.getDevCache(), (ArrayObject)arrayInv.get(0));
        addEvent.addInstance(inst);
        addEvent.addObjectPath(op);
        RequestBroker.getDevCache().postEvent(addEvent);
    }

    Object deleteSyntheticCacheInstance(CIMObjectPath op) {
        Object o;
        CIMInstance cacheInst = this.getInstanceFromSynCache(op);
        if (cacheInst != null) {
            CIMInstance delInst = (CIMInstance)this.getInstanceFromSynCache(op).clone();
            o = synCache.remove(new ObjectPath(op));
            ArrayList arrayInv = ArrayInventory.getInstance().getArrayInventory();
            CIMCacheEvent addEvent = new CIMCacheEvent(5, RequestBroker.getDevCache(), (ArrayObject)arrayInv.get(0));
            addEvent.addInstance(delInst);
            addEvent.addObjectPath(op);
            RequestBroker.getDevCache().postEvent(addEvent);
        } else {
            o = synCache.remove(new ObjectPath(op));
        }
        return o;
    }

    CIMInstance getCacheInstance(CIMObjectPath op) {
        return this.findInstance(op);
    }

    public static CIMInstanceCache getDevCache() {
        return devCache;
    }

    public static Map getSynCache() {
        return synCache;
    }

    boolean isSyntheticCacheInstance(CIMObjectPath op) {
        return synCache.containsKey(new ObjectPath(op));
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        CIMInstance inst = this.findInstance(op);
        if (inst == null && LicenseDispatcher.isLicenseClass(op)) {
            inst = LicenseDispatcher.getInstance(op, cc);
        }
        if (null != inst && (inst = this.filterProperties(inst, propertyList, localOnly, includeQualifier, includeClassOrigin)) != null) {
            CIMObjectPath curOp = new CIMObjectPath();
            curOp.setObjectName(op.getObjectName());
            curOp.setNameSpace("\\root\\se6x20\\");
            curOp.setHost(op.getHost());
            Vector keyVals = inst.getKeys();
            for (int i = 0; i < keyVals.size(); ++i) {
                curOp.addKey((CIMProperty)keyVals.get(i));
            }
            inst.setObjectPath(curOp);
        }
        return inst;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.getInstance(op, localOnly, includeQualifier, includeClassOrigin, propertyList, null);
    }

    CIMInstance filterProperties(CIMInstance inst, String[] propertyList, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin) {
        String METHOD = "filterProperties";
        if (localOnly) {
            inst = inst.localElements();
        }
        return inst.filterProperties(propertyList, includeQualifier, includeClassOrigin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CIMInstance getInstanceFromSynCache(CIMObjectPath op) {
        CIMInstance ci = null;
        Map map = synCache;
        synchronized (map) {
            Iterator synIT = synCache.values().iterator();
            while (synIT.hasNext()) {
                CIMInstance inst = (CIMInstance)synIT.next();
                if (!ObjectPath.objectPathsAreEqual(op, inst.getObjectPath())) continue;
                ci = inst;
                break;
            }
        }
        return ci;
    }

    public CIMInstance findInstance(CIMObjectPath op) {
        String METHOD = "findInstance";
        CIMInstance ci = null;
        if (op != null && "StorEdge_DSPOperatingSystem".equals(op.getObjectName())) {
            Vector keys = op.getKeys();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                CIMProperty key = (CIMProperty)iter.next();
                if (!"CSName".equals(key.getName()) || key.getValue() == null) continue;
                String device = (String)key.getValue().getValue();
                ArrayList osInstances = this.refreshOperatingSystemInstance(ArrayInventory.getInstance().getArrayObject(device));
                Trace.info((Object)this, (String)"findInstance", (String)(": Refreshed OperatingSystem instance for the array: " + device));
                if (!osInstances.isEmpty()) {
                    ci = (CIMInstance)osInstances.get(0);
                }
                break;
            }
        } else {
            ci = (CIMInstance)synCache.get(new ObjectPath(op));
            if (null == ci) {
                ci = devCache.getLiveInstance(op);
            }
        }
        return ci;
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        if (this.isSyntheticCacheInstance(op)) {
            this.deleteSyntheticCacheInstance(op);
            return;
        }
        devCache.remove(op);
    }

    public CIMInstance[] references(CIMObjectPath assocName, CIMObjectPath objectName, String role, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        ArrayList<CIMInstance> ret = new ArrayList<CIMInstance>();
        CIMInstance[] inst = this.enumerateInstances(assocName, false, includeQualifier, includeClassOrigin, null, null);
        if (null != inst && inst.length > 0) {
            for (int i = 0; i < inst.length; ++i) {
                if (null == inst[i]) continue;
                Vector props = inst[i].getProperties();
                Enumeration enum1 = props.elements();
                while (enum1.hasMoreElements()) {
                    CIMObjectPath pop;
                    CIMProperty p = (CIMProperty)enum1.nextElement();
                    if (!p.isReference() || !ObjectPath.objectPathsAreEqual(pop = (CIMObjectPath)p.getValue().getValue(), objectName) || role != null && !p.getName().equalsIgnoreCase(role)) continue;
                    ret.add(inst[i].filterProperties(propertyList, includeQualifier, includeClassOrigin));
                }
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new CIMInstance[0]);
    }

    public CIMInstance[] fastVolumeFind(CIMObjectPath op, String str, String str2, CIMClass cc) throws CIMException {
        String METHOD = "fastVolumeFind";
        Trace.methodBegin((Object)this, (String)"fastVolumeFind");
        String[] tokens = str.split(" ");
        StringBuffer name = null;
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals("=")) continue;
            name = new StringBuffer(tokens[i + 1]);
            break;
        }
        CIMInstance vol = null;
        if (name != null) {
            name.deleteCharAt(0);
            name.deleteCharAt(name.length() - 1);
            vol = devCache.findVolume(name.toString());
        }
        if (vol != null) {
            CIMInstance[] volInstances = new CIMInstance[]{vol};
            return volInstances;
        }
        return new CIMInstance[0];
    }

    CIMInstance findVolume(String volName) {
        String METHOD = "findVolume";
        CIMInstance ci = null;
        ci = devCache.findVolume(volName);
        return ci;
    }

    private CIMObjectPath[] convertInstToObjectPath(CIMInstance[] inst) {
        ArrayList<CIMObjectPath> ret = new ArrayList<CIMObjectPath>();
        if (null != inst) {
            for (int i = 0; i < inst.length; ++i) {
                ret.add(inst[i].getObjectPath());
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new CIMObjectPath[0]);
    }

    private ArrayList refreshOperatingSystemInstance(ArrayObject array) {
        ArrayList osList;
        block7: {
            String METHOD = "refreshOperatingSystemInstance";
            osList = null;
            try {
                osList = (ArrayList)InstanceFormer.parseXml(DevComm.getInstance().get(array, this.osFileName));
            }
            catch (StorEdgeIOException ioex) {
                Trace.error((Object)this, (String)(": StorEdgeIOException" + ioex.getMessage()), (Throwable)ioex);
                if (ioex.getType() != 1 || !array.permitUpload()) break block7;
                try {
                    FileInputStream file = new FileInputStream("__LOCAL_OS_INFO_FILE__");
                    if (file != null) {
                        Uploader.upload(array, file, this.osFileName);
                        osList = (ArrayList)InstanceFormer.parseXml(DevComm.getInstance().get(array, this.osFileName));
                    }
                    Trace.error((Object)this, (String)"refreshOperatingSystemInstance", (String)"Unable to find osinfo.htm file to upload.");
                }
                catch (Exception ex) {
                    Trace.error((Object)this, (String)(": ERROR: Uploading " + this.osFileName), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                Trace.error((Object)this, (String)"refreshOperatingSystemInstance", (String)(": ERROR: Error retrieving " + this.osFileName));
            }
        }
        if (osList == null) {
            Trace.error((Object)this, (String)"refreshOperatingSystemInstance", (String)": ERROR: Discovery returned no OperatingSystem object.");
            osList = new ArrayList();
        }
        return osList;
    }

    private static boolean isValidData(List cimlist) {
        String METHOD = "isValidData";
        for (int k = cimlist.size() - 1; k >= 0; --k) {
            CIMValue devIdVal;
            int i;
            String devId;
            CIMProperty[] cp;
            CIMObjectPath extPath;
            CIMInstance inst = (CIMInstance)cimlist.get(k);
            String cimClass = inst.getClassName();
            if (cimClass.equalsIgnoreCase("SunStorEdge_DSPBasedOn") || cimClass.equalsIgnoreCase("SunStorEdge_DSPMetaBasedOn")) {
                extPath = (CIMObjectPath)inst.getProperty("Antecedent").getValue().getValue();
                cp = extPath.getKeys().toArray(new CIMProperty[0]);
                devId = null;
                for (i = 0; i < cp.length; ++i) {
                    if (!cp[i].getName().equals("DeviceID")) continue;
                    devIdVal = cp[i].getValue();
                    if (devIdVal == null) break;
                    devId = (String)cp[i].getValue().getValue();
                    break;
                }
                if (devId == null || devId.length() == 0) {
                    Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"isValidData", (String)(" Null DeviceID in Antecedent ref of " + cimClass));
                    Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"isValidData", (String)("Removing " + cimClass + " from list"));
                    cimlist.remove(k);
                } else if (devId.equalsIgnoreCase("00000000000000000000000000000000")) {
                    Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"isValidData", (String)(" Zero DeviceID WWN in Antecedent ref of " + cimClass));
                    Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"isValidData", (String)("Removing " + cimClass + " from list"));
                    cimlist.remove(k);
                }
            }
            if (!cimClass.equalsIgnoreCase("SunStorEdge_DSPReplicationQueue")) continue;
            extPath = (CIMObjectPath)inst.getProperty("Dependent").getValue().getValue();
            cp = extPath.getKeys().toArray(new CIMProperty[0]);
            devId = null;
            for (i = 0; i < cp.length; ++i) {
                if (!cp[i].getName().equals("DeviceID")) continue;
                devIdVal = cp[i].getValue();
                if (devIdVal == null) break;
                devId = (String)cp[i].getValue().getValue();
                break;
            }
            if (devId == null || devId.length() == 0) {
                Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"isValidData", (String)(" Null DeviceID in Queue ref of " + cimClass));
                Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"isValidData", (String)("Removing " + cimClass + " from list"));
                cimlist.remove(k);
                continue;
            }
            if (!devId.equalsIgnoreCase("00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00") && !devId.equalsIgnoreCase("00000000000000000000000000000000")) continue;
            Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"isValidData", (String)(" Zero DeviceID WWN in Queue ref of " + cimClass));
            Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker == null ? RequestBroker.class$("com.sun.netstorage.dsp.mgmt.se6920.RequestBroker") : class$com$sun$netstorage$dsp$mgmt$se6920$RequestBroker), (String)"isValidData", (String)("Removing " + cimClass + " from list"));
            cimlist.remove(k);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance[] searchCache(ArrayObject array, String trgClass) {
        CIMInstance[] inst = devCache.enumerate(array, trgClass);
        if (inst == null) {
            ArrayList<CIMInstance[]> list = new ArrayList<CIMInstance[]>();
            Map map = synCache;
            synchronized (map) {
                Iterator synIT = synCache.values().iterator();
                while (synIT.hasNext()) {
                    CIMInstance cinst = (CIMInstance)synIT.next();
                    if (!cinst.getClassName().equalsIgnoreCase(trgClass)) continue;
                    list.add(inst);
                }
            }
            if (!list.isEmpty()) {
                inst = list.toArray(new CIMInstance[0]);
            }
        }
        return inst == null || inst.length == 0 ? null : inst;
    }

    public void postEvent(CIMCacheEvent event) {
        devCache.postEvent(event);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

