/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

public class PsxProvider {
    String ipAddress = new String();
    int port = 0;

    public String toString() {
        return super.toString() + " at IP address " + this.getIpAddress() + " and port " + this.getPort();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    protected void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    public static void unitTest(PsxProvider psx, String ipAddress, int port) {
        System.out.println("\nStarting unit test");
        if (ipAddress != null) {
            System.out.println("\tSetting IP Address to " + ipAddress);
            psx.setIpAddress(ipAddress);
        } else {
            System.out.println("\tNo IP Address to set");
        }
        if (port != 0) {
            System.out.println("\tSetting port to " + port);
            psx.setPort(port);
        } else {
            System.out.println("\tNo port to set");
        }
        System.out.println("\nPsx provider attributes are set to " + psx);
    }

    public static void usage() {
        System.out.println("\n\n  Usage:  PsxProvider [-d][-g][-h hostIp][-p port][-u]");
        System.out.println("           -d: show debug messages\n");
        System.out.println("           -g: use graphic window\n");
        System.out.println("           -h: specify PSX IP address\n");
        System.out.println("           -p: specify PSX port\n");
        System.out.println("           -u: unit test\n");
        System.out.println("\n");
    }

    public static void main(String[] args) {
        PsxProvider psx = null;
        int currentArg = 0;
        boolean showDebug = false;
        String psxIp = null;
        int psxPort = 80;
        boolean useGraphics = false;
        boolean runUnitTest = false;
        if (args.length > 0) {
            System.out.println("\n\tProcessing arguments\n");
            while (currentArg < args.length) {
                if (args[currentArg].equals("-d")) {
                    System.out.println("\n\t\tDebugging messages enabled");
                    showDebug = true;
                    ++currentArg;
                    continue;
                }
                if (args[currentArg].equals("-g")) {
                    System.out.println("\n\t\tGraphical window enabled");
                    useGraphics = true;
                    ++currentArg;
                    continue;
                }
                if (args[currentArg].equals("-h")) {
                    if (currentArg + 1 < args.length) {
                        psxIp = new String(args[currentArg + 1]);
                        System.out.println("\n\t\tPSX address set to " + psxIp);
                        currentArg += 2;
                        continue;
                    }
                    System.out.println("\n\tMissing value for parameter -h\n\n");
                    PsxProvider.usage();
                    System.exit(1);
                    continue;
                }
                if (args[currentArg].equals("-p")) {
                    if (currentArg + 1 < args.length) {
                        psxPort = new Integer(args[currentArg + 1]);
                        System.out.println("\n\t\tPSX port set to " + psxPort);
                        currentArg += 2;
                        continue;
                    }
                    System.out.println("\n\tMissing value for parameter -p\n\n");
                    PsxProvider.usage();
                    System.exit(1);
                    continue;
                }
                if (args[currentArg].equals("-u")) {
                    System.out.println("\n\t\tUnit testing enabled\n");
                    runUnitTest = true;
                    ++currentArg;
                    continue;
                }
                System.out.println("\n\tInvalid arg: " + args[currentArg]);
                PsxProvider.usage();
                System.exit(1);
            }
        }
        if (psxIp == null) {
            PsxProvider.usage();
            System.out.println("\n\tNo IP address specified.  Exiting \n\n");
            System.exit(1);
        }
        System.out.print("\nCreating PSX provider ...");
        psx = new PsxProvider();
        if (runUnitTest) {
            PsxProvider.unitTest(psx, psxIp, psxPort);
        }
        System.out.println("\nDone! \n\n");
    }
}

