/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMUtils;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.UnsignedInt16;

public class ModifySunStorEdge_DSPStorageSettingWithHints
extends ModifyModule {
    private static String CLASSNAME = "ModifySunStorEdge_DSPStorageSettingWithHints";
    private static String SE_CLASS = "SunStorEdge_DSPStorageSettingWithHints";
    private static String ELEMENT_SETTING_CLASS = "SunStorEdge_DSPElementSettingData";
    private static String STORAGE_VOLUME_CLASS = "SunStorEdge_DSPStorageVolume";
    private static final String VOLUME_DEVICEID = "DeviceID";
    private static final String VOL_NAME_PROP = "ElementName";
    private static final String HINTS_NAME = "ElementName";
    private static final String HINTS_DESCRIPTION = "Description";
    private static final String HINTS_SNAPSHOT_POLICY = "SnapshotPolicy";
    private static final String HINTS_ROLLBACK_PRIORITY = "RollbackPriority";
    private static final String HINTS_RESYNC_PRIORITY = "ResyncPriority";
    private static String SETTING_DATA = "SettingData";
    private static String MANAGED_ELEMENT = "ManagedElement";
    private static final String CAPABILITES_INSTANCEID = "InstanceID";
    private static final String STORAGE_VOLUME_MODIFY_PAGE = "VVolExt2.htm";
    private static final String VOL_MOD_NAME = "samVolume_SetByWwn";
    private static final String VOL_MOD_SIZE = "Size";
    private static final String VOL_MOD_CONSIDER = "Con";
    private static final String VOL_MOD_FORCE = "For";
    private static final String VOL_MOD_EXCLUDE = "Exc";
    private static final String VOL_CR_SNAP = "Snap";
    private static final String VOL_SNAP_CR_COW = "COWCon";
    private static final String VOL_SNAP_CR_POLICY = "COWPolicy";
    private static final String VOL_MOD_RESILVER = "LmPriority";
    private static final int CIM_POLICY_FAVIOR_SNAP = 1;
    private static final int CIM_POLICY_FAVIOR_VOLUME = 0;
    private static final String POLICY_BLOCK = "block";
    private static final String POLICY_ALLOW = "allow";
    private static final int ROLLBACK_CIM_HIGH = 64;
    private static final int ROLLBACK_CIM_MEDIUM = 128;
    private static final int ROLLBACK_CIM_LOW = 192;
    private static final String ROLLBACK_PRIORITY_HIGH = "high";
    private static final String ROLLBACK_PRIORITY_MEDIUM = "medium";
    private static final String ROLLBACK_PRIORITY_LOW = "low";
    private static final int RESILVER_CIM_HIGH = 64;
    private static final int RESILVER_CIM_MEDIUM = 128;
    private static final int RESILVER_CIM_LOW = 192;
    private static final String RESILVER_PRIORITY_HIGH = "high";
    private static final String RESILVER_PRIORITY_MEDIUM = "medium";
    private static final String RESILVER_PRIORITY_LOW = "low";
    protected static String VOLUME_XML_PAGE = "volume.xml";
    static /* synthetic */ Class class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStorageSettingWithHints;

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        Trace.methodBegin((Object)this, (String)"handleRequest");
        DspResults results = null;
        String classname = request.getCIMClassName();
        if (!classname.equals(SE_CLASS)) {
            return false;
        }
        Vector tokens = new Vector();
        if (request instanceof SetRequest) {
            StringBuffer volWWNbuf = new StringBuffer();
            StringBuffer volNamebuf = new StringBuffer();
            StringBuffer snapSetbuf = new StringBuffer();
            StringBuffer resilverSetbuf = new StringBuffer();
            this.buildVolumeModifyParms((SetRequest)request, tokens, volWWNbuf, volNamebuf, snapSetbuf, resilverSetbuf);
            String page = new String(STORAGE_VOLUME_MODIFY_PAGE);
            results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
            this.parseVolumeModifyResults(results);
            SetRequest srequest = (SetRequest)request;
            if (volWWNbuf.length() != 0) {
                page = new String(VOLUME_XML_PAGE + "?samVolume_SetByWwn=" + DspUtil.unquote(volWWNbuf.toString()));
                RequestBroker.getInstance().reloadCachePage(this.getSystem(), page);
            }
            try {
                String[] logArgs = new String[]{volNamebuf.toString(), snapSetbuf.toString(), resilverSetbuf.toString()};
                String volSetMsg = results.requestSucceeded() ? "DSP_VOL_SETTINGS" : "DSP_VOL_SETTINGS_FAILED";
                LogAPI.staticLog((String)volSetMsg, (String[])logArgs, null);
            }
            catch (Exception logEx) {
                // empty catch block
            }
            return true;
        }
        if (request instanceof CreateRequest || request instanceof DeleteRequest || request instanceof InvokeRequest) {
            // empty if block
        }
        return false;
    }

    private void buildVolumeModifyParms(SetRequest request, Vector nvPairs, StringBuffer volwwnbuf, StringBuffer volName, StringBuffer snapSetting, StringBuffer resilverSetting) throws CIMException {
        int cimSnapPolicy;
        String METHOD = "buildVolumeModifyParams";
        Trace.methodBegin((Object)this, (String)"buildVolumeModifyParams");
        String volumeWwn = new String();
        CIMInstance instance = request.getInstance();
        CIMObjectPath settingPath = request.getObjectPath();
        settingPath.setNameSpace("\\root\\se6x20\\");
        CIMObjectPath elementSetting = new CIMObjectPath(ELEMENT_SETTING_CLASS);
        CIMInstance[] insts = RequestBroker.getInstance().associators(elementSetting, settingPath, STORAGE_VOLUME_CLASS, SETTING_DATA, MANAGED_ELEMENT, false, true, null);
        if (insts == null) {
            Trace.error((Object)this, (String)"buildVolumeModifyParams", (String)" No StorageVolume associated to DSPSettingWithHints");
            CIMException tmpe = new CIMException("CIM_ERR_FAILED");
            tmpe.setDescription(" No StorageVolume associated to DSPSettingWithHints");
            throw tmpe;
        }
        volumeWwn = DspUtil.unquote(CIMUtils.getPropertyValue(insts[0], VOLUME_DEVICEID).toString());
        volwwnbuf.append(volumeWwn);
        String setVolName = DspUtil.unquote((String)insts[0].getProperty("ElementName").getValue().getValue());
        volName.append(setVolName);
        String snapPolicy = new String(POLICY_ALLOW);
        UnsignedInt16 snapPolicyVal = (UnsignedInt16)CIMUtils.getPropertyValue(instance, HINTS_SNAPSHOT_POLICY);
        if (snapPolicyVal != null && (cimSnapPolicy = snapPolicyVal.intValue()) == 1) {
            snapPolicy = POLICY_BLOCK;
        }
        snapSetting.append(snapPolicy);
        String rollbackPriority = "medium";
        UnsignedInt16 rollbackVal = (UnsignedInt16)CIMUtils.getPropertyValue(instance, HINTS_ROLLBACK_PRIORITY);
        if (rollbackVal != null) {
            int rollbackInt = rollbackVal.intValue();
            if (rollbackInt == 64) {
                rollbackPriority = "high";
            } else if (rollbackInt == 128) {
                rollbackPriority = "medium";
            } else if (rollbackInt == 192) {
                rollbackPriority = "low";
            }
        }
        String resilverPriority = new String("medium");
        UnsignedInt16 resilverVal = (UnsignedInt16)CIMUtils.getPropertyValue(instance, HINTS_RESYNC_PRIORITY);
        if (resilverVal != null) {
            int resilverInt = resilverVal.intValue();
            resilverPriority = resilverInt == 64 ? "high" : (resilverInt == 128 ? "medium" : (resilverInt == 192 ? "low" : new String("")));
        }
        resilverSetting.append(resilverPriority);
        nvPairs.add(new String("samVolume_SetByWwn=" + volumeWwn));
        nvPairs.add(new String("Size="));
        nvPairs.add(new String("Con="));
        nvPairs.add(new String("For="));
        nvPairs.add(new String("Exc="));
        nvPairs.add(new String("Snap="));
        nvPairs.add(new String("COWCon="));
        nvPairs.add(new String("COWPolicy=" + snapPolicy));
        nvPairs.add(new String("LmPriority=" + resilverPriority));
    }

    private void parseVolumeModifyResults(DspResults results) throws CIMException {
        String METHOD = "parseVolumeModifyResults";
        Trace.methodBegin((Object)this, (String)"parseVolumeModifyResults");
        if (!results.requestSucceeded()) {
            Trace.error((Object)this, (String)"parseVolumeModifyResults", (String)(" Storage Volume Settings Modify Failed. Status:" + DspUtil.mapDSPReturnCode(results.getReturnCode())));
            CIMException tmpE = new CIMException("CIM_ERR_FAILED", (Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())));
            tmpE.setDescription("DSP Operation Failed");
            throw tmpE;
        }
    }

    public static void deleteSetting(DeleteRequest request) throws CIMException {
        String METHOD = "deleteSetting";
        Trace.methodBegin((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStorageSettingWithHints == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStorageSettingWithHints = ModifySunStorEdge_DSPStorageSettingWithHints.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageSettingWithHints")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStorageSettingWithHints), (String)"deleteSetting");
        if (request == null) {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStorageSettingWithHints == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStorageSettingWithHints = ModifySunStorEdge_DSPStorageSettingWithHints.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageSettingWithHints")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStorageSettingWithHints), (String)"deleteSetting", (String)" Null request argument. ");
            throw new CIMException("CIM_ERR_FAILED");
        }
    }

    public ModifySunStorEdge_DSPStorageSettingWithHints(ArrayObject array) {
        super(array);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

