/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayInventory;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMCacheEvent;
import com.sun.netstorage.dsp.mgmt.se6920.Constants;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DspPage;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageConfigurationService;
import com.sun.netstorage.dsp.mgmt.se6920.ObjectPath;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;

public class ModifySunStorEdge_DSPStoragePool
extends ModifyModule
implements Constants {
    private static String CLASSNAME = "StoragePool";
    private static String SCS_CLASS = "SunStorEdge_DSPStorageConfigurationService";
    private static String POOL_CLASS = "SunStorEdge_DSPStoragePool";
    private static String HOSTEDPOOL_CLASS = "SunStorEdge_DSPHostedStoragePool";
    private static String EXTENT_CLASS = "SunStorEdge_DSPStorageExtent";
    private static String HOSTED_SERVICE_CLASS = "SunStorEdge_DSPHostedService";
    private static String CONCRETE_COMP_CLASS = "SunStorEdge_DSPConcreteComponent";
    private static String FCPORT_CLASS = "SunStorEdge_DSPStoragePool";
    private static String ELEMENT_SETTING_CLASS = "SunStorEdge_DSPElementSettingData";
    private static String SETTING_CLASS = "SunStorEdge_StorageSettingWithHints";
    private static String ALLOCATED_POOL = "SunStorEdge_DSPAllocatedFromStoragePool";
    private static String CONCRETE_COMP_GROUP = "GroupComponent";
    private static String CONCRETE_COMP_PART = "PartComponent";
    private static String ALLOC_POOL_GROUP = "Antecedent";
    private static String ALLOC_POOL_PART = "Dependent";
    private static String ALLOC_POOL_CONSUMED = "SpaceConsumed";
    private static String ELEMENT_SETTING_SETTING = "SettingData";
    private static String ELEMENT_ELEMENT = "ManagedElement";
    static final String SE_NAME = "ElementName";
    static final String SE_BLOCKSIZE = "BlockSize";
    static final String SE_BLOCKS = "ConsumableBlocks";
    static final String[] SE_PROP_LIST = new String[]{"ElementName", "BlockSize", "ConsumableBlocks"};
    private static final String STORAGE_POOL_NAME = "ElementName";
    private static final String STORAGE_POOL_DESCRIPTION = "Description";
    private static final String STORAGE_POOL_TOT_MANAGED_SPACE = "TotalManagedSpace";
    private static final String STORAGE_POOL_REM_MANAGED_SPACE = "RemainingManagedSpace";
    private static final String POOL_DEFAULT_NAME = "Default";
    private static final String STORAGE_POOL_TYPE = "Type";
    private static final String PRIMORDIAL_POOL = "Primordial";
    private static final String STORAGE_SETTING_STRIPE_SIZE = "StripeSize";
    private static final String GET_SIZE_RANGE = "GetSupportedSizeRange";
    private static final String GET_SIZES = "GetSupportedSizes";
    private static final String CIM_SUP_SIZE_ELEMENT_TYPE = "ElementType";
    private static final String CIM_SUP_SIZE_GOAL = "Goal";
    private static final String CIM_SUP_SIZE_MIN_VOL_SIZE = "MinimumVolumeSize";
    private static final String CIM_SUP_SIZE_MAX_VOL_SIZE = "MaximumVolumeSize";
    private static final String CIM_SUP_SIZE_VOL_SIZE_DIV = "VolumeSizeDivisor";
    private static final Integer SUP_SIZE_RET_SUCCESS = new Integer(0);
    private static final Integer SUP_SIZE_RET_NOT_SUPPORTED = new Integer(1);
    private static final Integer SUP_SIZE_USE_RANGE_INSTEAD = new Integer(2);
    private static final String MIN_VOL_SIZE_STRING = "16777216";
    private static final int MIN_VOL_SIZE = 0x1000000;
    private static final int VOLUME_ELEMENT_TYPE = 3;
    private static final UnsignedInt16 LEGACY_POOL_TYPE = new UnsignedInt16("3");
    static /* synthetic */ Class class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool;

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        Object reply = null;
        String METHOD = "handleRequest";
        String classname = request.getCIMClassName();
        if (!classname.equals(POOL_CLASS)) {
            return false;
        }
        Vector tokens = new Vector();
        if (request instanceof SetRequest || request instanceof CreateRequest || request instanceof DeleteRequest || request instanceof InvokeRequest) {
            // empty if block
        }
        return false;
    }

    public ModifySunStorEdge_DSPStoragePool(ArrayObject array) {
        super(array);
    }

    public static void processPools() {
        ModifySunStorEdge_DSPStoragePool.updatePoolSizes();
    }

    public static void updatePoolSizes() {
        CIMObjectPath poolPath = null;
        poolPath = new CIMObjectPath(POOL_CLASS);
        try {
            CIMInstance[] insts = RequestBroker.getInstance().enumerateInstances(poolPath, false, false, true, null, null);
            if (insts != null) {
                for (int j = 0; j < insts.length; ++j) {
                    CIMObjectPath curPoolPath = insts[j].getObjectPath();
                    ModifySunStorEdge_DSPStoragePool.calculatePoolSize(curPoolPath);
                }
            }
        }
        catch (Exception e) {
            Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"Exception in updatePoolSizes", (Throwable)e);
        }
    }

    public static void calculatePoolSize(CIMObjectPath poolPath) throws CIMException {
        CIMObjectPath concreteComp = null;
        CIMInstance extent = null;
        CIMInstance pool = null;
        UnsignedInt64 extentTotSize = null;
        UnsignedInt64 extentFreeSize = null;
        BigInteger totalSize = new BigInteger("0");
        BigInteger freeSize = new BigInteger("0");
        pool = RequestBroker.getInstance().findInstance(poolPath);
        if (pool == null) {
            return;
        }
        ArrayList arrayInv = ArrayInventory.getInstance().getArrayInventory();
        RequestBroker.getInstance();
        CIMCacheEvent modEvent = new CIMCacheEvent(6, RequestBroker.getDevCache(), (ArrayObject)arrayInv.get(0));
        CIMInstance evtInst = (CIMInstance)pool.clone();
        modEvent.addInstance(evtInst);
        modEvent.addObjectPath(poolPath);
        Boolean isPrimordial = (Boolean)pool.getProperty(PRIMORDIAL_POOL).getValue().getValue();
        if (isPrimordial.booleanValue()) {
            return;
        }
        concreteComp = new CIMObjectPath(CONCRETE_COMP_CLASS);
        poolPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance[] extentInsts = RequestBroker.getInstance().associators(concreteComp, poolPath, EXTENT_CLASS, CONCRETE_COMP_GROUP, CONCRETE_COMP_PART, false, true, null);
        if (extentInsts != null) {
            for (int j = 0; j < extentInsts.length; ++j) {
                extent = extentInsts[j];
                extentTotSize = (UnsignedInt64)extent.getProperty("NumberOfBlocks").getValue().getValue();
                totalSize = totalSize.add(extentTotSize.bigIntValue());
                extentFreeSize = (UnsignedInt64)extent.getProperty(SE_BLOCKS).getValue().getValue();
                freeSize = freeSize.add(extentFreeSize.bigIntValue());
            }
        }
        pool.getProperty(STORAGE_POOL_TOT_MANAGED_SPACE).setValue(new CIMValue((Object)new UnsignedInt64(totalSize)));
        pool.getProperty(STORAGE_POOL_REM_MANAGED_SPACE).setValue(new CIMValue((Object)new UnsignedInt64(freeSize)));
        ModifySunStorEdge_DSPStoragePool.calculateAndUpdatePrimordialPoolSize();
        CIMObjectPath allocPool = new CIMObjectPath(ALLOCATED_POOL);
        poolPath.setNameSpace("\\root\\se6x20\\");
        CIMObjectPath[] poolPaths = RequestBroker.getInstance().associatorNames(allocPool, poolPath, POOL_CLASS, ALLOC_POOL_PART, ALLOC_POOL_GROUP);
        if (poolPaths != null) {
            CIMObjectPath[] allocPaths;
            CIMObjectPath primordialPath = poolPaths[0];
            CIMInstance primordialPool = RequestBroker.getInstance().findInstance(primordialPath);
            if (primordialPool != null && (allocPaths = RequestBroker.getInstance().referenceNames(allocPool, poolPath, ALLOC_POOL_PART)) != null) {
                CIMObjectPath allocPath = allocPaths[0];
                CIMInstance allocAssoc = RequestBroker.getInstance().findInstance(allocPath);
                if (allocAssoc != null) {
                    allocAssoc.getProperty(ALLOC_POOL_CONSUMED).setValue(new CIMValue((Object)new UnsignedInt64(totalSize)));
                }
            }
        }
        modEvent.addInstance((CIMInstance)pool.clone());
        RequestBroker.getInstance().postEvent(modEvent);
    }

    private static void calculateAndUpdatePrimordialPoolSize() {
        CIMInstance poolInst = null;
        CIMInstance primordialPoolInst = null;
        CIMObjectPath poolPath = new CIMObjectPath(POOL_CLASS);
        BigInteger primordialTotal = new BigInteger("0");
        try {
            CIMInstance[] insts = RequestBroker.getInstance().enumerateInstances(poolPath, false, false, true, null, null);
            if (insts != null) {
                for (int j = 0; j < insts.length; ++j) {
                    poolInst = null;
                    CIMObjectPath curPoolPath = insts[j].getObjectPath();
                    poolInst = RequestBroker.getInstance().findInstance(curPoolPath);
                    if (null == poolInst) continue;
                    Boolean isPrimordial = (Boolean)poolInst.getProperty(PRIMORDIAL_POOL).getValue().getValue();
                    if (isPrimordial.booleanValue()) {
                        primordialPoolInst = RequestBroker.getInstance().findInstance(poolInst.getObjectPath());
                        continue;
                    }
                    CIMValue poolTypeValue = poolInst.getProperty(STORAGE_POOL_TYPE).getValue();
                    UnsignedInt16 poolType = null;
                    if (null != poolTypeValue) {
                        poolType = (UnsignedInt16)poolTypeValue.getValue();
                    }
                    if (null != poolType && poolType.equals((Object)LEGACY_POOL_TYPE)) continue;
                    UnsignedInt64 poolSize = (UnsignedInt64)poolInst.getProperty(STORAGE_POOL_TOT_MANAGED_SPACE).getValue().getValue();
                    primordialTotal = primordialTotal.add(poolSize.bigIntValue());
                }
                if (null != primordialPoolInst) {
                    primordialPoolInst.getProperty(STORAGE_POOL_TOT_MANAGED_SPACE).setValue(new CIMValue((Object)new UnsignedInt64(primordialTotal)));
                    primordialPoolInst.getProperty(STORAGE_POOL_REM_MANAGED_SPACE).setValue(new CIMValue((Object)new UnsignedInt64("0")));
                }
            }
        }
        catch (Exception e) {
            Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"Exception in calculateAndUpdatePrimordialPoolSize", (Throwable)e);
        }
    }

    public static void updatePool(ArrayObject system, CIMObjectPath poolPath) throws CIMException {
        String METHOD = "updatePool";
        Trace.methodBegin((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"updatePool");
        if (poolPath != null && poolPath.getObjectName().equals(POOL_CLASS)) {
            Vector vDisks = new Vector();
            String logDisks = ModifySunStorEdge_DSPStorageConfigurationService.getDisksInPool(poolPath, vDisks);
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"updatePool", (String)("Recalculating for pool: " + poolPath.toString()));
            for (int i = 0; i < vDisks.size(); ++i) {
                String wwn = (String)vDisks.get(i);
                String diskPage = new String(DspPage.DISK_PAGE + "?" + "samDisk_setCurrent=" + wwn);
                RequestBroker.getInstance().reloadCachePage(system, diskPage);
            }
            if (!vDisks.isEmpty()) {
                ModifySunStorEdge_DSPStoragePool.calculatePoolSize(poolPath);
            }
        } else {
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"updatePool", (String)("Pool is not a: " + POOL_CLASS + " class or is NULL"));
        }
        Trace.methodEnd((Object)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"updatePool");
    }

    public static void updateRRPools(ArrayObject system, CIMObjectPath logPath, CIMObjectPath queuePath) throws CIMException {
        String METHOD = "updateRRPools";
        Trace.methodBegin((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"updateRRPools");
        ModifySunStorEdge_DSPStoragePool.updatePool(system, logPath);
        boolean samePool = ObjectPath.objectPathsAreEqual(logPath, queuePath);
        if (queuePath != null && !samePool) {
            ModifySunStorEdge_DSPStoragePool.updatePool(system, queuePath);
        } else {
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"updateRRPools", (String)("Not need to update queue pool: " + queuePath));
        }
        Trace.methodEnd((Object)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"updateRRPools");
    }

    public static boolean handleModify(ModifyRequest request) throws CIMException {
        String METHOD = "handleModify";
        SetRequest srequest = (SetRequest)request;
        CIMInstance newPool = srequest.getInstance();
        CIMInstance pool = RequestBroker.getInstance().findInstance(srequest.getObjectPath());
        if (pool == null) {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"handleModify", (String)" Unable to get StoragePool Instance. ");
            CIMException tmpe = new CIMException("CIM_ERR_FAILED");
            tmpe.setDescription("Internal error: Failed getInstance.");
            throw tmpe;
        }
        ArrayList arrayInv = ArrayInventory.getInstance().getArrayInventory();
        RequestBroker.getInstance();
        CIMCacheEvent modEvent = new CIMCacheEvent(6, RequestBroker.getDevCache(), (ArrayObject)arrayInv.get(0));
        CIMInstance evtInst = (CIMInstance)pool.clone();
        modEvent.addInstance(evtInst);
        modEvent.addObjectPath(srequest.getObjectPath());
        String oldPoolName = (String)pool.getProperty("ElementName").getValue().getValue();
        String poolName = (String)newPool.getProperty("ElementName").getValue().getValue();
        if (oldPoolName.equalsIgnoreCase(POOL_DEFAULT_NAME)) {
            if (!poolName.equalsIgnoreCase(POOL_DEFAULT_NAME)) {
                Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"handleModify", (String)" Cannot rename Default pool ");
                CIMException tmpe = new CIMException("CIM_ERR_INVALID_PARAMETER");
                tmpe.setDescription("Invalid Parameter: Default pool cannot be renamed.");
                throw tmpe;
            }
            pool.setProperty(STORAGE_POOL_DESCRIPTION, newPool.getProperty(STORAGE_POOL_DESCRIPTION).getValue());
        } else if (!poolName.equalsIgnoreCase(POOL_DEFAULT_NAME)) {
            pool.setProperty("ElementName", newPool.getProperty("ElementName").getValue());
            pool.setProperty(STORAGE_POOL_DESCRIPTION, newPool.getProperty(STORAGE_POOL_DESCRIPTION).getValue());
        } else {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"handleModify", (String)" Unable to modify StoragePool Instance. ");
            CIMException tmpe = new CIMException("CIM_ERR_INVALID_PARAMETER");
            tmpe.setDescription("Invalid Parameter: Default cannot be used.");
            throw tmpe;
        }
        modEvent.addInstance((CIMInstance)pool.clone());
        RequestBroker.getInstance().postEvent(modEvent);
        return true;
    }

    public static boolean invokeMethod(InvokeRequest request) throws CIMException {
        UnsignedInt16 elementType = null;
        CIMObjectPath poolPath = null;
        String METHOD = "invokeMethod";
        Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"invokeMethod", (String)" InvokeRequest");
        InvokeRequest invokeRequest = request;
        CIMArgument[] inParams = invokeRequest.getInParams();
        CIMArgument[] outParams = invokeRequest.getOutParams();
        if (invokeRequest.getMethodName().equals(GET_SIZE_RANGE)) {
            CIMObjectPath goal = null;
            for (int i = 0; i < inParams.length; ++i) {
                String parmName = inParams[i].getName().toString();
                if (parmName.equals(CIM_SUP_SIZE_ELEMENT_TYPE)) {
                    elementType = (UnsignedInt16)inParams[i].getValue().getValue();
                    continue;
                }
                if (!parmName.equals(CIM_SUP_SIZE_GOAL)) continue;
                goal = (CIMObjectPath)inParams[i].getValue().getValue();
            }
            CIMInstance pool = RequestBroker.getInstance().findInstance(invokeRequest.getObjectPath());
            if (pool == null) {
                Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"invokeMethod", (String)" Unable to get StoragePool Instance. ");
                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("Internal error: Failed getInstance.");
                throw tmpe;
            }
            poolPath = invokeRequest.getObjectPath();
            UnsignedInt64 size = (UnsignedInt64)pool.getProperty(STORAGE_POOL_REM_MANAGED_SPACE).getValue().getValue();
            if (size.equals((Object)new UnsignedInt64("0")) || size.doubleValue() < 1.6777216E7) {
                outParams[0] = new CIMArgument(CIM_SUP_SIZE_MIN_VOL_SIZE, new CIMValue((Object)new UnsignedInt64("0")));
                outParams[1] = new CIMArgument(CIM_SUP_SIZE_MAX_VOL_SIZE, new CIMValue((Object)new UnsignedInt64("0")));
                outParams[2] = new CIMArgument(CIM_SUP_SIZE_VOL_SIZE_DIV, new CIMValue((Object)new UnsignedInt64("0")));
            } else {
                outParams[0] = new CIMArgument(CIM_SUP_SIZE_MIN_VOL_SIZE, new CIMValue((Object)new UnsignedInt64(MIN_VOL_SIZE_STRING)));
                outParams[1] = new CIMArgument(CIM_SUP_SIZE_MAX_VOL_SIZE, new CIMValue((Object)size));
                CIMObjectPath profilePath = new CIMObjectPath(ELEMENT_SETTING_CLASS);
                profilePath.setNameSpace("\\root\\se6x20\\");
                poolPath.setNameSpace("\\root\\se6x20\\");
                CIMInstance[] profileInstance = RequestBroker.getInstance().associators(profilePath, poolPath, SETTING_CLASS, ELEMENT_ELEMENT, ELEMENT_SETTING_SETTING, false, true, null);
                if (profileInstance == null) {
                    Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool = ModifySunStorEdge_DSPStoragePool.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPStoragePool), (String)"invokeMethod", (String)" Unable to get Profile for pool. ");
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                    tmpe.setDescription("Internal error: Failed getInstance.");
                    throw tmpe;
                }
                CIMInstance setting = profileInstance[0];
                CIMProperty stripeSizeProp = setting.getProperty(STORAGE_SETTING_STRIPE_SIZE);
                if (stripeSizeProp != null) {
                    String chunk = null;
                    UnsignedInt16 stripeSize = (UnsignedInt16)stripeSizeProp.getValue().getValue();
                    switch (stripeSize.intValue()) {
                        case 0: {
                            chunk = "131072";
                            break;
                        }
                        case 1: {
                            chunk = "524288";
                            break;
                        }
                        case 2: {
                            chunk = "1048576";
                            break;
                        }
                        case 3: {
                            chunk = "4194304";
                            break;
                        }
                        case 4: {
                            chunk = "4194304";
                            break;
                        }
                        case 5: {
                            chunk = "8388608";
                            break;
                        }
                        case 6: {
                            chunk = MIN_VOL_SIZE_STRING;
                            break;
                        }
                        default: {
                            chunk = "4194304";
                        }
                    }
                    outParams[2] = new CIMArgument(CIM_SUP_SIZE_VOL_SIZE_DIV, new CIMValue((Object)new UnsignedInt64(chunk)));
                } else {
                    outParams[2] = new CIMArgument(CIM_SUP_SIZE_VOL_SIZE_DIV, new CIMValue((Object)new UnsignedInt64("1048576")));
                }
            }
            invokeRequest.setResults(new CIMValue((Object)SUP_SIZE_RET_SUCCESS, new CIMDataType(5)));
        } else if (invokeRequest.getMethodName().equals(GET_SIZES)) {
            invokeRequest.setResults(new CIMValue((Object)SUP_SIZE_USE_RANGE_INSTEAD, new CIMDataType(5)));
        } else {
            invokeRequest.setResults(new CIMValue((Object)SUP_SIZE_RET_NOT_SUPPORTED, new CIMDataType(5)));
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

