/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;

public class ModifySunStorEdge_DSPStorageHardwareIDManagementService
extends ModifyModule {
    private static String CLASSNAME = "StorageHardwareIDManagementService";
    private static String SCS_CLASS = "SunStorEdge_DSPStorageHardwareIDManagementService";
    private static String DOMAIN_CLASS = "SunStorEdge_DSPStorageDomain";
    private static String HOSTED_COLLECTION_CLASS = "SunStorEdge_DSPHostedCollection";
    private static String INITIATOR_COLLECTION_CLASS = "SunStorEdge_DSPDomainInitiatorCollection";
    private static String HOSTED_SERVICE_CLASS = "SunStorEdge_DSPHostedService";
    private static final String ADD_TO_COLLECTION = "AddHardwareIDsToCollection";
    private static final String CREATE_HW_ID = "CreateStorageHardwareID";
    private static final String DELETE_HW_ID = "DeleteStorageHardwareID";
    private static final String CIM_ADD_TO_COLLECTION_HARDWAREIDS = "HardwareIDs";
    private static final String CIM_ADD_TO_COLLECTION_HARDWAREID = "HardwareID";
    private static final String CIM_ADD_TO_COLLECTION_COLLECTION = "Collection";
    private static final String ADD_TO_COLLECTION_PAGE = "response.xml";
    private static final String ADD_TO_COLLECTION_CURRENT_PHYSICAL = "samInitiator_setCurrentPhysical";
    private static final String ADD_TO_COLLECTION_DOMAIN = "samInitiator_curStorageDomain";
    private static String DEPENDENT = "Dependent";
    private static String ANTECEDENT = "Antecedent";
    private static final Integer ADD_TO_COLLECTION_RET_SUCCESS = new Integer(0);
    private static final Integer ADD_TO_COLLECTION_RET_NOT_SUPPORTED = new Integer(1);
    private static final Integer ADD_TO_COLLECTION_RET_RET_UNKNOWN = new Integer(2);
    private static final Integer ADD_TO_COLLECTION_RET_RET_TIMEOUT = new Integer(3);
    private static final Integer ADD_TO_COLLECTION_RET_RET_FAILED = new Integer(4);
    private static final Integer ADD_TO_COLLECTION_RET_RET_INVALID_PARAM = new Integer(5);
    private static final String SD_SYSTEM_NAME = "ElementName";
    private static final String[] SD_PROP_LIST = new String[]{"ElementName"};
    private static final String INITIATOR_INSTANCE_ID = "InstanceID";
    private static final String[] INITIATOR_PROP_LIST = new String[]{"InstanceID"};
    private static final String CSHWID_SERVER_ID = "samInitiator_webCreateOffline";
    private static final String CSHWID_SET_CURRENT = "samInitiator_setCurrentPhysical";
    private static final String CSHWID_INITIATOR_NAME = "samInitiator_curAlias";
    private static final String CSHWID_STORAGE_DOMAIN = "samInitiator_curStorageDomain";
    private static final String CSHWID_SERVER_TYPE = "samInitiator_curServerType";
    private static final String CSHWID_DESCRIPTION = "samInitiator_curDescription";
    private static final Integer HWID_CR_RET_SUCCESS = new Integer(0);
    private static final Integer HWID_CR_RET_NOT_SUPPORTED = new Integer(1);
    private static final Integer HWID_CR_RET_UNKNOWN = new Integer(2);
    private static final Integer HWID_CR_RET_TIMEOUT = new Integer(3);
    private static final Integer HWID_CR_RET_FAILED = new Integer(4);
    private static final Integer HWID_CR_RET_INVALID_PARAM = new Integer(5);
    private static final Integer HWID_CR_RET_DMTF_RESV_LOWER_LIMIT = new Integer(6);
    private static final Integer HWID_CR_RET_DMTF_RESV_UPPER_LIMIT = new Integer(4095);
    private static final Integer HWID_CR_RET_ID_ALREADY_CREATED = new Integer(4096);
    private static final Integer HWID_CR_RET_HW_IMPL_DOES_NOT_SUPPORT_IDTYPE = new Integer(4097);
    private static final Integer HWID_CR_RET_METHOD_RESV_LOWER_LIMIT = new Integer(4098);
    private static final Integer HWID_CR_RET_METHOD_RESV_UPPER_LIMIT = new Integer(Short.MAX_VALUE);
    private static final Integer HWID_CR_RET_VEND_SPEC_LOWER_LIMIT = new Integer(32768);
    private static final Integer HWID_CR_RET_VEND_SPEC_UPPER_LIMIT = new Integer(65535);
    private static String HOSTED_SERVICE_SERVICE = "Dependent";
    private static String HOSTED_SERVICE_SYSTEM = "Antecedent";
    private static final String DSHWID_SERVER_ID = "initiatorWWN";
    private static final Integer HWID_DEL_RET_SUCCESS = new Integer(0);
    private static final Integer HWID_DEL_RET_NOT_SUPPORTED = new Integer(1);
    private static final Integer HWID_DEL_RET_UNKNOWN = new Integer(2);
    private static final Integer HWID_DEL_RET_TIMEOUT = new Integer(3);
    private static final Integer HWID_DEL_RET_FAILED = new Integer(4);
    private static final Integer HWID_DEL_RET_INVALID_PARAM = new Integer(5);
    private static final Integer HWID_DEL_RET_DMTF_RESV_LOWER_LIMIT = new Integer(6);
    private static final Integer HWID_DEL_RET_DMTF_RESV_UPPER_LIMIT = new Integer(4095);
    private static final Integer HWID_DEL_RET_SPECIFIC_INST_NOT_FOUND = new Integer(4096);
    private static final Integer HWID_DEL_RET_METHOD_RESV_LOWER_LIMIT = new Integer(4097);
    private static final Integer HWID_DEL_RET_METHOD_RESV_UPPER_LIMIT = new Integer(Short.MAX_VALUE);
    private static final Integer HWID_DEL_RET_VEND_SPEC_LOWER_LIMIT = new Integer(32768);
    private static final Integer HWID_DEL_RET_VEND_SPEC_UPPER_LIMIT = new Integer(65535);
    private static final String VOLUME_XML_PAGE = "volume.xml";
    private static final String INITIATOR_XML_PAGE = "initor.xml";

    public ModifySunStorEdge_DSPStorageHardwareIDManagementService(ArrayObject array) {
        super(array);
    }

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        DspResults results = null;
        String classname = request.getCIMClassName();
        if (!classname.equals(SCS_CLASS)) {
            return false;
        }
        Vector tokens = new Vector();
        if (request instanceof SetRequest) {
            Trace.error((Object)this, (String)"handleRequest", (String)" Modify on HardwareIDManagementService not supported. ");
            CIMException tmpe = new CIMException("CIM_ERR_NOT_SUPPORTED");
            tmpe.setDescription("Modify not supported");
            throw tmpe;
        }
        if (!(request instanceof CreateRequest) && !(request instanceof DeleteRequest) && request instanceof InvokeRequest) {
            block23: {
                InvokeRequest invokeRequest = (InvokeRequest)request;
                CIMArgument[] inParams = invokeRequest.getInParams();
                CIMArgument[] outParams = invokeRequest.getOutParams();
                StringBuffer serverWwn = new StringBuffer();
                if (invokeRequest.getMethodName().equals(ADD_TO_COLLECTION)) {
                    CIMObjectPath collectionPath = new CIMObjectPath();
                    Vector hardwareIDs = new Vector();
                    String domainName = new String();
                    String page = new String(ADD_TO_COLLECTION_PAGE);
                    for (int i = 0; i < inParams.length; ++i) {
                        String parmName = inParams[i].getName().toString();
                        if (parmName.equals(CIM_ADD_TO_COLLECTION_COLLECTION)) {
                            collectionPath = (CIMObjectPath)inParams[i].getValue().getValue();
                            collectionPath.setNameSpace("\\root\\se6x20\\");
                        }
                        if (!parmName.equals(CIM_ADD_TO_COLLECTION_HARDWAREIDS)) continue;
                        hardwareIDs = (Vector)inParams[i].getValue().getValue();
                    }
                    CIMObjectPath hostedCollection = new CIMObjectPath(HOSTED_COLLECTION_CLASS);
                    CIMInstance[] insts = RequestBroker.getInstance().associators(hostedCollection, collectionPath, DOMAIN_CLASS, DEPENDENT, ANTECEDENT, false, true, SD_PROP_LIST);
                    CIMInstance domain = insts[0];
                    domainName = (String)domain.getProperty(SD_SYSTEM_NAME).getValue().getValue();
                    for (int j = 0; j < hardwareIDs.size(); ++j) {
                        this.buildAddToCollectionParms((String)hardwareIDs.elementAt(j), domainName, invokeRequest, tokens, serverWwn);
                        results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
                        this.parseAddToCollectionResults(invokeRequest, results);
                        if (!results.requestSucceeded()) continue;
                        CIMObjectPath hardwareIDPath = DspUtil.stringToCOP((CIMOMHandle)SunStorEdge_DSPProvider.cimom, "\\root\\se6x20\\", (String)hardwareIDs.elementAt(j));
                        hardwareIDPath.setNameSpace("\\root\\se6x20\\");
                        CIMObjectPath mofPath = new CIMObjectPath("SunStorEdge_DSPMemberOfCollection");
                        CIMObjectPath[] referencePaths = RequestBroker.getInstance().referenceNames(mofPath, hardwareIDPath, "Member");
                        int referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
                        for (int k = 0; k < referencePathsLength; ++k) {
                            RequestBroker.getInstance().deleteInstance(referencePaths[k]);
                        }
                        if (serverWwn.length() == 0) continue;
                        Trace.info((Object)this, (String)"handleRequest", (String)"Reloading initor.xml for initiator.");
                        String reloadpage = new String("initor.xml?samFcTarget_SetCurrentByInitiatorWWN=" + serverWwn.toString());
                        RequestBroker.getInstance().reloadCachePage(this.getSystem(), reloadpage);
                        serverWwn.setLength(0);
                    }
                } else if (invokeRequest.getMethodName().equals(CREATE_HW_ID)) {
                    Integer errorCode = HWID_CR_RET_SUCCESS;
                    boolean idExists = this.buildCreateStorageHwIdParams(inParams, outParams, tokens, invokeRequest, errorCode, serverWwn);
                    String page = new String(ADD_TO_COLLECTION_PAGE);
                    try {
                        results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
                        if (results.requestSucceeded()) {
                            if (idExists) {
                                ((InvokeRequest)request).setResults(new CIMValue((Object)HWID_CR_RET_ID_ALREADY_CREATED, new CIMDataType(5)));
                            } else {
                                ((InvokeRequest)request).setResults(new CIMValue((Object)errorCode, new CIMDataType(5)));
                            }
                            if (serverWwn.length() == 0) break block23;
                            Trace.info((Object)this, (String)"handleRequest", (String)"Reloading initor.xml for initiator.");
                            String reloadpage = new String("initor.xml?samFcTarget_SetCurrentByInitiatorWWN=" + serverWwn.toString());
                            RequestBroker.getInstance().reloadCachePage(this.getSystem(), reloadpage);
                            serverWwn.setLength(0);
                            break block23;
                        }
                        ((InvokeRequest)request).setResults(new CIMValue((Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())), new CIMDataType(5)));
                    }
                    catch (Exception e) {}
                } else if (invokeRequest.getMethodName().equals(DELETE_HW_ID)) {
                    CIMObjectPath hwIDPath = null;
                    for (int i = 0; i < inParams.length; ++i) {
                        String paramName = inParams[i].getName().toString();
                        if (!paramName.equals(CIM_ADD_TO_COLLECTION_HARDWAREID)) continue;
                        CIMValue theValue = inParams[i].getValue();
                        hwIDPath = (CIMObjectPath)theValue.getValue();
                    }
                    this.buildDeleteStorageHwIdParams(inParams, tokens, (InvokeRequest)request);
                    String page = new String("initVirtDel.htm");
                    try {
                        results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
                        if (results.requestSucceeded()) {
                            ((InvokeRequest)request).setResults(new CIMValue((Object)HWID_DEL_RET_SUCCESS, new CIMDataType(5)));
                            try {
                                this.cleanupInitiatorReferences(hwIDPath);
                                RequestBroker.getInstance().deleteInstance(hwIDPath);
                            }
                            catch (CIMException ex) {
                                Trace.error((Object)this, (String)"Exception cleaning up deleted initiator ", (Throwable)ex);
                            }
                        }
                        ((InvokeRequest)request).setResults(new CIMValue((Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())), new CIMDataType(5)));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean buildCreateStorageHwIdParams(CIMArgument[] cimParams, CIMArgument[] outParams, Vector nvPairs, InvokeRequest req, Integer errorCode, StringBuffer initorWwn) throws CIMException {
        CIMProperty osProp;
        CIMValue osVal;
        Vector osTypes;
        Vector initiators = new Vector();
        String namespace = req.getObjectPath().getNameSpace();
        boolean hwIdAlreadyExists = false;
        CIMInstance clientSettingInst = null;
        CIMInstance hwIdInst = null;
        CIMObjectPath clientSettingPath = null;
        CIMObjectPath hwIdPath = null;
        String elemName = new String();
        String storageId = new String();
        String colonatedStorageId = new String();
        String otherIdType = new String();
        String serverType = new String("default");
        UnsignedInt16 idTypeUint16 = new UnsignedInt16(0);
        for (int i = 0; i < cimParams.length; ++i) {
            CIMValue theValue;
            String paramName = cimParams[i].getName().toString();
            if (paramName.equals(SD_SYSTEM_NAME)) {
                theValue = cimParams[i].getValue();
                elemName = (String)theValue.getValue();
                continue;
            }
            if (paramName.equals("StorageID")) {
                theValue = cimParams[i].getValue();
                storageId = (String)theValue.getValue();
                if (storageId.length() != 16) {
                    errorCode = HWID_CR_RET_INVALID_PARAM;
                }
                String extendedStorageId = new String(storageId + "0000000000000000");
                colonatedStorageId = DspUtil.addColonsToWWN(extendedStorageId);
                continue;
            }
            if (paramName.equals("IDType")) {
                theValue = cimParams[i].getValue();
                idTypeUint16 = (UnsignedInt16)theValue.getValue();
                if (idTypeUint16.intValue() == 2) continue;
                errorCode = HWID_CR_RET_HW_IMPL_DOES_NOT_SUPPORT_IDTYPE;
                continue;
            }
            if (paramName.equals("OtherIDType")) {
                theValue = cimParams[i].getValue();
                otherIdType = (String)theValue.getValue();
                continue;
            }
            if (!paramName.equals("Setting") || (theValue = cimParams[i].getValue()) == null) continue;
            clientSettingPath = (CIMObjectPath)theValue.getValue();
            clientSettingInst = RequestBroker.getInstance().findInstance(clientSettingPath);
        }
        initorWwn.append(colonatedStorageId);
        if (clientSettingInst != null && (osTypes = (Vector)(osVal = (osProp = clientSettingInst.getProperty("ClientTypes")).getValue()).getValue()).size() == 1) {
            UnsignedInt16 osNum = (UnsignedInt16)osTypes.firstElement();
            int osNumInt = osNum.intValue();
            switch (osNumInt) {
                case 0: {
                    serverType = new String("Unknown");
                    break;
                }
                case 4: {
                    serverType = new String("hp-unix");
                    break;
                }
                case 32768: {
                    serverType = new String("emulex");
                    break;
                }
                default: {
                    serverType = new String("default");
                }
            }
        }
        hwIdPath = new CIMObjectPath("SunStorEdge_DSPStorageHardwareID");
        hwIdPath.setNameSpace(namespace);
        CIMClass hwIdClass = SunStorEdge_DSPProvider.cimom.getClass(hwIdPath, false, true, true, null);
        if (hwIdClass == null) {
            CIMException tmpe = new CIMException("CIM_ERR_FAILED");
            tmpe.setDescription("Internal error: Failed getClass.");
            throw tmpe;
        }
        hwIdInst = hwIdClass.newInstance();
        String propName0 = new String(INITIATOR_INSTANCE_ID);
        CIMValue val0 = new CIMValue((Object)colonatedStorageId);
        hwIdInst.setProperty(propName0, val0);
        CIMProperty prop0 = hwIdInst.getProperty(propName0);
        hwIdInst.updatePropertyValue(prop0);
        String propName1 = new String("StorageID");
        CIMValue val1 = new CIMValue((Object)storageId);
        hwIdInst.setProperty(propName1, val1);
        CIMProperty prop1 = hwIdInst.getProperty(propName1);
        hwIdInst.updatePropertyValue(prop1);
        String propName2 = new String(SD_SYSTEM_NAME);
        CIMValue val2 = new CIMValue((Object)elemName);
        hwIdInst.setProperty(propName2, val2);
        CIMProperty prop2 = hwIdInst.getProperty(propName2);
        hwIdInst.updatePropertyValue(prop2);
        String propName3 = new String("OtherIDType");
        CIMValue val3 = new CIMValue((Object)otherIdType);
        hwIdInst.setProperty(propName3, val3);
        CIMProperty prop3 = hwIdInst.getProperty(propName3);
        hwIdInst.updatePropertyValue(prop3);
        String propName4 = new String("IDType");
        CIMValue val4 = new CIMValue((Object)idTypeUint16);
        hwIdInst.setProperty(propName4, val4);
        CIMProperty prop4 = hwIdInst.getProperty(propName4);
        hwIdInst.updatePropertyValue(prop4);
        hwIdPath = hwIdInst.getObjectPath();
        hwIdPath.setNameSpace(namespace);
        CIMValue hwIdPathVal = new CIMValue((Object)hwIdPath);
        outParams[0] = new CIMArgument(new String(CIM_ADD_TO_COLLECTION_HARDWAREID), hwIdPathVal);
        CIMInstance foundHwIdInst = RequestBroker.getInstance().findInstance(hwIdPath);
        hwIdAlreadyExists = foundHwIdInst != null;
        CIMObjectPath hostedService = new CIMObjectPath(HOSTED_SERVICE_CLASS);
        CIMObjectPath mgmtService = req.getObjectPath();
        CIMInstance[] insts = RequestBroker.getInstance().associators(hostedService, mgmtService, DOMAIN_CLASS, HOSTED_SERVICE_SERVICE, HOSTED_SERVICE_SYSTEM, false, true, null);
        CIMInstance domain = insts[0];
        CIMProperty domainElemName = domain.getProperty(SD_SYSTEM_NAME);
        CIMValue domainElemNameVal = domainElemName.getValue();
        String domainName = (String)domainElemNameVal.getValue();
        nvPairs.add(new String("samInitiator_webCreateOffline=" + colonatedStorageId));
        nvPairs.add(new String("samInitiator_setCurrentPhysical=" + colonatedStorageId));
        nvPairs.add(new String("samInitiator_curAlias=" + elemName));
        nvPairs.add(new String("samInitiator_curStorageDomain=" + domainName));
        nvPairs.add(new String("samInitiator_curServerType=" + serverType));
        return hwIdAlreadyExists;
    }

    private void buildDeleteStorageHwIdParams(CIMArgument[] cimParams, Vector nvPairs, InvokeRequest req) throws CIMException {
        String serverWwn = new String();
        String namespace = req.getObjectPath().getNameSpace();
        CIMInstance hwIdInst = null;
        for (int i = 0; i < cimParams.length; ++i) {
            String paramName = cimParams[i].getName().toString();
            if (!paramName.equals(CIM_ADD_TO_COLLECTION_HARDWAREID)) continue;
            CIMValue theValue = cimParams[i].getValue();
            CIMObjectPath thePath = (CIMObjectPath)theValue.getValue();
            hwIdInst = RequestBroker.getInstance().findInstance(thePath);
        }
        CIMProperty instIdProp = hwIdInst.getProperty(INITIATOR_INSTANCE_ID);
        CIMValue instIdPropVal = instIdProp.getValue();
        serverWwn = (String)instIdPropVal.getValue();
        nvPairs.add(new String("initiatorWWN=" + serverWwn));
    }

    private void buildAddToCollectionParms(String hardwareID, String domainName, InvokeRequest request, Vector nvPairs, StringBuffer initorWWN) throws CIMException {
        CIMInstance instance;
        CIMObjectPath hardwareIDPath = new CIMObjectPath();
        String wwn = new String();
        hardwareIDPath = DspUtil.stringToCOP((CIMOMHandle)SunStorEdge_DSPProvider.cimom, "\\root\\se6x20\\", hardwareID);
        hardwareIDPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance initiator = instance = RequestBroker.getInstance().getInstance(hardwareIDPath, false, true, true, INITIATOR_PROP_LIST, null);
        wwn = (String)initiator.getProperty(INITIATOR_INSTANCE_ID).getValue().getValue();
        initorWWN.append(wwn);
        nvPairs.add(new String("samInitiator_setCurrentPhysical=" + wwn));
        nvPairs.add(new String("samInitiator_curStorageDomain=" + domainName));
    }

    private void parseAddToCollectionResults(InvokeRequest request, DspResults results) {
        if (results.requestSucceeded()) {
            request.setResults(new CIMValue((Object)ADD_TO_COLLECTION_RET_SUCCESS, new CIMDataType(5)));
        } else {
            request.setResults(new CIMValue((Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())), new CIMDataType(5)));
        }
    }

    private void cleanupInitiatorReferences(CIMObjectPath hardwareIDPath) throws CIMException {
        String METHOD_NAME = "cleanupInitiatorReferences";
        Trace.methodBegin((Object)this, (String)"cleanupInitiatorReferences");
        CIMObjectPath aiPath = new CIMObjectPath("SunStorEdge_DSPAssignedIdentity");
        CIMObjectPath[] referencePaths = RequestBroker.getInstance().referenceNames(aiPath, hardwareIDPath, "IdentityInfo");
        int referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
        for (int i = 0; i < referencePathsLength; ++i) {
            RequestBroker.getInstance().deleteInstance(referencePaths[i]);
        }
        CIMObjectPath mofPath = new CIMObjectPath("SunStorEdge_DSPMemberOfCollection");
        referencePaths = RequestBroker.getInstance().referenceNames(mofPath, hardwareIDPath, "Member");
        referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
        for (int j = 0; j < referencePathsLength; ++j) {
            RequestBroker.getInstance().deleteInstance(referencePaths[j]);
        }
        CIMObjectPath esPath = new CIMObjectPath("SunStorEdge_DSPElementSettingData");
        referencePaths = RequestBroker.getInstance().referenceNames(esPath, hardwareIDPath, "ManagedElement");
        referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
        for (int j = 0; j < referencePathsLength; ++j) {
            RequestBroker.getInstance().deleteInstance(referencePaths[j]);
        }
        CIMObjectPath cdPath = new CIMObjectPath("SunStorEdge_DSPConcreteDependency");
        referencePaths = RequestBroker.getInstance().referenceNames(cdPath, hardwareIDPath, "Dependent");
        referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
        for (int j = 0; j < referencePathsLength; ++j) {
            RequestBroker.getInstance().deleteInstance(referencePaths[j]);
        }
        CIMObjectPath asPath = new CIMObjectPath("SunStorEdge_DSPAuthorizedSubject");
        referencePaths = RequestBroker.getInstance().referenceNames(asPath, hardwareIDPath, "PrivilegedElement");
        referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
        for (int j = 0; j < referencePathsLength; ++j) {
            RequestBroker.getInstance().deleteInstance(referencePaths[j]);
        }
    }
}

