/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMUtils;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ModifySunStorEdge_DSPStorageHardwareID
extends ModifyModule {
    private static String CLASSNAME = "ModifySunStorEdge_DSPStorageHardwareID";
    private static String INITIATOR_CLASS = "SunStorEdge_DSPStorageHardwareID";
    private static final String INITIATOR_MODIFY_PAGE = "response.xml";
    private static final String INITIATOR_MODIFY_CURRENT = "samInitiator_setCurrentPhysical";
    private static final String INITIATOR_MODIFY_NAME = "samInitiator_curAlias";
    private static final String INITIATOR_MODIFY_DESC = "samInitiator_curDescription";
    private static final String INITIATOR_RELOAD_FLAG = "samFcTarget_SetCurrentByInitiatorWWN";
    private static final String INITIATOR_XML_PAGE = "initor.xml";

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        DspResults results = null;
        String classname = request.getCIMClassName();
        if (!classname.equals(INITIATOR_CLASS)) {
            return false;
        }
        Vector tokens = new Vector();
        if (request instanceof SetRequest) {
            String instanceID = this.buildInitiatorModifyParms((SetRequest)request, tokens);
            String page = new String(INITIATOR_MODIFY_PAGE);
            results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
            this.parseInitiatorModifyResults(results, instanceID);
            return true;
        }
        if (request instanceof CreateRequest || request instanceof DeleteRequest || request instanceof InvokeRequest) {
            // empty if block
        }
        return false;
    }

    private String buildInitiatorModifyParms(SetRequest request, Vector nvPairs) throws CIMException {
        CIMInstance instance = request.getInstance();
        CIMObjectPath path = request.getObjectPath();
        CIMInstance oldInstance = RequestBroker.getInstance().findInstance(path);
        String initiatorNewName = DspUtil.unquote(CIMUtils.getPropertyValue(instance, "ElementName").toString());
        String initiatorDescription = DspUtil.unquote(CIMUtils.getPropertyValue(instance, "Description").toString());
        String initiatorName = DspUtil.unquote(CIMUtils.getPropertyValue(oldInstance, "InstanceID").toString());
        nvPairs.add(new String("samInitiator_setCurrentPhysical=" + initiatorName));
        nvPairs.add(new String("samInitiator_curAlias=" + initiatorNewName));
        nvPairs.add(new String("samInitiator_curDescription=" + initiatorDescription));
        return initiatorName;
    }

    private void parseInitiatorModifyResults(DspResults results, String instanceID) throws CIMException {
        String METHOD = "parseInitiatorModifyResults";
        if (!results.requestSucceeded()) {
            Trace.error((Object)this, (String)"parseInitiatorModifyResults", (String)(" Initiator Modify Failed. Status:" + DspUtil.mapDSPReturnCode(results.getReturnCode())));
            CIMException tmpE = new CIMException("CIM_ERR_FAILED", (Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())));
            tmpE.setDescription("DSP Operation Failed");
            throw tmpE;
        }
        String page = new String("initor.xml?samFcTarget_SetCurrentByInitiatorWWN=" + instanceID);
        RequestBroker.getInstance().reloadCachePage(this.getSystem(), page);
    }

    public ModifySunStorEdge_DSPStorageHardwareID(ArrayObject array) {
        super(array);
    }
}

