/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMUtils;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspPage;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class ModifySunStorEdge_DSPStorageDomainConfigurationService
extends ModifyModule {
    private static String CLASSNAME = "StorageDomainConfigurationService";
    private static String SDCS_CLASS = "SunStorEdge_DSPStorageDomainConfigurationService";
    private static String DOMAIN_CLASS = "SunStorEdge_DSPStorageDomain";
    private static final String SVSD_CREATE = "CreateStorageDomain";
    private static final String CIM_SVSD_CR_DESC = "Description";
    private static final String CIM_SVSD_CR_ELE_NAME = "ElementName";
    private static final String CIM_SVSD_NAME = "StorageDomain";
    private static final String SVSD_CR_PAGE = "vsdC2.htm";
    private static final String SVSD_CR_NAME = "new_Name";
    private static final String SVSD_CR_DESC = "new_Desc";
    private static final Integer SD_CR_RET_SUCCESS = new Integer(0);
    private static final Integer SD_CR_RET_NOT_SUPPORTED = new Integer(1);
    private static final Integer SD_CR_RET_UNKNOWN = new Integer(2);
    private static final Integer SD_CR_RET_TIMEOUT = new Integer(3);
    private static final Integer SD_CR_RET_FAILED = new Integer(4);
    private static final Integer SD_CR_RET_INVALID_PARAM = new Integer(5);

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        DspResults results = null;
        String classname = request.getCIMClassName();
        if (!classname.equals(SDCS_CLASS)) {
            return false;
        }
        Vector tokens = new Vector();
        if (!(request instanceof SetRequest) && !(request instanceof CreateRequest) && !(request instanceof DeleteRequest) && request instanceof InvokeRequest) {
            InvokeRequest invokeRequest = (InvokeRequest)request;
            CIMArgument[] inParams = invokeRequest.getInParams();
            CIMArgument[] outParams = invokeRequest.getOutParams();
            if (invokeRequest.getMethodName().equals(SVSD_CREATE)) {
                StringBuffer nameBuff = new StringBuffer();
                this.buildSvsdCreateParms(inParams, tokens, nameBuff);
                String page = new String(SVSD_CR_PAGE);
                results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
                this.parseSvsdCreateResults(invokeRequest, results, outParams);
                RequestBroker.getInstance().reloadCachePage(this.getSystem(), DspPage.SVSDS_PAGE.toString());
                CIMObjectPath domainPath = null;
                CIMObjectPath domainClassPath = new CIMObjectPath(DOMAIN_CLASS);
                domainClassPath.setNameSpace("\\root\\se6x20\\");
                CIMClass domClass = SunStorEdge_DSPProvider.cimom.getClass(domainClassPath, false, true, true, null);
                CIMInstance[] doms = RequestBroker.getInstance().enumerateInstances(domainClassPath, false, false, true, null, domClass);
                if (doms != null) {
                    for (int j = 0; j < doms.length; ++j) {
                        CIMInstance domInst = doms[j];
                        String svsdName = DspUtil.unquote(CIMUtils.getPropertyValue(domInst, CIM_SVSD_CR_ELE_NAME).toString());
                        if (!svsdName.equals(nameBuff.toString())) continue;
                        domainPath = domInst.getObjectPath();
                        break;
                    }
                }
                outParams[0] = new CIMArgument(CIM_SVSD_NAME, new CIMValue(domainPath));
                String[] logArgs = new String[]{nameBuff.toString(), this.getSystem().getHost()};
                try {
                    if (results.requestSucceeded()) {
                        LogAPI.staticLog((String)"DSP_DOMAIN_CREATED", (String[])logArgs, null);
                    } else {
                        LogAPI.staticLog((String)"DSP_DOMAIN_CREATE_FAILED", (String[])logArgs, null);
                    }
                }
                catch (Exception logEx) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    private void buildSvsdCreateParms(CIMArgument[] cimParms, Vector nvPairs, StringBuffer nameBuff) throws CIMException {
        String svsdName = new String();
        String svsdDesc = new String();
        for (int i = 0; i < cimParms.length; ++i) {
            String parmName = cimParms[i].getName().toString();
            if (parmName.equals(CIM_SVSD_CR_DESC)) {
                svsdDesc = DspUtil.unquote(cimParms[i].getValue().toString());
                continue;
            }
            if (!parmName.equals(CIM_SVSD_CR_ELE_NAME)) continue;
            svsdName = DspUtil.unquote(cimParms[i].getValue().toString());
        }
        nvPairs.add(new String("new_Name=" + svsdName));
        nvPairs.add(new String("new_Desc=" + svsdDesc));
        nameBuff.append(svsdName);
    }

    private void parseSvsdCreateResults(InvokeRequest request, DspResults results, CIMArgument[] cimParms) {
        if (results.requestSucceeded()) {
            request.setResults(new CIMValue((Object)SD_CR_RET_SUCCESS, new CIMDataType(5)));
        } else {
            request.setResults(new CIMValue((Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())), new CIMDataType(5)));
        }
    }

    public ModifySunStorEdge_DSPStorageDomainConfigurationService(ArrayObject array) {
        super(array);
    }
}

