/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMUtils;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspPage;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ModifySunStorEdge_DSPStorageDomain
extends ModifyModule {
    private static String CLASSNAME = "ModifySunStorEdge_DSPStorageDomain";
    private static String SD_CLASS = "SunStorEdge_DSPStorageDomain";
    private static String POOL_CLASS = "SunStorEdge_DSPStoragePool";
    private static String SD_NAME = "ElementName";
    private static final String SVSD_MODIFY_PAGE = "response.xml";
    private static final String SVSD_MODIFY_NAME = "samVsd_setCurrent";
    private static final String SVSD_MODIFY_DESC = "samVsd_curDescription";
    private static final String SVSD_DEL_PAGE = "vsdDel.htm";
    private static final String SVSD_DEL_NAME = "samVsd_setCurrent";
    private static final String GROUP_COMPONENT = "GroupComponent";
    private static final String PART_COMPONENT = "PartComponent";
    private static final String HOSTED_STORAGE_POOL_CLASS = "SunStorEdge_DSPHostedStoragePool";
    private static final Integer DOMAIN_DEL_RET_IN_USE = new Integer(6);

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        DspResults results = null;
        String classname = request.getCIMClassName();
        if (!classname.equals(SD_CLASS)) {
            return false;
        }
        Vector tokens = new Vector();
        if (request instanceof SetRequest) {
            this.buildSvsdModifyParms((SetRequest)request, tokens);
            String page = new String(SVSD_MODIFY_PAGE);
            results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
            this.parseSvsdModifyResults(results);
            RequestBroker.getInstance().reloadCachePage(this.getSystem(), DspPage.SVSDS_PAGE.toString());
            return true;
        }
        if (!(request instanceof CreateRequest)) {
            if (request instanceof DeleteRequest) {
                DeleteRequest deleteRequest = (DeleteRequest)request;
                CIMObjectPath path = request.getObjectPath();
                CIMInstance instance = RequestBroker.getInstance().findInstance(path);
                String svsdName = DspUtil.unquote(CIMUtils.getPropertyValue(instance, SD_NAME).toString());
                CIMObjectPath hostedStoragePool = new CIMObjectPath(HOSTED_STORAGE_POOL_CLASS);
                CIMInstance[] insts = RequestBroker.getInstance().associators(hostedStoragePool, instance.getObjectPath(), POOL_CLASS, GROUP_COMPONENT, PART_COMPONENT, false, true, null);
                if (insts != null) {
                    Trace.error((Object)this, (String)METHOD, (String)(" Storage Domain Delete Failed. Status:" + DOMAIN_DEL_RET_IN_USE));
                    CIMException tmpE = new CIMException("CIM_ERR_FAILED", (Object)DOMAIN_DEL_RET_IN_USE);
                    tmpE.setDescription("DSP Operation Failed");
                    throw tmpE;
                }
                this.buildSvsdDeleteParms(deleteRequest, tokens);
                String page = new String(SVSD_DEL_PAGE);
                results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
                this.parseSvsdDeleteResults(results);
                String[] logArgs = new String[]{svsdName, this.getSystem().getHost()};
                try {
                    if (results.requestSucceeded()) {
                        this.cleanupDomainReferences(path);
                        RequestBroker.getInstance().deleteInstance(path);
                        RequestBroker.getInstance().reloadCachePage(this.getSystem(), DspPage.INITIATORS_PAGE.toString());
                        RequestBroker.getInstance().reloadCachePage(this.getSystem(), DspPage.SVSDS_PAGE.toString());
                        LogAPI.staticLog((String)"DSP_DOMAIN_DELETED", (String[])logArgs, null);
                    } else {
                        LogAPI.staticLog((String)"DSP_DOMAIN_DELETE_FAILED", (String[])logArgs, null);
                    }
                }
                catch (Exception logEx) {
                    // empty catch block
                }
                return true;
            }
            if (request instanceof InvokeRequest) {
                // empty if block
            }
        }
        return false;
    }

    private void buildSvsdModifyParms(SetRequest request, Vector nvPairs) throws CIMException {
        CIMInstance instance = request.getInstance();
        String svsdDescription = DspUtil.unquote(CIMUtils.getPropertyValue(instance, "Description").toString());
        String svsdName = DspUtil.unquote(CIMUtils.getPropertyValue(instance, SD_NAME).toString());
        nvPairs.add(new String("samVsd_setCurrent=" + svsdName));
        nvPairs.add(new String("samVsd_curDescription=" + svsdDescription));
    }

    private void parseSvsdModifyResults(DspResults results) throws CIMException {
        String METHOD = "parseSvsdModifyResults";
        if (!results.requestSucceeded()) {
            Trace.error((Object)this, (String)"parseSvsdModifyResults", (String)(" Storage Domain Modify Failed. Status:" + DspUtil.mapDSPReturnCode(results.getReturnCode())));
            CIMException tmpE = new CIMException("CIM_ERR_FAILED", (Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())));
            tmpE.setDescription("DSP Operation Failed");
            throw tmpE;
        }
    }

    private void buildSvsdDeleteParms(DeleteRequest request, Vector nvPairs) throws CIMException {
        CIMObjectPath path = request.getObjectPath();
        CIMInstance instance = RequestBroker.getInstance().findInstance(path);
        String svsdName = DspUtil.unquote(CIMUtils.getPropertyValue(instance, SD_NAME).toString());
        nvPairs.add(new String("samVsd_setCurrent=" + svsdName));
    }

    private void parseSvsdDeleteResults(DspResults results) throws CIMException {
        String METHOD = "parseSvsdDeleteResults";
        if (!results.requestSucceeded()) {
            Trace.error((Object)this, (String)"parseSvsdDeleteResults", (String)(" Storage Domain Delete Failed. Status:" + DspUtil.mapDSPReturnCode(results.getReturnCode())));
            CIMException tmpE = new CIMException("CIM_ERR_FAILED", (Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())));
            tmpE.setDescription("DSP Operation Failed");
            throw tmpE;
        }
    }

    public ModifySunStorEdge_DSPStorageDomain(ArrayObject array) {
        super(array);
    }

    private void cleanupDomainReferences(CIMObjectPath domainPath) throws CIMException {
        int j;
        String METHOD_NAME = "cleanupDomainReferences";
        Trace.methodBegin((Object)this, (String)"cleanupDomainReferences");
        CIMObjectPath ccPath = new CIMObjectPath("SunStorEdge_DSPComponentCS");
        CIMObjectPath[] referencePaths = RequestBroker.getInstance().referenceNames(ccPath, domainPath, PART_COMPONENT);
        int referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
        for (int i = 0; i < referencePathsLength; ++i) {
            RequestBroker.getInstance().deleteInstance(referencePaths[i]);
        }
        CIMObjectPath hcPath = new CIMObjectPath("SunStorEdge_DSPHostedCollection");
        CIMObjectPath[] dicPaths = RequestBroker.getInstance().associatorNames(hcPath, domainPath, "SunStorEdge_DSPDomainInitiatorCollection", "Antecedent", "Dependent");
        CIMObjectPath mofPath = new CIMObjectPath("SunStorEdge_DSPMemberOfCollection");
        int dicPathsLength = dicPaths == null ? 0 : dicPaths.length;
        for (int i = 0; i < dicPathsLength; ++i) {
            int j2;
            referencePaths = RequestBroker.getInstance().referenceNames(mofPath, dicPaths[i], "Collection");
            referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
            for (j2 = 0; j2 < referencePathsLength; ++j2) {
                RequestBroker.getInstance().deleteInstance(referencePaths[j2]);
            }
            referencePaths = RequestBroker.getInstance().referenceNames(hcPath, dicPaths[i], "Dependent");
            referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
            for (j2 = 0; j2 < referencePathsLength; ++j2) {
                RequestBroker.getInstance().deleteInstance(referencePaths[j2]);
            }
            RequestBroker.getInstance().deleteInstance(dicPaths[i]);
        }
        CIMObjectPath cspPath = new CIMObjectPath("SunStorEdge_DSPComputerSystemPackage");
        referencePaths = RequestBroker.getInstance().referenceNames(cspPath, domainPath, "Dependent");
        referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
        for (int i = 0; i < referencePathsLength; ++i) {
            RequestBroker.getInstance().deleteInstance(referencePaths[i]);
        }
        CIMObjectPath ecPath = new CIMObjectPath("SunStorEdge_DSPElementCapabilities");
        CIMObjectPath[] pcmcPaths = RequestBroker.getInstance().associatorNames(ecPath, domainPath, "SunStorEdge_DSPProtocolControllerMaskingCapabilities", "ManagedElement", "Capabilities");
        int pcmcPathsLength = pcmcPaths == null ? 0 : pcmcPaths.length;
        for (int i = 0; i < pcmcPathsLength; ++i) {
            referencePaths = RequestBroker.getInstance().referenceNames(ecPath, pcmcPaths[i], "Capabilities");
            referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
            for (int j3 = 0; j3 < referencePathsLength; ++j3) {
                RequestBroker.getInstance().deleteInstance(referencePaths[j3]);
            }
            RequestBroker.getInstance().deleteInstance(pcmcPaths[i]);
        }
        CIMObjectPath hsPath = new CIMObjectPath("SunStorEdge_DSPHostedService");
        CIMObjectPath[] shimsPaths = RequestBroker.getInstance().associatorNames(hsPath, domainPath, "SunStorEdge_DSPStorageHardwareIDManagementService", "Antecedent", "Dependent");
        CIMObjectPath cdPath = new CIMObjectPath("SunStorEdge_DSPConcreteDependency");
        int shimsPathsLength = shimsPaths == null ? 0 : shimsPaths.length;
        for (int i = 0; i < shimsPathsLength; ++i) {
            int j4;
            referencePaths = RequestBroker.getInstance().referenceNames(hsPath, shimsPaths[i], "Dependent");
            referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
            for (j4 = 0; j4 < referencePathsLength; ++j4) {
                RequestBroker.getInstance().deleteInstance(referencePaths[j4]);
            }
            referencePaths = RequestBroker.getInstance().referenceNames(cdPath, shimsPaths[i], "Antecedent");
            referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
            for (j4 = 0; j4 < referencePathsLength; ++j4) {
                RequestBroker.getInstance().deleteInstance(referencePaths[j4]);
            }
            RequestBroker.getInstance().deleteInstance(shimsPaths[i]);
        }
        CIMObjectPath[] scsPaths = RequestBroker.getInstance().associatorNames(hsPath, domainPath, "SunStorEdge_DSPStorageConfigurationService", "Antecedent", "Dependent");
        int scsPathsLength = scsPaths == null ? 0 : scsPaths.length;
        for (int i = 0; i < scsPathsLength; ++i) {
            referencePaths = RequestBroker.getInstance().referenceNames(hsPath, scsPaths[i], "Dependent");
            referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
            for (int j5 = 0; j5 < referencePathsLength; ++j5) {
                RequestBroker.getInstance().deleteInstance(referencePaths[j5]);
            }
            CIMObjectPath[] sccPaths = RequestBroker.getInstance().associatorNames(ecPath, scsPaths[i], "SunStorEdge_DSPStorageConfigurationCapabilities", "ManagedElement", "Capabilities");
            int sccPathsLength = sccPaths == null ? 0 : sccPaths.length;
            for (j = 0; j < sccPathsLength; ++j) {
                referencePaths = RequestBroker.getInstance().referenceNames(ecPath, sccPaths[j], "Capabilities");
                referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
                for (int z = 0; z < referencePathsLength; ++z) {
                    RequestBroker.getInstance().deleteInstance(referencePaths[z]);
                }
                RequestBroker.getInstance().deleteInstance(sccPaths[j]);
            }
            RequestBroker.getInstance().deleteInstance(scsPaths[i]);
        }
        CIMObjectPath[] ccsPaths = RequestBroker.getInstance().associatorNames(hsPath, domainPath, "SunStorEdge_DSPControllerConfigurationService", "Antecedent", "Dependent");
        int ccsPathsLength = ccsPaths == null ? 0 : ccsPaths.length;
        for (int i = 0; i < ccsPathsLength; ++i) {
            referencePaths = RequestBroker.getInstance().referenceNames(hsPath, ccsPaths[i], "Dependent");
            referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
            for (j = 0; j < referencePathsLength; ++j) {
                RequestBroker.getInstance().deleteInstance(referencePaths[j]);
            }
            RequestBroker.getInstance().deleteInstance(ccsPaths[i]);
        }
        CIMObjectPath hdPath = new CIMObjectPath("SunStorEdge_DSPHostedDependency");
        CIMObjectPath[] pPaths = null;
        int pPathsLength = -1;
        CIMObjectPath[] pmsPaths = RequestBroker.getInstance().associatorNames(hsPath, domainPath, "SunStorEdge_DSPPrivilegeManagementService", "Antecedent", "Dependent");
        int pmsPathsLength = pmsPaths == null ? 0 : pmsPaths.length;
        for (int i = 0; i < pmsPathsLength; ++i) {
            int j6;
            referencePaths = RequestBroker.getInstance().referenceNames(hsPath, pmsPaths[i], "Dependent");
            referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
            for (j6 = 0; j6 < referencePathsLength; ++j6) {
                RequestBroker.getInstance().deleteInstance(referencePaths[j6]);
            }
            pPaths = RequestBroker.getInstance().associatorNames(hdPath, pmsPaths[i], "SunStorEdge_DSPPrivilege", "Antecedent", "Dependent");
            pPathsLength = pPaths == null ? 0 : pPaths.length;
            for (j6 = 0; j6 < pPathsLength; ++j6) {
                referencePaths = RequestBroker.getInstance().referenceNames(hdPath, pPaths[j6], "Dependent");
                referencePathsLength = referencePaths == null ? 0 : referencePaths.length;
                for (int z = 0; z < referencePathsLength; ++z) {
                    RequestBroker.getInstance().deleteInstance(referencePaths[z]);
                }
                RequestBroker.getInstance().deleteInstance(pPaths[j6]);
            }
            RequestBroker.getInstance().deleteInstance(pmsPaths[i]);
        }
    }
}

