/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.Constants;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class ModifySunStorEdge_DSPReplicationLink
extends ModifyModule {
    private static final String CLASSNAME = "SunStorEdge_DSPReplicationLink";
    private static final String EP_ENABLE_PAGE = "epEnable.htm";
    private static final String REAL_PORT = "realPort";
    private static final String LOCAL_ADDR = "localIpAddr";
    private static final String NET_MASK = "ipMask";
    private static final String DEFAULT_GATE = "defaultGateway";
    private static final String LINK_INFO = "linkInfo";
    private String[] classes = new String[0];
    static /* synthetic */ Class class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink;

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        DspResults results = null;
        String classname = request.getCIMClassName();
        if (!classname.equals(CLASSNAME)) {
            return false;
        }
        Vector tokens = new Vector();
        if (!(request instanceof SetRequest) && !(request instanceof CreateRequest)) {
            if (request instanceof DeleteRequest) {
                Trace.info((Object)this, (String)"handleRequest", (String)" Delete Request");
                String deviceID = null;
                String localAddress = null;
                String networkMask = null;
                String defaultGateway = null;
                String remoteAddress = null;
                String linkInfo = null;
                Vector<String> nvPairs = new Vector<String>();
                CIMObjectPath linkPath = request.getObjectPath();
                CIMInstance linkInstance = RequestBroker.getInstance().findInstance(linkPath);
                if (linkInstance == null) {
                    Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get ReplicationLink instance. ");
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                    tmpe.setDescription("Internal error: Could not find ReplicationLink Instance.");
                    throw tmpe;
                }
                CIMValue remoteAddr = linkInstance.getProperty("RemoteAddress").getValue();
                if (remoteAddr == null) {
                    Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get remote address attribute. ");
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                    tmpe.setDescription("Internal error: Could not obtain remote address attribute.");
                    throw tmpe;
                }
                remoteAddress = (String)remoteAddr.getValue();
                CIMObjectPath settingData = new CIMObjectPath("SunStorEdge_DSPElementSettingData");
                settingData.setNameSpace("\\root\\se6x20\\");
                CIMInstance[] eportInstances = RequestBroker.getInstance().associators(settingData, linkPath, "SunStorEdge_DSPEthernetPort", "SettingData", "ManagedElement", false, true, null);
                if (eportInstances != null) {
                    CIMValue defaultGate;
                    CIMObjectPath eportPath = eportInstances[0].getObjectPath();
                    CIMInstance eportInst = RequestBroker.getInstance().findInstance(eportPath);
                    if (eportInst == null) {
                        Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get EthernetPort instance. ");
                        CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                        tmpe.setDescription("Internal error: Could not find EthernetPort Instance.");
                        throw tmpe;
                    }
                    CIMValue deviceIDVal = eportInst.getProperty("DeviceID").getValue();
                    if (deviceIDVal == null) {
                        Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get deviceID attribute. ");
                        CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                        tmpe.setDescription("Internal error: Could not obtain deviceID attribute.");
                        throw tmpe;
                    }
                    deviceID = (String)deviceIDVal.getValue();
                    CIMInstance[] repPortInstances = RequestBroker.getInstance().associators(settingData, eportPath, "SunStorEdge_DSPReplicationPort", "ManagedElement", "SettingData", false, true, null);
                    if (repPortInstances != null) {
                        CIMValue localAddr = repPortInstances[0].getProperty("LocalAddress").getValue();
                        if (localAddr == null) {
                            Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get local address attribute. ");
                            CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                            tmpe.setDescription("Internal error: Could not obtain local address attribute.");
                            throw tmpe;
                        }
                        localAddress = (String)localAddr.getValue();
                        CIMValue netMask = repPortInstances[0].getProperty("NetworkMask").getValue();
                        if (netMask == null) {
                            Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get network mask attribute. ");
                            CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                            tmpe.setDescription("Internal error: Could not obtain network mask attribute.");
                            throw tmpe;
                        }
                        networkMask = (String)netMask.getValue();
                        defaultGate = repPortInstances[0].getProperty("DefaultGateway").getValue();
                        if (defaultGate == null) {
                            Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get default gateway attribute.");
                            CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                            tmpe.setDescription("Internal error: Could not obtain default gateway attribute.");
                            throw tmpe;
                        }
                    } else {
                        Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get ReplicationPort instance. ");
                        CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                        tmpe.setDescription("Internal error: Could not obtain ReplicationPort instance.");
                        throw tmpe;
                    }
                    defaultGateway = (String)defaultGate.getValue();
                    CIMInstance[] linkInstances = RequestBroker.getInstance().associators(settingData, eportPath, CLASSNAME, "ManagedElement", "SettingData", false, true, null);
                    if (linkInstances != null) {
                        for (int k = 0; k < linkInstances.length; ++k) {
                            CIMInstance linkInst = linkInstances[k];
                            remoteAddr = linkInst.getProperty("RemoteAddress").getValue();
                            if (remoteAddr == null) {
                                Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get remote address attribute.");
                                CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                                tmpe.setDescription("Internal error: Could not obtain remote address attribute.");
                                throw tmpe;
                            }
                            CIMValue description = linkInst.getProperty("Description").getValue();
                            if (description == null) {
                                Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get description attribute. ");
                                CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                                tmpe.setDescription("Internal error: Could not obtain description attribute.");
                                throw tmpe;
                            }
                            String curRemoteAddress = (String)remoteAddr.getValue();
                            if (curRemoteAddress.equalsIgnoreCase(remoteAddress)) continue;
                            linkInfo = linkInfo == null ? new String() : linkInfo + "#";
                            linkInfo = linkInfo + curRemoteAddress + "$" + (String)description.getValue();
                        }
                        if (linkInfo == null) {
                            linkInfo = new String();
                        }
                        nvPairs.add("realPort=" + deviceID);
                        nvPairs.add("localIpAddr=" + localAddress);
                        nvPairs.add("ipMask=" + networkMask);
                        nvPairs.add("defaultGateway=" + defaultGateway);
                        nvPairs.add("linkInfo=" + linkInfo);
                        String page = new String(EP_ENABLE_PAGE);
                        results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, nvPairs);
                    }
                } else {
                    Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get EthernetPort instance. ");
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                    tmpe.setDescription("Internal error: Could not obtain EthernetPort instance.");
                    throw tmpe;
                }
                if (results.requestSucceeded()) {
                    CIMObjectPath settingPath = new CIMObjectPath("SunStorEdge_DSPElementSettingData");
                    settingPath.setNameSpace("\\root\\se6x20\\");
                    CIMObjectPath[] settingAssocs = RequestBroker.getInstance().referenceNames(settingPath, linkPath, "SettingData");
                    if (settingAssocs != null) {
                        RequestBroker.getInstance().deleteInstance(settingAssocs[0]);
                    }
                } else {
                    Trace.error((Object)this, (String)"handleRequest", (String)" No EthernetPort instance found. ");
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED", (Object)Constants.CIM_ERR_ERRORS);
                    tmpe.setDescription("Internal error: Could not obtain EthernetPort instance.");
                    throw tmpe;
                }
                RequestBroker.getInstance().deleteInstance(linkPath);
                return true;
            }
            if (request instanceof InvokeRequest) {
                // empty if block
            }
        }
        return false;
    }

    public ModifySunStorEdge_DSPReplicationLink(ArrayObject system) {
        super(system);
    }

    public static void createLink(CreateRequest request) throws CIMException {
        String METHOD = "createLink";
        Trace.methodBegin((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink = ModifySunStorEdge_DSPReplicationLink.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPReplicationLink")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink), (String)"createLink");
        if (request == null) {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink = ModifySunStorEdge_DSPReplicationLink.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPReplicationLink")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink), (String)"createLink", (String)" Null request argument. ");
            throw new CIMException("CIM_ERR_FAILED");
        }
        CIMInstance theInstance = request.getNewInstance();
        CIMObjectPath thePath = theInstance.getObjectPath();
        thePath.setNameSpace(request.getObjectPath().getNameSpace());
        RequestBroker.getInstance().addSyntheticCacheInstance(thePath, theInstance);
        request.setResults(thePath);
    }

    public static boolean handleModify(ModifyRequest request) throws CIMException {
        String METHOD = "handleModify";
        Trace.methodBegin((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink = ModifySunStorEdge_DSPReplicationLink.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPReplicationLink")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink), (String)"handleModify");
        SetRequest srequest = (SetRequest)request;
        CIMInstance newLink = srequest.getInstance();
        CIMInstance link = RequestBroker.getInstance().findInstance(srequest.getObjectPath());
        if (link == null) {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink = ModifySunStorEdge_DSPReplicationLink.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPReplicationLink")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPReplicationLink), (String)"handleModify", (String)" Unable to get ReplicationLink Instance. ");
            CIMException tmpe = new CIMException("CIM_ERR_FAILED");
            tmpe.setDescription("Internal error: Failed getInstance.");
            throw tmpe;
        }
        link.setProperty("RemoteAddress", newLink.getProperty("RemoteAddress").getValue());
        link.setProperty("Description", newLink.getProperty("Description").getValue());
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

