/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMUtils;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspPage;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ModifySunStorEdge_DSPFibreChannelPort
extends ModifyModule {
    private static String CLASSNAME = "ModifySunStorEdge_DSPFibreChannelPort";
    private static String FCPORT_CLASS = "SunStorEdge_DSPFCPort";
    private static final String FCPORT_MOD_PAGE = "response.xml";
    private static final String FCPORT_MOD_NAME = "samPort_setCurrentAndModule";
    private static final String FCPORT_MOD_LINK_TRAP = "samPort_curLinkTrapEnable";
    private static final String FCPORT_MOD_DESC = "samPort_curDescription";
    private static final String FCPORT_MOD_SPEED = "samPort_curFcPortSpeed";
    private static final String FCPORT_MOD_SUBMIT = "submit";
    private static final String FCPORT_MOD_PEER = "samPort_curPeerPortEnabled";
    private static final String FCPORT_LINK_ENABLED = "1";
    private static final String FCPORT_SUBMIT = "submit";
    private static final String FCPORT_SPEED_1G = "1G";
    private static final String FCPORT_SPEED_2G = "2G";
    private static final String FCPORT_SPEED_AUTO = "AUTO";
    private static final String FCPORT_PROP_NAME = "DeviceID";
    private static final String FCPORT_PROP_AUTOSENSE = "AutoSense";
    private static final String FCPORT_PROP_SPEED = "Speed";
    private static final String FCPORT_PROP_DESC = "Description";
    private static final String FCPORT_PROP_PEER = "ReplicationCapable";
    private static final String FCPORT_TRUE = "true";
    private static final String FCPORT_1G = "850000000";
    private static final String FCPORT_2G = "1700000000";
    private static final String FCPORT_DESC_NULL = "";

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        DspResults results = null;
        String classname = request.getCIMClassName();
        if (!classname.equals(FCPORT_CLASS)) {
            return false;
        }
        Vector tokens = new Vector();
        if (request instanceof SetRequest) {
            this.buildFcPortModifyParms((SetRequest)request, tokens);
            String page = new String(FCPORT_MOD_PAGE);
            results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
            this.parseFcPortModifyResults(results);
            RequestBroker.getInstance().reloadCachePage(this.getSystem(), DspPage.FCPORTS_PAGE.toString());
            return true;
        }
        if (request instanceof CreateRequest || request instanceof DeleteRequest || request instanceof InvokeRequest) {
            // empty if block
        }
        return false;
    }

    private void buildFcPortModifyParms(SetRequest request, Vector nvPairs) throws CIMException {
        CIMObjectPath path = request.getObjectPath();
        CIMInstance instance = RequestBroker.getInstance().findInstance(path);
        String portName = DspUtil.unquote(CIMUtils.getPropertyValue(instance, FCPORT_PROP_NAME).toString());
        String linkTrap = FCPORT_LINK_ENABLED;
        String submit = "submit";
        String peerPortStr = new String("false");
        Properties props = request.getProperties();
        String speed = FCPORT_SPEED_1G;
        String val = props.getProperty(FCPORT_PROP_AUTOSENSE);
        if (val != null) {
            if (val.equalsIgnoreCase(FCPORT_TRUE)) {
                speed = FCPORT_SPEED_AUTO;
            } else {
                val = props.getProperty(FCPORT_PROP_SPEED);
                if (val != null && val.equalsIgnoreCase(FCPORT_2G)) {
                    speed = FCPORT_SPEED_2G;
                }
            }
        }
        String description = FCPORT_DESC_NULL;
        val = props.getProperty(FCPORT_PROP_DESC);
        if (val != null) {
            description = val;
        }
        if ((val = props.getProperty(FCPORT_PROP_PEER)) != null && val.equalsIgnoreCase(FCPORT_TRUE)) {
            peerPortStr = FCPORT_TRUE;
        }
        nvPairs.add(new String("samPort_setCurrentAndModule=" + portName));
        nvPairs.add(new String("samPort_curLinkTrapEnable=" + linkTrap));
        nvPairs.add(new String("samPort_curDescription=" + description));
        nvPairs.add(new String("samPort_curFcPortSpeed=" + speed));
        nvPairs.add(new String("samPort_curPeerPortEnabled=" + peerPortStr));
    }

    private void parseFcPortModifyResults(DspResults results) throws CIMException {
        String METHOD = "parseFcPortModifyResults";
        if (!results.requestSucceeded()) {
            Trace.error((Object)this, (String)"parseFcPortModifyResults", (String)(" Storage Volume Modify Failed. Status:" + DspUtil.mapDSPReturnCode(results.getReturnCode())));
            CIMException tmpE = new CIMException("CIM_ERR_FAILED", (Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())));
            tmpE.setDescription("DSP Operation Failed");
            throw tmpE;
        }
    }

    public ModifySunStorEdge_DSPFibreChannelPort(ArrayObject array) {
        super(array);
    }
}

