/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMUtils;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ModifySunStorEdge_DSPEthernetPort
extends ModifyModule {
    private static String CLASSNAME = "ModifySunStorEdge_DSPEthernetPort";
    private static String PORT_CLASS = "SunStorEdge_DSPEthernetPort";
    private static final String EPORTS_XML = "eports.xml";
    private static final String PORT_MOD_PAGE = "response.xml";
    private static final String PORT_MOD_PEER = "samPort_curPeerPortEnabled";
    private static final String PORT_MOD_NAME = "samPort_setCurrentAndModule";
    private static final String PORT_PROP_PEER = "ReplicationCapable";
    private static final String PORT_TRUE = "true";
    private static final String PORT_PROP_NAME = "DeviceID";

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        Trace.methodBegin((Object)this, (String)"handleRequest");
        DspResults results = null;
        String classname = request.getCIMClassName();
        if (!classname.equals(PORT_CLASS)) {
            return false;
        }
        Vector tokens = new Vector();
        if (request instanceof SetRequest) {
            boolean repCapable = false;
            CIMObjectPath path = request.getObjectPath();
            Properties props = ((SetRequest)request).getProperties();
            String val = props.getProperty(PORT_PROP_PEER);
            if (val != null && val.equalsIgnoreCase(PORT_TRUE)) {
                repCapable = true;
            }
            this.buildPortModifyParms((SetRequest)request, tokens);
            String page = new String(PORT_MOD_PAGE);
            results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
            this.parsePortModifyResults(results, repCapable, path);
            return true;
        }
        if (request instanceof CreateRequest || request instanceof DeleteRequest || request instanceof InvokeRequest) {
            // empty if block
        }
        return false;
    }

    private void buildPortModifyParms(SetRequest request, Vector nvPairs) throws CIMException {
        String METHOD = "buildPortModifyParms";
        Trace.methodBegin((Object)this, (String)"buildPortModifyParms");
        CIMObjectPath path = request.getObjectPath();
        CIMInstance instance = RequestBroker.getInstance().findInstance(path);
        String peerPortStr = new String("false");
        String portName = DspUtil.unquote(CIMUtils.getPropertyValue(instance, PORT_PROP_NAME).toString());
        Properties props = request.getProperties();
        String val = props.getProperty(PORT_PROP_PEER);
        if (val != null && val.equalsIgnoreCase(PORT_TRUE)) {
            peerPortStr = PORT_TRUE;
        }
        nvPairs.add(new String("samPort_setCurrentAndModule=" + portName));
        nvPairs.add(new String("samPort_curPeerPortEnabled=" + peerPortStr));
    }

    private void parsePortModifyResults(DspResults results, boolean repCapable, CIMObjectPath eportPath) throws CIMException {
        String METHOD = "parsePortModifyResults";
        Trace.methodBegin((Object)this, (String)"parsePortModifyResults");
        if (results.requestSucceeded()) {
            String etherPage = EPORTS_XML;
            RequestBroker.getInstance().reloadCachePage(this.getSystem(), etherPage);
            if (!repCapable) {
                this.deleteRepPortModel(eportPath);
                CIMObjectPath settingData = new CIMObjectPath("SunStorEdge_DSPElementSettingData");
                settingData.setNameSpace("\\root\\se6x20\\");
                eportPath.setNameSpace("\\root\\se6x20\\");
                CIMInstance[] linkInstances = RequestBroker.getInstance().associators(settingData, eportPath, "SunStorEdge_DSPReplicationLink", "ManagedElement", "SettingData", false, true, null);
                if (linkInstances != null) {
                    for (int j = 0; j < linkInstances.length; ++j) {
                        RequestBroker.getInstance().deleteInstance(linkInstances[j].getObjectPath());
                    }
                }
            }
        } else {
            Trace.error((Object)this, (String)"parsePortModifyResults", (String)(" Ethernet Port Modify Failed. Status:" + DspUtil.mapDSPReturnCode(results.getReturnCode())));
            CIMException tmpE = new CIMException("CIM_ERR_FAILED", (Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())));
            tmpE.setDescription("DSP Operation Failed");
            throw tmpE;
        }
    }

    private void deleteRepPortModel(CIMObjectPath eportPath) throws CIMException {
        String METHOD = "deleteRepPortModel";
        Trace.methodBegin((Object)this, (String)"deleteRepPortModel");
        CIMObjectPath settingData = new CIMObjectPath("SunStorEdge_DSPElementSettingData");
        settingData.setNameSpace("\\root\\se6x20\\");
        CIMInstance[] settingsInstances = RequestBroker.getInstance().associators(settingData, eportPath, "SunStorEdge_DSPReplicationPort", "ManagedElement", "SettingData", false, true, null);
        if (settingsInstances != null) {
            for (int i = 0; i < settingsInstances.length; ++i) {
                CIMObjectPath repPortPath = settingsInstances[i].getObjectPath();
                CIMObjectPath settingPath = new CIMObjectPath("SunStorEdge_DSPElementSettingData");
                settingPath.setNameSpace("\\root\\se6x20\\");
                CIMObjectPath[] settingAssocs = RequestBroker.getInstance().referenceNames(settingPath, repPortPath, "SettingData");
                if (settingAssocs != null) {
                    RequestBroker.getInstance().deleteInstance(settingAssocs[0]);
                }
                RequestBroker.getInstance().deleteInstance(repPortPath);
            }
        }
    }

    public ModifySunStorEdge_DSPEthernetPort(ArrayObject array) {
        super(array);
    }
}

