/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ObjectPath;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.util.Calendar;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;

public class ModifySunStorEdge_DSPControllerConfigurationService
extends ModifyModule {
    private static String CLASSNAME = "ModifySunStorEdge_DSPStorageConfigurationService";
    private static String CCS_CLASS = "SunStorEdge_DSPControllerConfigurationService";
    private static String SCSIPC_CLASS = "SunStorEdge_DSPSCSIProtocolController";
    private static String VOLUME_CLASS = "SunStorEdge_DSPStorageVolume";
    private static String PCUNIT_CLASS = "SunStorEdge_DSPProtocolControllerForUnit";
    private static String AUTHORIZED_TARGET_CLASS = "SunStorEdge_DSPAuthorizedTarget";
    private static String AUTHORIZED_SUBJECT_CLASS = "SunStorEdge_DSPAuthorizedSubject";
    private static String PRIVILEGE_CLASS = "SunStorEdge_DSPPrivilege";
    private static String CONCRETE_DEPEND_CLASS = "SunStorEdge_DSPConcreteDependency";
    private static String PROTOCOL_FOR_PORT_CLASS = "SunStorEdge_DSPProtocolControllerForPort";
    private static final double VOL_SIZE_KB = 1024.0;
    private static final double VOL_SIZE_MB = 1048576.0;
    private static final double VOL_SIZE_GB = 1.073741824E9;
    private static final double VOL_SIZE_TB = 1.099511627776E12;
    private static final String AD_CR_SERVER_ID = "serverWWN";
    private static final String AD_CR_DEVICE_ID = "deviceWWN";
    private static final String AD_CR_LUN = "lun";
    private static final String AD_CR_DEVICE_TYPE = "deviceType";
    private static final String AD_CR_ACCESS_LEVEL = "accessLevel";
    private static final String AD_CR_FCTARG_NAME = "targetName";
    private static final String DD_CR_SERVER_ID = "serverWWN";
    private static final String DD_CR_LUN = "lun";
    private static final String PD_CR_TARG_NAME = "fcTargName";
    private static final String PD_CR_VSD_NAME = "vsdName";
    private static final Integer PC_CR_RET_SUCCESS = new Integer(0);
    private static final Integer PC_CR_RET_NOT_SUPPORTED = new Integer(1);
    private static final Integer PC_CR_RET_UNSPEC_ERROR = new Integer(2);
    private static final Integer PC_CR_RET_TIMEOUT = new Integer(3);
    private static final Integer PC_CR_RET_FAILED = new Integer(4);
    private static final Integer PC_CR_RET_INVALID_PARAM = new Integer(5);
    private static final Integer PC_CR_RET_DMTF_RESV_LOWER_LIMIT = new Integer(6);
    private static final Integer PC_CR_RET_DMTF_RESV_UPPER_LIMIT = new Integer(4095);
    private static final Integer PC_CR_RET_ID_PARAM_MISSING_OR_NOT_UNIQUE = new Integer(4096);
    private static final Integer PC_CR_RET_HW_IMPL_REQ_NULL_PORTS_PARAMS = new Integer(4097);
    private static final Integer PC_CR_RET_BUSY = new Integer(4098);
    private static final Integer PC_CR_RET_METHOD_RESV_LOWER_LIMIT = new Integer(4099);
    private static final Integer PC_CR_RET_METHOD_RESV_UPPER_LIMIT = new Integer(Short.MAX_VALUE);
    private static final Integer PC_CR_RET_VEND_SPEC_LOWER_LIMIT = new Integer(32768);
    private static final Integer PC_CR_RET_VEND_SPEC_UPPER_LIMIT = new Integer(65535);
    private static final Integer AD_CR_RET_SUCCESS = new Integer(0);
    private static final Integer AD_CR_RET_NOT_SUPPORTED = new Integer(1);
    private static final Integer AD_CR_RET_UNSPEC_ERROR = new Integer(2);
    private static final Integer AD_CR_RET_TIMEOUT = new Integer(3);
    private static final Integer AD_CR_RET_FAILED = new Integer(4);
    private static final Integer AD_CR_RET_INVALID_PARAM = new Integer(5);
    private static final Integer AD_CR_RET_DMTF_RESV_LOWER_LIMIT = new Integer(6);
    private static final Integer AD_CR_RET_DMTF_RESV_UPPER_LIMIT = new Integer(4095);
    private static final Integer AD_CR_RET_INVALID_LOGICAL_DEVICE_INST = new Integer(4096);
    private static final Integer AD_CR_RET_DEVICE_NUMBER_CONFLICT = new Integer(4097);
    private static final Integer AD_CR_RET_DEV_NUM_MUST_BE_PROVIDED = new Integer(4098);
    private static final Integer AD_CR_RET_HW_IMP_REQUIRES_NULL_DEV_NUM = new Integer(4099);
    private static final Integer AD_CR_RET_BUSY = new Integer(4100);
    private static final Integer AD_CR_RET_METHOD_RESV_LOWER_LIMIT = new Integer(4101);
    private static final Integer AD_CR_RET_METHOD_RESV_UPPER_LIMIT = new Integer(Short.MAX_VALUE);
    private static final Integer AD_CR_RET_VEND_SPEC_LOWER_LIMIT = new Integer(32768);
    private static final Integer AD_CR_RET_VEND_SPEC_UPPER_LIMIT = new Integer(65535);
    private static final Integer DD_CR_RET_SUCCESS = new Integer(0);
    private static final Integer DD_CR_RET_NOT_SUPPORTED = new Integer(1);
    private static final Integer DD_CR_RET_UNSPEC_ERROR = new Integer(2);
    private static final Integer DD_CR_RET_TIMEOUT = new Integer(3);
    private static final Integer DD_CR_RET_FAILED = new Integer(4);
    private static final Integer DD_CR_RET_INVALID_PARAM = new Integer(5);
    private static final Integer DD_CR_RET_DMTF_RESV_LOWER_LIMIT = new Integer(6);
    private static final Integer DD_CR_RET_DMTF_RESV_UPPER_LIMIT = new Integer(4095);
    private static final Integer DD_CR_RET_LOG_DEV_NOT_ASSOC_W_CNTRL = new Integer(4096);
    private static final Integer DD_CR_RET_BUSY = new Integer(4097);
    private static final Integer DD_CR_RET_METHOD_RESV_LOWER_LIMIT = new Integer(4098);
    private static final Integer DD_CR_RET_METHOD_RESV_UPPER_LIMIT = new Integer(Short.MAX_VALUE);
    private static final Integer DD_CR_RET_VEND_SPEC_LOWER_LIMIT = new Integer(32768);
    private static final Integer DD_CR_RET_VEND_SPEC_UPPER_LIMIT = new Integer(65535);
    private static final String VOLUME_XML_PAGE = "volume.xml";
    private static final String INITIATOR_XML_PAGE = "initor.xml";
    private static String DOMAIN_CLASS = "SunStorEdge_DSPStorageDomain";
    private static String HOSTED_SERVICE_CLASS = "SunStorEdge_DSPHostedService";
    private static String HOSTED_SERVICE_SERVICE = "Dependent";
    private static String HOSTED_SERVICE_SYSTEM = "Antecedent";
    private static String PC_FOR_UNIT_CONTROLLER = "Antecedent";
    private static String PC_FOR_UNIT_VOLUME = "Dependent";
    private static String AUTH_TARG_PRIV = "Privilege";
    private static String AUTH_TARG_ELEMENT = "TargetElement";
    private static String AUTH_SUBJ_PRIV = "Privilege";
    private static String AUTH_SUBJ_ELEMENT = "PrivilegedElement";
    private static String ANTECEDENT = "Antecedent";
    private static String DEPENDENT = "Dependent";
    private static String ELEMENT_NAME = "ElementName";
    private static String INSTANCE_ID = "InstanceID";
    private static String DEVICE_ID = "DeviceID";
    static /* synthetic */ Class class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPControllerConfigurationService;

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        String classname = request.getCIMClassName();
        if (!classname.equals(CCS_CLASS)) {
            return false;
        }
        DspResults results = null;
        Vector<String> tokens = new Vector<String>();
        Vector serverWwns = new Vector();
        Vector mapPermissions = new Vector();
        Vector initiators = new Vector();
        Vector protocol = new Vector();
        Vector volumeWwn = new Vector();
        if (request instanceof SetRequest) {
            Trace.error((Object)this, (String)"handleRequest", (String)" Modify on CCS not supported. ");
            CIMException tmpe = new CIMException("CIM_ERR_NOT_SUPPORTED");
            tmpe.setDescription("Modify not supported");
            throw tmpe;
        }
        if (!(request instanceof CreateRequest) && !(request instanceof DeleteRequest) && request instanceof InvokeRequest) {
            CIMArgument[] inParams = ((InvokeRequest)request).getInParams();
            CIMArgument[] outParams = ((InvokeRequest)request).getOutParams();
            if (((InvokeRequest)request).getMethodName().equals("CreateProtocolControllerWithPorts")) {
                CIMObjectPath privilegePath = null;
                CIMObjectPath identityPath = null;
                CIMObjectPath pcPath = new CIMObjectPath(SCSIPC_CLASS);
                pcPath.setNameSpace(request.getObjectPath().getNameSpace());
                CIMClass pcClass = SunStorEdge_DSPProvider.cimom.getClass(pcPath, false, true, true, null);
                if (pcClass == null) {
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                    tmpe.setDescription("Internal error: Failed getClass.");
                    throw tmpe;
                }
                CIMInstance pcInstance = pcClass.newInstance();
                for (int i = 0; i < inParams.length; ++i) {
                    if (inParams[i].getName().equals("Ports") || inParams[i].getName().equals("Protocol")) continue;
                    if (inParams[i].getName().equals("Privilege")) {
                        privilegePath = (CIMObjectPath)inParams[i].getValue().getValue();
                        continue;
                    }
                    if (inParams[i].getName().equals("Identity")) {
                        identityPath = (CIMObjectPath)inParams[i].getValue().getValue();
                        continue;
                    }
                    if (!inParams[i].getName().equals("ElementName")) continue;
                    String propName = inParams[i].getName();
                    CIMValue enValue = new CIMValue(inParams[i].getValue().getValue(), inParams[i].getType());
                    pcInstance.setProperty(propName, enValue);
                    CIMProperty property = pcInstance.getProperty(propName);
                    pcInstance.updatePropertyValue(property);
                    CIMObjectPath sccPath = new CIMObjectPath("SunStorEdge_DSPStorageDomain");
                    sccPath.setNameSpace(request.getObjectPath().getNameSpace());
                    String propName1 = new String("SystemCreationClassName");
                    CIMValue val1 = new CIMValue((Object)"SunStorEdge_DSPStorageDomain");
                    pcInstance.setProperty(propName1, val1);
                    CIMProperty prop1 = pcInstance.getProperty(propName1);
                    pcInstance.updatePropertyValue(prop1);
                    String propName2 = new String("SystemName");
                    CIMProperty nameProp2 = new CIMProperty("Name", new CIMValue((Object)this.getDomain(request)));
                    CIMValue val2 = nameProp2.getValue();
                    pcInstance.setProperty(propName2, val2);
                    CIMProperty prop2 = pcInstance.getProperty(propName2);
                    pcInstance.updatePropertyValue(prop2);
                    String propName3 = new String("CreationClassName");
                    String valName3 = SCSIPC_CLASS;
                    CIMValue val3 = new CIMValue((Object)valName3);
                    pcInstance.setProperty(propName3, val3);
                    CIMProperty prop3 = pcInstance.getProperty(propName3);
                    pcInstance.updatePropertyValue(prop3);
                    String propName4 = new String("DeviceID");
                    pcInstance.setProperty(propName4, enValue);
                    CIMProperty prop4 = pcInstance.getProperty(propName4);
                    pcInstance.updatePropertyValue(prop4);
                    String propName5 = new String("MaxUnitsControlled");
                    UnsignedInt32 valName5 = new UnsignedInt32(255L);
                    CIMValue val5 = new CIMValue((Object)valName5);
                    pcInstance.setProperty(propName5, val5);
                    CIMProperty prop5 = pcInstance.getProperty(propName5);
                    pcInstance.updatePropertyValue(prop5);
                }
                ArrayObject ao = this.getSystem();
                pcPath = pcInstance.getObjectPath();
                pcPath.setNameSpace(request.getObjectPath().getNameSpace());
                RequestBroker.getInstance().addSyntheticCacheInstance(pcInstance);
                CIMObjectPath authTargetPath = new CIMObjectPath("SunStorEdge_DSPAuthorizedTarget");
                authTargetPath.setNameSpace(request.getObjectPath().getNameSpace());
                CIMClass authTargetClass = SunStorEdge_DSPProvider.cimom.getClass(authTargetPath, false, true, true, null);
                if (authTargetClass == null) {
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                    tmpe.setDescription("Internal error: Failed getClass.");
                    throw tmpe;
                }
                CIMObjectPath authSubjectPath = new CIMObjectPath("SunStorEdge_DSPAuthorizedSubject");
                authSubjectPath.setNameSpace(request.getObjectPath().getNameSpace());
                CIMClass authSubjectClass = SunStorEdge_DSPProvider.cimom.getClass(authSubjectPath, false, true, true, null);
                if (authSubjectClass == null) {
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                    tmpe.setDescription("Internal error: Failed getClass.");
                    throw tmpe;
                }
                CIMInstance privInst = RequestBroker.getInstance().findInstance(privilegePath);
                privilegePath.setNameSpace("\\root\\se6x20\\");
                CIMClass privilegeClass = SunStorEdge_DSPProvider.cimom.getClass(privilegePath, false, true, true, null);
                if (privilegeClass == null) {
                    Trace.error((Object)this, (String)"handleRequest", (String)" Unable to get Privilege Class. ");
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                    tmpe.setDescription("Internal error: Failed getClass.");
                    throw tmpe;
                }
                CIMInstance newPriv = privilegeClass.newInstance();
                newPriv.updatePropertyValues(privInst.getProperties());
                CIMProperty keyProp = newPriv.getProperty("InstanceID");
                CIMValue keyValue = new CIMValue((Object)Long.toString(Calendar.getInstance().getTimeInMillis()), keyProp.getType());
                keyProp.setValue(keyValue);
                newPriv.updatePropertyValue(keyProp);
                CIMInstance idInst = RequestBroker.getInstance().findInstance(identityPath);
                CIMInstance atInst = authTargetClass.newInstance();
                CIMInstance asInst = authSubjectClass.newInstance();
                atInst.setProperty("Privilege", new CIMValue((Object)newPriv.getObjectPath()));
                atInst.setProperty("TargetElement", new CIMValue((Object)pcInstance.getObjectPath()));
                asInst.setProperty("Privilege", new CIMValue((Object)newPriv.getObjectPath()));
                asInst.setProperty("PrivilegedElement", new CIMValue((Object)idInst.getObjectPath()));
                authTargetPath = atInst.getObjectPath();
                authTargetPath.setNameSpace(request.getObjectPath().getNameSpace());
                RequestBroker.getInstance().addSyntheticCacheInstance(atInst);
                authSubjectPath = asInst.getObjectPath();
                authSubjectPath.setNameSpace(request.getObjectPath().getNameSpace());
                RequestBroker.getInstance().addSyntheticCacheInstance(asInst);
                RequestBroker.getInstance().addSyntheticCacheInstance(newPriv);
                CIMArgument outArg = new CIMArgument("ProtocolController");
                CIMValue copValue = new CIMValue((Object)pcInstance.getObjectPath());
                outArg.setValue(copValue);
                outParams[0] = outArg;
                ((InvokeRequest)request).setResults(new CIMValue((Object)PC_CR_RET_SUCCESS, new CIMDataType(5)));
                return true;
            }
            if (((InvokeRequest)request).getMethodName().equals("AttachDevice")) {
                StringBuffer devNum = new StringBuffer();
                this.buildAttachDeviceParams(inParams, tokens, serverWwns, mapPermissions, initiators, protocol, (InvokeRequest)request, volumeWwn, devNum);
                String page = new String("lunMap.htm");
                ListIterator serverWwnIter = serverWwns.listIterator();
                ListIterator mapPermissionsIter = mapPermissions.listIterator();
                while (serverWwnIter.hasNext()) {
                    String serverWwnString = (String)serverWwnIter.next();
                    String permissionString = (String)mapPermissionsIter.next();
                    tokens.insertElementAt(serverWwnString, 0);
                    tokens.insertElementAt(permissionString, 4);
                    results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
                    tokens.removeElementAt(0);
                    tokens.removeElementAt(3);
                }
                this.removeTempObjectsFromSynCache(initiators, (CIMObjectPath)protocol.get(0), (InvokeRequest)request);
                if (results != null && results.requestSucceeded()) {
                    ((InvokeRequest)request).setResults(new CIMValue((Object)AD_CR_RET_SUCCESS, new CIMDataType(5)));
                    if (outParams.length >= 1) {
                        Trace.info((Object)this, (String)"handleRequest", (String)"  Updating parm 1 with DeviceNumber information");
                        outParams[0] = new CIMArgument("DeviceNumber", new CIMValue((Object)devNum.toString()));
                    }
                } else {
                    if (results != null) {
                        ((InvokeRequest)request).setResults(new CIMValue((Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())), new CIMDataType(5)));
                    } else {
                        ((InvokeRequest)request).setResults(new CIMValue((Object)AD_CR_RET_NOT_SUPPORTED, new CIMDataType(5)));
                    }
                    if (outParams.length >= 1) {
                        outParams[0] = new CIMArgument("DeviceNumber", null);
                    }
                }
                page = new String("volume.xml?samVolume_SetByWwn=" + (String)volumeWwn.get(0));
                RequestBroker.getInstance().reloadCachePage(this.getSystem(), page);
                for (int l = 0; l < serverWwns.size(); ++l) {
                    String token = (String)serverWwns.get(l);
                    String[] tns = token.split("=");
                    page = new String("initor.xml?samFcTarget_SetCurrentByInitiatorWWN=" + tns[1]);
                    RequestBroker.getInstance().reloadCachePage(this.getSystem(), page);
                }
                return true;
            }
            if (((InvokeRequest)request).getMethodName().equals("DetachDevice")) {
                CIMObjectPath pcPath = null;
                CIMObjectPath volPath = null;
                for (int i = 0; i < inParams.length; ++i) {
                    CIMValue theValue;
                    String paramName = inParams[i].getName().toString();
                    if (paramName.equals("ProtocolController")) {
                        theValue = inParams[i].getValue();
                        pcPath = (CIMObjectPath)theValue.getValue();
                        continue;
                    }
                    if (!paramName.equals("Device")) continue;
                    theValue = inParams[i].getValue();
                    volPath = (CIMObjectPath)theValue.getValue();
                }
                this.buildDetachDeviceParams(inParams, tokens, (InvokeRequest)request);
                String page = new String("lunUnMap.htm");
                results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
                if (results.requestSucceeded()) {
                    ((InvokeRequest)request).setResults(new CIMValue((Object)DD_CR_RET_SUCCESS, new CIMDataType(5)));
                    this.removeMappingModel(pcPath, volPath);
                } else {
                    ((InvokeRequest)request).setResults(new CIMValue((Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())), new CIMDataType(5)));
                    RequestBroker.getInstance().invalidateCache(this.getSystem());
                }
                return true;
            }
            if (((InvokeRequest)request).getMethodName().equals("DeleteProtocolController")) {
                if (!this.buildDeleteControllerParams(inParams, tokens, (InvokeRequest)request)) {
                    ((InvokeRequest)request).setResults(new CIMValue((Object)PC_CR_RET_SUCCESS, new CIMDataType(5)));
                    return true;
                }
                String page = new String("fcTargDel.htm");
                results = DevComm.getInstance().postWithDspResults(this.getSystem(), page, tokens);
                if (results.requestSucceeded()) {
                    ((InvokeRequest)request).setResults(new CIMValue((Object)DD_CR_RET_SUCCESS, new CIMDataType(5)));
                } else {
                    ((InvokeRequest)request).setResults(new CIMValue((Object)new Integer(DspUtil.mapDSPReturnCode(results.getReturnCode())), new CIMDataType(5)));
                }
                RequestBroker.getInstance().invalidateCache(this.getSystem());
                return true;
            }
            return false;
        }
        return false;
    }

    private void buildAttachDeviceParams(CIMArgument[] cimParams, Vector nvPairs, Vector serverWwns, Vector mapPermissions, Vector initiators, Vector protocol, InvokeRequest req, Vector volumeWwn, StringBuffer newDevNum) throws CIMException {
        String deviceWwn = new String();
        String lun = new String();
        CIMObjectPath protocolPath = null;
        String deviceType = new String("vol");
        String namespace = req.getObjectPath().getNameSpace();
        for (int i = 0; i < cimParams.length; ++i) {
            String paramName = cimParams[i].getName().toString();
            if (paramName.equals("DeviceNumber")) {
                String tmpLun = DspUtil.unquote(cimParams[i].getValue().toString());
                lun = this.convertHexDeviceNumberToIntStr(tmpLun);
                newDevNum.append(tmpLun);
                continue;
            }
            if (paramName.equals("ProtocolController")) {
                protocolPath = (CIMObjectPath)cimParams[i].getValue().getValue();
                protocol.add(protocolPath);
                continue;
            }
            if (!paramName.equals("Device")) continue;
            CIMInstance devInst = RequestBroker.getInstance().findInstance((CIMObjectPath)cimParams[i].getValue().getValue());
            deviceWwn = devInst.getProperty("DeviceID").getValue().getValue().toString();
            volumeWwn.add(deviceWwn);
        }
        CIMInstance pcInst = RequestBroker.getInstance().findInstance(protocolPath);
        if (pcInst != null) {
            nvPairs.add(new String("targetName=" + pcInst.getProperty("DeviceID").getValue().getValue()));
            CIMClass authTargetClass = new CIMClass("SunStorEdge_DSPAuthorizedTarget");
            CIMClass authSubjectClass = new CIMClass("SunStorEdge_DSPAuthorizedSubject");
            CIMInstance atInst = authTargetClass.newInstance();
            CIMInstance asInst = authSubjectClass.newInstance();
            CIMObjectPath authTargetPath = atInst.getObjectPath();
            authTargetPath.setNameSpace(namespace);
            CIMObjectPath pcPath = pcInst.getObjectPath();
            pcPath.setNameSpace(namespace);
            CIMInstance[] privileges = RequestBroker.getInstance().associators(authTargetPath, pcPath, new String("SunStorEdge_DSPPrivilege"), new String("TargetElement"), new String("Privilege"), false, true, null);
            CIMObjectPath authSubjPath = asInst.getObjectPath();
            authSubjPath.setNameSpace(namespace);
            for (int j = 0; j < privileges.length; ++j) {
                CIMObjectPath privPath = privileges[j].getObjectPath();
                privPath.setNameSpace(namespace);
                CIMInstance privilegeInst = RequestBroker.getInstance().getInstance(privPath, false, true, false, null, null);
                Vector permVector = (Vector)privilegeInst.getProperty("Activities").getValue().getValue();
                boolean read = false;
                boolean write = false;
                for (int k = 0; k < permVector.size(); ++k) {
                    UnsignedInt16 permValue = (UnsignedInt16)permVector.get(k);
                    if (permValue.intValue() == 5) {
                        read = true;
                    }
                    if (permValue.intValue() != 6) continue;
                    write = true;
                }
                CIMInstance[] tmpInitiators = RequestBroker.getInstance().associators(authSubjPath, privPath, new String("SunStorEdge_DSPStorageHardwareID"), new String("Privilege"), new String("PrivilegedElement"), false, true, null);
                if (tmpInitiators == null) continue;
                for (int k = 0; k < tmpInitiators.length; ++k) {
                    initiators.add(tmpInitiators[k]);
                    serverWwns.add(new String("serverWWN=" + tmpInitiators[k].getProperty("InstanceID").getValue().getValue().toString()));
                    if (read && write) {
                        mapPermissions.add(new String("accessLevel=readwrite"));
                        continue;
                    }
                    mapPermissions.add(new String("accessLevel=readonly"));
                }
            }
            for (int l = 0; l < initiators.size(); ++l) {
                CIMInstance curInitiator = (CIMInstance)initiators.get(l);
                CIMInstance[] privs = RequestBroker.getInstance().associators(authSubjPath, curInitiator.getObjectPath(), new String("SunStorEdge_DSPPrivilege"), new String("PrivilegedElement"), new String("Privilege"), false, true, null);
                if (privs.length <= 1) continue;
                for (int m = 0; m < privs.length; ++m) {
                    CIMInstance[] volumes;
                    CIMInstance curPrivilege = privs[m];
                    Vector permVector = (Vector)curPrivilege.getProperty("Activities").getValue().getValue();
                    boolean read = false;
                    boolean write = false;
                    for (int n = 0; n < permVector.size(); ++n) {
                        UnsignedInt16 permValue = (UnsignedInt16)permVector.get(n);
                        if (permValue.intValue() == 5) {
                            read = true;
                        }
                        if (permValue.intValue() != 6) continue;
                        write = true;
                    }
                    if (write || (volumes = RequestBroker.getInstance().associators(authTargetPath, curPrivilege.getObjectPath(), new String("SunStorEdge_DSPStorageVolume"), new String("Privilege"), new String("TargetElement"), false, true, null)) == null) continue;
                    for (int n = 0; n < volumes.length; ++n) {
                        CIMInstance curVol = volumes[n];
                        String curWwn = curVol.getProperty("DeviceID").getValue().getValue().toString();
                        if (!curWwn.equals(deviceWwn)) continue;
                        mapPermissions.remove(l);
                        mapPermissions.insertElementAt(new String("accessLevel=readonly"), l);
                    }
                }
            }
        }
        nvPairs.add(new String("deviceWWN=" + deviceWwn));
        nvPairs.add(new String("lun=" + lun));
        nvPairs.add(new String("deviceType=" + deviceType));
    }

    private String convertHexDeviceNumberToIntStr(String hexDeviceNumber) throws CIMException {
        String result = "";
        try {
            result = Integer.toString(Integer.parseInt(hexDeviceNumber, 16));
        }
        catch (NumberFormatException nfe) {
            Trace.error((Object)this, (String)"convertHexDeviceNumberToIntStr", (String)" DeviceNumver is not a hexadecimal number  ");
            CIMException tmpe = new CIMException("CIM_ERR_INVALID_PARAMETER");
            Object[] arg = new String[]{"DeviceNumber"};
            tmpe.setParams(arg);
            tmpe.setDescription("DeviceNumver is not a hexadecimal number");
            throw tmpe;
        }
        return result;
    }

    private void buildDetachDeviceParams(CIMArgument[] cimParams, Vector nvPairs, InvokeRequest req) throws CIMException {
        Vector initiators = new Vector();
        String serverWwn = new String();
        String lun = new String();
        String namespace = req.getObjectPath().getNameSpace();
        CIMInstance pcInst = null;
        CIMInstance devInst = null;
        for (int i = 0; i < cimParams.length; ++i) {
            CIMObjectPath thePath;
            CIMValue theValue;
            String paramName = cimParams[i].getName().toString();
            if (paramName.equals("ProtocolController")) {
                theValue = cimParams[i].getValue();
                thePath = (CIMObjectPath)theValue.getValue();
                pcInst = RequestBroker.getInstance().findInstance(thePath);
                continue;
            }
            if (!paramName.equals("Device")) continue;
            theValue = cimParams[i].getValue();
            thePath = (CIMObjectPath)theValue.getValue();
            devInst = RequestBroker.getInstance().findInstance(thePath);
        }
        CIMObjectPath pcPath = null;
        CIMObjectPath devPath = null;
        if (pcInst != null) {
            pcPath = new CIMObjectPath();
            pcPath.setObjectName(pcInst.getObjectPath().getObjectName());
            pcPath.setKeys(pcInst.getObjectPath().getKeys());
            pcPath.setNameSpace(namespace);
        }
        if (devInst != null) {
            devPath = new CIMObjectPath();
            devPath.setObjectName(devInst.getObjectPath().getObjectName());
            devPath.setKeys(devInst.getObjectPath().getKeys());
            devPath.setNameSpace(namespace);
        }
        if (devPath != null) {
            CIMValue devNumVal;
            CIMProperty devNumProp;
            CIMClass pcForUnitClass = new CIMClass("SunStorEdge_DSPProtocolControllerForUnit");
            CIMInstance pcForUnitInst = pcForUnitClass.newInstance();
            CIMObjectPath pcForUnitPath = pcForUnitInst.getObjectPath();
            CIMInstance[] pcForUnitInstArray = RequestBroker.getInstance().references(pcForUnitPath, devPath, new String("Dependent"), true, true, null);
            boolean assocFound = false;
            for (int i = 0; i < pcForUnitInstArray.length; ++i) {
                pcForUnitPath = (CIMObjectPath)pcForUnitInstArray[i].getProperty("Antecedent").getValue().getValue();
                if (!ObjectPath.objectPathsAreEqual(pcForUnitPath, pcPath)) continue;
                pcForUnitInst = pcForUnitInstArray[i];
                assocFound = true;
                break;
            }
            if (assocFound && (devNumProp = pcForUnitInst.getProperty("DeviceNumber")) != null && (devNumVal = devNumProp.getValue()) != null) {
                lun = this.convertHexDeviceNumberToIntStr((String)devNumVal.getValue());
            }
        }
        if (pcPath != null) {
            CIMClass authTargetClass = new CIMClass("SunStorEdge_DSPAuthorizedTarget");
            CIMInstance atInst = authTargetClass.newInstance();
            CIMObjectPath atPath = new CIMObjectPath();
            atPath.setObjectName(atInst.getObjectPath().getObjectName());
            atPath.setKeys(atInst.getObjectPath().getKeys());
            atPath.setNameSpace(namespace);
            CIMInstance[] authTargetInstArray = RequestBroker.getInstance().references(atPath, pcPath, new String("TargetElement"), true, true, null);
            atPath.setObjectName(authTargetInstArray[0].getObjectPath().getObjectName());
            atPath.setKeys(authTargetInstArray[0].getObjectPath().getKeys());
            atPath.setNameSpace(namespace);
            CIMInstance[] privileges = RequestBroker.getInstance().associators(atPath, pcPath, new String("SunStorEdge_DSPPrivilege"), new String("TargetElement"), new String("Privilege"), false, true, null);
            CIMClass authSubjectClass = new CIMClass("SunStorEdge_DSPAuthorizedSubject");
            CIMInstance asInst = authSubjectClass.newInstance();
            CIMObjectPath asPath = new CIMObjectPath();
            asPath.setObjectName(asInst.getObjectPath().getObjectName());
            asPath.setKeys(asInst.getObjectPath().getKeys());
            asPath.setNameSpace(namespace);
            CIMObjectPath privPath = new CIMObjectPath();
            privPath.setObjectName(privileges[0].getObjectPath().getObjectName());
            privPath.setKeys(privileges[0].getObjectPath().getKeys());
            privPath.setNameSpace(namespace);
            CIMInstance[] authSubjectInstArray = RequestBroker.getInstance().references(asPath, privPath, new String("Privilege"), true, true, null);
            asPath.setObjectName(authSubjectInstArray[0].getObjectPath().getObjectName());
            asPath.setKeys(authSubjectInstArray[0].getObjectPath().getKeys());
            asPath.setNameSpace(namespace);
            CIMInstance[] tmpInitiators = RequestBroker.getInstance().associators(asPath, privPath, new String("SunStorEdge_DSPStorageHardwareID"), new String("Privilege"), new String("PrivilegedElement"), false, true, null);
            serverWwn = tmpInitiators[0].getProperty("InstanceID").getValue().getValue().toString();
        }
        nvPairs.add(new String("serverWWN=" + serverWwn));
        nvPairs.add(new String("lun=" + lun));
    }

    private boolean buildDeleteControllerParams(CIMArgument[] cimParams, Vector nvPairs, InvokeRequest req) throws CIMException {
        Vector initiators = new Vector();
        String serverWwn = new String();
        String lun = new String();
        String namespace = req.getObjectPath().getNameSpace();
        CIMInstance pcInst = null;
        Object devInst = null;
        Boolean deleteUnits = new Boolean(false);
        CIMObjectPath configService = req.getObjectPath();
        CIMObjectPath hostedService = null;
        CIMObjectPath thePath = null;
        for (int i = 0; i < cimParams.length; ++i) {
            CIMValue theValue;
            String paramName = cimParams[i].getName().toString();
            if (paramName.equals("ProtocolController")) {
                theValue = cimParams[i].getValue();
                thePath = (CIMObjectPath)theValue.getValue();
                pcInst = RequestBroker.getInstance().findInstance(thePath);
                continue;
            }
            if (!paramName.equals("DeleteUnits")) continue;
            theValue = cimParams[i].getValue();
            deleteUnits = (Boolean)theValue.getValue();
        }
        if (thePath != null && RequestBroker.getInstance().isSyntheticCacheInstance(thePath)) {
            this.FindInitiators(initiators, thePath, req);
            this.removeTempObjectsFromSynCache(initiators, thePath, req);
            return false;
        }
        if (pcInst != null) {
            nvPairs.add(new String("fcTargName=" + pcInst.getProperty("DeviceID").getValue().getValue()));
        }
        hostedService = new CIMObjectPath(HOSTED_SERVICE_CLASS);
        CIMInstance[] insts = RequestBroker.getInstance().associators(hostedService, configService, DOMAIN_CLASS, HOSTED_SERVICE_SERVICE, HOSTED_SERVICE_SYSTEM, false, true, null);
        CIMInstance domainInst = insts[0];
        nvPairs.add(new String("vsdName=" + domainInst.getProperty("ElementName").getValue().getValue()));
        return true;
    }

    private void removeTempObjectsFromSynCache(Vector initiators, CIMObjectPath protocolPath, InvokeRequest req) throws CIMException {
        String namespace = req.getObjectPath().getNameSpace();
        protocolPath.setNameSpace(namespace);
        CIMInstance pcInst = RequestBroker.getInstance().findInstance(protocolPath);
        if (pcInst != null) {
            CIMClass authTargetClass = new CIMClass("SunStorEdge_DSPAuthorizedTarget");
            CIMClass authSubjectClass = new CIMClass("SunStorEdge_DSPAuthorizedSubject");
            CIMInstance atNewInst = authTargetClass.newInstance();
            CIMInstance asNewInst = authSubjectClass.newInstance();
            CIMObjectPath authTargetPath = atNewInst.getObjectPath();
            authTargetPath.setNameSpace(namespace);
            CIMInstance[] privileges = RequestBroker.getInstance().associators(authTargetPath, protocolPath, new String("SunStorEdge_DSPPrivilege"), new String("TargetElement"), new String("Privilege"), false, true, null);
            CIMObjectPath authSubjPath = asNewInst.getObjectPath();
            authSubjPath.setNameSpace(namespace);
            for (int j = 0; j < privileges.length; ++j) {
                CIMObjectPath privInstPath = privileges[j].getObjectPath();
                privInstPath.setNameSpace(namespace);
                CIMInstance privInst = RequestBroker.getInstance().findInstance(privInstPath);
                CIMObjectPath privPath = privInst.getObjectPath();
                privPath.setNameSpace(namespace);
                CIMInstance[] authTargets = RequestBroker.getInstance().enumerateInstances(authTargetPath, false, false, true, null, authTargetClass);
                for (int k = 0; k < authTargets.length; ++k) {
                    ObjectPath atPrivPath;
                    CIMInstance atInst = authTargets[k];
                    CIMObjectPath atPath = atInst.getObjectPath();
                    CIMProperty atPrivProp = atInst.getProperty("Privilege");
                    CIMValue atPrivVal = atPrivProp.getValue();
                    if (atPrivVal == null || (atPrivPath = new ObjectPath((CIMObjectPath)atPrivVal.getValue())) == null || !atPrivPath.equals(privPath)) continue;
                    CIMObjectPath tmpPath = (CIMObjectPath)atPrivVal.getValue();
                    tmpPath.setNameSpace("");
                    CIMInstance at = (CIMInstance)RequestBroker.getInstance().deleteSyntheticCacheInstance(atPath);
                }
                CIMInstance[] authSubjects = RequestBroker.getInstance().enumerateInstances(authSubjPath, false, false, true, null, authSubjectClass);
                for (int l = 0; l < authSubjects.length; ++l) {
                    ObjectPath asPrivPath;
                    CIMInstance asInst = authSubjects[l];
                    CIMObjectPath asPath = asInst.getObjectPath();
                    CIMProperty asPrivProp = asInst.getProperty("Privilege");
                    CIMValue asPrivVal = asPrivProp.getValue();
                    if (asPrivVal == null || (asPrivPath = new ObjectPath((CIMObjectPath)asPrivVal.getValue())) == null || !asPrivPath.equals(privPath)) continue;
                    CIMObjectPath tmpPath = (CIMObjectPath)asPrivVal.getValue();
                    tmpPath.setNameSpace("");
                    CIMInstance as = (CIMInstance)RequestBroker.getInstance().deleteSyntheticCacheInstance(asPath);
                }
                privInst = (CIMInstance)RequestBroker.getInstance().deleteSyntheticCacheInstance(privInstPath);
            }
        }
        if (RequestBroker.getInstance().isSyntheticCacheInstance(protocolPath)) {
            pcInst = (CIMInstance)RequestBroker.getInstance().deleteSyntheticCacheInstance(protocolPath);
        }
        for (int y = 0; y < initiators.size(); ++y) {
            CIMInstance curInitiator = (CIMInstance)initiators.get(y);
            CIMObjectPath curInitPath = curInitiator.getObjectPath();
            curInitPath.setNameSpace(namespace);
            CIMClass authTargetClass = new CIMClass("SunStorEdge_DSPAuthorizedTarget");
            CIMClass authSubjectClass = new CIMClass("SunStorEdge_DSPAuthorizedSubject");
            CIMInstance atNewInst = authTargetClass.newInstance();
            CIMInstance asNewInst = authSubjectClass.newInstance();
            CIMObjectPath authTargetPath = atNewInst.getObjectPath();
            authTargetPath.setNameSpace(namespace);
            CIMObjectPath authSubjPath = asNewInst.getObjectPath();
            authSubjPath.setNameSpace(namespace);
            CIMInstance[] privileges = RequestBroker.getInstance().associators(authSubjPath, curInitPath, new String("SunStorEdge_DSPPrivilege"), new String("PrivilegedElement"), new String("Privilege"), false, true, null);
            if (privileges != null) {
                for (int j = 0; j < privileges.length; ++j) {
                    CIMObjectPath privInstPath = privileges[j].getObjectPath();
                    privInstPath.setNameSpace(namespace);
                    CIMInstance privInst = RequestBroker.getInstance().findInstance(privInstPath);
                    CIMObjectPath privPath = privInst.getObjectPath();
                    privPath.setNameSpace(namespace);
                    CIMInstance[] authTargets = RequestBroker.getInstance().enumerateInstances(authTargetPath, false, false, true, null, authTargetClass);
                    for (int k = 0; k < authTargets.length; ++k) {
                        ObjectPath atPrivPath;
                        CIMInstance atInst = authTargets[k];
                        CIMObjectPath atPath = atInst.getObjectPath();
                        CIMProperty atPrivProp = atInst.getProperty("Privilege");
                        CIMValue atPrivVal = atPrivProp.getValue();
                        if (atPrivVal == null || (atPrivPath = new ObjectPath((CIMObjectPath)atPrivVal.getValue())) == null || !atPrivPath.equals(privPath)) continue;
                        CIMInstance at = (CIMInstance)RequestBroker.getInstance().deleteSyntheticCacheInstance(atPath);
                    }
                    CIMInstance[] authSubjects = RequestBroker.getInstance().enumerateInstances(authSubjPath, false, false, true, null, authSubjectClass);
                    for (int l = 0; l < authSubjects.length; ++l) {
                        ObjectPath asPrivPath;
                        CIMInstance asInst = authSubjects[l];
                        CIMObjectPath asPath = asInst.getObjectPath();
                        CIMProperty asPrivProp = asInst.getProperty("Privilege");
                        CIMValue asPrivVal = asPrivProp.getValue();
                        if (asPrivVal == null || (asPrivPath = new ObjectPath((CIMObjectPath)asPrivVal.getValue())) == null || !asPrivPath.equals(privPath)) continue;
                        CIMInstance as = (CIMInstance)RequestBroker.getInstance().deleteSyntheticCacheInstance(asPath);
                    }
                    privInst = (CIMInstance)RequestBroker.getInstance().deleteSyntheticCacheInstance(privInstPath);
                }
            }
            if (!RequestBroker.getInstance().isSyntheticCacheInstance(curInitPath)) continue;
            curInitiator = (CIMInstance)RequestBroker.getInstance().deleteSyntheticCacheInstance(curInitPath);
        }
    }

    void removeMappingModel(CIMObjectPath pcPath, CIMObjectPath volPath) throws CIMException {
        String METHOD = "removeMapping";
        Trace.methodBegin((Object)this, (String)"removeMapping");
        CIMInstance pcInst = null;
        CIMInstance volInst = null;
        String serverWwn = null;
        if (pcPath == null || volPath == null) {
            if (pcPath == null) {
                Trace.info((Object)this, (String)"removeMapping", (String)" pcPath is null");
            }
            if (volPath == null) {
                Trace.info((Object)this, (String)"removeMapping", (String)" volPath is null");
            }
            return;
        }
        pcInst = RequestBroker.getInstance().findInstance(pcPath);
        volInst = RequestBroker.getInstance().findInstance(volPath);
        if (pcInst == null || volInst == null) {
            if (pcInst == null) {
                Trace.info((Object)this, (String)"removeMapping", (String)" No controller found for pcPath");
            }
            if (volInst == null) {
                Trace.info((Object)this, (String)"removeMapping", (String)" No volume found for volPath");
            }
            return;
        }
        volPath.setNameSpace("\\root\\se6x20\\");
        pcPath.setNameSpace("\\root\\se6x20\\");
        CIMObjectPath pcUnitPath = new CIMObjectPath(PCUNIT_CLASS);
        pcUnitPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance[] mappings = RequestBroker.getInstance().references(pcUnitPath, pcPath, PC_FOR_UNIT_CONTROLLER, false, false, null);
        if (mappings == null) {
            Trace.info((Object)this, (String)"removeMapping", (String)" No mapping to remove ");
            return;
        }
        for (int i = 0; i < mappings.length; ++i) {
            CIMInstance pcfuInst = mappings[i];
            CIMObjectPath volSide = (CIMObjectPath)pcfuInst.getProperty(PC_FOR_UNIT_VOLUME).getValue().getValue();
            if (!ObjectPath.objectPathsAreEqual(volSide, volPath)) continue;
            Trace.info((Object)this, (String)"removeMapping", (String)"Found mapping for this volume.");
            RequestBroker.getInstance().deleteInstance(pcfuInst.getObjectPath());
            break;
        }
        CIMObjectPath newPrivPath = new CIMObjectPath(PRIVILEGE_CLASS);
        newPrivPath.setNameSpace("\\root\\se6x20\\");
        CIMClass privClass = SunStorEdge_DSPProvider.cimom.getClass(newPrivPath, false, false, true, null);
        CIMInstance tmpInst = privClass.newInstance();
        tmpInst.setProperty(INSTANCE_ID, new CIMValue((Object)(pcInst.getProperty(ELEMENT_NAME).getValue().getValue() + "RO")));
        CIMObjectPath privPath = tmpInst.getObjectPath();
        privPath.setNameSpace("\\root\\se6x20\\");
        privPath.setHost(SunStorEdge_DSPProvider.getIPAddress());
        volPath.setHost(SunStorEdge_DSPProvider.getIPAddress());
        CIMObjectPath authTargPath = new CIMObjectPath(AUTHORIZED_TARGET_CLASS);
        authTargPath.setNameSpace("\\root\\se6x20\\");
        CIMClass authTargClass = SunStorEdge_DSPProvider.cimom.getClass(authTargPath, false, false, true, null);
        tmpInst = authTargClass.newInstance();
        tmpInst.setProperty(AUTH_TARG_ELEMENT, new CIMValue((Object)volPath));
        tmpInst.setProperty(AUTH_TARG_PRIV, new CIMValue((Object)privPath));
        CIMObjectPath tmpPath = tmpInst.getObjectPath();
        tmpPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance authTargInst = RequestBroker.getInstance().findInstance(tmpPath);
        if (authTargInst != null) {
            Trace.info((Object)this, (String)"removeMapping", (String)"Deleting AuthTarget instance.");
            RequestBroker.getInstance().deleteInstance(authTargInst.getObjectPath());
        } else {
            Trace.info((Object)this, (String)"removeMapping", (String)"AuthTarget instance not found.");
        }
        Trace.info((Object)this, (String)"removeMapping", (String)"Reloading volume page.");
        String volumeWwn = (String)volInst.getProperty(DEVICE_ID).getValue().getValue();
        String page = new String("volume.xml?samVolume_SetByWwn=" + volumeWwn);
        RequestBroker.getInstance().reloadCachePage(this.getSystem(), page);
        if (mappings.length == 1) {
            Trace.info((Object)this, (String)"removeMapping", (String)"Only one mapping, calling deleteModel().");
            this.deleteModel(pcInst);
        } else {
            Trace.info((Object)this, (String)"removeMapping", (String)"More than one mapping found.");
            newPrivPath = new CIMObjectPath(PRIVILEGE_CLASS);
            newPrivPath.setNameSpace("\\root\\se6x20\\");
            privClass = SunStorEdge_DSPProvider.cimom.getClass(newPrivPath, false, false, true, null);
            tmpInst = privClass.newInstance();
            tmpInst.setProperty(INSTANCE_ID, new CIMValue((Object)(pcInst.getProperty(ELEMENT_NAME).getValue().getValue() + "RW")));
            CIMObjectPath tmpPrivPath = tmpInst.getObjectPath();
            tmpPrivPath.setNameSpace("\\root\\se6x20\\");
            CIMInstance privRWInst = RequestBroker.getInstance().findInstance(tmpPrivPath);
            CIMObjectPath privRWPath = privRWInst.getObjectPath();
            privRWPath.setNameSpace("\\root\\se6x20\\");
            CIMObjectPath authSubjPath = new CIMObjectPath(AUTHORIZED_SUBJECT_CLASS);
            authSubjPath.setNameSpace("\\root\\se6x20\\");
            CIMInstance[] tmpInitiators = RequestBroker.getInstance().associators(authSubjPath, privRWPath, new String("SunStorEdge_DSPStorageHardwareID"), new String("Privilege"), new String("PrivilegedElement"), false, true, null);
            if (tmpInitiators != null) {
                Trace.info((Object)this, (String)"removeMapping", (String)"Initiators found, reloading page.");
                serverWwn = tmpInitiators[0].getProperty("InstanceID").getValue().getValue().toString();
                page = new String("initor.xml?samFcTarget_SetCurrentByInitiatorWWN=" + serverWwn);
                RequestBroker.getInstance().reloadCachePage(this.getSystem(), page);
            } else {
                Trace.info((Object)this, (String)"removeMapping", (String)"No initiators found.");
            }
        }
    }

    public void deleteModel(CIMInstance pcInst) throws CIMException {
        CIMInstance[] authSubjs;
        String METHOD = "deleteModel";
        Trace.methodBegin((Object)this, (String)"deleteModel");
        if (pcInst == null) {
            Trace.info((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPControllerConfigurationService == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPControllerConfigurationService = ModifySunStorEdge_DSPControllerConfigurationService.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPControllerConfigurationService")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPControllerConfigurationService), (String)"deleteModel", (String)" pcInst is null");
            return;
        }
        String serverWwn = null;
        CIMObjectPath pcPath = pcInst.getObjectPath();
        pcPath.setNameSpace("\\root\\se6x20\\");
        CIMObjectPath dependPath = new CIMObjectPath(CONCRETE_DEPEND_CLASS);
        dependPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance[] depend = RequestBroker.getInstance().references(dependPath, pcPath, DEPENDENT, false, false, null);
        if (depend != null) {
            Trace.info((Object)this, (String)"deleteModel", (String)"Deleting ConcDependency instance.");
            RequestBroker.getInstance().deleteInstance(depend[0].getObjectPath());
        } else {
            Trace.info((Object)this, (String)"deleteModel", (String)"ConcDependency instance not found.");
        }
        CIMObjectPath authTargPath = new CIMObjectPath(AUTHORIZED_TARGET_CLASS);
        authTargPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance[] authTargs = RequestBroker.getInstance().references(authTargPath, pcPath, AUTH_TARG_ELEMENT, false, false, null);
        if (authTargs != null) {
            Trace.info((Object)this, (String)"deleteModel", (String)"Found AuthTarget instances.");
            for (int i = 0; i < authTargs.length; ++i) {
                Trace.info((Object)this, (String)"deleteModel", (String)"Deleting AuthTarget instance.");
                RequestBroker.getInstance().deleteInstance(authTargs[i].getObjectPath());
            }
        } else {
            Trace.info((Object)this, (String)"deleteModel", (String)"No AuthTarget instances found.");
        }
        CIMObjectPath pcPortPath = new CIMObjectPath(PROTOCOL_FOR_PORT_CLASS);
        authTargPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance[] pcPorts = RequestBroker.getInstance().references(pcPortPath, pcPath, ANTECEDENT, false, false, null);
        if (pcPorts != null) {
            Trace.info((Object)this, (String)"deleteModel", (String)"PCFP instances found.");
            for (int i = 0; i < pcPorts.length; ++i) {
                Trace.info((Object)this, (String)"deleteModel", (String)"Deleting PCFP instance.");
                RequestBroker.getInstance().deleteInstance(pcPorts[i].getObjectPath());
            }
        } else {
            Trace.info((Object)this, (String)"deleteModel", (String)"No PCFP instances found.");
        }
        CIMObjectPath newPrivPath = new CIMObjectPath(PRIVILEGE_CLASS);
        newPrivPath.setNameSpace("\\root\\se6x20\\");
        CIMClass privClass = SunStorEdge_DSPProvider.cimom.getClass(newPrivPath, false, false, true, null);
        CIMInstance tmpInst = privClass.newInstance();
        tmpInst.setProperty(INSTANCE_ID, new CIMValue((Object)(pcInst.getProperty(ELEMENT_NAME).getValue().getValue() + "RW")));
        CIMObjectPath tmpPrivPath = tmpInst.getObjectPath();
        tmpPrivPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance privRWInst = RequestBroker.getInstance().findInstance(tmpPrivPath);
        CIMObjectPath privRWPath = privRWInst.getObjectPath();
        privRWPath.setNameSpace("\\root\\se6x20\\");
        Trace.info((Object)this, (String)"deleteModel", (String)"Deleting privilege instance.");
        RequestBroker.getInstance().deleteInstance(privRWPath);
        CIMObjectPath authSubjPath = new CIMObjectPath(AUTHORIZED_SUBJECT_CLASS);
        authSubjPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance[] tmpInitiators = RequestBroker.getInstance().associators(authSubjPath, privRWPath, new String("SunStorEdge_DSPStorageHardwareID"), new String("Privilege"), new String("PrivilegedElement"), false, true, null);
        if (tmpInitiators != null) {
            serverWwn = tmpInitiators[0].getProperty("InstanceID").getValue().getValue().toString();
        }
        if ((authSubjs = RequestBroker.getInstance().references(authSubjPath, privRWPath, AUTH_SUBJ_PRIV, false, false, null)) != null) {
            Trace.info((Object)this, (String)"deleteModel", (String)"AuthSubject instances found.");
            for (int i = 0; i < authSubjs.length; ++i) {
                Trace.info((Object)this, (String)"deleteModel", (String)"Deleting AuthSubject instances.");
                RequestBroker.getInstance().deleteInstance(authSubjs[i].getObjectPath());
            }
        } else {
            Trace.info((Object)this, (String)"deleteModel", (String)"No AuthSubject instances found.");
        }
        tmpInst = privClass.newInstance();
        tmpInst.setProperty(INSTANCE_ID, new CIMValue((Object)(pcInst.getProperty(ELEMENT_NAME).getValue().getValue() + "RO")));
        tmpPrivPath = tmpInst.getObjectPath();
        tmpPrivPath.setNameSpace("\\root\\se6x20\\");
        CIMInstance privROInst = RequestBroker.getInstance().findInstance(tmpPrivPath);
        if (privROInst != null) {
            CIMObjectPath privROPath = privROInst.getObjectPath();
            privROPath.setNameSpace("\\root\\se6x20\\");
            Trace.info((Object)this, (String)"deleteModel", (String)"Deleting RO privilege.");
            RequestBroker.getInstance().deleteInstance(privROPath);
            authSubjPath = new CIMObjectPath(AUTHORIZED_SUBJECT_CLASS);
            authTargPath.setNameSpace("\\root\\se6x20\\");
            authSubjs = RequestBroker.getInstance().references(authSubjPath, privROPath, AUTH_SUBJ_PRIV, false, false, null);
            if (authSubjs != null) {
                Trace.info((Object)this, (String)"deleteModel", (String)"AuthSubject instances found.");
                for (int i = 0; i < authSubjs.length; ++i) {
                    Trace.info((Object)this, (String)"deleteModel", (String)"Deleting AuthSubject instance.");
                    RequestBroker.getInstance().deleteInstance(authSubjs[i].getObjectPath());
                }
            } else {
                Trace.info((Object)this, (String)"deleteModel", (String)"No AuthSubject instances found.");
            }
        } else {
            Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPControllerConfigurationService == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPControllerConfigurationService = ModifySunStorEdge_DSPControllerConfigurationService.class$("com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPControllerConfigurationService")) : class$com$sun$netstorage$dsp$mgmt$se6920$ModifySunStorEdge_DSPControllerConfigurationService), (String)"deleteModel", (String)" RO Privilege is null!");
        }
        Trace.info((Object)this, (String)"deleteModel", (String)"Deleting SCSIProtocolController instance.");
        RequestBroker.getInstance().deleteInstance(pcPath);
        if (serverWwn != null) {
            Trace.info((Object)this, (String)"deleteModel", (String)"Reloading initor.xml for initiator.");
            String page = new String("initor.xml?samFcTarget_SetCurrentByInitiatorWWN=" + serverWwn);
            RequestBroker.getInstance().reloadCachePage(this.getSystem(), page);
        }
    }

    protected String getDomain(ModifyRequest request) {
        Vector keys = request.getObjectPath().getKeys();
        Iterator itr = keys.iterator();
        String domain = null;
        while (itr.hasNext()) {
            CIMProperty prop = (CIMProperty)itr.next();
            if (!prop.getName().equalsIgnoreCase("SystemName")) continue;
            domain = prop.getValue().getValue().toString();
            break;
        }
        return domain;
    }

    private void FindInitiators(Vector initiators, CIMObjectPath protoCtl, InvokeRequest req) throws CIMException {
        String namespace = req.getObjectPath().getNameSpace();
        CIMClass authTargetClass = new CIMClass("SunStorEdge_DSPAuthorizedTarget");
        CIMClass authSubjectClass = new CIMClass("SunStorEdge_DSPAuthorizedSubject");
        CIMInstance atInst = authTargetClass.newInstance();
        CIMInstance asInst = authSubjectClass.newInstance();
        CIMObjectPath authTargetPath = atInst.getObjectPath();
        authTargetPath.setNameSpace(namespace);
        CIMObjectPath pcPath = protoCtl;
        pcPath.setNameSpace(namespace);
        CIMInstance[] privileges = RequestBroker.getInstance().associators(authTargetPath, pcPath, new String("SunStorEdge_DSPPrivilege"), new String("TargetElement"), new String("Privilege"), false, true, null);
        CIMObjectPath authSubjPath = asInst.getObjectPath();
        authSubjPath.setNameSpace(namespace);
        for (int j = 0; j < privileges.length; ++j) {
            CIMObjectPath privPath = privileges[j].getObjectPath();
            privPath.setNameSpace(namespace);
            CIMInstance privilegeInst = RequestBroker.getInstance().getInstance(privPath, false, true, false, null, null);
            Vector permVector = (Vector)privilegeInst.getProperty("Activities").getValue().getValue();
            boolean read = false;
            boolean write = false;
            for (int k = 0; k < permVector.size(); ++k) {
                UnsignedInt16 permValue = (UnsignedInt16)permVector.get(k);
                if (permValue.intValue() == 5) {
                    read = true;
                }
                if (permValue.intValue() != 6) continue;
                write = true;
            }
            CIMInstance[] tmpInitiators = RequestBroker.getInstance().associators(authSubjPath, privPath, new String("SunStorEdge_DSPStorageHardwareID"), new String("Privilege"), new String("PrivilegedElement"), false, true, null);
            if (tmpInitiators == null) continue;
            for (int k = 0; k < tmpInitiators.length; ++k) {
                initiators.add(tmpInitiators[k]);
            }
        }
    }

    public ModifySunStorEdge_DSPControllerConfigurationService(ArrayObject array) {
        super(array);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

