/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CreateRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DeleteRequest;
import com.sun.netstorage.dsp.mgmt.se6920.DspJob;
import com.sun.netstorage.dsp.mgmt.se6920.DspJobVolumeModification;
import com.sun.netstorage.dsp.mgmt.se6920.InvokeRequest;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyModule;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyRequest;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ModifySunStorEdge_DSPConcreteJob
extends ModifyModule {
    private static String CLASSNAME = "ModifySunStorEdge_DSPConcreteJob";
    private static String CONCRETE_JOB_CLASSNAME = "SunStorEdge_DSPConcreteJob";
    private static String UI_JOB_CLASSNAME = "SunStorEdge_DSPUIJob";
    public static final String XML_LUN_CREATION_JOBS = "LUN_CREATION_JOBS";
    private static final String XML_LUN_CREATION_JOBS_B = "<LUN_CREATION_JOBS>";
    private static final String XML_LUN_CREATION_JOBS_E = "</LUN_CREATION_JOBS>";
    private static final String KILL_JOB = "killJob";
    private List jobList = Collections.synchronizedList(new ArrayList());
    private static final String sccs_id = "@(#)ModifySunStorEdge_DSPConcreteJob.java    1.16    05/07/29     SMI";

    private List getJobList() {
        return this.jobList;
    }

    public ModifySunStorEdge_DSPConcreteJob(ArrayObject array) {
        super(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DspJob findCimJob(CIMObjectPath cimJobPath) throws CIMException {
        DspJob job;
        Iterator it;
        String METHOD = "findCimJob";
        Trace.info((Object)this, (String)"findCimJob", (String)" Begin ");
        cimJobPath.setNameSpace("");
        List list = this.getJobList();
        synchronized (list) {
            it = this.getJobList().iterator();
            while (it.hasNext()) {
                job = (DspJob)it.next();
                if (!job.getCimJobPath().equals((Object)cimJobPath)) continue;
                Trace.info((Object)this, (String)"findCimJob", (String)" Found the job ");
                return job;
            }
        }
        cimJobPath.setNameSpace("\\root\\se6x20\\");
        list = this.getJobList();
        synchronized (list) {
            it = this.getJobList().iterator();
            while (it.hasNext()) {
                job = (DspJob)it.next();
                if (!job.getCimJobPath().equals((Object)cimJobPath)) continue;
                Trace.info((Object)this, (String)"findCimJob", (String)" Found the job ");
                return job;
            }
        }
        Trace.info((Object)this, (String)"findCimJob", (String)" Couldn't find the job ");
        throw new CIMException("CIM_ERR_NOT_FOUND");
    }

    public void addNewJobToList(DspJob dspJob) {
        String METHOD = "addNewJobToList";
        Trace.info((Object)this, (String)"addNewJobToList", (String)" Begin ");
        this.getJobList().add(dspJob);
    }

    public void removeJobFromList(DspJob dspJob) {
        String METHOD = "removeJobFromList";
        Trace.info((Object)this, (String)"removeJobFromList", (String)" Begin ");
        this.getJobList().remove(dspJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List copyJobList() {
        ArrayList jobListCopy = new ArrayList();
        List list = this.getJobList();
        synchronized (list) {
            Iterator it = this.getJobList().iterator();
            while (it.hasNext()) {
                jobListCopy.add(it.next());
            }
        }
        return jobListCopy;
    }

    public static String getHostname(CIMObjectPath cimJobPath) throws CIMException {
        CIMInstance job = RequestBroker.getInstance().findInstance(cimJobPath);
        if (job == null) {
            return null;
        }
        String hostname = (String)job.getProperty("SystemName").getValue().getValue();
        return hostname;
    }

    public void checkOutstandingJobs() {
        String METHOD = "checkOutstandingJobs";
        Trace.methodBegin((Object)this, (String)"checkOutstandingJobs");
        List jobListCopy = this.copyJobList();
        Iterator it = jobListCopy.iterator();
        while (it.hasNext()) {
            DspJob job = (DspJob)it.next();
            if (!job.isComplete()) {
                Trace.info((Object)this, (String)"checkOutstandingJobs", (String)(" Checking job " + job.getCimJobId() + " for completion"));
                job.checkForJobCompletion();
                continue;
            }
            Trace.info((Object)this, (String)"checkOutstandingJobs", (String)(" Skipping completed job " + job.getCimJobId()));
        }
        Trace.methodEnd((Object)this, (String)"checkOutstandingJobs");
    }

    public void checkOutstandingVolumeModificationJobs(String volWwn) {
        String METHOD = "checkOutstandingVolumeModificationJobs";
        Trace.methodBegin((Object)this, (String)"checkOutstandingVolumeModificationJobs");
        List jobListCopy = this.copyJobList();
        Iterator it = jobListCopy.iterator();
        while (it.hasNext()) {
            DspJob job = (DspJob)it.next();
            if (!job.isComplete()) {
                if (job instanceof DspJobVolumeModification) {
                    DspJobVolumeModification volJob = (DspJobVolumeModification)job;
                    Trace.info((Object)this, (String)"checkOutstandingVolumeModificationJobs", (String)(" Checking job " + job.getCimJobId() + " for completion"));
                    volJob.checkTargetStateChange(volWwn);
                    continue;
                }
                Trace.info((Object)this, (String)"checkOutstandingVolumeModificationJobs", (String)(" Skipping job " + job.getCimJobId() + " - not DspJobVolumeModification subclass"));
                continue;
            }
            Trace.info((Object)this, (String)"checkOutstandingVolumeModificationJobs", (String)(" Skipping completed job " + job.getCimJobId()));
        }
        Trace.methodEnd((Object)this, (String)"checkOutstandingVolumeModificationJobs");
    }

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        Trace.info((Object)this, (String)"handleRequest", (String)" Begin ");
        String classname = request.getCIMClassName();
        if (!classname.equals(CONCRETE_JOB_CLASSNAME) && !classname.equals(UI_JOB_CLASSNAME)) {
            return false;
        }
        CIMObjectPath cimJobPath = request.getObjectPath();
        if (request instanceof SetRequest) {
            Trace.info((Object)this, (String)"handleRequest", (String)" SetRequest ");
            try {
                this.findCimJob(cimJobPath).updateAttributes((SetRequest)request);
            }
            catch (Exception e) {
                // empty catch block
            }
            return true;
        }
        if (request instanceof CreateRequest) {
            Trace.info((Object)this, (String)"handleRequest", (String)" CreateRequest ");
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (request instanceof DeleteRequest) {
            Trace.info((Object)this, (String)"handleRequest", (String)" DeleteRequest ");
            DspJob dspJob = null;
            try {
                dspJob = this.findCimJob(cimJobPath);
            }
            catch (CIMException e) {
                Trace.info((Object)this, (String)"handleRequest", (String)" Job not found in internal job list ");
                RequestBroker.getInstance().deleteSyntheticCacheInstance(cimJobPath);
                throw e;
            }
            CIMInstance cimJob = RequestBroker.getInstance().findInstance(cimJobPath);
            if (cimJob == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND");
            }
            String status = (String)cimJob.getProperty("JobStatus").getValue().getValue();
            if (!dspJob.isCompletionSet()) {
                Trace.info((Object)this, (String)"handleRequest", (String)(" Can't delete an active job with a status of " + status));
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            dspJob.deleteJob();
            Trace.info((Object)this, (String)"handleRequest", (String)" DeleteRequest complete");
            return true;
        }
        if (request instanceof InvokeRequest) {
            Trace.info((Object)this, (String)"handleRequest", (String)" InvokeRequest ");
            InvokeRequest invokeRequest = (InvokeRequest)request;
            if (invokeRequest.getMethodName().equalsIgnoreCase(KILL_JOB)) {
                Trace.info((Object)this, (String)"handleRequest", (String)" Kill job request ");
                try {
                    this.findCimJob(cimJobPath).kill();
                }
                catch (Exception e) {
                    RequestBroker.getInstance().deleteSyntheticCacheInstance(cimJobPath);
                }
            } else {
                Trace.info((Object)this, (String)"handleRequest", (String)(" Unsupported InvokeRequest: " + invokeRequest.getMethodName()));
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            return true;
        }
        Trace.warn((Object)this, (String)"handleRequest", (String)" Unsupported Request ");
        return false;
    }

    public void persistToXml(FileOutputStream stream) throws CIMException, IOException {
        String METHOD = "persistToXml";
        Trace.info((Object)this, (String)"persistToXml", (String)" Begin ");
        SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, "<LUN_CREATION_JOBS>\n  ");
        SunStorEdge_DSPPersistenceManager.writeStringToStream(stream, "</LUN_CREATION_JOBS>\n  ");
        Trace.info((Object)this, (String)"persistToXml", (String)" End ");
    }
}

