/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayInventory;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.Constants;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.ProviderCIMOMHandle;

public class IndicationHelper
implements Constants {
    private ProviderCIMOMHandle pch = null;
    private static String CLASSNAME = "IndicationHelper";
    private static IndicationHelper singleton = new IndicationHelper();
    private static ArrayList classEventsList = new ArrayList();
    private static HashMap classEventTypeMap = new HashMap();
    private static HashMap supportedEvents = new HashMap();
    private HashMap registeredClasses = new HashMap();
    private HashMap classInsts = new HashMap();
    private static ArrayList instCreationOnly = new ArrayList(1);
    private static ArrayList instCreateDelete = new ArrayList(2);
    private static ArrayList instCreateDeleteModify = new ArrayList(3);
    private static ArrayList instModifyOnly = new ArrayList(1);
    private static ArrayList instDeleteOnly = new ArrayList(1);

    private IndicationHelper() {
        this.pch = (ProviderCIMOMHandle)SunStorEdge_DSPProvider.getCIMOMHandle();
    }

    public static IndicationHelper getInstance() {
        return singleton;
    }

    public void createIndication(String type, CIMObjectPath devPath) {
        String METHOD = "createIndication";
        try {
            Trace.error((Object)this, (String)METHOD, (String)(": An indication has been requested for " + devPath + " and with type " + type));
            this.createIndication(type, RequestBroker.getInstance().getInstance(devPath, false, true, false, null));
        }
        catch (CIMException ce) {
            Trace.error((Object)this, (String)METHOD, (String)(": Exception occurred while attempting to retrieve instance from object path\n" + devPath));
        }
    }

    public void createIndication(String type, CIMInstance newInst, CIMInstance oldInst) {
        String METHOD = "createIndication";
        CIMInstance indication = new CIMInstance();
        CIMProperty cp = null;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        indication.setClassName(type);
        cp = new CIMProperty("SourceInstance", new CIMValue((Object)newInst));
        v.addElement(cp);
        cp = new CIMProperty("PreviousInstance", new CIMValue((Object)oldInst));
        v.addElement(cp);
        indication.setProperties(v);
        if (newInst.getObjectPath().getNameSpace() == null || newInst.getObjectPath().getNameSpace() == "") {
            newInst.getObjectPath().setNameSpace("\\root\\se6x20\\");
            oldInst.getObjectPath().setNameSpace("\\root\\se6x20\\");
        }
        this.pch.deliverEvent(newInst.getObjectPath().getNameSpace(), indication);
    }

    public void createIndication(String type, CIMInstance changed) {
        String METHOD = "createIndication";
        CIMInstance indication = new CIMInstance();
        CIMProperty cp = null;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        indication.setClassName(type);
        cp = new CIMProperty("SourceInstance", new CIMValue((Object)changed));
        v.addElement(cp);
        indication.setProperties(v);
        if (changed.getObjectPath().getNameSpace() == null || changed.getObjectPath().getNameSpace() == "") {
            changed.getObjectPath().setNameSpace("\\root\\se6x20\\");
        }
        Trace.error((Object)this, (String)METHOD, (String)(": An indication has been requested for " + changed.getObjectPath() + " and with type " + type));
        Trace.error((Object)this, (String)METHOD, (String)("" + indication.getObjectPath()));
        this.pch.deliverEvent(changed.getObjectPath().getNameSpace(), indication);
    }

    public void activateFilter(CIMInstance filter, CIMInstance handler, CIMInstance subscription, String[] subFilters, CIMObjectPath[] classPath, String[] eventType) throws CIMException {
        String METHOD = "activateFilter";
        Trace.methodBegin((Object)this, (String)METHOD);
        for (int i = 0; i < classPath.length; ++i) {
            String requestedClass = this.findName(classPath[i].getObjectName());
            if (requestedClass == null) {
                Trace.warn((Object)this, (String)METHOD, (String)(" An unsupported class was attempted to be activated for indications: " + classPath[i].getObjectName()));
                continue;
            }
            HashMap activities = (HashMap)this.registeredClasses.get(requestedClass);
            Vector<CIMInstance> handlers = null;
            if (activities == null) {
                activities = new HashMap();
                handlers = new Vector<CIMInstance>();
                HashMap classArrayMap = new HashMap();
                ArrayList arrayInv = ArrayInventory.getInstance().getArrayInventory();
                Iterator inventory = arrayInv.iterator();
                while (inventory.hasNext()) {
                    ArrayObject invItem = (ArrayObject)inventory.next();
                    Vector<CIMInstance> instVec = new Vector<CIMInstance>();
                    CIMInstance[] currentInsts = RequestBroker.getInstance().searchCache(invItem, requestedClass);
                    for (int j = 0; currentInsts != null && j < currentInsts.length; ++j) {
                        instVec.add(currentInsts[j]);
                    }
                    classArrayMap.put(invItem, instVec);
                }
                this.classInsts.put(requestedClass, classArrayMap);
            } else {
                handlers = (Vector<CIMInstance>)activities.get(eventType[i]);
                if (handlers == null) {
                    handlers = new Vector();
                }
            }
            handlers.add(handler);
            activities.put(eventType[i], handlers);
            this.registeredClasses.put(requestedClass, activities);
        }
    }

    public void authorizeFilter(CIMInstance filter, CIMInstance handler, CIMInstance subscription, String[] subFilters, CIMObjectPath[] classPath, String[] eventType) throws CIMException {
        String METHOD = "authorizeFilter";
        Trace.methodBegin((Object)this, (String)METHOD);
        for (int i = 0; i < classPath.length; ++i) {
            String requestedClass = this.findName(classPath[i].getObjectName());
            if (requestedClass == null || !classEventsList.contains(requestedClass)) {
                Trace.error((Object)this, (String)METHOD, (String)(" An invalid filter was requested to be authorized.  " + classPath[i].getObjectName() + " is not supported in being registered for."));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", requestedClass);
            }
            Vector activities = (Vector)supportedEvents.get(requestedClass);
            if (activities.contains(eventType[i])) continue;
            Trace.error((Object)this, (String)METHOD, (String)(" An invalid filter was requested to be authorized.  " + eventType[i] + " is not supported for " + requestedClass + " in being registered for."));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)subFilters[i], (Object)requestedClass);
        }
    }

    public void deActivateFilter(CIMInstance filter, CIMInstance handler, CIMInstance subscription, String[] subFilters, CIMObjectPath[] classPath, String[] eventType) throws CIMException {
        String METHOD = "deActivateFilter";
        Trace.methodBegin((Object)this, (String)METHOD);
        for (int i = 0; i < classPath.length; ++i) {
            String requestedClass = this.findName(classPath[i].getObjectName());
            if (requestedClass == null) continue;
            HashMap activities = (HashMap)this.registeredClasses.get(requestedClass);
            if (activities != null) {
                Vector handlers = (Vector)activities.get(eventType[i]);
                if (handlers != null) {
                    handlers.remove(handler);
                }
                if (handlers.isEmpty()) {
                    activities.remove(eventType[i]);
                }
            }
            if (!activities.isEmpty()) continue;
            this.registeredClasses.remove(requestedClass);
            this.classInsts.remove(requestedClass);
        }
    }

    public boolean[] mustPoll(CIMInstance filter, CIMInstance handler, CIMInstance subscription, String[] subFilters, CIMObjectPath[] classPath, String[] eventType) throws CIMException {
        String METHOD = "mustPoll";
        Trace.methodBegin((Object)this, (String)METHOD);
        boolean[] retBool = new boolean[classPath.length];
        for (int i = 0; i < retBool.length; ++i) {
            retBool[i] = false;
        }
        return retBool;
    }

    public HashMap getClassInsts(String className) {
        return (HashMap)this.classInsts.get(className);
    }

    public void updateClassInsts(String className, ArrayObject invItem, CIMInstance[] currentInsts) {
        String HDR = CLASSNAME + ".updateClassInsts:";
        Vector<CIMInstance> classVec = new Vector<CIMInstance>();
        HashMap<ArrayObject, Vector<CIMInstance>> classArrayMap = new HashMap<ArrayObject, Vector<CIMInstance>>();
        if (currentInsts != null) {
            for (int j = 0; j < currentInsts.length; ++j) {
                classVec.add(currentInsts[j]);
            }
            classArrayMap.put(invItem, classVec);
            this.classInsts.put(className, classArrayMap);
        }
    }

    public Iterator getActivities(String className) {
        return ((HashMap)this.registeredClasses.get(className)).keySet().iterator();
    }

    public Set getRegisteredClasses() {
        return this.registeredClasses.keySet();
    }

    private String findName(String name) {
        String HDR = CLASSNAME + "." + "findName:";
        Iterator setIter = supportedEvents.keySet().iterator();
        while (setIter.hasNext()) {
            String nextName = (String)setIter.next();
            if (!nextName.equalsIgnoreCase(name)) continue;
            return nextName;
        }
        return null;
    }

    public boolean isClassRegistered(String name) {
        String METHOD = "isClassRegistered";
        if (name == null) {
            return true;
        }
        Iterator setIter = this.registeredClasses.keySet().iterator();
        while (setIter.hasNext()) {
            String nextName = (String)setIter.next();
            if (!nextName.equalsIgnoreCase(name)) continue;
            Trace.debug((Object)this, (String)"isClassRegistered", (String)("Class: " + name + " is registered for indications"));
            return true;
        }
        return false;
    }

    static {
        instCreationOnly.add("CIM_InstCreation");
        instCreateDelete.add("CIM_InstCreation");
        instCreateDelete.add("CIM_InstDeletion");
        instCreateDeleteModify.add("CIM_InstCreation");
        instCreateDeleteModify.add("CIM_InstDeletion");
        instCreateDeleteModify.add("CIM_InstModification");
        instDeleteOnly.add("CIM_InstDeletion");
        instModifyOnly.add("CIM_InstModification");
        classEventsList.add("SunStorEdge_DSPProtocolControllerForUnit");
        supportedEvents.put("SunStorEdge_DSPProtocolControllerForUnit", instCreateDelete);
        classEventsList.add("SunStorEdge_DSPStorageDomain");
        supportedEvents.put("SunStorEdge_DSPStorageDomain", instCreateDeleteModify);
        classEventsList.add("SunStorEdge_DSPStorageVolume");
        supportedEvents.put("SunStorEdge_DSPStorageVolume", instCreateDeleteModify);
        classEventsList.add("SunStorEdge_DSPStoragePool");
        supportedEvents.put("SunStorEdge_DSPStoragePool", instCreateDeleteModify);
        classEventsList.add("SunStorEdge_DSPStorageSynchronized");
        supportedEvents.put("SunStorEdge_DSPStorageSynchronized", instCreateDeleteModify);
        classEventsList.add("SunStorEdge_DSPRemoteStorageSynchronized");
        supportedEvents.put("SunStorEdge_DSPRemoteStorageSynchronized", instCreateDeleteModify);
        classEventsList.add("SunStorEdge_DSPSynchronizedComponent");
        supportedEvents.put("SunStorEdge_DSPSynchronizedComponent", instCreateDeleteModify);
        classEventsList.add("SunStorEdge_DSPReplicationSet");
        supportedEvents.put("SunStorEdge_DSPReplicationSet", instCreateDeleteModify);
        classEventsList.add("SunStorEdge_DspConcreteJob");
        supportedEvents.put("SunStorEdge_DspConcreteJob", instModifyOnly);
        classEventsList.add("SunStorEdge_DSPStorageConfigurationJob");
        supportedEvents.put("SunStorEdge_DSPStorageConfigurationJob", instModifyOnly);
        classEventsList.add("SunStorEdge_DSPStorageOperationalJob");
        supportedEvents.put("SunStorEdge_DSPStorageOperationalJob", instModifyOnly);
    }
}

