/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMCacheEvent;
import com.sun.netstorage.dsp.mgmt.se6920.CIMUtils;
import com.sun.netstorage.dsp.mgmt.se6920.Constants;
import com.sun.netstorage.dsp.mgmt.se6920.IndicationHelper;
import com.sun.netstorage.dsp.mgmt.se6920.ObjectPath;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

class IndicationEventHandler
implements Runnable,
Constants {
    private String CLASSNAME = "IndicationEventHandler";
    private CIMCacheEvent event = null;
    private int eventType;

    public IndicationEventHandler(CIMCacheEvent event) {
        this.event = event;
    }

    public void run() {
        block8: {
            String METHOD = "run";
            Trace.methodBegin((Object)this, (String)"run");
            this.eventType = this.event.getType();
            try {
                if (this.eventType == 2) {
                    this.handleArrayReload();
                    break block8;
                }
                if (this.eventType == 1) {
                    this.handleNewArray();
                    break block8;
                }
                if (this.eventType == 3) {
                    this.handleArrayRemoved();
                    break block8;
                }
                if (this.eventType == 4) {
                    this.handleInstanceAdded();
                    break block8;
                }
                if (this.eventType == 5) {
                    this.handleInstanceRemoved();
                    break block8;
                }
                if (this.eventType == 6) {
                    this.handleInstanceChanged();
                    break block8;
                }
                Trace.debug((Object)this, (String)"run", (String)("event " + CIMCacheEvent.eventTypeName[this.eventType] + " ignored."));
                return;
            }
            catch (Exception e) {
                Trace.debug((Object)this, (String)"run", (String)(" An exception occurred while handling event. " + e));
            }
        }
    }

    private void handleNewArray() {
        String METHOD = "handleNewArray";
        Trace.methodBegin((Object)this, (String)"handleNewArray");
    }

    private void handleArrayRemoved() {
        String METHOD = "handleArrayRemoved";
        Trace.methodBegin((Object)this, (String)"handleArrayRemoved");
    }

    private void handleInstanceAdded() {
        String METHOD = "handleInstanceAdded";
        Trace.methodBegin((Object)this, (String)"handleInstanceAdded");
        ArrayList instList = this.event.getInstances();
        if (instList.isEmpty()) {
            ArrayList ops = this.event.getObjectPaths();
            if (ops.isEmpty()) {
                throw new NoSuchElementException("No source CIM instance supplied");
            }
            Object ob = ops.get(0);
            CIMObjectPath cop = ob instanceof ObjectPath ? ((ObjectPath)ob).getCIMObjectPath() : (CIMObjectPath)ob;
            IndicationHelper.getInstance().createIndication("CIM_InstCreation", cop);
            return;
        }
        CIMInstance source = (CIMInstance)this.event.getInstances().get(0);
        IndicationHelper.getInstance().createIndication("CIM_InstCreation", source);
    }

    private void handleInstanceRemoved() {
        String METHOD = "handleInstanceRemoved";
        Trace.methodBegin((Object)this, (String)"handleInstanceRemoved");
        ArrayList instList = this.event.getInstances();
        if (instList.isEmpty()) {
            ArrayList ops = this.event.getObjectPaths();
            if (ops.isEmpty()) {
                throw new NoSuchElementException("No source CIM instance supplied");
            }
            Object ob = ops.get(0);
            CIMObjectPath cop = ob instanceof ObjectPath ? ((ObjectPath)ob).getCIMObjectPath() : (CIMObjectPath)ob;
            IndicationHelper.getInstance().createIndication("CIM_InstDeletion", cop);
            return;
        }
        CIMInstance source = (CIMInstance)this.event.getInstances().get(0);
        IndicationHelper.getInstance().createIndication("CIM_InstDeletion", source);
    }

    private void handleInstanceChanged() {
        String METHOD = "handleInstanceChanged";
        Trace.methodBegin((Object)this, (String)"handleInstanceChanged");
        CIMInstance oldInst = (CIMInstance)this.event.getInstances().get(0);
        CIMInstance source = (CIMInstance)this.event.getInstances().get(1);
        IndicationHelper.getInstance().createIndication("CIM_InstModification", source, oldInst);
    }

    private void findNewInstances(CIMCacheEvent event, CIMInstance[] newInsts, Vector current) {
        Vector differences = (Vector)current.clone();
        for (int i = 0; newInsts != null && i < newInsts.length; ++i) {
            if (current.contains(newInsts[i])) continue;
            RequestBroker.getInstance();
            CIMCacheEvent arrayEvent = new CIMCacheEvent(4, RequestBroker.getDevCache(), event.getArray());
            arrayEvent.addObjectPath(newInsts[i].getObjectPath());
            arrayEvent.addInstance(newInsts[i]);
            RequestBroker.getInstance();
            RequestBroker.getDevCache().postEvent(arrayEvent);
        }
    }

    private void findRemovedInstances(CIMCacheEvent event, CIMInstance[] newInsts, Vector current) {
        int i;
        Vector differences = (Vector)current.clone();
        for (i = 0; newInsts != null && i < newInsts.length; ++i) {
            newInsts[i].getObjectPath().setNameSpace("\\root\\se6x20\\");
            if (!differences.contains(newInsts[i])) continue;
            differences.remove(newInsts[i]);
        }
        if (!differences.isEmpty()) {
            for (i = 0; i < differences.size(); ++i) {
                RequestBroker.getInstance();
                CIMCacheEvent arrayEvent = new CIMCacheEvent(5, RequestBroker.getDevCache(), event.getArray());
                arrayEvent.addObjectPath(((CIMInstance)differences.get(i)).getObjectPath());
                arrayEvent.addInstance((CIMInstance)differences.get(i));
                RequestBroker.getInstance();
                RequestBroker.getDevCache().postEvent(arrayEvent);
            }
        }
    }

    private void findChangedInstances(CIMCacheEvent event, CIMInstance[] newInsts, Vector current) {
        Vector differences = (Vector)current.clone();
        for (int i = 0; newInsts != null && i < newInsts.length; ++i) {
            newInsts[i].getObjectPath().setNameSpace("\\root\\se6x20\\");
            if (!differences.contains(newInsts[i])) continue;
            ArrayList props = new ArrayList(newInsts[i].getProperties());
            CIMInstance oldInst = (CIMInstance)differences.get(differences.indexOf(newInsts[i]));
            if (CIMUtils.arePropertiesEqual(newInsts[i], oldInst, props)) continue;
            RequestBroker.getInstance();
            CIMCacheEvent arrayEvent = new CIMCacheEvent(6, RequestBroker.getDevCache(), event.getArray());
            arrayEvent.addObjectPath(((CIMInstance)differences.get(i)).getObjectPath());
            arrayEvent.addInstance(oldInst);
            arrayEvent.addInstance(newInsts[i]);
            RequestBroker.getInstance();
            RequestBroker.getDevCache().postEvent(arrayEvent);
        }
    }

    public void handleArrayReload() {
        String METHOD = "handleArrayReload";
        Trace.methodBegin((Object)this, (String)"handleArrayReload");
        if (IndicationHelper.getInstance().getRegisteredClasses().isEmpty()) {
            return;
        }
        ArrayObject targetArray = this.event.getArray();
        Iterator classIter = IndicationHelper.getInstance().getRegisteredClasses().iterator();
        while (classIter.hasNext()) {
            String className = (String)classIter.next();
            Vector current = (Vector)IndicationHelper.getInstance().getClassInsts(className).get(targetArray);
            Trace.info((Object)this, (String)"handleArrayReload", (String)(" Running instances for " + className + " size of current list: " + current.size()));
            CIMInstance[] newInsts = this.event.findNewInstancesInCache(className);
            Iterator activities = IndicationHelper.getInstance().getActivities(className);
            while (activities.hasNext()) {
                String activity = (String)activities.next();
                if (activity.equalsIgnoreCase("CIM_InstCreation")) {
                    this.findNewInstances(this.event, newInsts, current);
                    continue;
                }
                if (activity.equalsIgnoreCase("CIM_InstDeletion")) {
                    this.findRemovedInstances(this.event, newInsts, current);
                    continue;
                }
                if (!activity.equalsIgnoreCase("CIM_InstModification")) continue;
                this.findChangedInstances(this.event, newInsts, current);
            }
            IndicationHelper.getInstance().updateClassInsts(className, targetArray, newInsts);
        }
    }
}

