/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import java.io.BufferedReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DspResultsParser
extends DefaultHandler {
    private static SAXParserFactory factory = null;
    private DspResults results = null;
    private String currentTag = null;
    private boolean debug = false;

    private SAXParserFactory getFactory() {
        return factory;
    }

    private void setResults(DspResults newResults) {
        this.results = newResults;
    }

    private DspResults getResults() {
        return this.results;
    }

    private void setCurrentTag(String tagName) {
        this.currentTag = tagName;
    }

    private String getCurrentTag() {
        return this.currentTag;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public DspResultsParser() {
        factory = SAXParserFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DspResults parseResults(BufferedReader source) {
        if (source == null) {
            return new DspResults("FAILURE", -1, "Unknown error", null);
        }
        this.setResults(new DspResults());
        this.setCurrentTag(new String(""));
        try {
            SAXParser saxParser = this.getFactory().newSAXParser();
            saxParser.parse(new InputSource(source), (DefaultHandler)this);
        }
        catch (Exception e) {
            this.setResults(new DspResults("FAILURE", -1, "Unknown error", null));
        }
        finally {
            try {
                source.close();
            }
            catch (Exception exception) {}
        }
        return this.getResults();
    }

    public void setDocumentLocator(Locator loc) {
    }

    public void startDocument() throws SAXException {
        if (this.debug) {
            System.out.println("Starting to parse a document");
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
        String elementName = localName;
        if ("".equals(elementName)) {
            elementName = qualifiedName;
        }
        this.setCurrentTag(elementName);
        if (this.debug) {
            System.out.println("Found " + elementName + " tag");
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.debug) {
            System.out.println("Done processing " + localName + "tag");
        }
        this.setCurrentTag(new String(""));
    }

    public void characters(char[] buffer, int offset, int len) throws SAXException {
        String chars = new String(buffer, offset, len);
        String tag = this.getCurrentTag();
        if (this.debug) {
            System.out.println("Found string: " + chars);
        }
        if (tag == null) {
            return;
        }
        if (tag.equals("Status")) {
            this.getResults().setStatus(chars);
        } else if (tag.equals("ErrorCode")) {
            try {
                this.getResults().setReturnCode(new Integer(chars));
            }
            catch (Exception e) {
                this.getResults().setReturnCode(-1);
            }
        } else if (tag.equals("ErrorString")) {
            this.getResults().setErrorString(chars);
        } else if (tag.equals("ResultData")) {
            this.getResults().setResultData(chars);
        }
    }
}

