/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

public class DspResults {
    public static final String DSP_SUCCESS = "SUCCESS";
    public static final String DSP_FAILURE = "FAILURE";
    public static final int DSP_GENERIC_ERROR = -1;
    public static final String DSP_GENERIC_ERROR_STRING = "Unknown error";
    private String status;
    private int returnCode;
    private String errorString;
    private String resultData = null;

    public void setStatus(String newStatus) {
        if (newStatus.equals(DSP_SUCCESS) || newStatus.equals(DSP_FAILURE)) {
            this.status = newStatus;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setReturnCode(int code) {
        this.returnCode = code;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setErrorString(String msg) {
        this.errorString = msg;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setResultData(String newData) {
        this.resultData = this.resultData == null ? newData : this.resultData + newData;
    }

    public String getResultData() {
        if (this.resultData != null) {
            return this.resultData;
        }
        return "";
    }

    DspResults() {
        this.status = new String(DSP_FAILURE);
        this.returnCode = -1;
        this.errorString = new String(DSP_GENERIC_ERROR_STRING);
    }

    public DspResults(String statusString, int code, String msg, String obj) {
        this.status = statusString;
        this.returnCode = code;
        this.errorString = msg;
        this.resultData = obj;
    }

    public boolean requestSucceeded() {
        return this.returnCode == 0 || this.returnCode < -10000 && this.returnCode > -19999;
    }

    public String toString() {
        String additionalInfo = new String();
        int retCode = this.getReturnCode();
        if (retCode <= -10000 && retCode > -15000) {
            additionalInfo = new String(" (INFO) ");
        } else if (retCode <= -15000 && retCode > -20000) {
            additionalInfo = new String(" (WARNING) ");
        }
        return new String("DspResults: Status = " + this.getStatus() + additionalInfo + ", Return code = " + this.getReturnCode() + ", Error msg = " + this.getErrorString() + ", Result Data = " + this.getResultData());
    }
}

